//      >>>>>  T-I-N-Y  B-E-R-T for ATTINY85  GPL v3 <<<<
//                   Programmer: Daniel C 2019-2021
//              Contact EMAIL: electro_l.i.b@tinyjoypad.com
//                     https://www.tinyjoypad.com   
//           https://sites.google.com/view/arduino-collection

//  Tiny Bert is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//for TINY JOYPAD rev2 (attiny85)
//the code work at 16MHZ internal
//Program the chip with an arduino uno in "Arduino as ISP" mode.

// -----------------------------------------
// Babypad adaptation: Miroslav Nemecek 2025
// -----------------------------------------

#include "../include.h"

uint8_t MAX_RENEW=DEFAULT_SPEED;
uint8_t MAX_SPEED=DEFAULT_SPEED;

uint8_t PlateGrid[4][4];

const int8_t RAND2[] PROGMEM = {0,1,1,0,1,0,1,1,0,0,0,0,0,1,1,0,1,1,0,0,0,1,0,1,1,1,1,1,0,1};
const int8_t RAND4[] PROGMEM = {0,2,1,3,1,2,0,3,2,1,0,2,1,0,0,0,0,0,3,0,1,2,1,3,1,1,1,1,1,2};
const int8_t Jump[] PROGMEM = {1,-1,1,0,1,0,1,0,1,1,1,1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,2,1,1,0,2,};

const uint8_t PlatePos[] PROGMEM = {
	54,6,
	64,20,
	74,34,
	84,48,
	44,20,
	54,34,
	64,48,
	34,34,
	44,48,
	24,48
};

const uint8_t INTRO[] PROGMEM = {
	0xF0,0xFC,0xFE,0x1F,0x07,0x03,0x03,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x01,0xC1,0xC1,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0x81,0x81,0x81,0x81,0x81,
	0x81,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0x81,0x01,0x01,0x01,0x03,0x03,0x07,0x1F,0xFE,0xFC,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x03,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
	0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x03,0xFF,0xFE,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0xBB,0xFF,0x6D,0x01,0x01,0x00,0x00,0xFE,0xFE,0x80,0x00,0x76,
	0xFE,0xAE,0x04,0x06,0xFE,0xFC,0x48,0x00,0x06,0x1E,0xFC,0xE0,0xF0,0x7E,0x0E,0x02,0x00,0x18,0x18,0x18,0x10,0x00,0xAA,0xFF,0xFF,0xC9,0xCC,0xCF,0xFF,0x73,0x00,0x00,0x7C,0x7C,0xF6,0x92,0xD6,0xDE,0x7C,0x00,0x00,0xFE,0xFE,0x4C,0x06,0x02,0x06,0x02,0xFF,0xFF,
	0xC6,0xC2,0x02,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFB,0x20,0xF8,0x00,0xF8,0x00,0xF8,0xA8,0xE8,0x00,0xF8,0x20,0xF8,0x00,0xB8,0xA8,0xE8,0x00,0xF8,0x88,0x88,0x00,0xF8,0x88,0xF8,0x00,0xF8,0x68,0xB8,0x00,0xF8,
	0xA8,0x88,0x03,0x01,0x00,0x00,0x0F,0x3F,0x7F,0xF8,0xE0,0xC0,0xC0,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x86,0x86,0x83,0x81,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
	0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xC0,0xC0,0xE0,0x78,0x7F,0x3F,0x0F,0x00,0x80,0xC0,0xC0,0xC0,0xF0,0xF8,0x38,0x98,0x98,0x9C,0x0C,
	0x4C,0x4C,0xDC,0x9C,0x9C,0x98,0x18,0x1C,0x3C,0x38,0x30,0x98,0x18,0x78,0x70,0x30,0x30,0x30,0xF0,0xF0,0x70,0x60,0xE0,0xF0,0xE0,0xC0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFC,0x04,0x04,0xE4,0xE4,0x24,0x24,0xA4,0x24,0x24,0x64,0xE4,0xE4,
	0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0x64,0x24,0xE4,0xE4,0x24,0x24,0xA4,0x24,0x24,0xE4,0xE4,0xE4,0x24,0x64,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0x04,0x04,0xFC,0xF8,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xE0,0x70,0x38,0x3C,0x3C,0x96,0x27,0x67,0x87,0xC1,0x40,0x30,0x34,0x66,0x62,0x59,0x99,0x83,0xB3,0x34,0x44,0x4E,0x55,0xD9,0x9A,0xA3,0x10,0x0C,0xC4,0xED,0x19,0x08,0x06,0x22,0x0C,0x0C,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x0F,0xFF,0xF8,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0xC0,0xC0,0xFB,0xFB,0xF8,0xFC,0xFF,0xC0,0xC0,0xFD,0xFE,0xFF,0xE1,0xC0,0xDA,0xC8,0xC9,0xFB,0xFD,0xC8,0xD2,0xCA,0xC4,0xEF,0xDD,0xD0,0xCA,0xD2,0xC6,0xFF,
	0xFF,0xFF,0xFF,0xF5,0x80,0x1F,0xFF,0xFF,0xC0,0xC0,0xDD,0xC9,0xC0,0xE2,0xFF,0xFF,0x0A,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x3C,0xFE,0xDF,0x0F,0x07,0x21,0xE1,0xF8,0x98,0xCC,0xCC,0xC5,0xD3,0xC9,0x82,0x86,0x89,0x0C,0x04,
	0x03,0x13,0x16,0x26,0x62,0x29,0x0C,0x03,0x11,0x14,0x06,0x06,0x09,0x09,0x0F,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF8,0x80,0x80,0x80,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xEF,0x03,0x07,
	0xEF,0xEF,0x3F,0x1F,0xCF,0xEF,0x0F,0x1F,0xFF,0xFF,0xFF,0xFF,0xC7,0xC3,0x9B,0x93,0x3B,0x7F,0xFB,0xFB,0xB3,0x03,0x93,0xFB,0xFB,0x3F,0x07,0x43,0x73,0x07,0x1F,0xFF,0xFF,0x03,0x03,0xBB,0x13,0x03,0xEF,0xFB,0xF3,0x7B,0x03,0x83,0xFB,0xF3,0xFF,0xFF,0xFF,0xFF,
	0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x03,0x3F,0xFC,0xC0,0x00,0x03,0x3F,0xFF,0xFC,0xCD,0xEF,0xFF,0xFF,0xFD,0xDD,0x9F,0xFF,0xFB,0xBB,0xBB,0xBF,0xFF,0xF7,0x76,0x36,0x7F,0xFF,0xF8,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x80,0x10,0x90,0x60,0x60,0x48,0xCD,0xC3,0x33,0x00,0x00,0x3F,0x7F,0x40,0x40,0x4F,0x4F,0x4E,0x4C,0x4D,0x4D,0x4F,0x4C,0x4C,0x4D,0x4C,0x4E,0x4F,0x4F,0x4F,0x4F,0x4C,0x4C,0x4D,0x4C,0x4C,0x4F,0x4F,0x4F,0x4F,0x4C,
	0x4C,0x4F,0x4F,0x4C,0x4E,0x4F,0x4F,0x4E,0x4C,0x4D,0x4F,0x4C,0x4C,0x4F,0x4F,0x4C,0x4C,0x4F,0x4F,0x4F,0x4C,0x4C,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x4F,0x40,0x40,0x7F,0x3F,0x00,0x00,0xC0,0xC0,0xC0,0xE0,0x7B,0x7F,0x1C,0x80,0x00,0x03,0x03,0x82,0x44,0x06,
	0x87,0x07,0x03,0x0D,0x0D,0x0F,0x07,0x83,0x09,0x1B,0x0F,0x0F,0x07,0x23,0x3B,0x3F,0x7E,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0xE0,0x30,0x20,0x0C,0x64,0x78,0x98,0x84,0x32,0x32,0x2C,0xCC,0xC9,0x99,0x94,0x46,0x73,0x1C,0xC8,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x80,0x80,0x80,0xC0,0xF0,0x70,0x38,0x3C,0x1E,0x9E,0x66,0x47,0x03,0xC1,0xA0,0x30,0x20,0xA6,0x65,0x51,0x9A,0xF3,0x32,0x30,0x0C,0x47,0x69,0x98,0x8A,0x52,0x22,0x2C,0xC8,0xE9,0x19,0x14,0x26,0x72,0x1C,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7C,0xFE,0xDD,0xD9,0xB9,0x98,0xFE,0xF3,0x71,0x30,0xB8,0xF1,0xE0,0x60,0x33,0xF3,0xE0,0xEC,0xE6,0x61,0xE1,0xE2,0x03,0x01,
};

const uint8_t BACK[] PROGMEM = {
	0xF0,0xFC,0xFE,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x0F,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
	0x03,0x03,0x03,0x03,0x83,0x83,0xC3,0x43,0x63,0x23,0xA3,0x53,0x93,0x53,0xB3,0x23,0x63,0x43,0xC3,0x83,0x83,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0x07,0x0F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x01,0x01,0x01,0x01,0x01,
	0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x03,0x07,0xFF,0xFE,0xFE,0xFC,0xF0,0x00,0x03,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x03,0xF9,0x55,0xF4,0xAA,0xE5,0x4A,0xD5,0xAA,0x95,0x2A,0x15,0x2A,0x15,0x0A,0x05,0x0A,0x04,0x01,0x01,
	0x03,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x07,0x07,0x0F,0x0F,0x0F,0x0E,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0E,
	0x0F,0x0F,0x07,0x07,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0x40,
	0x60,0x20,0xB0,0x50,0x98,0x48,0xAC,0x57,0xA0,0x53,0xA5,0x47,0x8A,0x4F,0x95,0x1F,0x2A,0x7F,0x00,0x00,0x00,0x00,0x80,0x40,0x80,0x40,0xA0,0x50,0xA0,0x57,0xAC,0x48,0x98,0x50,0xB0,0x20,0x60,0x40,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFE,0x55,0xFD,0xAA,0xF9,0x52,0xF5,0xAA,0xE5,0x0A,0x05,0x0A,0x05,0x02,0x01,0x02,0x01,0x00,0x00,0x00,0xFE,0x55,0xFD,
	0xAA,0xF9,0x52,0xF5,0xAA,0xE5,0x0A,0x05,0x0A,0x05,0x02,0x01,0x02,0x01,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x30,0x90,0x58,0x48,0xAC,0x54,
	0xA6,0x52,0xAB,0x55,0xA8,0x54,0xA9,0x51,0xA2,0x53,0xA5,0x47,0x0A,0x1F,0x00,0x80,0x40,0x40,0xA0,0x50,0xA0,0x50,0xA8,0x54,0xA8,0x54,0xA9,0x51,0xA2,0x53,0xA5,0x47,0x0A,0x1F,0x00,0x80,0x40,0x40,0xA0,0x50,0xA0,0x50,0xA8,0x54,0xA8,0x55,0xAB,0x52,0xA6,0x54,
	0xAC,0x48,0x18,0x10,0x30,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xC0,0x7F,0x00,0x3F,0x55,0x7F,0xAA,0xFE,0x54,0xFD,0xAA,0xF9,0x02,0x01,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x55,0x7F,0xAA,0xFE,0x54,0xFD,
	0xAA,0xF9,0x02,0x01,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x55,0x7F,0xAA,0xFE,0x54,0xFD,0xAA,0xF9,0x02,0x01,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x0C,0xE4,0x56,0xD2,0xAB,0x95,0x29,0x54,0xAA,0x55,
	0xAA,0x55,0xAA,0x54,0x28,0x14,0x29,0x11,0x02,0x07,0x00,0xE0,0x50,0xD0,0xA8,0x94,0x28,0x54,0xAA,0x55,0xAA,0x55,0xAA,0x54,0x28,0x14,0x29,0x11,0x02,0x07,0x00,0xE0,0x50,0xD0,0xA8,0x94,0x28,0x54,0xAA,0x55,0xAA,0x55,0xAA,0x54,0x28,0x14,0x29,0x11,0x02,0x07,
	0x00,0xE0,0x50,0xD0,0xA8,0x94,0x28,0x54,0xAA,0x55,0xAA,0x55,0xAA,0x54,0x29,0x15,0x2B,0x12,0x06,0x04,0x0C,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x20,0x6F,0x55,0xDF,0xAA,0xBF,0x55,0x7F,0xAA,0xFE,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xC0,0x40,0x60,0x20,0x6F,0x55,0xDF,0xAA,0xBF,0x55,0x7F,0xAA,0xFE,0x00,0x00,
	0x00,0x00,0x00,0x80,0x80,0xC0,0x40,0x60,0x20,0x6F,0x55,0xDF,0xAA,0xBF,0x55,0x7F,0xAA,0xFE,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xC0,0x40,0x60,0x20,0x6F,0x55,0xDF,0xAA,0xBF,0x55,0x7F,0xAA,0xFE,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xC0,0x40,0x60,0x20,0x3F,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

const uint8_t Plate[] PROGMEM = {
	17,1,
	0x10,0x18,0x38,0x3C,0x7C,0x7E,0xFE,0xFF,0xFF,0xFF,0xFE,0x7E,0x7C,0x3C,0x38,0x18,0x10,
};

const uint8_t TINYBERT[] PROGMEM = {
	9,2,
	0x00,0x1C,0x3E,0xFE,0xFE,0xB6,0x1C,0x04,0x00,
	0x00,0x00,0x01,0x01,0x00,0x01,0x00,0x00,0x00,
	0x00,0x38,0x7C,0xFC,0xFC,0x6C,0x38,0x08,0x00,
	0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,
	0x00,0x04,0x1C,0xB6,0xFE,0xFE,0x3E,0x1C,0x00,
	0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x00,0x00,
	0x00,0x08,0x38,0x6C,0xFC,0xFC,0x7C,0x38,0x00,
	0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,
};

const uint8_t TINYBERT_BLACK[] PROGMEM = {
	9,2,
	0x3E,0xE3,0xC1,0x01,0x01,0x49,0xE3,0x3A,0x0E,
	0x00,0x03,0x02,0x02,0x03,0x02,0x03,0x00,0x00,
	0x7C,0xC6,0x82,0x02,0x02,0x92,0xC6,0x74,0x1C,0x00,0x00,0x03,0x02,0x03,0x02,0x03,0x00,0x00,
	0x0E,0x3A,0xE3,0x49,0x01,0x01,0xC1,0xE3,0x3E,
	0x00,0x00,0x03,0x02,0x03,0x02,0x02,0x03,0x00,
	0x1C,0x74,0xC6,0x92,0x02,0x02,0x82,0xC6,0x7C,0x00,0x00,0x03,0x02,0x03,0x02,0x03,0x00,0x00,
};

const uint8_t BALL[] PROGMEM = {
	9,2,
	0x00,0x78,0xFC,0xFE,0xFA,0xF2,0xE4,0x78,0x00,
	0x00,0x00,0x00,0x01,0x01,0x01,0x00,0x00,0x00,
	0x00,0x60,0xF0,0xF8,0xE8,0xE8,0xD0,0x60,0x00,
	0x00,0x00,0x00,0x01,0x01,0x01,0x00,0x00,0x00,
	0x00,0x78,0xFC,0xFE,0xFA,0xF2,0xE4,0x78,0x00,
	0x00,0x00,0x00,0x01,0x01,0x01,0x00,0x00,0x00,
	0x00,0x60,0xF0,0xF8,0xE8,0xE8,0xD0,0x60,0x00,
	0x00,0x00,0x00,0x01,0x01,0x01,0x00,0x00,0x00,
};

const uint8_t BALL_BLACK[] PROGMEM = {
	9,2,
	0xFC,0x86,0x03,0x01,0x05,0x0D,0x1B,0x86,0xFC,
	0x00,0x01,0x03,0x02,0x02,0x02,0x03,0x01,0x00,
	0xF0,0x98,0x0C,0x04,0x14,0x14,0x2C,0x98,0xF0,
	0x00,0x01,0x03,0x02,0x02,0x02,0x03,0x01,0x00,
	0xFC,0x86,0x03,0x01,0x05,0x0D,0x1B,0x86,0xFC,
	0x00,0x01,0x03,0x02,0x02,0x02,0x03,0x01,0x00,
	0xF0,0x98,0x0C,0x04,0x14,0x14,0x2C,0x98,0xF0,
	0x00,0x01,0x03,0x02,0x02,0x02,0x03,0x01,0x00,
};

const uint8_t SNACK[] PROGMEM = {
	9,2,
	0x00,0x98,0x3C,0x66,0x66,0xCA,0xCE,0x94,0x00,
	0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
	0x00,0x90,0x38,0x6C,0x4C,0xD4,0x9C,0xA8,0x00,
	0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
	0x00,0x94,0xCE,0xCA,0x66,0x66,0x3C,0x98,0x00,
	0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
	0x00,0xA8,0x9C,0xD4,0x4C,0x6C,0x38,0x90,0x00,
	0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
};

const uint8_t SNACK_BLACK[] PROGMEM = {
	9,2,  
	0x98,0x64,0xC2,0x99,0x99,0x35,0x31,0x6A,0x94,
	0x00,0x01,0x02,0x02,0x02,0x02,0x02,0x01,0x00,
	0x90,0x68,0xC4,0x92,0xB2,0x2A,0x62,0x54,0xA8,
	0x00,0x01,0x02,0x02,0x02,0x02,0x02,0x01,0x00,
	0x94,0x6A,0x31,0x35,0x99,0x99,0xC2,0x64,0x98,
	0x00,0x01,0x02,0x02,0x02,0x02,0x02,0x01,0x00,
	0xA8,0x54,0x62,0x2A,0xB2,0x92,0xC4,0x68,0x90,
	0x00,0x01,0x02,0x02,0x02,0x02,0x02,0x01,0x00,
};

const uint8_t Live[] PROGMEM = {
	9,2,0x00,0x1C,0x3E,0xFE,0xFE,0xB6,0x1C,0x04,0x00,
	0x00,0x00,0x01,0x01,0x00,0x01,0x00,0x00,0x00,
};

const uint8_t police[] PROGMEM = {
	0xF9,0x89,0xF9,0x01,0x01,0xF9,0x01,0x01,0xE9,0xA9,0xB9,0x01,0x89,0xA9,0xF9,0x01,0x39,0x21,0xF9,0x01,
	0xB9,0xA9,0xE9,0x01,0xF9,0xA9,0xE9,0x01,0x09,0xE9,0x19,0x01,0xF9,0xA9,0xF9,0x01,0xB9,0xA9,0xF9,0x01,
};

const uint8_t LIFT_PLATE[] PROGMEM = {
	13,1,
	0x1C,0x36,0x22,0x7B,0x51,0x7D,0x4D,0x57,0x45,0x6B,0x22,0x36,0x1C,
	0x1C,0x36,0x22,0x6B,0x43,0x55,0x7F,0x55,0x61,0x6B,0x22,0x36,0x1C,
	0x1C,0x36,0x36,0x6F,0x4D,0x5D,0x49,0x5D,0x49,0x6B,0x3A,0x3E,0x1C,
};
