
// ****************************************************************************
//
//                                 Main code
//
// ****************************************************************************
// Blinking LED using PIO

#include "include.h"

int main()
{
	// Choose which PIO instance to use (there are two instances)
	PIO pio = pio0;

	// Our assembled program needs to be loaded into this PIO's instruction
	// memory. This SDK function will find a location (offset) in the
	// instruction memory where there is enough space for our program. We need
	// to remember this location!
	uint offset = pio_add_program(pio, &hello_program);

	// Find a free state machine on our chosen PIO (erroring if there are
	// none). Configure it to run our program, and start it, using the
	// helper function we included in our .pio file.
	uint sm = pio_claim_unused_sm(pio, true);
	hello_program_init(pio, sm, offset, PICO_DEFAULT_LED_PIN);

	// The state machine is now running. Any value we push to its TX FIFO will
	// appear on the LED pin.
	while (true)
	{
		// Blink
		pio_sm_put_blocking(pio, sm, 1);
		sleep_ms(500);

		// Blonk
		pio_sm_put_blocking(pio, sm, 0);
		sleep_ms(500);
	}
}
		