
// ****************************************************************************
//
//                                 Main code
//
// ****************************************************************************
// Output clock signal to GPIO21.

// clk_sys = 125000 kHz, clk_sys/100 on GPIO21 = 1250 kHz
// clk_usb = 48000 kHz, clk_usb/100 on GPIO21 = 480 kHz
// clk_adc = 48000 kHz, clk_adc/100 on GPIO21 = 480 kHz
// clk_rtc = 46875 Hz, clk_rtc/100 on GPIO21 = 468.75 Hz

#include "include.h"

int main()
{
	stdio_init_all();
	printf("Hello gpout\n");

	while (True)
	{
		// Output clk_sys / 100 to gpio 21, etc...
		uint f_clk_sys = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_SYS);
		printf("clk_sys = %dkHz, output on GPIO21 = %dkHz\n", f_clk_sys, (f_clk_sys+50)/100);
		clock_gpio_init(21, CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_VALUE_CLK_SYS, 100);
		sleep_ms(5000);

		uint f_clk_usb = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_USB);
		printf("clk_usb = %dkHz, output on GPIO21 = %dkHz\n", f_clk_usb, (f_clk_usb+50)/100);
		clock_gpio_init(21, CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_VALUE_CLK_USB, 100);
		sleep_ms(5000);

		uint f_clk_adc = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_ADC);
		printf("clk_adc = %dkHz, output on GPIO21 = %dkHz\n", f_clk_adc, (f_clk_adc+50)/100);
		clock_gpio_init(21, CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_VALUE_CLK_ADC, 100);
		sleep_ms(5000);

		uint f_clk_rtc = frequency_count_khz(CLOCKS_FC0_SRC_VALUE_CLK_RTC);
		printf("clk_rtc = %dkHz, output on GPIO21 = %dHz\n", f_clk_rtc, (f_clk_rtc*1000+50)/100);
		clock_gpio_init(21, CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_VALUE_CLK_RTC, 100);
		sleep_ms(5000);
	}

	return 0;
}
