
#include <stdio.h>
#include <malloc.h>
#include <math.h>

#pragma warning(disable : 4996) // unsafe fopen

typedef signed char s8;
typedef unsigned char u8;
typedef signed short s16;
typedef unsigned short u16;
//typedef signed long int s32;		// on 64-bit system use "signed int"
//typedef unsigned long int u32;		// on 64-bit system use "unsigned int"
typedef signed int s32;
typedef unsigned int u32;

typedef unsigned int BOOL;
#define TRUE  1
#define FALSE 0

#define LOG_MUL		(1<<13)		// log multiplier (= 8192)

// table of -log(ur)*LOG_MUL
//	ur = relative voltage 0, 1/4096, 2/4096 .. 4094/4096, 4095/4096
//	-log(ur) = values -, 8.3178, 7.6246 .. 4,8840e-4, 2.4417e-4
//	table = values 65535, 65535, 62461 .. 4, 2
u16 LogUTab[4096];

// round double to int
int MyRound(double x)
{
	if (x >= 0)
		return (int)(x + 0.5);
	else
		return (int)(x - 0.5);
}

int main(int argc, char* argv[])
{
	int i, k;
	LogUTab[0] = 65535;
	for (i = 1; i <= 4095; i++)
	{
		k = MyRound(-log(i/4096.0)*LOG_MUL);
		if (k > 65535) k = 65535;
		LogUTab[i] = k;
	}

	int pos = 0;
	for (i = 0; i < 4096; i++)
	{
		printf("\t%u,", LogUTab[i]);
		pos++;
		if (pos == 16)
		{
			printf("\n");
			pos = 0;
		}
	}

	return 0;
}
