
// ****************************************************************************
//
//                         Page U - voltage meter
//
// ****************************************************************************
// U input: PD4, ADC7, input resistors: 2M2 + 220K, input range 0..3V (0..5V) or 0..30V (0..50V), minimal measured voltage 1mV or 10mV, relative error 5%, absolute error 3mV or 30mV
// ADC clock divider is set to 750kHz. One ADC clock cycle is 1.33us.
// U sampling time is (6) 71.5 cycles. One sample is 71.5+12.5=84 ADC clock cycles = 112us.

#ifndef _PAGE_U_H
#define _PAGE_U_H

#ifdef __cplusplus
extern "C" {
#endif

#define U_ADC	7		// U input ADC channel
#define U_GPIO	PD4		// U GPIO

#define U_R1	2200000		// U top resistor
#define U_R2	220000		// U bottom resistor

#define U_SHIFT 12		// UI shift
#define U1_K	(1<<U_SHIFT)	// U1 input multiplication ratio << 12 (range 3.3V or 5.0V))
#define U2_K	((u32)((((u64)(U_R1+U_R2)<<U_SHIFT)+U_R2/2)/U_R2)) // U2 input multiplication ratio << 12 (= 45056 = 11.0, range 36V or 55V))

// U mode
enum {
	U_MODE_LOW = 0,		// low input mode 0..3.3V
	U_MODE_HIGH,		// high input mode 0..36V

	U_MODE_NUM		// number of modes
};

extern int UMode;	// U mode

// display UI value
void UI_DispVal(s32 val, int y, char unit);

// Page U (returns key PREV/NEXT)
u8 PageU();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_U_H
