
// ****************************************************************************
//
//                         Page REP - repeater
//
// ****************************************************************************
// Input: PD2, Timer 1 channel 1 mapping 0
//   0 ... PC5:ETR, >>> PD2:CH1 <<<<, PA1:CH2, PC3:CH3, PC4:CH4, PC2:BKIN, PD0:CH1N, PA2:CH2N, PD1:CH3N
// Output: PC4, Timer 1 channel 4 mapping 0
//   0 ... PC5:ETR, PD2:CH1, PA1:CH2, PC3:CH3, >>> PC4:CH4 <<<, PC2:BKIN, PD0:CH1N, PA2:CH2N, PD1:CH3N

#ifndef _PAGE_REP_H
#define _PAGE_REP_H

#ifdef __cplusplus
extern "C" {
#endif

#define REP_IN_GPIO	PD2		// REP input pin
#define REP_OUT_GPIO	PD4		// REP output pin

#define REP_DMA		4	// used DMA channel (with TIM1_CH4 data request)

// interrupt on signal edge ... handler located at page_asm.S
HANDLER void REP_Handler();

// Page REP (returns key PREV/NEXT)
u8 PageREP();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_REP_H
