
// ****************************************************************************
//
//                           Page OSC - oscilloscope
//
// ****************************************************************************
// Input channel 1: PD2 - A3, channel 2: PD3 - A4
// Timings: Timer 1
// Automatic synchronization is performed according to the first channel.
//  - Automatic signal synchronization using "local integrated steepness".
// "Hold" button - a short press activates the HOLD of the signal, a long press switches between AUTO/FREE mode.

#ifndef _PAGE_OSC_H
#define _PAGE_OSC_H

#ifdef __cplusplus
extern "C" {
#endif

// OSC time base
enum {
	OSC_BASE1_10US = 0,	//  0: 1 channel,  time base  10us, sample rate   3 MHz, total time 42.7us
	OSC_BASE1_30US,		//  1: 1 channel,  time base  30us, sample rate   1 MHz, total time  128us
	OSC_BASE1_100US,	//  2: 1 channel,  time base 100us, sample rate 300 kHz, total time  427us
	OSC_BASE1_300US,	//  3: 1 channel,  time base 300us, sample rate 100 kHz, total time 1.28ms
	OSC_BASE1_1MS,		//  4: 1 channel,  time base   1ms, sample rate  30 kHz, total time 4.27ms
	OSC_BASE1_3MS,		//  5: 1 channel,  time base   3ms, sample rate  10 kHz, total time 12.8ms
	OSC_BASE1_10MS,		//  6: 1 channel,  time base  10ms, sample rate   3 kHz, total time 42.7ms
	OSC_BASE1_30MS,		//  7: 1 channel,  time base  30ms, sample rate   1 kHz, total time  128ms
	OSC_BASE1_100MS,	//  8: 1 channel,  time base 100ms, sample rate 300 Hz,  total time  427ms

	OSC_BASE2_20US,		//  9: 2 channels, time base  20us, sample rate 1.5 MHz, total time 85.3us
	OSC_BASE2_40US,		// 10: 2 channels, time base  40us, sample rate 750 kHz, total time  171us
	OSC_BASE2_100US,	// 11: 2 channels, time base 100us, sample rate 300 kHz, total time  427us
	OSC_BASE2_300US,	// 12: 2 channels, time base 300us, sample rate 100 kHz, total time 1.28ms
	OSC_BASE2_1MS,		// 13: 2 channels, time base   1ms, sample rate  30 kHz, total time 4.27ms
	OSC_BASE2_3MS,		// 14: 2 channels, time base   3ms, sample rate  10 kHz, total time 12.8ms
	OSC_BASE2_10MS,		// 15: 2 channels, time base  10ms, sample rate   3 kHz, total time 42.7ms
	OSC_BASE2_30MS,		// 16: 2 channels, time base  30ms, sample rate   1 kHz, total time  128ms
	OSC_BASE2_100MS,	// 17: 2 channels, time base 100ms, sample rate 300 Hz,  total time  427ms

	OSC_BASEX_20US,		// 18: XY channels, time base  20us, sample rate 1.5 MHz, total time 85.3us
	OSC_BASEX_40US,		// 19: XY channels, time base  40us, sample rate 750 kHz, total time  171us
	OSC_BASEX_100US,	// 20: XY channels, time base 100us, sample rate 300 kHz, total time  427us
	OSC_BASEX_300US,	// 21: XY channels, time base 300us, sample rate 100 kHz, total time 1.28ms
	OSC_BASEX_1MS,		// 22: XY channels, time base   1ms, sample rate  30 kHz, total time 4.27ms
	OSC_BASEX_3MS,		// 23: XY channels, time base   3ms, sample rate  10 kHz, total time 12.8ms
	OSC_BASEX_10MS,		// 24: XY channels, time base  10ms, sample rate   3 kHz, total time 42.7ms
	OSC_BASEX_30MS,		// 25: XY channels, time base  30ms, sample rate   1 kHz, total time  128ms
	OSC_BASEX_100MS,	// 26: XY channels, time base 100ms, sample rate 300 Hz,  total time  427ms

	OSC_BASE_NUM		// 27
};

#define OSC_BASE_FIRSTX	OSC_BASEX_20US	// first base with XY channels
#define OSC_BASE_FIRST2	OSC_BASE2_20US	// first base with 2 channels
#define OSC_BASE_LAST1	OSC_BASE1_100MS	// last base with 1 channel
#define OSC_BASE_DEF	OSC_BASE1_1MS	// default time base

#define OSC_DMA	1	// used DMA channel (with ADC1 data request)

// OSC input pins
#define OSC_GPIO1	PD2		// input pin, channel 1
#define OSC_GPIO2	PD3		// input pin, channel 2

#define OSC_ADC1	3		// input ADC, channel 1
#define OSC_ADC2	4		// input ADC, channel 2

// Page OSC (returns key PREV/NEXT)
u8 PageOSC();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_OSC_H
