
// ****************************************************************************
//
//                           Page L - inductance meter
//
// ****************************************************************************
// Input: PC0, Timer 2, channel 1, mapping 4
// Resonator: LM311D
// Frequency: f=1/(2*pi*sqrt(L*C))
// check L: serial L0 = 68uH, parallel C0 = 1nF
// L range: 0.1uH .. 20H
//   L = (1/(f*2*pi))^2 / C0 - L0
// frequency: 1 kHz ... 640 kHz
// resolution 10nH, absolute error 50nH, relative error 10%, range 0.1uH to 20H.

#ifndef _PAGE_L_H
#define _PAGE_L_H

#ifdef __cplusplus
extern "C" {
#endif

#define L_GPIO		PC0		// L input pin
#define L0_REF		6800		// reference L in 10nH (= 68uH, scale = -8)
#define C0_REF		10000		// reference C in 0.1pF (= 1nF, scale = -13)

// L Timer 2 interrupt handler ... handler located at page_asm.S
HANDLER void L_Handler();

// Page L (returns key PREV/NEXT)
u8 PageL();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_L_H
