
// ****************************************************************************
//
//                      Page FT - frequency and period meter
//
// ****************************************************************************
// Input: PD2
// Timer 1, channel 1, mapping 0: count edges, up to 24 MHz
//	0 ... PC5:ETR, >>> PD2:CH1 <<<<, PA1:CH2, PC3:CH3, PC4:CH4, PC2:BKIN, PD0:CH1N, PA2:CH2N, PD1:CH3N
// Timer 2, channel 3, mapping 2: capture time of edges
//	2 ... PC5:CH1/ETR, PC2:CH2, >>> PD2:CH3/CH1N <<<, PC1:CH4/CH2N

// The measured value is displayed with 6 valid digits. The accuracy is primarily
// determined by the accuracy of the crystal used, which is usually around 50 ppm,
// meaning that the last 2 digits of the value are only approximate and inaccurate.
// The upper measurable frequency is 24 MHz. The lower measurable frequency is not
// defined; it is determined only by the measurement time.

#ifndef _PAGE_FT_H
#define _PAGE_FT_H

#ifdef __cplusplus
extern "C" {
#endif

// FT Timer 1 interrupt handler - overflow of edge counter ... handler located at page_asm.S
HANDLER void FT_Handler1();

// FT Timer 2 interrupt handler - time of edges ... handler located at page_asm.S
HANDLER void FT_Handler2();

// Page FT (returns key PREV/NEXT)
u8 PageFT();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_FT_H
