
// table of -log(ur)*LOG_MUL
//	ur = relative voltage 0, 1/4096, 2/4096 .. 4094/4096, 4095/4096
//	-log(ur) = values -, 8.3178, 7.6246 .. 4,8840e-4, 2.4417e-4
//	table = values 65535, 65535, 62461 .. 4, 2
const u16 LogUTab[4096] = {
	65535,	65535,	62461,	59139,	56783,	54955,	53461,	52198,	51104,	50139,	49276,	48496,	47783,	47127,	46520,	45955,
	45426,	44929,	44461,	44018,	43598,	43198,	42817,	42453,	42105,	41770,	41449,	41140,	40842,	40554,	40277,	40008,
	39748,	39496,	39251,	39014,	38783,	38559,	38340,	38127,	37920,	37718,	37520,	37327,	37139,	36955,	36775,	36599,
	36426,	36257,	36092,	35930,	35771,	35615,	35461,	35311,	35163,	35018,	34876,	34736,	34598,	34463,	34330,	34199,
	34070,	33943,	33817,	33694,	33573,	33453,	33335,	33219,	33105,	32992,	32880,	32770,	32662,	32555,	32449,	32345,
	32242,	32140,	32039,	31940,	31842,	31745,	31649,	31554,	31461,	31368,	31277,	31186,	31097,	31008,	30920,	30834,
	30748,	30663,	30579,	30496,	30414,	30332,	30251,	30171,	30092,	30014,	29936,	29859,	29783,	29708,	29633,	29559,
	29485,	29412,	29340,	29269,	29198,	29127,	29058,	28989,	28920,	28852,	28785,	28718,	28651,	28586,	28520,	28456,
	28391,	28328,	28264,	28202,	28139,	28077,	28016,	27955,	27895,	27835,	27775,	27716,	27657,	27599,	27541,	27484,
	27426,	27370,	27313,	27258,	27202,	27147,	27092,	27038,	26984,	26930,	26876,	26823,	26771,	26718,	26666,	26615,
	26563,	26512,	26462,	26411,	26361,	26311,	26262,	26213,	26164,	26115,	26067,	26019,	25971,	25923,	25876,	25829,
	25783,	25736,	25690,	25644,	25598,	25553,	25508,	25463,	25418,	25374,	25330,	25286,	25242,	25199,	25156,	25113,
	25070,	25027,	24985,	24943,	24901,	24859,	24818,	24776,	24735,	24694,	24654,	24613,	24573,	24533,	24493,	24454,
	24414,	24375,	24336,	24297,	24258,	24219,	24181,	24143,	24105,	24067,	24029,	23992,	23955,	23917,	23880,	23844,
	23807,	23770,	23734,	23698,	23662,	23626,	23590,	23555,	23519,	23484,	23449,	23414,	23379,	23345,	23310,	23276,
	23242,	23208,	23174,	23140,	23106,	23073,	23039,	23006,	22973,	22940,	22907,	22875,	22842,	22810,	22777,	22745,
	22713,	22681,	22649,	22618,	22586,	22555,	22523,	22492,	22461,	22430,	22399,	22368,	22338,	22307,	22277,	22247,
	22216,	22186,	22156,	22127,	22097,	22067,	22038,	22008,	21979,	21950,	21921,	21892,	21863,	21834,	21805,	21777,
	21748,	21720,	21691,	21663,	21635,	21607,	21579,	21551,	21524,	21496,	21469,	21441,	21414,	21386,	21359,	21332,
	21305,	21278,	21252,	21225,	21198,	21172,	21145,	21119,	21092,	21066,	21040,	21014,	20988,	20962,	20936,	20911,
	20885,	20859,	20834,	20809,	20783,	20758,	20733,	20708,	20683,	20658,	20633,	20608,	20583,	20559,	20534,	20510,
	20485,	20461,	20437,	20413,	20388,	20364,	20340,	20316,	20293,	20269,	20245,	20221,	20198,	20174,	20151,	20128,
	20104,	20081,	20058,	20035,	20012,	19989,	19966,	19943,	19920,	19897,	19875,	19852,	19830,	19807,	19785,	19762,
	19740,	19718,	19696,	19674,	19652,	19630,	19608,	19586,	19564,	19542,	19520,	19499,	19477,	19456,	19434,	19413,
	19391,	19370,	19349,	19328,	19307,	19285,	19264,	19243,	19223,	19202,	19181,	19160,	19139,	19119,	19098,	19078,
	19057,	19037,	19016,	18996,	18976,	18955,	18935,	18915,	18895,	18875,	18855,	18835,	18815,	18795,	18775,	18755,
	18736,	18716,	18696,	18677,	18657,	18638,	18618,	18599,	18580,	18560,	18541,	18522,	18503,	18484,	18465,	18446,
	18427,	18408,	18389,	18370,	18351,	18332,	18314,	18295,	18276,	18258,	18239,	18221,	18202,	18184,	18165,	18147,
	18129,	18110,	18092,	18074,	18056,	18038,	18020,	18002,	17984,	17966,	17948,	17930,	17912,	17894,	17877,	17859,
	17841,	17824,	17806,	17788,	17771,	17753,	17736,	17719,	17701,	17684,	17667,	17649,	17632,	17615,	17598,	17581,
	17563,	17546,	17529,	17512,	17496,	17479,	17462,	17445,	17428,	17411,	17395,	17378,	17361,	17345,	17328,	17311,
	17295,	17278,	17262,	17245,	17229,	17213,	17196,	17180,	17164,	17148,	17131,	17115,	17099,	17083,	17067,	17051,
	17035,	17019,	17003,	16987,	16971,	16955,	16939,	16924,	16908,	16892,	16876,	16861,	16845,	16829,	16814,	16798,
	16783,	16767,	16752,	16736,	16721,	16705,	16690,	16675,	16660,	16644,	16629,	16614,	16599,	16583,	16568,	16553,
	16538,	16523,	16508,	16493,	16478,	16463,	16448,	16433,	16419,	16404,	16389,	16374,	16359,	16345,	16330,	16315,
	16301,	16286,	16271,	16257,	16242,	16228,	16213,	16199,	16184,	16170,	16156,	16141,	16127,	16113,	16098,	16084,
	16070,	16056,	16042,	16027,	16013,	15999,	15985,	15971,	15957,	15943,	15929,	15915,	15901,	15887,	15873,	15859,
	15845,	15832,	15818,	15804,	15790,	15777,	15763,	15749,	15735,	15722,	15708,	15695,	15681,	15668,	15654,	15640,
	15627,	15614,	15600,	15587,	15573,	15560,	15547,	15533,	15520,	15507,	15493,	15480,	15467,	15454,	15440,	15427,
	15414,	15401,	15388,	15375,	15362,	15349,	15336,	15323,	15310,	15297,	15284,	15271,	15258,	15245,	15232,	15220,
	15207,	15194,	15181,	15168,	15156,	15143,	15130,	15118,	15105,	15092,	15080,	15067,	15055,	15042,	15030,	15017,
	15005,	14992,	14980,	14967,	14955,	14942,	14930,	14918,	14905,	14893,	14881,	14868,	14856,	14844,	14832,	14819,
	14807,	14795,	14783,	14771,	14758,	14746,	14734,	14722,	14710,	14698,	14686,	14674,	14662,	14650,	14638,	14626,
	14614,	14602,	14591,	14579,	14567,	14555,	14543,	14531,	14520,	14508,	14496,	14484,	14473,	14461,	14449,	14438,
	14426,	14414,	14403,	14391,	14380,	14368,	14356,	14345,	14333,	14322,	14310,	14299,	14288,	14276,	14265,	14253,
	14242,	14231,	14219,	14208,	14197,	14185,	14174,	14163,	14151,	14140,	14129,	14118,	14107,	14095,	14084,	14073,
	14062,	14051,	14040,	14029,	14017,	14006,	13995,	13984,	13973,	13962,	13951,	13940,	13929,	13918,	13908,	13897,
	13886,	13875,	13864,	13853,	13842,	13831,	13821,	13810,	13799,	13788,	13777,	13767,	13756,	13745,	13735,	13724,
	13713,	13703,	13692,	13681,	13671,	13660,	13649,	13639,	13628,	13618,	13607,	13597,	13586,	13576,	13565,	13555,
	13544,	13534,	13523,	13513,	13503,	13492,	13482,	13471,	13461,	13451,	13440,	13430,	13420,	13410,	13399,	13389,
	13379,	13369,	13358,	13348,	13338,	13328,	13318,	13307,	13297,	13287,	13277,	13267,	13257,	13247,	13237,	13227,
	13217,	13207,	13197,	13187,	13177,	13167,	13157,	13147,	13137,	13127,	13117,	13107,	13097,	13087,	13077,	13067,
	13058,	13048,	13038,	13028,	13018,	13008,	12999,	12989,	12979,	12969,	12960,	12950,	12940,	12930,	12921,	12911,
	12901,	12892,	12882,	12873,	12863,	12853,	12844,	12834,	12825,	12815,	12805,	12796,	12786,	12777,	12767,	12758,
	12748,	12739,	12729,	12720,	12710,	12701,	12692,	12682,	12673,	12663,	12654,	12645,	12635,	12626,	12617,	12607,
	12598,	12589,	12579,	12570,	12561,	12552,	12542,	12533,	12524,	12515,	12505,	12496,	12487,	12478,	12469,	12460,
	12450,	12441,	12432,	12423,	12414,	12405,	12396,	12387,	12378,	12369,	12359,	12350,	12341,	12332,	12323,	12314,
	12305,	12296,	12287,	12279,	12270,	12261,	12252,	12243,	12234,	12225,	12216,	12207,	12198,	12189,	12181,	12172,
	12163,	12154,	12145,	12137,	12128,	12119,	12110,	12101,	12093,	12084,	12075,	12066,	12058,	12049,	12040,	12032,
	12023,	12014,	12006,	11997,	11988,	11980,	11971,	11962,	11954,	11945,	11937,	11928,	11919,	11911,	11902,	11894,
	11885,	11877,	11868,	11860,	11851,	11843,	11834,	11826,	11817,	11809,	11800,	11792,	11783,	11775,	11767,	11758,
	11750,	11741,	11733,	11725,	11716,	11708,	11700,	11691,	11683,	11675,	11666,	11658,	11650,	11641,	11633,	11625,
	11617,	11608,	11600,	11592,	11584,	11575,	11567,	11559,	11551,	11543,	11534,	11526,	11518,	11510,	11502,	11494,
	11486,	11477,	11469,	11461,	11453,	11445,	11437,	11429,	11421,	11413,	11405,	11397,	11389,	11381,	11373,	11365,
	11357,	11349,	11341,	11333,	11325,	11317,	11309,	11301,	11293,	11285,	11277,	11269,	11261,	11253,	11245,	11237,
	11230,	11222,	11214,	11206,	11198,	11190,	11182,	11175,	11167,	11159,	11151,	11143,	11136,	11128,	11120,	11112,
	11104,	11097,	11089,	11081,	11073,	11066,	11058,	11050,	11043,	11035,	11027,	11020,	11012,	11004,	10997,	10989,
	10981,	10974,	10966,	10958,	10951,	10943,	10936,	10928,	10920,	10913,	10905,	10898,	10890,	10883,	10875,	10867,
	10860,	10852,	10845,	10837,	10830,	10822,	10815,	10807,	10800,	10792,	10785,	10777,	10770,	10763,	10755,	10748,
	10740,	10733,	10725,	10718,	10711,	10703,	10696,	10689,	10681,	10674,	10666,	10659,	10652,	10644,	10637,	10630,
	10622,	10615,	10608,	10601,	10593,	10586,	10579,	10571,	10564,	10557,	10550,	10542,	10535,	10528,	10521,	10513,
	10506,	10499,	10492,	10485,	10477,	10470,	10463,	10456,	10449,	10442,	10434,	10427,	10420,	10413,	10406,	10399,
	10392,	10385,	10377,	10370,	10363,	10356,	10349,	10342,	10335,	10328,	10321,	10314,	10307,	10300,	10293,	10286,
	10279,	10272,	10265,	10258,	10251,	10244,	10237,	10230,	10223,	10216,	10209,	10202,	10195,	10188,	10181,	10174,
	10167,	10160,	10153,	10146,	10140,	10133,	10126,	10119,	10112,	10105,	10098,	10091,	10085,	10078,	10071,	10064,
	10057,	10050,	10044,	10037,	10030,	10023,	10016,	10010,	10003,	9996,	9989,	9982,	9976,	9969,	9962,	9955,
	9949,	9942,	9935,	9929,	9922,	9915,	9908,	9902,	9895,	9888,	9882,	9875,	9868,	9862,	9855,	9848,
	9842,	9835,	9828,	9822,	9815,	9808,	9802,	9795,	9789,	9782,	9775,	9769,	9762,	9756,	9749,	9743,
	9736,	9729,	9723,	9716,	9710,	9703,	9697,	9690,	9684,	9677,	9671,	9664,	9658,	9651,	9645,	9638,
	9632,	9625,	9619,	9612,	9606,	9599,	9593,	9586,	9580,	9573,	9567,	9561,	9554,	9548,	9541,	9535,
	9529,	9522,	9516,	9509,	9503,	9497,	9490,	9484,	9477,	9471,	9465,	9458,	9452,	9446,	9439,	9433,
	9427,	9420,	9414,	9408,	9402,	9395,	9389,	9383,	9376,	9370,	9364,	9358,	9351,	9345,	9339,	9332,
	9326,	9320,	9314,	9308,	9301,	9295,	9289,	9283,	9276,	9270,	9264,	9258,	9252,	9245,	9239,	9233,
	9227,	9221,	9215,	9208,	9202,	9196,	9190,	9184,	9178,	9172,	9165,	9159,	9153,	9147,	9141,	9135,
	9129,	9123,	9117,	9111,	9104,	9098,	9092,	9086,	9080,	9074,	9068,	9062,	9056,	9050,	9044,	9038,
	9032,	9026,	9020,	9014,	9008,	9002,	8996,	8990,	8984,	8978,	8972,	8966,	8960,	8954,	8948,	8942,
	8936,	8930,	8924,	8918,	8912,	8906,	8900,	8895,	8889,	8883,	8877,	8871,	8865,	8859,	8853,	8847,
	8841,	8835,	8830,	8824,	8818,	8812,	8806,	8800,	8794,	8789,	8783,	8777,	8771,	8765,	8759,	8754,
	8748,	8742,	8736,	8730,	8725,	8719,	8713,	8707,	8701,	8696,	8690,	8684,	8678,	8672,	8667,	8661,
	8655,	8649,	8644,	8638,	8632,	8626,	8621,	8615,	8609,	8604,	8598,	8592,	8586,	8581,	8575,	8569,
	8564,	8558,	8552,	8547,	8541,	8535,	8530,	8524,	8518,	8513,	8507,	8501,	8496,	8490,	8484,	8479,
	8473,	8468,	8462,	8456,	8451,	8445,	8439,	8434,	8428,	8423,	8417,	8411,	8406,	8400,	8395,	8389,
	8384,	8378,	8372,	8367,	8361,	8356,	8350,	8345,	8339,	8334,	8328,	8323,	8317,	8312,	8306,	8301,
	8295,	8290,	8284,	8279,	8273,	8268,	8262,	8257,	8251,	8246,	8240,	8235,	8229,	8224,	8218,	8213,
	8207,	8202,	8197,	8191,	8186,	8180,	8175,	8169,	8164,	8159,	8153,	8148,	8142,	8137,	8132,	8126,
	8121,	8115,	8110,	8105,	8099,	8094,	8088,	8083,	8078,	8072,	8067,	8062,	8056,	8051,	8046,	8040,
	8035,	8030,	8024,	8019,	8014,	8008,	8003,	7998,	7992,	7987,	7982,	7976,	7971,	7966,	7961,	7955,
	7950,	7945,	7940,	7934,	7929,	7924,	7918,	7913,	7908,	7903,	7897,	7892,	7887,	7882,	7876,	7871,
	7866,	7861,	7856,	7850,	7845,	7840,	7835,	7830,	7824,	7819,	7814,	7809,	7804,	7798,	7793,	7788,
	7783,	7778,	7773,	7767,	7762,	7757,	7752,	7747,	7742,	7736,	7731,	7726,	7721,	7716,	7711,	7706,
	7701,	7695,	7690,	7685,	7680,	7675,	7670,	7665,	7660,	7655,	7649,	7644,	7639,	7634,	7629,	7624,
	7619,	7614,	7609,	7604,	7599,	7594,	7589,	7584,	7579,	7574,	7568,	7563,	7558,	7553,	7548,	7543,
	7538,	7533,	7528,	7523,	7518,	7513,	7508,	7503,	7498,	7493,	7488,	7483,	7478,	7473,	7468,	7463,
	7458,	7453,	7448,	7443,	7439,	7434,	7429,	7424,	7419,	7414,	7409,	7404,	7399,	7394,	7389,	7384,
	7379,	7374,	7369,	7364,	7360,	7355,	7350,	7345,	7340,	7335,	7330,	7325,	7320,	7315,	7311,	7306,
	7301,	7296,	7291,	7286,	7281,	7277,	7272,	7267,	7262,	7257,	7252,	7247,	7243,	7238,	7233,	7228,
	7223,	7218,	7214,	7209,	7204,	7199,	7194,	7189,	7185,	7180,	7175,	7170,	7165,	7161,	7156,	7151,
	7146,	7141,	7137,	7132,	7127,	7122,	7118,	7113,	7108,	7103,	7099,	7094,	7089,	7084,	7080,	7075,
	7070,	7065,	7061,	7056,	7051,	7046,	7042,	7037,	7032,	7028,	7023,	7018,	7013,	7009,	7004,	6999,
	6995,	6990,	6985,	6980,	6976,	6971,	6966,	6962,	6957,	6952,	6948,	6943,	6938,	6934,	6929,	6924,
	6920,	6915,	6910,	6906,	6901,	6897,	6892,	6887,	6883,	6878,	6873,	6869,	6864,	6859,	6855,	6850,
	6846,	6841,	6836,	6832,	6827,	6823,	6818,	6813,	6809,	6804,	6800,	6795,	6790,	6786,	6781,	6777,
	6772,	6768,	6763,	6758,	6754,	6749,	6745,	6740,	6736,	6731,	6727,	6722,	6717,	6713,	6708,	6704,
	6699,	6695,	6690,	6686,	6681,	6677,	6672,	6668,	6663,	6659,	6654,	6650,	6645,	6641,	6636,	6632,
	6627,	6623,	6618,	6614,	6609,	6605,	6600,	6596,	6591,	6587,	6582,	6578,	6573,	6569,	6565,	6560,
	6556,	6551,	6547,	6542,	6538,	6533,	6529,	6525,	6520,	6516,	6511,	6507,	6502,	6498,	6494,	6489,
	6485,	6480,	6476,	6471,	6467,	6463,	6458,	6454,	6449,	6445,	6441,	6436,	6432,	6428,	6423,	6419,
	6414,	6410,	6406,	6401,	6397,	6393,	6388,	6384,	6379,	6375,	6371,	6366,	6362,	6358,	6353,	6349,
	6345,	6340,	6336,	6332,	6327,	6323,	6319,	6314,	6310,	6306,	6301,	6297,	6293,	6288,	6284,	6280,
	6276,	6271,	6267,	6263,	6258,	6254,	6250,	6245,	6241,	6237,	6233,	6228,	6224,	6220,	6215,	6211,
	6207,	6203,	6198,	6194,	6190,	6186,	6181,	6177,	6173,	6169,	6164,	6160,	6156,	6152,	6147,	6143,
	6139,	6135,	6131,	6126,	6122,	6118,	6114,	6109,	6105,	6101,	6097,	6093,	6088,	6084,	6080,	6076,
	6072,	6067,	6063,	6059,	6055,	6051,	6046,	6042,	6038,	6034,	6030,	6026,	6021,	6017,	6013,	6009,
	6005,	6001,	5996,	5992,	5988,	5984,	5980,	5976,	5971,	5967,	5963,	5959,	5955,	5951,	5947,	5942,
	5938,	5934,	5930,	5926,	5922,	5918,	5914,	5909,	5905,	5901,	5897,	5893,	5889,	5885,	5881,	5877,
	5873,	5868,	5864,	5860,	5856,	5852,	5848,	5844,	5840,	5836,	5832,	5828,	5824,	5819,	5815,	5811,
	5807,	5803,	5799,	5795,	5791,	5787,	5783,	5779,	5775,	5771,	5767,	5763,	5759,	5755,	5751,	5747,
	5743,	5738,	5734,	5730,	5726,	5722,	5718,	5714,	5710,	5706,	5702,	5698,	5694,	5690,	5686,	5682,
	5678,	5674,	5670,	5666,	5662,	5658,	5654,	5650,	5646,	5642,	5638,	5634,	5630,	5626,	5622,	5618,
	5615,	5611,	5607,	5603,	5599,	5595,	5591,	5587,	5583,	5579,	5575,	5571,	5567,	5563,	5559,	5555,
	5551,	5547,	5543,	5539,	5536,	5532,	5528,	5524,	5520,	5516,	5512,	5508,	5504,	5500,	5496,	5492,
	5488,	5485,	5481,	5477,	5473,	5469,	5465,	5461,	5457,	5453,	5449,	5446,	5442,	5438,	5434,	5430,
	5426,	5422,	5418,	5415,	5411,	5407,	5403,	5399,	5395,	5391,	5387,	5384,	5380,	5376,	5372,	5368,
	5364,	5361,	5357,	5353,	5349,	5345,	5341,	5337,	5334,	5330,	5326,	5322,	5318,	5314,	5311,	5307,
	5303,	5299,	5295,	5292,	5288,	5284,	5280,	5276,	5272,	5269,	5265,	5261,	5257,	5253,	5250,	5246,
	5242,	5238,	5235,	5231,	5227,	5223,	5219,	5216,	5212,	5208,	5204,	5200,	5197,	5193,	5189,	5185,
	5182,	5178,	5174,	5170,	5167,	5163,	5159,	5155,	5152,	5148,	5144,	5140,	5137,	5133,	5129,	5125,
	5122,	5118,	5114,	5110,	5107,	5103,	5099,	5095,	5092,	5088,	5084,	5081,	5077,	5073,	5069,	5066,
	5062,	5058,	5055,	5051,	5047,	5044,	5040,	5036,	5032,	5029,	5025,	5021,	5018,	5014,	5010,	5007,
	5003,	4999,	4996,	4992,	4988,	4984,	4981,	4977,	4973,	4970,	4966,	4962,	4959,	4955,	4951,	4948,
	4944,	4941,	4937,	4933,	4930,	4926,	4922,	4919,	4915,	4911,	4908,	4904,	4900,	4897,	4893,	4889,
	4886,	4882,	4879,	4875,	4871,	4868,	4864,	4860,	4857,	4853,	4850,	4846,	4842,	4839,	4835,	4832,
	4828,	4824,	4821,	4817,	4814,	4810,	4806,	4803,	4799,	4796,	4792,	4788,	4785,	4781,	4778,	4774,
	4770,	4767,	4763,	4760,	4756,	4753,	4749,	4745,	4742,	4738,	4735,	4731,	4728,	4724,	4720,	4717,
	4713,	4710,	4706,	4703,	4699,	4696,	4692,	4689,	4685,	4681,	4678,	4674,	4671,	4667,	4664,	4660,
	4657,	4653,	4650,	4646,	4643,	4639,	4636,	4632,	4628,	4625,	4621,	4618,	4614,	4611,	4607,	4604,
	4600,	4597,	4593,	4590,	4586,	4583,	4579,	4576,	4572,	4569,	4565,	4562,	4558,	4555,	4551,	4548,
	4544,	4541,	4538,	4534,	4531,	4527,	4524,	4520,	4517,	4513,	4510,	4506,	4503,	4499,	4496,	4492,
	4489,	4485,	4482,	4479,	4475,	4472,	4468,	4465,	4461,	4458,	4454,	4451,	4448,	4444,	4441,	4437,
	4434,	4430,	4427,	4423,	4420,	4417,	4413,	4410,	4406,	4403,	4399,	4396,	4393,	4389,	4386,	4382,
	4379,	4376,	4372,	4369,	4365,	4362,	4359,	4355,	4352,	4348,	4345,	4342,	4338,	4335,	4331,	4328,
	4325,	4321,	4318,	4314,	4311,	4308,	4304,	4301,	4297,	4294,	4291,	4287,	4284,	4281,	4277,	4274,
	4270,	4267,	4264,	4260,	4257,	4254,	4250,	4247,	4244,	4240,	4237,	4233,	4230,	4227,	4223,	4220,
	4217,	4213,	4210,	4207,	4203,	4200,	4197,	4193,	4190,	4187,	4183,	4180,	4177,	4173,	4170,	4167,
	4163,	4160,	4157,	4153,	4150,	4147,	4143,	4140,	4137,	4134,	4130,	4127,	4124,	4120,	4117,	4114,
	4110,	4107,	4104,	4100,	4097,	4094,	4091,	4087,	4084,	4081,	4077,	4074,	4071,	4068,	4064,	4061,
	4058,	4054,	4051,	4048,	4045,	4041,	4038,	4035,	4031,	4028,	4025,	4022,	4018,	4015,	4012,	4009,
	4005,	4002,	3999,	3996,	3992,	3989,	3986,	3983,	3979,	3976,	3973,	3970,	3966,	3963,	3960,	3957,
	3953,	3950,	3947,	3944,	3940,	3937,	3934,	3931,	3927,	3924,	3921,	3918,	3915,	3911,	3908,	3905,
	3902,	3898,	3895,	3892,	3889,	3886,	3882,	3879,	3876,	3873,	3869,	3866,	3863,	3860,	3857,	3853,
	3850,	3847,	3844,	3841,	3837,	3834,	3831,	3828,	3825,	3822,	3818,	3815,	3812,	3809,	3806,	3802,
	3799,	3796,	3793,	3790,	3787,	3783,	3780,	3777,	3774,	3771,	3767,	3764,	3761,	3758,	3755,	3752,
	3749,	3745,	3742,	3739,	3736,	3733,	3730,	3726,	3723,	3720,	3717,	3714,	3711,	3708,	3704,	3701,
	3698,	3695,	3692,	3689,	3686,	3682,	3679,	3676,	3673,	3670,	3667,	3664,	3660,	3657,	3654,	3651,
	3648,	3645,	3642,	3639,	3636,	3632,	3629,	3626,	3623,	3620,	3617,	3614,	3611,	3608,	3604,	3601,
	3598,	3595,	3592,	3589,	3586,	3583,	3580,	3576,	3573,	3570,	3567,	3564,	3561,	3558,	3555,	3552,
	3549,	3546,	3543,	3539,	3536,	3533,	3530,	3527,	3524,	3521,	3518,	3515,	3512,	3509,	3506,	3503,
	3499,	3496,	3493,	3490,	3487,	3484,	3481,	3478,	3475,	3472,	3469,	3466,	3463,	3460,	3457,	3454,
	3451,	3448,	3444,	3441,	3438,	3435,	3432,	3429,	3426,	3423,	3420,	3417,	3414,	3411,	3408,	3405,
	3402,	3399,	3396,	3393,	3390,	3387,	3384,	3381,	3378,	3375,	3372,	3369,	3366,	3363,	3360,	3357,
	3354,	3351,	3348,	3345,	3342,	3339,	3336,	3333,	3330,	3327,	3324,	3321,	3318,	3315,	3312,	3309,
	3306,	3303,	3300,	3297,	3294,	3291,	3288,	3285,	3282,	3279,	3276,	3273,	3270,	3267,	3264,	3261,
	3258,	3255,	3252,	3249,	3246,	3243,	3240,	3237,	3234,	3231,	3228,	3225,	3222,	3219,	3216,	3213,
	3210,	3207,	3204,	3201,	3198,	3196,	3193,	3190,	3187,	3184,	3181,	3178,	3175,	3172,	3169,	3166,
	3163,	3160,	3157,	3154,	3151,	3148,	3145,	3143,	3140,	3137,	3134,	3131,	3128,	3125,	3122,	3119,
	3116,	3113,	3110,	3107,	3104,	3102,	3099,	3096,	3093,	3090,	3087,	3084,	3081,	3078,	3075,	3072,
	3069,	3067,	3064,	3061,	3058,	3055,	3052,	3049,	3046,	3043,	3040,	3038,	3035,	3032,	3029,	3026,
	3023,	3020,	3017,	3014,	3012,	3009,	3006,	3003,	3000,	2997,	2994,	2991,	2988,	2986,	2983,	2980,
	2977,	2974,	2971,	2968,	2965,	2963,	2960,	2957,	2954,	2951,	2948,	2945,	2942,	2940,	2937,	2934,
	2931,	2928,	2925,	2922,	2920,	2917,	2914,	2911,	2908,	2905,	2902,	2900,	2897,	2894,	2891,	2888,
	2885,	2883,	2880,	2877,	2874,	2871,	2868,	2866,	2863,	2860,	2857,	2854,	2851,	2848,	2846,	2843,
	2840,	2837,	2834,	2832,	2829,	2826,	2823,	2820,	2817,	2815,	2812,	2809,	2806,	2803,	2800,	2798,
	2795,	2792,	2789,	2786,	2784,	2781,	2778,	2775,	2772,	2770,	2767,	2764,	2761,	2758,	2756,	2753,
	2750,	2747,	2744,	2742,	2739,	2736,	2733,	2730,	2728,	2725,	2722,	2719,	2716,	2714,	2711,	2708,
	2705,	2703,	2700,	2697,	2694,	2691,	2689,	2686,	2683,	2680,	2678,	2675,	2672,	2669,	2666,	2664,
	2661,	2658,	2655,	2653,	2650,	2647,	2644,	2642,	2639,	2636,	2633,	2631,	2628,	2625,	2622,	2620,
	2617,	2614,	2611,	2609,	2606,	2603,	2600,	2598,	2595,	2592,	2589,	2587,	2584,	2581,	2578,	2576,
	2573,	2570,	2567,	2565,	2562,	2559,	2556,	2554,	2551,	2548,	2546,	2543,	2540,	2537,	2535,	2532,
	2529,	2526,	2524,	2521,	2518,	2516,	2513,	2510,	2507,	2505,	2502,	2499,	2497,	2494,	2491,	2488,
	2486,	2483,	2480,	2478,	2475,	2472,	2469,	2467,	2464,	2461,	2459,	2456,	2453,	2451,	2448,	2445,
	2442,	2440,	2437,	2434,	2432,	2429,	2426,	2424,	2421,	2418,	2416,	2413,	2410,	2408,	2405,	2402,
	2399,	2397,	2394,	2391,	2389,	2386,	2383,	2381,	2378,	2375,	2373,	2370,	2367,	2365,	2362,	2359,
	2357,	2354,	2351,	2349,	2346,	2343,	2341,	2338,	2335,	2333,	2330,	2327,	2325,	2322,	2319,	2317,
	2314,	2311,	2309,	2306,	2304,	2301,	2298,	2296,	2293,	2290,	2288,	2285,	2282,	2280,	2277,	2274,
	2272,	2269,	2267,	2264,	2261,	2259,	2256,	2253,	2251,	2248,	2245,	2243,	2240,	2238,	2235,	2232,
	2230,	2227,	2224,	2222,	2219,	2217,	2214,	2211,	2209,	2206,	2203,	2201,	2198,	2196,	2193,	2190,
	2188,	2185,	2183,	2180,	2177,	2175,	2172,	2170,	2167,	2164,	2162,	2159,	2156,	2154,	2151,	2149,
	2146,	2143,	2141,	2138,	2136,	2133,	2131,	2128,	2125,	2123,	2120,	2118,	2115,	2112,	2110,	2107,
	2105,	2102,	2099,	2097,	2094,	2092,	2089,	2087,	2084,	2081,	2079,	2076,	2074,	2071,	2068,	2066,
	2063,	2061,	2058,	2056,	2053,	2050,	2048,	2045,	2043,	2040,	2038,	2035,	2033,	2030,	2027,	2025,
	2022,	2020,	2017,	2015,	2012,	2009,	2007,	2004,	2002,	1999,	1997,	1994,	1992,	1989,	1987,	1984,
	1981,	1979,	1976,	1974,	1971,	1969,	1966,	1964,	1961,	1959,	1956,	1953,	1951,	1948,	1946,	1943,
	1941,	1938,	1936,	1933,	1931,	1928,	1926,	1923,	1921,	1918,	1915,	1913,	1910,	1908,	1905,	1903,
	1900,	1898,	1895,	1893,	1890,	1888,	1885,	1883,	1880,	1878,	1875,	1873,	1870,	1868,	1865,	1863,
	1860,	1858,	1855,	1853,	1850,	1848,	1845,	1843,	1840,	1837,	1835,	1832,	1830,	1827,	1825,	1822,
	1820,	1817,	1815,	1813,	1810,	1808,	1805,	1803,	1800,	1798,	1795,	1793,	1790,	1788,	1785,	1783,
	1780,	1778,	1775,	1773,	1770,	1768,	1765,	1763,	1760,	1758,	1755,	1753,	1750,	1748,	1745,	1743,
	1740,	1738,	1736,	1733,	1731,	1728,	1726,	1723,	1721,	1718,	1716,	1713,	1711,	1708,	1706,	1703,
	1701,	1699,	1696,	1694,	1691,	1689,	1686,	1684,	1681,	1679,	1676,	1674,	1671,	1669,	1667,	1664,
	1662,	1659,	1657,	1654,	1652,	1649,	1647,	1645,	1642,	1640,	1637,	1635,	1632,	1630,	1627,	1625,
	1623,	1620,	1618,	1615,	1613,	1610,	1608,	1606,	1603,	1601,	1598,	1596,	1593,	1591,	1589,	1586,
	1584,	1581,	1579,	1576,	1574,	1572,	1569,	1567,	1564,	1562,	1559,	1557,	1555,	1552,	1550,	1547,
	1545,	1543,	1540,	1538,	1535,	1533,	1530,	1528,	1526,	1523,	1521,	1518,	1516,	1514,	1511,	1509,
	1506,	1504,	1502,	1499,	1497,	1494,	1492,	1490,	1487,	1485,	1482,	1480,	1478,	1475,	1473,	1470,
	1468,	1466,	1463,	1461,	1458,	1456,	1454,	1451,	1449,	1447,	1444,	1442,	1439,	1437,	1435,	1432,
	1430,	1427,	1425,	1423,	1420,	1418,	1416,	1413,	1411,	1408,	1406,	1404,	1401,	1399,	1397,	1394,
	1392,	1389,	1387,	1385,	1382,	1380,	1378,	1375,	1373,	1371,	1368,	1366,	1363,	1361,	1359,	1356,
	1354,	1352,	1349,	1347,	1345,	1342,	1340,	1337,	1335,	1333,	1330,	1328,	1326,	1323,	1321,	1319,
	1316,	1314,	1312,	1309,	1307,	1305,	1302,	1300,	1298,	1295,	1293,	1291,	1288,	1286,	1283,	1281,
	1279,	1276,	1274,	1272,	1269,	1267,	1265,	1262,	1260,	1258,	1255,	1253,	1251,	1248,	1246,	1244,
	1241,	1239,	1237,	1235,	1232,	1230,	1228,	1225,	1223,	1221,	1218,	1216,	1214,	1211,	1209,	1207,
	1204,	1202,	1200,	1197,	1195,	1193,	1190,	1188,	1186,	1184,	1181,	1179,	1177,	1174,	1172,	1170,
	1167,	1165,	1163,	1160,	1158,	1156,	1154,	1151,	1149,	1147,	1144,	1142,	1140,	1137,	1135,	1133,
	1131,	1128,	1126,	1124,	1121,	1119,	1117,	1114,	1112,	1110,	1108,	1105,	1103,	1101,	1098,	1096,
	1094,	1092,	1089,	1087,	1085,	1082,	1080,	1078,	1076,	1073,	1071,	1069,	1067,	1064,	1062,	1060,
	1057,	1055,	1053,	1051,	1048,	1046,	1044,	1041,	1039,	1037,	1035,	1032,	1030,	1028,	1026,	1023,
	1021,	1019,	1017,	1014,	1012,	1010,	1007,	1005,	1003,	1001,	998,	996,	994,	992,	989,	987,
	985,	983,	980,	978,	976,	974,	971,	969,	967,	965,	962,	960,	958,	956,	953,	951,
	949,	947,	944,	942,	940,	938,	935,	933,	931,	929,	926,	924,	922,	920,	918,	915,
	913,	911,	909,	906,	904,	902,	900,	897,	895,	893,	891,	888,	886,	884,	882,	880,
	877,	875,	873,	871,	868,	866,	864,	862,	860,	857,	855,	853,	851,	848,	846,	844,
	842,	840,	837,	835,	833,	831,	829,	826,	824,	822,	820,	817,	815,	813,	811,	809,
	806,	804,	802,	800,	798,	795,	793,	791,	789,	787,	784,	782,	780,	778,	776,	773,
	771,	769,	767,	765,	762,	760,	758,	756,	754,	751,	749,	747,	745,	743,	740,	738,
	736,	734,	732,	730,	727,	725,	723,	721,	719,	716,	714,	712,	710,	708,	706,	703,
	701,	699,	697,	695,	692,	690,	688,	686,	684,	682,	679,	677,	675,	673,	671,	669,
	666,	664,	662,	660,	658,	656,	653,	651,	649,	647,	645,	643,	640,	638,	636,	634,
	632,	630,	627,	625,	623,	621,	619,	617,	614,	612,	610,	608,	606,	604,	602,	599,
	597,	595,	593,	591,	589,	587,	584,	582,	580,	578,	576,	574,	571,	569,	567,	565,
	563,	561,	559,	556,	554,	552,	550,	548,	546,	544,	542,	539,	537,	535,	533,	531,
	529,	527,	524,	522,	520,	518,	516,	514,	512,	510,	507,	505,	503,	501,	499,	497,
	495,	493,	490,	488,	486,	484,	482,	480,	478,	476,	473,	471,	469,	467,	465,	463,
	461,	459,	456,	454,	452,	450,	448,	446,	444,	442,	440,	437,	435,	433,	431,	429,
	427,	425,	423,	421,	419,	416,	414,	412,	410,	408,	406,	404,	402,	400,	397,	395,
	393,	391,	389,	387,	385,	383,	381,	379,	377,	374,	372,	370,	368,	366,	364,	362,
	360,	358,	356,	354,	351,	349,	347,	345,	343,	341,	339,	337,	335,	333,	331,	328,
	326,	324,	322,	320,	318,	316,	314,	312,	310,	308,	306,	304,	301,	299,	297,	295,
	293,	291,	289,	287,	285,	283,	281,	279,	277,	275,	272,	270,	268,	266,	264,	262,
	260,	258,	256,	254,	252,	250,	248,	246,	244,	242,	239,	237,	235,	233,	231,	229,
	227,	225,	223,	221,	219,	217,	215,	213,	211,	209,	207,	205,	202,	200,	198,	196,
	194,	192,	190,	188,	186,	184,	182,	180,	178,	176,	174,	172,	170,	168,	166,	164,
	162,	160,	158,	155,	153,	151,	149,	147,	145,	143,	141,	139,	137,	135,	133,	131,
	129,	127,	125,	123,	121,	119,	117,	115,	113,	111,	109,	107,	105,	103,	101,	99,
	97,	95,	93,	90,	88,	86,	84,	82,	80,	78,	76,	74,	72,	70,	68,	66,
	64,	62,	60,	58,	56,	54,	52,	50,	48,	46,	44,	42,	40,	38,	36,	34,
	32,	30,	28,	26,	24,	22,	20,	18,	16,	14,	12,	10,	8,	6,	4,	2,
};
