
// ****************************************************************************
//
//                            Page C - capacitor meter
//
// ****************************************************************************
// Range: 1pF to 4mF, precision 10%
// Do not leave the programmer pins connected during capacitor and resistor measurements.

#ifndef _PAGE_C_H
#define _PAGE_C_H

#ifdef __cplusplus
extern "C" {
#endif

#define U_LOW	(4096/4)	// low voltage level (= 1024)
#define U_HIGH	(4096/4*3)	// high voltage level (= 3072)

// timing in [us]
#define C_PERIOD_FAST	(20000*HCLK_PER_US) // fast period ... 10 ms
#define C_PERIOD_INT	(19000*HCLK_PER_US) // middle period of SysTick ... 19 ms
#define C_PERIOD_SLOW	(500000*HCLK_PER_US) // slow period ... 500 ms

// Page C (returns key PREV/NEXT)
u8 PageC();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_C_H
