
// ****************************************************************************
//
//                               Keys
//
// ****************************************************************************

#ifndef _KEY_H
#define _KEY_H

#ifdef __cplusplus
extern "C" {
#endif

// Key codes
#define KEY_PREV	1		// key "Prev", short
#define KEY_NEXT	2		// key "Next", short
#define KEY_SLOW	3		// key "Slow", short
#define KEY_FAST	4		// key "Fast", short
#define KEY_HOLD	5		// key "Hold", short

#define KEY_FIRST	KEY_PREV

#define KEY_NUM		5		// number of keys

#define KEY_PREV_LONG	6		// key "Prev", long
#define KEY_NEXT_LONG	7		// key "Next", long
#define KEY_SLOW_LONG	8		// key "Slow", long
#define KEY_FAST_LONG	9		// key "Fast", long
#define KEY_HOLD_LONG	10		// key "Hold", long

#define KEY_FIRST_LONG	KEY_PREV_LONG

#define NOKEY		0		// no key

// Key GPIOs
#define KEY_PREV_GPIO	PD0		// key "Prev" GPIO
#define KEY_NEXT_GPIO	PA3		// key "Next" GPIO
#define KEY_SLOW_GPIO	PB0		// key "Slow" GPIO
#define KEY_FAST_GPIO	PB1		// key "Fast" GPIO
#define KEY_HOLD_GPIO	PA0		// key "Hold" GPIO

// last pressed key
extern volatile u8 KeyBuf;

extern Bool KeyUseLong[KEY_NUM];	// flags - use long pressed key

// set 'Hold' key to short/long mode
INLINE void KeyHoldShort() { KeyUseLong[KEY_HOLD-1] = False; }
INLINE void KeyHoldLong() { KeyUseLong[KEY_HOLD-1] = True; }

// get press button (NOKEY = no key)
u8 KeyGet();

// flush key buffer
void KeyFlush();

// Initialize keyboard service
void KeyInit();

#ifdef __cplusplus
}
#endif

#endif // _KEY_H
