
// ****************************************************************************
//
//                                   Drawing
//
// ****************************************************************************

#ifndef _DRAW_H
#define _DRAW_H

#ifdef __cplusplus
extern "C" {
#endif

#define COL_BLACK	0		// black color
#define COL_WHITE	1		// white color

#define FONT		FontBold8x12x128 // default font
#define FONTH		12		// height of the font
#define FONTH2		(FONTH*2)	// height of double-sized font

extern const u8* DrawFont;	// current draw font
extern int FontHeight;		// height of system font

// clear screen
void DrawClear();

// draw/clear/set/invert pixel (fast version does not check coordinates)
void DrawPointFast(int x, int y, u8 col);
void DrawPoint(int x, int y, u8 col);
void DrawPointClrFast(int x, int y);
void DrawPointClr(int x, int y);
void DrawPointSetFast(int x, int y);
void DrawPointSet(int x, int y);
void DrawPointInvFast(int x, int y);
void DrawPointInv(int x, int y);

// draw/clear/set/invert rectangle (fast version: x and w must be multiply of 8, does not check coordinates)
void DrawRectFast(int x, int y, int w, int h, u8 col);
void DrawRect(int x, int y, int w, int h, u8 col);
void DrawRectClrFast(int x, int y, int w, int h);
void DrawRectClr(int x, int y, int w, int h);
void DrawRectSetFast(int x, int y, int w, int h);
void DrawRectSet(int x, int y, int w, int h);
void DrawRectInvFast(int x, int y, int w, int h);
void DrawRectInv(int x, int y, int w, int h);

// draw/clear/set/invert horizontal line (fast version: x and w must be multiply of 8, does not check coordinates)
void DrawHLineFast(int x, int y, int w, u8 col);
void DrawHLine(int x, int y, int w, u8 col);
void DrawHLineClrFast(int x, int y, int w);
void DrawHLineClr(int x, int y, int w);
void DrawHLineSetFast(int x, int y, int w);
void DrawHLineSet(int x, int y, int w);
void DrawHLineInvFast(int x, int y, int w);
void DrawHLineInv(int x, int y, int w);

// draw/clear/set/invert vertical line
void DrawVLine(int x, int y, int h, u8 col);
void DrawVLineClr(int x, int y, int h);
void DrawVLineSet(int x, int y, int h);
void DrawVLineInv(int x, int y, int h);

// draw/clear/set(invert frame
void DrawFrame(int x, int y, int w, int h, u8 col);
void DrawFrameClr(int x, int y, int w, int h);
void DrawFrameSet(int x, int y, int w, int h);
void DrawFrameInv(int x, int y, int w, int h);

// draw line
void DrawLine(int x1, int y1, int x2, int y2, u8 col);

// set line fast (no checks)
void DrawLineSetFast(int x1, int y1, int x2, int y2);

// draw character normal/inverted (fast version: x must be multiply of 8, does not check coordinates)
void DrawCharFast(char ch, int x, int y);
void DrawChar(char ch, int x, int y);
void DrawCharInvFast(char ch, int x, int y);
void DrawCharInv(char ch, int x, int y);

// Draw character double-sized
void DrawChar2(char ch, int x, int y);

// Draw text normal/inverted (fast version: x must be multiply of 8, does not check coordinates)
void DrawTextFast(const char* text, int x, int y);
void DrawText(const char* text, int x, int y);
void DrawTextInvFast(const char* text, int x, int y);
void DrawTextInv(const char* text, int x, int y);

// Draw text double-sized
void DrawText2(const char* text, int x, int y);

// set print font
void SetFont(const char* font, int fonth);

// display unsigned value (returns next X coordinate; need to call DispUpdate())
//  x ... X coordinate
//  y ... Y coordinate
//  val ... value
//  dig ... number of valid digits
//  ex ... decimal exponent related to base unit, in range -18..+8
//  unit ... unit character, 0=none
//  small ... use small unit characters
//  allsmall ... display all text small
int DispUVal(int x, int y, u32 val, int dig, int ex, char unit, Bool small, Bool allsmall);

// display signed value (returns next X coordinate; need to call DispUpdate())
//  x ... X coordinate
//  y ... Y coordinate
//  val ... value
//  dig ... number of valid digits
//  ex ... decimal exponent related to base unit, in range -18..+8
//  unit ... unit character, 0=none
//  small ... use small unit characters
//  allsmall ... display all text small
int DispVal(int x, int y, s32 val, int dig, int ex, char unit, Bool small, Bool allsmall);

#ifdef __cplusplus
}
#endif

#endif // _DRAW_H
