
// ****************************************************************************
//
//                             Display driver
//
// ****************************************************************************
// OLED I2C 0.96" SSD1306 display blue+yellow, resolution 128x64 pixels, controller SSD1306, power 3 to 5V.
// https://www.hadex.cz/m508c-displej-oled-096-128x64-znaku-iici2c-4piny-modrozluty/

#if USE_DISP		// 1=use software display driver, 2=use hardware display driver (0=no driver)

#ifndef _DISP_H
#define _DISP_H

#ifdef __cplusplus
extern "C" {
#endif

#define DISP_SDA_PORT	GPIO_PORT(DISP_SDA_GPIO)	// display port with SDA
#define DISP_SCL_PORT	GPIO_PORT(DISP_SCL_GPIO)	// display port with SCL
#define DISP_SDA_PIN	GPIO_PIN(DISP_SDA_GPIO)		// display pin with SDA
#define DISP_SCL_PIN	GPIO_PIN(DISP_SCL_GPIO)		// display pin with SCL

#define WIDTH		128		// width in pixels
#define HEIGHT		64		// height in graphics lines
#define WIDTHBYTE	(WIDTH/8)	// width in bytes (= 16)
#define FRAMESIZE	(WIDTHBYTE*HEIGHT) // size of frame buffer in bytes (= 16*64 = 1024 bytes)
#define TEXTWIDTH	(WIDTH/8)	// text width in characters (= 16)
#define TEXTHEIGHT	(HEIGHT/8)	// text height in rows (= 8; 1 character = 8x8 pixels)

// Pointer to FrameBuf is defined as part od common data buffer (see main.h)
//extern u8 FrameBuf[FRAMESIZE];		// display graphics buffer

// start I2C communication
void DispI2C_Start(void);

// stop I2C communication
void DispI2C_Stop(void);

// write a byte over I2C
void DispI2C_Write(u8 data);

// Display select SSD1306 page, start transfer data
void DispI2C_SelectPage(int page);

// Display initialize
void DispInit(void);

// Display terminate
void DispTerm(void);

// Display update - send frame buffer to the display (takes 12 ms)
void DispUpdate();

#ifdef __cplusplus
}
#endif

#endif // _DISP_H

#endif // USE_DISP
