; ****************************************************************************
;
;                       Delay loop (F_CPU = 8000000, 4000000)
;
; ****************************************************************************

#include "include.inc"

#define	nop2		rjmp	.+0	; [2] shorter form of "nop nop"

	.text

; ============================================================================
;                                  8 MHz 
; ============================================================================
; Quartz 8 MHz, 1 clock = 0.125 us, 1 us = 8 clocks

#if F_CPU >= 6000000

; ----------------------------------------------------------------------------
;                     Delay 10 us (8 MHz: 80 clock cycles)
; ----------------------------------------------------------------------------
; DESTROYS: -
; ----------------------------------------------------------------------------
; clocks = 3 + 2 + 1 + 2 + 2 + (13-1)*5 + 4 + 2 + 4 = 80

.global Wait10us
Wait10us:

	; rcall	Wait10us	; [rcall 3]

	push	r24		; [2] push R24
	
	ldi	r24,13		; [1]
	nop2			; [2]
1:	nop2			; [2]

2:	nop2			; [2]
	dec	r24		; [1]
	brne	2b		; [1,2]

	pop	r24		; [2] pop R24
	ret			; [4]

; ----------------------------------------------------------------------------
;                     Delay 100 us (8 MHz: 800 clock cycles)
; ----------------------------------------------------------------------------
; DESTROYS: -
; ----------------------------------------------------------------------------
; clocks = 3 + 2 + 1 + 2 + 2 + (157-1)*5 + 4 + 2 + 4 = 800

.global Wait100us
Wait100us:

	; rcall	Wait100us	; [rcall 3]

	push	r24		; [2] push R24

	ldi	r24,157		; [1]
	rjmp	1b		; [2]

; ============================================================================
;                                  4 MHz 
; ============================================================================
; Quartz 4 MHz, 1 clock = 0.25 us, 1 us = 4 clocks

#else  // #if F_CPU >= 6000000

; ----------------------------------------------------------------------------
;                     Delay 10 us (4 MHz: 40 clock cycles)
; ----------------------------------------------------------------------------
; DESTROYS: -
; ----------------------------------------------------------------------------
; clocks = 3 + 2 + 1 + 2 + 2 + (5-1)*5 + 4 + 2 + 4 = 40

.global Wait10us
Wait10us:

	; rcall	Wait10us	; [rcall 3]

	push	r24		; [2] push R24
	
	ldi	r24,5		; [1]
	nop2			; [2]
1:	nop2			; [2]

2:	nop2			; [2]
	dec	r24		; [1]
	brne	2b		; [1,2]

	pop	r24		; [2] pop R24
	ret			; [4]

; ----------------------------------------------------------------------------
;                     Delay 100 us (4 MHz: 400 clock cycles)
; ----------------------------------------------------------------------------
; DESTROYS: -
; ----------------------------------------------------------------------------
; clocks = 3 + 2 + 1 + 2 + 2 + (77-1)*5 + 4 + 2 + 4 = 400

.global Wait100us
Wait100us:

	; rcall	Wait100us	; [rcall 3]

	push	r24		; [2] push R24

	ldi	r24,77		; [1]
	rjmp	1b		; [2]

#endif // #if F_CPU >= 6000000

; ----------------------------------------------------------------------------
;                           Delay 10 ms
; ----------------------------------------------------------------------------
; DESTROYS: R24
; ----------------------------------------------------------------------------

.global Wait10ms
Wait10ms:
	ldi	r24,10		; 10 ms
	rjmp	Waitms

; ----------------------------------------------------------------------------
;                           Delay 100 ms
; ----------------------------------------------------------------------------
; DESTROYS: R24
; ----------------------------------------------------------------------------

.global Wait100ms
Wait100ms:
	ldi	r24,100		; 100 ms
	rjmp	Waitms

; ----------------------------------------------------------------------------
;                           Delay 1 second
; ----------------------------------------------------------------------------
; DESTROYS: R24
; ----------------------------------------------------------------------------

.global Wait1s
Wait1s:
	rcall	Wait250ms
	rcall	Wait250ms
	rcall	Wait250ms

; ----------------------------------------------------------------------------
;                           Delay 250 ms
; ----------------------------------------------------------------------------
; DESTROYS: R24
; ----------------------------------------------------------------------------

.global Wait250ms
Wait250ms:
	ldi	r24,250		; 250 ms

; Waitms must follow

; ----------------------------------------------------------------------------
;                           Delay 1..255 ms
; ----------------------------------------------------------------------------
; INPUT: R24 = numer of [ms]
; DESTROYS: -
; ----------------------------------------------------------------------------

.global Waitms
Waitms:

	push	r24
	push	r25

1:	ldi	r25,10		; counter to 1 ms

; DESTROYS: -
2:	rcall	Wait100us	; wait 100 us
	dec	r25
	brne	2b

	dec	r24		; counter of ms
	brne	1b

	pop	r25
	pop	r24
	ret

