#include "../include.h"

// format: Attribute compressed 4x4/4 colors 8-bit paletted pixel graphics
// compression ratio: 50%
// required memory: 16640 B pixels, 16640 B attributes (33280 B total, unpacked 66560 B)
// image width: 320 pixels
// image height: 208 lines
// image pixels pitch: 80 bytes
// image attribute pitch: 320 bytes
const u16 ImgAttr8_Pal[256] __attribute__ ((aligned(4))) = {
	0xE861, 0xC041, 0x8821, 0x1041, 0x0020, 0x6412, 0x532E, 0x95D9, 0x0331, 0x028D, 0x9E3A, 0x465E, 0x2C75, 0x8556, 0x0497, 0x03F3, 
	0x09C8, 0x3EBF, 0x3DDB, 0x3538, 0x232F, 0x4EBF, 0x428A, 0x161E, 0x157A, 0x124A, 0x2BD1, 0x4EBE, 0x4EFF, 0x56FF, 0x3208, 0x3E3C, 
	0x4EBD, 0x3F1F, 0x0945, 0x4EFE, 0x575F, 0x2145, 0x08A2, 0x5FDF, 0x67FF, 0x5570, 0x12C7, 0x44EE, 0x0C4A, 0x164E, 0x1F30, 0x5611, 
	0x1B89, 0x442B, 0x0A44, 0x3CEB, 0x348A, 0x3389, 0x44AB, 0x4CEC, 0x55AD, 0x4D2C, 0x44EB, 0x4CAB, 0x19C4, 0x2B27, 0x2245, 0x1923, 
	0x55AB, 0x4469, 0x4CAA, 0x44E9, 0x44A9, 0x4D2A, 0x664D, 0x2AC5, 0x4CEA, 0x4408, 0x3BC8, 0x556A, 0x4CE9, 0x3366, 0x4CA9, 0x0861, 
	0x18E3, 0x4D29, 0x55AA, 0x7F0E, 0x65EB, 0x5DEA, 0x08A1, 0x5DAA, 0x65AB, 0x5D2A, 0x4D27, 0x764C, 0x5CEA, 0x652B, 0x4CC7, 0x6DEB, 
	0x4C48, 0x648B, 0x656A, 0x6DAB, 0x5CA9, 0x4466, 0x1141, 0x4BA7, 0x3303, 0xDF9A, 0x2A22, 0xD736, 0x42A4, 0xB5F2, 0x2985, 0xEFF7, 
	0xE7B6, 0xCEB5, 0xEFF6, 0x52A8, 0x844D, 0xAD71, 0x6329, 0x9CEF, 0x5B03, 0xEFB7, 0xC633, 0xE791, 0xEFB5, 0xEFB6, 0x3A06, 0xF7F8, 
	0xADE2, 0x6B83, 0xDF0F, 0x73AB, 0x9D22, 0x8423, 0xEF57, 0xDF15, 0xFFF2, 0xDED4, 0xFFD4, 0xFFFA, 0xCE4F, 0xB58E, 0x18A1, 0x49E1, 
	0xFE02, 0x6AA1, 0x5A21, 0xFE45, 0xEDE5, 0x6AA2, 0x2101, 0xCCA1, 0xF5A2, 0x8322, 0x7AE2, 0x9BA3, 0xEDA5, 0xD525, 0xA3A1, 0xE522, 
	0xBC22, 0xCCA2, 0xC462, 0x49A1, 0x9362, 0xED64, 0xFDE5, 0xA3C3, 0xCCC4, 0xF5A5, 0xE565, 0xBC64, 0xAC24, 0xD4A1, 0xB3E1, 0xFD82, 
	0xED22, 0xD4A2, 0x51E1, 0x72A1, 0x6A61, 0xED65, 0xCC21, 0xE4C2, 0x82C1, 0x9B61, 0xCC62, 0xCC63, 0xE4C4, 0xBC23, 0xED24, 0xFDA5, 
	0xF565, 0x9B01, 0x3920, 0x4161, 0xB360, 0xBB80, 0xCBC0, 0xDC40, 0xFCE1, 0xDC43, 0x6A21, 0xB3A2, 0x59A1, 0xAB62, 0x8261, 0xC361, 
	0x92A1, 0xB321, 0x30E0, 0x9260, 0x71E0, 0xAAC1, 0x8A61, 0x7A21, 0x8A20, 0x61A0, 0xB2C1, 0x4920, 0xBB21, 0xCB62, 0x28E1, 0xA260, 
	0x79E0, 0x9A61, 0x71E1, 0x9220, 0x81E0, 0x71A0, 0x5940, 0x38E0, 0x79E1, 0x28A0, 0x9A20, 0x89E0, 0x79A0, 0x9221, 0xA200, 0x91E0, 
	0x6140, 0x81A0, 0x91A0, 0x7140, 0x40C0, 0x30A0, 0x9160, 0x8940, 0x38A0, 0x58C0, 0x1840, 0x2040, 0x68A0, 0x3840, 0x4840, 0x5820, 
};

const u8 ImgAttr8_Attr[16640] __attribute__ ((aligned(4))) = {
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x14, 0x1C, 0x13, 0x27, 0x26, 0x20, 0x1A, 0x24, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x24, 0x1C, 0x27, 0x16, 0x1C, 0x13, 0x24, 0xF5, 0x1B, 0x16, 0x24, 
	0xFB, 0x13, 0xC3, 0x27, 0xF5, 0xA3, 0xF4, 0x76, 0xFA, 0xE5, 0xDB, 0xE3, 0xF5, 0xE0, 0xE6, 0xE3, 
	0xDE, 0x20, 0x95, 0x27, 0x00, 0x1C, 0x15, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x1C, 0x24, 
	0x56, 0x29, 0x35, 0x1F, 0x8E, 0x15, 0x14, 0x24, 0x00, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x3E, 0x12, 0x2B, 0x24, 0x66, 0x2B, 0x2A, 0x20, 0x15, 0x00, 0x1C, 0x27, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x15, 0x24, 0x1C, 0x27, 0x8E, 0x1C, 0x1A, 0x24, 
	0xFB, 0x13, 0xA3, 0x24, 0xF5, 0x76, 0x6E, 0x1C, 0xFB, 0xE6, 0xE7, 0xEA, 0xFA, 0xD9, 0xE7, 0xD8, 
	0x4F, 0xE0, 0xE6, 0xE3, 0x00, 0xE4, 0xE0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0xFF, 0xE0, 0x7E, 0xE3, 0xF8, 0x1C, 0x1A, 0x27, 0x00, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x12, 0x24, 0x1C, 0x27, 
	0x3D, 0x3A, 0x31, 0x2B, 0x8E, 0x3A, 0x19, 0x2F, 0x26, 0x1B, 0x3F, 0x27, 0x00, 0x00, 0x15, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x13, 0x1C, 0x15, 0x27, 
	0x6A, 0x43, 0x35, 0x2F, 0x66, 0x41, 0x4D, 0x43, 0x3C, 0x1C, 0x0C, 0x27, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x24, 0x1C, 0x27, 
	0x6E, 0x1C, 0x0C, 0x27, 0x04, 0x20, 0x6E, 0x27, 0xFD, 0x1A, 0xDB, 0x24, 0xFB, 0xE6, 0xF8, 0xD4, 
	0xD2, 0xE0, 0xE6, 0xE3, 0xE7, 0xE0, 0xDB, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xDB, 0xE3, 
	0x00, 0xE0, 0xE6, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xFD, 0x95, 0xF1, 0x1F, 0x22, 0x1C, 0x12, 0x27, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 
	0x00, 0x1C, 0x15, 0x24, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 0x3E, 0x15, 0x1A, 0x24, 
	0x47, 0x3A, 0x44, 0x39, 0x31, 0x3A, 0x36, 0x37, 0x66, 0x31, 0x3D, 0x2B, 0x66, 0x1B, 0x35, 0x27, 
	0x19, 0x1C, 0x12, 0x27, 0x15, 0x24, 0x1C, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 0x3E, 0x20, 0x1A, 0x24, 
	0x00, 0x43, 0x68, 0x4B, 0x4A, 0x43, 0x44, 0x45, 0x66, 0x35, 0x47, 0x24, 0x12, 0x1C, 0x15, 0x27, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x11, 0x24, 0x1C, 0x27, 0x6E, 0x1C, 0x13, 0x27, 0xF8, 0x12, 0x16, 0x24, 0xFD, 0x06, 0xC3, 0x1C, 
	0xFD, 0xE6, 0xD2, 0xE0, 0x8E, 0xE0, 0xE6, 0xE3, 0xE9, 0xE0, 0xE6, 0xE3, 0x00, 0xE4, 0xE0, 0xE3, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0xE0, 0xE5, 0xEB, 
	0xFB, 0xE4, 0xE6, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xE5, 0xE3, 0xF5, 0x06, 0xF0, 0x24, 0xFB, 0x1C, 0x13, 0x27, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x24, 0x1C, 0x27, 
	0x26, 0x12, 0x1A, 0x24, 0x00, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 0x3C, 0x1C, 0x0C, 0x27, 0x3C, 0x3A, 0x35, 0x2F, 
	0x00, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x36, 0x3A, 0x00, 0x3A, 0x31, 0x39, 0x47, 0x35, 0x3D, 0x37, 
	0x66, 0x47, 0x3E, 0x35, 0x56, 0x12, 0x14, 0x24, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x3C, 0x15, 0x0C, 0x27, 0x3C, 0x43, 0x47, 0x38, 
	0x41, 0x43, 0x44, 0x51, 0x00, 0x00, 0x00, 0x43, 0x47, 0x4A, 0x3D, 0x43, 0x26, 0x1F, 0x3D, 0x24, 
	0x00, 0x1C, 0x15, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x15, 0x24, 0x1C, 0x27, 0xF5, 0x1C, 0x0C, 0x27, 0xF8, 0x12, 0x7E, 0x24, 
	0xFB, 0xCA, 0xC2, 0x13, 0xFB, 0xE6, 0xF4, 0xE3, 0xE9, 0xD9, 0xE7, 0xE4, 0xD9, 0xEB, 0xE0, 0xE3, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xFB, 0xE0, 0xF4, 0xEB, 0xFA, 0xE0, 0xD9, 0xE3, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0xFB, 0xE0, 0xDB, 0xE3, 0xE9, 0xE0, 0xE6, 0xEA, 0x00, 0xE4, 0xE0, 0xE3, 0xE7, 0xE0, 0xD9, 0xEB, 
	0xE7, 0xE4, 0xF0, 0xE3, 0xE9, 0xE0, 0xF4, 0xEB, 0xEC, 0xEB, 0xE0, 0xD8, 0xFB, 0xD8, 0xF1, 0x12, 
	0xFA, 0x1C, 0x13, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x35, 0x1C, 0x13, 0x27, 
	0x3F, 0x37, 0x30, 0x2F, 0x10, 0x1C, 0x20, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x15, 0x24, 0x1C, 0x27, 0x2A, 0x1B, 0x31, 0x24, 0x3C, 0x39, 0x14, 0x2F, 0x35, 0x3A, 0x31, 0x37, 
	0x00, 0x00, 0x00, 0x3A, 0x31, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x3E, 0x3A, 0x41, 0x37, 
	0x26, 0x1A, 0x3D, 0x24, 0x26, 0x0B, 0x14, 0x24, 0x15, 0x00, 0x1C, 0x27, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x15, 0x24, 0x1C, 0x27, 0x3E, 0x4B, 0x31, 0x24, 0x00, 0x00, 0x43, 0x40, 
	0x49, 0x44, 0x41, 0x43, 0x00, 0x00, 0x44, 0x43, 0x3D, 0x43, 0x4A, 0x45, 0x3F, 0x3D, 0x47, 0x4A, 
	0x3F, 0x1C, 0x1A, 0x24, 0x00, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x15, 0x24, 0x1C, 0x27, 0x1E, 0x1C, 0x12, 0x24, 
	0xFE, 0x12, 0x73, 0x24, 0xF5, 0x6C, 0xC3, 0x0B, 0xFA, 0xF0, 0xE7, 0xEB, 0xD2, 0xD9, 0xDB, 0xE4, 
	0xE9, 0xE0, 0xF0, 0xEB, 0xFA, 0xE0, 0xF4, 0xEB, 0xFB, 0xE0, 0xDB, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0xE0, 0xFF, 0xE3, 0xF5, 0x83, 0xE4, 0x7F, 0xF5, 0x7A, 0x76, 0x7F, 
	0xFD, 0x87, 0x95, 0x8B, 0x00, 0xE0, 0xFE, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0xE7, 0xE0, 0xEC, 0xEB, 0xFA, 0xF0, 0xDB, 0xEA, 0xFA, 0xE5, 0xDB, 0xE3, 0xE7, 0xE0, 0xF0, 0xEB, 
	0x00, 0xEB, 0xE0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0xDE, 0xEA, 0xEC, 0x23, 0x08, 0x1C, 0x15, 0x27, 0x10, 0x1C, 0x1F, 0x27, 0x10, 0x29, 0x35, 0x24, 
	0x00, 0x2B, 0x31, 0x29, 0x3F, 0x2B, 0x3D, 0x24, 0x3C, 0x1B, 0x0C, 0x27, 0x00, 0x1C, 0x15, 0x24, 
	0x26, 0x12, 0x1A, 0x24, 0x3E, 0x40, 0x35, 0x27, 0x3C, 0x36, 0x19, 0x23, 0x31, 0x39, 0x3A, 0x38, 
	0x36, 0x00, 0x3A, 0x39, 0x3D, 0x36, 0x41, 0x37, 0x3F, 0x36, 0x35, 0x39, 0x3C, 0x3A, 0x3E, 0x37, 
	0x3F, 0x35, 0x47, 0x39, 0x3F, 0x0B, 0x19, 0x27, 0x00, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x15, 0x24, 0x1C, 0x27, 0x3C, 0x1F, 0x2B, 0x27, 0x00, 0x43, 0x6A, 0x4B, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x49, 0x44, 0x41, 0x43, 0x00, 0x00, 0x43, 0x45, 0x47, 0x49, 0x3D, 0x48, 
	0x26, 0x3D, 0x6A, 0x31, 0x00, 0x1C, 0x22, 0x27, 0x00, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 
	0x0C, 0x1C, 0x11, 0x27, 0xF5, 0x1B, 0x1E, 0x27, 0xF8, 0x0C, 0xCC, 0x24, 0xFB, 0xCC, 0xF4, 0xE3, 
	0xFB, 0xE6, 0xDB, 0xE3, 0xE9, 0xE0, 0xE7, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xDB, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xFA, 0xE4, 0xA3, 0x76, 0x77, 0x79, 0x6B, 0x7F, 0x03, 0x7A, 0x7E, 0x79, 
	0x4F, 0x6B, 0x7E, 0x7F, 0xF5, 0x77, 0xE8, 0x8B, 0xE7, 0xE0, 0xD9, 0xEB, 0xE7, 0xE0, 0xDB, 0xE3, 
	0xE9, 0xE0, 0xE7, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x4F, 0xE0, 0xE6, 0xE3, 0xFB, 0xE0, 0xF5, 0xE3, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xE9, 0x13, 0x95, 0x27, 0x3C, 0x2B, 0x35, 0x24, 0x3D, 0x2B, 0x31, 0x29, 
	0x26, 0x31, 0x3E, 0x2B, 0x3C, 0x2B, 0x3D, 0x29, 0x4F, 0x13, 0x2A, 0x24, 0x1B, 0x24, 0x1C, 0x27, 
	0x13, 0x1C, 0x15, 0x24, 0x3C, 0x15, 0x31, 0x27, 0x6A, 0x37, 0x35, 0x39, 0x3C, 0x3A, 0x3D, 0x37, 
	0x3F, 0x36, 0x3D, 0x38, 0x00, 0x3A, 0x3E, 0x39, 0x47, 0x3A, 0x41, 0x39, 0x3E, 0x3A, 0x35, 0x38, 
	0x35, 0x3A, 0x41, 0x39, 0x3C, 0x37, 0x35, 0x27, 0x3F, 0x1C, 0x0C, 0x27, 0x00, 0x00, 0x15, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x13, 0x1C, 0x15, 0x27, 
	0x3E, 0x2F, 0x35, 0x24, 0x66, 0x43, 0x44, 0x45, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 0x3D, 0x43, 0x49, 0x45, 
	0x00, 0x3D, 0x47, 0x49, 0x3F, 0x3D, 0x6A, 0x2B, 0x3F, 0x15, 0x1A, 0x27, 0x00, 0x1C, 0x15, 0x27, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 0x6E, 0x15, 0x13, 0x27, 0xF8, 0x1F, 0x7E, 0x27, 
	0xFB, 0xD9, 0xC2, 0x0C, 0xFA, 0xE5, 0xE7, 0xE3, 0xE9, 0xE5, 0xDB, 0xE4, 0xE7, 0xE0, 0xF0, 0xE4, 
	0xF5, 0xD8, 0xE6, 0xA2, 0xE9, 0xE0, 0xDB, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0xE0, 0xDB, 0xEB, 0xE9, 0xE0, 0xF4, 0xE3, 
	0x00, 0xE4, 0xE0, 0xEA, 0xFD, 0x74, 0xE5, 0x7B, 0x76, 0x7C, 0x77, 0x7F, 0x03, 0x7A, 0x7E, 0x7F, 
	0x6E, 0x76, 0x73, 0x83, 0x25, 0x79, 0x71, 0x8B, 0xFB, 0xE4, 0xE6, 0x6D, 0x00, 0xE4, 0xE0, 0xE3, 
	0x00, 0x00, 0x00, 0xE0, 0xF8, 0xE0, 0xC2, 0xEB, 0xE7, 0xE0, 0xD9, 0xEB, 0xFA, 0xE0, 0xE6, 0xE3, 
	0x00, 0xE0, 0xE9, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xFD, 0xE0, 0xDB, 0xE3, 0x03, 0x0C, 0x19, 0x23, 0x3C, 0x2B, 0x3D, 0x29, 
	0x00, 0x2B, 0x35, 0x29, 0x3E, 0x2B, 0x35, 0x29, 0x4F, 0x35, 0x3E, 0x2B, 0x26, 0x1B, 0x14, 0x27, 
	0x2A, 0x15, 0x1A, 0x27, 0x26, 0x3A, 0x47, 0x39, 0x3C, 0x3A, 0x47, 0x38, 0x49, 0x37, 0x3A, 0x38, 
	0x00, 0x00, 0x00, 0x3A, 0x31, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x4F, 0x36, 0x35, 0x37, 0x8E, 0x35, 0x3E, 0x31, 0x3F, 0x0B, 0x1A, 0x24, 
	0x00, 0x00, 0x00, 0x1C, 0x0C, 0x1C, 0x15, 0x24, 0x3E, 0x1C, 0x14, 0x24, 0x6A, 0x3A, 0x3D, 0x20, 
	0x3F, 0x5E, 0x3D, 0x4B, 0x4A, 0x43, 0x44, 0x45, 0x4A, 0x43, 0x41, 0x45, 0x49, 0x00, 0x44, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 0x49, 0x44, 0x41, 0x43, 
	0x47, 0x43, 0x4D, 0x45, 0x00, 0x00, 0x47, 0x3D, 0x56, 0x3D, 0x6A, 0x4A, 0x56, 0x12, 0x47, 0x27, 
	0x12, 0x1C, 0x15, 0x24, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x15, 0x1C, 0x50, 0x1B, 0x73, 0x27, 0x04, 0xA3, 0xE9, 0xD6, 0xFA, 0xE6, 0xE7, 0xE4, 
	0xF5, 0xE4, 0xE6, 0xA1, 0xE7, 0xE4, 0xD9, 0xA0, 0x00, 0xE0, 0xF9, 0xE3, 0xD2, 0xE4, 0xE6, 0xAE, 
	0xF8, 0xAE, 0xE0, 0x98, 0xFB, 0xE0, 0xDB, 0xEB, 0xD2, 0xE0, 0xF0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xFB, 0xE0, 0xDB, 0xE3, 
	0xFB, 0xE3, 0xA3, 0x82, 0x00, 0x82, 0x7E, 0x7B, 0x76, 0x82, 0x77, 0x8A, 0x04, 0x79, 0x7A, 0x8B, 
	0x25, 0x79, 0x76, 0x7F, 0x00, 0x79, 0x86, 0x8B, 0xF5, 0x74, 0xE2, 0x8B, 0xD9, 0xE4, 0xE0, 0xE3, 
	0xFD, 0xF7, 0xFF, 0xF2, 0xF5, 0x01, 0xF4, 0x01, 0xF5, 0x01, 0x02, 0x00, 0x00, 0xE4, 0xE0, 0xE3, 
	0xFB, 0xE0, 0xE6, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xD9, 0xE4, 0xE0, 0xEA, 0xFA, 0x3B, 0xA3, 0x29, 0x00, 0x2B, 0x14, 0x29, 
	0x00, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x00, 0x2B, 0x3D, 0x2B, 0x31, 0x29, 0x26, 0x35, 0x3E, 0x3A, 
	0x3E, 0x3A, 0x47, 0x39, 0x00, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x31, 0x3A, 0x36, 0x37, 
	0x3B, 0x37, 0x3A, 0x39, 0x3D, 0x37, 0x3A, 0x39, 0x26, 0x35, 0x3E, 0x38, 0x26, 0x35, 0x3E, 0x0C, 
	0x00, 0x00, 0x00, 0x1C, 0x0C, 0x1C, 0x15, 0x24, 0x3C, 0x1C, 0x2A, 0x24, 0x3C, 0x0B, 0x1A, 0x27, 
	0x3C, 0x2B, 0x4D, 0x2F, 0x3E, 0x44, 0x47, 0x4B, 0x3F, 0x4A, 0x47, 0x40, 0x00, 0x00, 0x43, 0x4B, 
	0x00, 0x48, 0x43, 0x45, 0x3D, 0x41, 0x49, 0x51, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x41, 0x43, 
	0x3F, 0x44, 0x4D, 0x4B, 0x3C, 0x4D, 0x47, 0x44, 0x56, 0x47, 0x3C, 0x4D, 0x3C, 0x0B, 0x1A, 0x27, 
	0x00, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x25, 0x1C, 0x13, 0x24, 0xFE, 0xCE, 0x92, 0x29, 0x8E, 0xCE, 0xA3, 0xBD, 0xE9, 0xE2, 0xDB, 0xD8, 
	0xD2, 0xE4, 0xF0, 0xD3, 0xF4, 0xAD, 0xD4, 0xB0, 0xF8, 0xE0, 0xE6, 0xEA, 0xF8, 0xE3, 0xE5, 0xC8, 
	0xF5, 0xE0, 0xF0, 0xEB, 0xF8, 0xE0, 0xD9, 0xEB, 0xE9, 0xE0, 0xDB, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xE7, 0xE0, 0xEC, 0xE3, 0xE7, 0xE0, 0xE6, 0xE3, 0xF5, 0xE0, 0xE6, 0xEB, 
	0xE9, 0xE4, 0xE6, 0x8C, 0x50, 0x82, 0xF8, 0x88, 0x73, 0x82, 0x83, 0x7B, 0x7E, 0x7A, 0x74, 0x7F, 
	0x8F, 0x71, 0x83, 0x7F, 0x7E, 0x80, 0x85, 0x8B, 0xC3, 0x84, 0x81, 0x80, 0xFD, 0xE0, 0xF4, 0xE3, 
	0xFE, 0x01, 0xFC, 0x00, 0xFF, 0x01, 0x02, 0x00, 0xFD, 0xF6, 0xFC, 0xEE, 0x00, 0x00, 0x00, 0xE0, 
	0xE9, 0xE0, 0xEC, 0xEB, 0xE9, 0xE0, 0xDB, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x00, 0xE4, 0xE0, 0xE3, 
	0xE9, 0xE0, 0xE7, 0xE3, 0xE9, 0xE0, 0xDB, 0xE3, 0xE6, 0xE4, 0xEC, 0xE3, 0x8E, 0x81, 0xE2, 0x29, 
	0x00, 0x2B, 0x31, 0x29, 0x56, 0x2B, 0x3D, 0x29, 0x3E, 0x36, 0x3D, 0x38, 0x3F, 0x37, 0x47, 0x39, 
	0x26, 0x36, 0x3D, 0x39, 0x35, 0x3A, 0x31, 0x39, 0x00, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x35, 0x3A, 0x31, 0x39, 0x00, 0x37, 0x3A, 0x39, 0x3F, 0x3A, 0x49, 0x39, 
	0x26, 0x4D, 0x3E, 0x39, 0x26, 0x35, 0x3C, 0x3A, 0x3E, 0x3A, 0x35, 0x39, 0x47, 0x35, 0x3D, 0x3B, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 0x19, 0x1C, 0x0C, 0x27, 
	0x22, 0x65, 0x3E, 0x45, 0x3C, 0x43, 0x4A, 0x4B, 0x3C, 0x43, 0x4D, 0x40, 0x3F, 0x43, 0x4D, 0x45, 
	0x56, 0x49, 0x3E, 0x45, 0x3C, 0x44, 0x47, 0x4B, 0x3C, 0x41, 0x47, 0x45, 0x00, 0x49, 0x3C, 0x48, 
	0x3E, 0x45, 0x4D, 0x54, 0x4F, 0x43, 0x47, 0x4B, 0x47, 0x49, 0x4D, 0x48, 0x8E, 0x35, 0x47, 0x1F, 
	0x4F, 0x1C, 0x1A, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x15, 0x24, 0x1C, 0x27, 
	0xF5, 0x13, 0xCA, 0x24, 0xE9, 0xB8, 0xE6, 0xAB, 0x9A, 0xA5, 0xAB, 0xBF, 0xD2, 0xA8, 0x92, 0xA6, 
	0xFA, 0xD9, 0xDB, 0xD8, 0x00, 0xE4, 0xE0, 0xE3, 0xE7, 0xE0, 0xDB, 0xEB, 0xE7, 0xE0, 0xE6, 0xE3, 
	0xFA, 0xE0, 0xF4, 0xD8, 0xE7, 0xA0, 0xCA, 0x98, 0xFA, 0xE6, 0xF8, 0xE4, 0x04, 0xE5, 0xE7, 0xEB, 
	0xF5, 0xE0, 0xE6, 0xE3, 0xE7, 0xE0, 0xE6, 0xEB, 0x00, 0xE4, 0xE0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xFD, 0xE4, 0x6E, 0x7B, 0xFA, 0x82, 0x83, 0x88, 0x8F, 0x8D, 0x81, 0x7B, 
	0x92, 0x84, 0x85, 0x80, 0x00, 0x00, 0x00, 0x84, 0x00, 0x00, 0x84, 0x80, 0xFB, 0x85, 0xD9, 0x80, 
	0xE6, 0xE0, 0xE5, 0xEB, 0xE9, 0xE0, 0xC3, 0xEB, 0x00, 0xE0, 0xDB, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0xE5, 0xE4, 0xE0, 0xE3, 0xFA, 0xF0, 0xDB, 0xEA, 0xE9, 0xEC, 0xDB, 0xE4, 0xE7, 0xE0, 0xDB, 0xE3, 
	0xF5, 0xE0, 0xF9, 0xE3, 0x00, 0xE0, 0xF0, 0xE4, 0xDB, 0xA2, 0xB4, 0x98, 0xFD, 0xF1, 0xF4, 0xEB, 
	0x26, 0x2B, 0x7E, 0x2F, 0x3D, 0x2B, 0x35, 0x29, 0x3E, 0x31, 0x2A, 0x2B, 0x3E, 0x37, 0x35, 0x29, 
	0x47, 0x37, 0x3D, 0x38, 0x3F, 0x36, 0x47, 0x39, 0x35, 0x3A, 0x31, 0x39, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x35, 0x3A, 0x31, 0x37, 0x3E, 0x3A, 0x47, 0x38, 0x3E, 0x3A, 0x47, 0x38, 
	0x3E, 0x36, 0x35, 0x39, 0x47, 0x3A, 0x36, 0x39, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x3A, 0x3D, 0x39, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x1C, 0x15, 0x27, 0x3E, 0x51, 0x14, 0x24, 
	0x00, 0x48, 0x43, 0x4B, 0x3F, 0x43, 0x4D, 0x4B, 0x3C, 0x41, 0x47, 0x43, 0x3C, 0x43, 0x4D, 0x45, 
	0x00, 0x4B, 0x43, 0x40, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x43, 0x45, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x47, 0x43, 0x4A, 0x45, 
	0x56, 0x2B, 0x68, 0x27, 0x56, 0x1C, 0x0C, 0x27, 0x00, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 0xFE, 0x1B, 0x73, 0x27, 
	0xE9, 0xD7, 0xE6, 0x9B, 0xA8, 0xA5, 0x9D, 0xBF, 0x00, 0x00, 0x00, 0xA5, 0xB4, 0xAA, 0xAC, 0xA9, 
	0xE9, 0xD7, 0xDB, 0xCE, 0xFA, 0xE0, 0xE6, 0xEB, 0xE7, 0x99, 0xE0, 0xB0, 0xF5, 0xE0, 0xE7, 0xC1, 
	0xF5, 0xE0, 0xE6, 0xE3, 0xF5, 0xE0, 0xE6, 0xE3, 0xD2, 0xE0, 0xE5, 0xEB, 0x00, 0xEB, 0xE0, 0xE3, 
	0xFA, 0xE5, 0xF4, 0xEB, 0x00, 0xE4, 0xE0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0xFB, 0xE0, 0xD2, 0xE3, 
	0xF8, 0xF6, 0xF9, 0x01, 0xC2, 0xE0, 0xD4, 0xEB, 0xFD, 0xE3, 0xE8, 0x82, 0x78, 0x8C, 0x74, 0x88, 
	0x00, 0x84, 0x85, 0x80, 0x00, 0x00, 0x00, 0x84, 0x00, 0x00, 0x00, 0x84, 0xE9, 0x84, 0x95, 0x80, 
	0xFA, 0xDB, 0xF4, 0xE6, 0xDB, 0xE5, 0xE6, 0xE4, 0xF8, 0xE0, 0xF0, 0xE4, 0xE7, 0xE0, 0xE6, 0xE3, 
	0xD2, 0xE0, 0xF4, 0xE3, 0x00, 0xE0, 0xF0, 0xE3, 0xD2, 0xE0, 0xE6, 0xE3, 0xF5, 0xE4, 0xF0, 0xE3, 
	0xE7, 0xA2, 0x9A, 0x98, 0xE7, 0xD8, 0xD4, 0xB0, 0xE7, 0xD3, 0xD4, 0x9F, 0xF8, 0xE0, 0xE5, 0xEB, 
	0xF5, 0xD7, 0xF3, 0x29, 0x00, 0x2B, 0x19, 0x29, 0x1E, 0x2B, 0x35, 0x29, 0x56, 0x35, 0x3E, 0x39, 
	0x3C, 0x36, 0x47, 0x39, 0x3E, 0x3A, 0x49, 0x38, 0x00, 0x00, 0x36, 0x3A, 0x31, 0x00, 0x36, 0x3A, 
	0x00, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x31, 0x00, 0x36, 0x3A, 0x31, 0x00, 0x36, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x31, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x36, 0x3A, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 0x3C, 0x1B, 0x2B, 0x27, 0x3C, 0x43, 0x68, 0x4B, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x41, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x4A, 0x44, 0x49, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x3D, 0x43, 0x4A, 0x45, 0x56, 0x31, 0x47, 0x2F, 0x3F, 0x1C, 0x0C, 0x27, 0x00, 0x1C, 0x15, 0x27, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x8E, 0x1C, 0x1A, 0x27, 0xFD, 0xE4, 0xDB, 0x83, 
	0xC2, 0xAB, 0x9B, 0x9C, 0x00, 0xA9, 0xA5, 0xBF, 0x00, 0x00, 0x00, 0xA5, 0x9D, 0xC0, 0xA5, 0xA6, 
	0xD2, 0xAC, 0x92, 0xB5, 0xE9, 0xD0, 0xDB, 0xAA, 0xFA, 0xE5, 0xE7, 0xD8, 0xF5, 0xE0, 0xE7, 0xEA, 
	0xE7, 0xE0, 0xF0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0xE0, 0xF5, 0xEB, 0xE9, 0xE0, 0xE6, 0xE3, 0xF8, 0xF1, 0xF4, 0xEB, 0xFF, 0x01, 0x02, 0x00, 
	0xFD, 0x01, 0xFC, 0x00, 0xC2, 0xE0, 0xA3, 0xEB, 0x00, 0x00, 0xF3, 0xE0, 0xFD, 0x77, 0x9A, 0x7B, 
	0x8F, 0x84, 0xB4, 0x80, 0x00, 0x00, 0x84, 0x80, 0x78, 0x84, 0x81, 0x80, 0xE9, 0x84, 0x78, 0x80, 
	0x4F, 0xCC, 0xE7, 0x85, 0xE9, 0xF4, 0xF5, 0xE6, 0xE9, 0xE6, 0xDB, 0xE0, 0x00, 0xE4, 0xE0, 0xE3, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xDB, 0xEB, 
	0xF5, 0xE0, 0xF0, 0xE3, 0xE7, 0xEC, 0xDB, 0xE4, 0xD2, 0xD5, 0xD4, 0xC8, 0xF0, 0xE0, 0xEC, 0xE4, 
	0xF8, 0xE0, 0xF0, 0xEB, 0x50, 0xB3, 0x7E, 0x31, 0x3C, 0x2B, 0x3D, 0x29, 0x47, 0x3A, 0x36, 0x39, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x31, 0x00, 0x36, 0x3A, 0x49, 0x00, 0x36, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x36, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x00, 0x00, 0x1C, 0x6A, 0x1C, 0x1A, 0x27, 0x3C, 0x43, 0x4D, 0x38, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x49, 0x43, 0x41, 0x51, 0x4A, 0x44, 0x41, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x47, 0x43, 0x4A, 0x45, 0x3D, 0x44, 0x4A, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x41, 0x43, 0x00, 0x00, 0x43, 0x45, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x3D, 0x43, 0x41, 0x45, 0x8E, 0x3D, 0x3E, 0x48, 0x26, 0x1B, 0x0C, 0x27, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x14, 0x1C, 0x15, 0x24, 0xF5, 0x95, 0xE5, 0x20, 0xC2, 0xAB, 0x9A, 0xB5, 
	0x00, 0xC0, 0xA5, 0xA6, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0xC3, 0x9D, 0x99, 0xA9, 0xFA, 0xE2, 0xE6, 0xD6, 0xFA, 0xE0, 0xF4, 0xEB, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xFB, 0xE0, 0xDB, 0xEB, 0xD2, 0xE0, 0xE5, 0xE3, 0xFF, 0xD9, 0xDB, 0xE4, 
	0xF8, 0xE0, 0xC2, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xF8, 0xE0, 0xE6, 0x9A, 
	0xD2, 0x84, 0x6C, 0x80, 0xFB, 0x81, 0xE6, 0x80, 0xFB, 0xE6, 0xF4, 0xCC, 0xFD, 0x00, 0xF9, 0xE6, 
	0x00, 0x00, 0x00, 0xE6, 0xFA, 0xE6, 0xD2, 0xF0, 0xDB, 0xF0, 0xE6, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0xE0, 0xF0, 0xE3, 
	0xF5, 0xE0, 0xF4, 0xE3, 0xF0, 0xE0, 0xEC, 0xEB, 0xE9, 0xEC, 0xDB, 0xA0, 0xFA, 0xE4, 0xDB, 0xD6, 
	0xE9, 0xA1, 0xCA, 0x98, 0xDE, 0xF1, 0xE6, 0xE3, 0x3F, 0x3A, 0x6E, 0x38, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x31, 0x3A, 0x36, 0x37, 0x00, 0x00, 0x36, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x3E, 0x1C, 0x1A, 0x27, 0x00, 0x3A, 0x66, 0x38, 0x44, 0x45, 0x43, 0x4B, 0x4D, 0x00, 0x41, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x47, 0x43, 0x4A, 0x45, 0x47, 0x4D, 0x3D, 0x41, 0x47, 0x43, 0x4A, 0x45, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x4D, 0x43, 0x44, 0x45, 0x4F, 0x4D, 0x3E, 0x45, 0x3F, 0x49, 0x3E, 0x45, 
	0x3C, 0x4A, 0x3E, 0x45, 0x3F, 0x31, 0x47, 0x23, 0x66, 0x1C, 0x0C, 0x27, 0x00, 0x00, 0x15, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x1C, 0x15, 0x27, 0xF5, 0x0C, 0x92, 0x24, 0xD2, 0xE4, 0xA3, 0xA7, 0xB2, 0xAA, 0xA7, 0xA9, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0xAC, 0xA5, 0x9D, 0xBF, 0xD2, 0xAC, 0xB3, 0xAA, 0xE9, 0xE2, 0xC2, 0xA8, 
	0xFA, 0xE0, 0xE6, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0xEB, 0xE0, 0xE3, 0xE9, 0xEC, 0xDB, 0xEB, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0xE4, 0xE0, 0xE3, 0xE7, 0xE5, 0xE6, 0xE4, 0xE7, 0xE4, 0xE6, 0xE3, 0xF5, 0xE0, 0xE6, 0xEB, 
	0xFA, 0xE5, 0xF4, 0xEB, 0xE6, 0xE0, 0xE5, 0xE4, 0xDB, 0xD9, 0xE6, 0xE4, 0xDB, 0xD9, 0xE6, 0xE4, 
	0xDB, 0xF0, 0xE6, 0xE4, 0x04, 0xE5, 0xE6, 0xE4, 0xFB, 0xE0, 0xDB, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0xE9, 0xE0, 0xE6, 0xEB, 0xE9, 0xE4, 0xF8, 0xE3, 0xF4, 0xA2, 0xB4, 0xAF, 0xF3, 0xE0, 0xEC, 0xEB, 
	0xFB, 0xE0, 0xF4, 0xD6, 0xE9, 0xE0, 0xE6, 0xE3, 0xE9, 0x92, 0xDE, 0x61, 0x3F, 0x31, 0x3D, 0x37, 
	0x3C, 0x31, 0x35, 0x37, 0x3F, 0x4A, 0x47, 0x37, 0x3D, 0x3A, 0x35, 0x39, 0x00, 0x00, 0x00, 0x3A, 
	0x35, 0x3A, 0x31, 0x39, 0x31, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x31, 0x3A, 0x36, 0x39, 
	0x3F, 0x3A, 0x35, 0x39, 0x3E, 0x36, 0x35, 0x37, 0x3E, 0x36, 0x35, 0x37, 0x3F, 0x49, 0x3D, 0x37, 
	0x66, 0x5E, 0x3C, 0x39, 0x3C, 0x31, 0x4D, 0x45, 0x26, 0x65, 0x2A, 0x29, 0x4A, 0x43, 0x44, 0x4B, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x4D, 0x43, 0x44, 0x45, 0x47, 0x44, 0x4D, 0x45, 
	0x3F, 0x4D, 0x3E, 0x45, 0x66, 0x44, 0x3E, 0x40, 0x3C, 0x4D, 0x47, 0x45, 0x3C, 0x4A, 0x47, 0x43, 
	0x3C, 0x49, 0x4A, 0x43, 0x3F, 0x41, 0x3C, 0x43, 0x3C, 0x43, 0x4A, 0x4B, 0x3F, 0x4D, 0x47, 0x40, 
	0x3C, 0x49, 0x3D, 0x45, 0x56, 0x3D, 0x6A, 0x31, 0x26, 0x15, 0x6A, 0x27, 0x00, 0x00, 0x15, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 
	0xF8, 0x1B, 0x06, 0x27, 0xF5, 0xD7, 0xDB, 0x9B, 0xAC, 0xA5, 0xA8, 0xA9, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xC0, 0xA5, 0xA6, 0xC2, 0xAC, 0xCA, 0xB5, 
	0xFA, 0xE0, 0xE7, 0xD3, 0x00, 0xE0, 0xE5, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0xEB, 0xE0, 0xEA, 0xFA, 0xE0, 0xF4, 0xEB, 0xFA, 0xF0, 0xDB, 0xEB, 
	0xF8, 0xE0, 0xE6, 0xE3, 0xE7, 0xE0, 0xF0, 0xEB, 0xF5, 0xD8, 0xE6, 0x9F, 0xE7, 0xE0, 0xF0, 0xE3, 
	0xF5, 0xE4, 0xF0, 0xD0, 0xE9, 0xE0, 0xE6, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xFB, 0xE0, 0xF4, 0xEB, 0xFA, 0xE0, 0xDB, 0xE3, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x04, 0xE5, 0xE7, 0xEE, 0xE7, 0xD4, 0xE6, 0xE3, 0xF5, 0xE0, 0xF4, 0xEB, 
	0xF5, 0xE0, 0xE6, 0xEA, 0xF5, 0xE0, 0xE6, 0xE3, 0x00, 0xE0, 0xF9, 0xE3, 0x96, 0x34, 0xB4, 0x38, 
	0x3F, 0x36, 0x35, 0x38, 0x3F, 0x39, 0x3D, 0x38, 0x3C, 0x3A, 0x47, 0x37, 0x3C, 0x31, 0x47, 0x37, 
	0x3C, 0x36, 0x35, 0x39, 0x00, 0x00, 0x00, 0x3A, 0x31, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x36, 0x3A, 
	0x3E, 0x3A, 0x31, 0x39, 0x00, 0x41, 0x3C, 0x3A, 0x3C, 0x36, 0x3E, 0x37, 0x3D, 0x3A, 0x49, 0x38, 
	0x13, 0x1C, 0x12, 0x24, 0x3C, 0x1F, 0x0C, 0x27, 0x3C, 0x41, 0x3D, 0x4B, 0x00, 0x49, 0x3C, 0x43, 
	0x3C, 0x49, 0x47, 0x43, 0x3C, 0x4A, 0x47, 0x48, 0x3C, 0x4D, 0x47, 0x45, 0x3C, 0x43, 0x47, 0x4B, 
	0x4A, 0x4B, 0x43, 0x52, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x41, 0x45, 0x43, 0x40, 
	0x47, 0x43, 0x3D, 0x4B, 0x00, 0x43, 0x47, 0x52, 0x47, 0x43, 0x49, 0x45, 0x00, 0x45, 0x43, 0x40, 
	0x00, 0x4C, 0x43, 0x45, 0x47, 0x4A, 0x3D, 0x45, 0x4F, 0x3D, 0x6A, 0x31, 0x26, 0x1C, 0x1A, 0x27, 
	0x00, 0x1C, 0x15, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x4F, 0x1C, 0x13, 0x27, 
	0xF8, 0xCE, 0xA3, 0x21, 0xFB, 0xAC, 0xB3, 0xB5, 0x00, 0xC0, 0xA5, 0xA9, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xA4, 0xA5, 0xA8, 0xA9, 
	0xD2, 0x9B, 0xB4, 0xB5, 0xFA, 0xD4, 0xE7, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0xE4, 0xE0, 0xE3, 
	0xF5, 0xE0, 0xE6, 0xE3, 0xE9, 0xE0, 0xDB, 0xE3, 0xE9, 0xE0, 0xF4, 0xEB, 0xFA, 0xE0, 0xE6, 0xEB, 
	0xE9, 0xE0, 0xF4, 0xEB, 0xE7, 0xE0, 0xE5, 0xEB, 0xF4, 0xE3, 0xE5, 0x98, 0xF4, 0xE4, 0xCC, 0xCE, 
	0xF4, 0xA0, 0xE4, 0xAF, 0xF5, 0xE0, 0xE6, 0xE3, 0xE9, 0xE0, 0xE6, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xFB, 0xE0, 0xE7, 0xE3, 
	0x00, 0xEB, 0xE0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xF5, 0xE0, 0xDB, 0xE3, 
	0xE9, 0xE4, 0xE6, 0xE3, 0xFA, 0xE0, 0xDB, 0xEB, 0xFB, 0xE5, 0xE7, 0xEA, 0xE7, 0xE0, 0xF0, 0xE3, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xDE, 0xE0, 0xFC, 0xE3, 
	0x03, 0x36, 0x6C, 0x39, 0x3E, 0x3A, 0x35, 0x38, 0x3E, 0x3A, 0x3D, 0x39, 0x49, 0x39, 0x3A, 0x38, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x36, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x1C, 0x15, 0x27, 0x3E, 0x1F, 0x37, 0x27, 0x41, 0x45, 0x43, 0x4B, 0x4A, 0x43, 0x49, 0x45, 
	0x49, 0x43, 0x41, 0x45, 0x00, 0x45, 0x43, 0x4B, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x41, 0x00, 0x44, 0x43, 
	0x49, 0x00, 0x41, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x47, 0x49, 0x4D, 0x43, 0x3F, 0x3D, 0x47, 0x4A, 
	0x26, 0x13, 0x3D, 0x24, 0x0C, 0x1C, 0x15, 0x27, 0x00, 0x1C, 0x15, 0x24, 0xF5, 0x0C, 0xD7, 0x24, 
	0xC2, 0xAC, 0xB4, 0xAA, 0x9D, 0xC0, 0xA5, 0xA9, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xA5, 0x81, 0xA6, 
	0xCA, 0xA5, 0x95, 0x93, 0x00, 0xC0, 0xA5, 0x94, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xAB, 0xA5, 0xAA, 0xA9, 0xE9, 0xB8, 0xA3, 0xAB, 0xFA, 0xE5, 0xF4, 0xE3, 0xE9, 0xE0, 0xDB, 0xEB, 
	0xF5, 0xE0, 0xF0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0xE9, 0xE4, 0xF4, 0xEA, 0xF5, 0x9A, 0xD9, 0x9F, 0xF4, 0xD8, 0xCC, 0x90, 0xE9, 0xE3, 0xF0, 0xC7, 
	0xFB, 0xE4, 0xE6, 0xEB, 0xF5, 0xB9, 0xD8, 0x90, 0xF5, 0xF0, 0xDB, 0xEB, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xE7, 0xE3, 
	0xFA, 0xD4, 0xDB, 0xE3, 0xE7, 0xE0, 0xE6, 0xEB, 0xD2, 0xE0, 0xE6, 0xE3, 0xF5, 0xE0, 0xDB, 0xEB, 
	0x00, 0xE4, 0xE0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xE6, 0xEB, 0xE9, 0xE0, 0xF0, 0xEB, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0xFD, 0xE2, 0xF4, 0x99, 0x3C, 0x3A, 0x36, 0x38, 0x00, 0x00, 0x00, 0x3A, 0x35, 0x3A, 0x31, 0x37, 
	0x31, 0x3A, 0x36, 0x37, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x36, 0x00, 0x3B, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x66, 0x1C, 0x1A, 0x27, 0x3E, 0x43, 0x68, 0x4B, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x41, 0x43, 0x00, 0x00, 0x41, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x41, 0x43, 
	0x49, 0x00, 0x41, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x47, 0x43, 0x4D, 0x45, 
	0x47, 0x4D, 0x3D, 0x44, 0x56, 0x4D, 0x2A, 0x20, 0x8E, 0x13, 0x73, 0x27, 0xFD, 0xD7, 0xCC, 0xB9, 
	0xA3, 0x9D, 0xA7, 0xA9, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xFB, 0xA5, 0x85, 0x93, 
	0xFF, 0x85, 0x01, 0xA6, 0x02, 0x94, 0x01, 0x93, 0xFE, 0xAC, 0x01, 0xA6, 0xFE, 0x00, 0xF0, 0xA8, 
	0x02, 0x00, 0x01, 0x00, 0xFE, 0x81, 0x00, 0xA6, 0xA8, 0xC0, 0xA5, 0xA6, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x96, 0xA5, 0xAC, 0xA9, 0xE9, 0xA8, 0xA3, 0xA9, 0xD2, 0xE0, 0xF0, 0xD8, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0xE0, 0xDB, 0xEB, 0xE9, 0xD4, 0xF4, 0xE3, 0xF5, 0xE0, 0xA3, 0xE3, 0xF5, 0xE0, 0xE6, 0xD5, 
	0xE9, 0xE0, 0xDB, 0xD8, 0xF5, 0xE0, 0xE6, 0xD6, 0xD2, 0xE0, 0xF0, 0xEB, 0xD2, 0xE0, 0xDB, 0xEB, 
	0x00, 0xE4, 0xE0, 0xE3, 0xF5, 0xE0, 0xDB, 0xEB, 0xF5, 0xE0, 0xE6, 0xE3, 0xE9, 0xE0, 0xE6, 0xE3, 
	0xD2, 0xE0, 0xE6, 0xE3, 0xE7, 0xE4, 0xE5, 0xEA, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xF4, 0xE3, 
	0x00, 0xE0, 0xF4, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0xE4, 0xE0, 0xEA, 0xF8, 0xEA, 0x3D, 0x39, 0x00, 0x00, 0x3B, 0x3A, 0x00, 0x3A, 0x31, 0x37, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x31, 0x3A, 
	0x35, 0x36, 0x49, 0x39, 0x35, 0x3A, 0x41, 0x37, 0x35, 0x3A, 0x41, 0x37, 0x00, 0x00, 0x36, 0x3A, 
	0x8E, 0x43, 0x66, 0x45, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x4A, 0x44, 0x49, 0x43, 0x00, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 0x49, 0x00, 0x44, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x41, 0x00, 0x44, 0x43, 0x4A, 0x00, 0x49, 0x45, 0x56, 0x44, 0x3C, 0x45, 0x3C, 0x41, 0x3E, 0x45, 
	0x3C, 0x4A, 0x47, 0x48, 0x96, 0x49, 0x3E, 0x40, 0xE9, 0xE0, 0xC3, 0x99, 0xB2, 0xAA, 0xA7, 0xA9, 
	0x9D, 0x00, 0xA5, 0xA6, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0xA5, 0xA6, 0xFF, 0xAC, 0x01, 0xA6, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0xCA, 0xA5, 0x81, 0x93, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xC2, 0xA8, 0xA4, 0xA9, 0xE9, 0xD4, 0xDB, 0xD3, 
	0xF5, 0xE0, 0xE5, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xE6, 0xE3, 0xF5, 0xEB, 0xE6, 0xA4, 0xF4, 0xD6, 0xE0, 0x90, 
	0xE7, 0x9E, 0xE0, 0x90, 0xFA, 0xE0, 0xF4, 0xD8, 0xD2, 0xE0, 0xE6, 0xEB, 0xFA, 0xE5, 0xDB, 0xE3, 
	0xE9, 0xE0, 0xDB, 0xEA, 0xE7, 0xE0, 0xE6, 0xE1, 0xF8, 0xE4, 0xE6, 0xD6, 0xE7, 0xE4, 0xF0, 0xB8, 
	0xDB, 0x9E, 0xD8, 0x98, 0xF5, 0xE4, 0xF0, 0xE3, 0x00, 0xE0, 0xF0, 0xEB, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0xE4, 0xE0, 0xE3, 
	0xE9, 0xE0, 0xF4, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0xEB, 0xE0, 0xE3, 0xD2, 0xE0, 0xE6, 0xEB, 
	0xD2, 0xD8, 0xE6, 0xBA, 0xDE, 0x3A, 0x4D, 0x39, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x3A, 0x36, 0x37, 0x00, 0x3A, 0x31, 0x37, 0x00, 0x00, 0x36, 0x3A, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x4C, 0x43, 0x45, 
	0x4D, 0x44, 0x49, 0x43, 0x00, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x41, 0x43, 0x49, 0x00, 0x44, 0x43, 0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x4D, 0x43, 0x49, 0x45, 0x47, 0x41, 0x4D, 0x43, 0x49, 0x43, 0x44, 0x45, 0x00, 0x00, 0x43, 0x45, 
	0x00, 0x00, 0x43, 0x45, 0x00, 0x45, 0x43, 0x4B, 0x3C, 0x43, 0x47, 0x40, 0x4F, 0x4A, 0x3E, 0x43, 
	0x47, 0x45, 0x43, 0x40, 0xE9, 0xD7, 0xE6, 0x60, 0xF5, 0x9B, 0xCC, 0xAC, 0xAB, 0xA5, 0xA8, 0xBF, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xF9, 0xAC, 0x01, 0xA6, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x01, 0xA8, 0x00, 0xA5, 0x85, 0xA6, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xA5, 0xA8, 0xA9, 0xD2, 0xA8, 0xA4, 0xA9, 
	0xFA, 0xE6, 0xDB, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE4, 0xDB, 0xEA, 0xE6, 0xE0, 0xEC, 0xE3, 
	0xF5, 0xE0, 0xE7, 0xEB, 0xF5, 0xE0, 0xDB, 0xEA, 0xF8, 0xE0, 0xEC, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0xD2, 0xE0, 0xF4, 0xEB, 0xF8, 0xE3, 0xE6, 0xB0, 0xE7, 0x9B, 0xE6, 0x9F, 0xF4, 0xE0, 0xCC, 0xE4, 
	0xFB, 0xE4, 0xE6, 0xD5, 0x00, 0xE0, 0xF0, 0xEB, 0xF5, 0xE4, 0xF0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x8E, 0xE0, 0xF4, 0xD3, 0xF8, 0xD0, 0xD9, 0xA1, 0xE7, 0xC1, 0xCA, 0xBA, 0xC3, 0xA0, 0x99, 0xAD, 
	0xA0, 0xB1, 0xBA, 0xB0, 0x47, 0x64, 0xD0, 0x5D, 0x00, 0x00, 0x00, 0x3A, 0x36, 0x00, 0x3B, 0x3A, 
	0x31, 0x3A, 0x36, 0x37, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x3E, 0x43, 0x47, 0x48, 0x3E, 0x41, 0x47, 0x43, 0x3C, 0x49, 0x47, 0x45, 0x56, 0x3D, 0x3E, 0x44, 
	0x3C, 0x43, 0x4A, 0x4B, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x3E, 0x43, 0x41, 0x45, 
	0x3E, 0x49, 0x4A, 0x45, 0x00, 0x00, 0x44, 0x43, 0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x4A, 0x43, 0x41, 0x45, 0x3C, 0x43, 0x47, 0x4B, 0x3C, 0x49, 0x3D, 0x4B, 
	0x3C, 0x49, 0x47, 0x4B, 0x3C, 0x49, 0x47, 0x45, 0x3C, 0x43, 0x3D, 0x4B, 0x44, 0x45, 0x43, 0x40, 
	0xFB, 0x4D, 0xA3, 0x45, 0xC2, 0x9B, 0xB2, 0xBC, 0xA7, 0xA5, 0x9D, 0xA6, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xA5, 0x78, 0xA6, 
	0xF4, 0xAB, 0x01, 0x94, 0xFE, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xFC, 0x00, 0x92, 0xAB, 0x02, 0xA5, 0x92, 0xA6, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x9D, 0xA9, 0xA5, 0xBF, 
	0xE9, 0xCE, 0xDB, 0xAB, 0xE9, 0xE0, 0xF0, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xD9, 0xE3, 0xFA, 0xE5, 0xE6, 0xE3, 0xFA, 0xF0, 0xE7, 0xE4, 
	0xE7, 0xE0, 0xF0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE5, 0xDB, 0xE3, 0xF1, 0xE4, 0xE0, 0xEB, 0xE7, 0xE4, 0xD9, 0xB7, 
	0xE7, 0xE0, 0xE6, 0xD8, 0xE7, 0xE4, 0xE5, 0xB1, 0xF5, 0xD8, 0xDB, 0x9F, 0xFB, 0xE0, 0xE6, 0xE3, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0xE4, 0xE0, 0xE3, 0xE7, 0xE0, 0xF0, 0xE3, 0xD2, 0xD7, 0xE6, 0x9E, 
	0xD2, 0xA0, 0xB3, 0xAD, 0x00, 0xAD, 0xBA, 0xB1, 0x00, 0xAD, 0xBA, 0xB1, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x92, 0x5D, 0x4A, 0xB0, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x3D, 0x36, 0x35, 0x37, 0x3C, 0x31, 0x3D, 0x37, 0x31, 0x3A, 0x36, 0x37, 0x00, 0x37, 0x3A, 0x39, 
	0x00, 0x37, 0x3A, 0x39, 0x00, 0x00, 0x3A, 0x37, 0x00, 0x00, 0x3A, 0x37, 0x00, 0x37, 0x3A, 0x39, 
	0x00, 0x4B, 0x43, 0x40, 0x00, 0x00, 0x00, 0x43, 0x3C, 0x43, 0x4A, 0x40, 0x3E, 0x41, 0x47, 0x40, 
	0x3E, 0x43, 0x47, 0x45, 0x3C, 0x44, 0x47, 0x45, 0x3C, 0x49, 0x47, 0x45, 0x66, 0x41, 0x47, 0x4B, 
	0x00, 0x43, 0x4D, 0x4B, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x41, 0x00, 0x44, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x44, 0x43, 0x96, 0x43, 0x6C, 0x40, 
	0x8E, 0xE5, 0xDB, 0xCE, 0x92, 0xAB, 0xA7, 0x9C, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0xA9, 0xA5, 0x93, 0xE6, 0xBE, 0xE1, 0xA6, 0xF9, 0x85, 0x00, 0x93, 0xFE, 0x99, 0x01, 0x93, 
	0xFD, 0xA5, 0xAB, 0x93, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xA3, 0xAA, 0xAB, 0xA9, 0xFA, 0xD0, 0xE7, 0x9D, 0xFA, 0xE0, 0xE7, 0xE3, 0xF5, 0xE0, 0xDB, 0xEB, 
	0xE9, 0xE0, 0xDB, 0xE3, 0xE9, 0xE0, 0xDB, 0xE3, 0x00, 0xE4, 0xE0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0xF5, 0xE0, 0xE6, 0xEB, 0x00, 0xE0, 0xEC, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xEB, 0xF5, 0xE4, 0xE6, 0xE3, 0xF4, 0xC1, 0xD4, 0x9F, 
	0xDB, 0xE0, 0xEC, 0xEB, 0xF5, 0xE0, 0x92, 0xD1, 0xDB, 0xEA, 0xD7, 0x9F, 0xFB, 0xEB, 0xE7, 0xC1, 
	0xE7, 0xE0, 0xE6, 0xB8, 0xE7, 0xCE, 0xCC, 0xA2, 0xC2, 0xA0, 0xA4, 0xBA, 0x9E, 0xBA, 0xA0, 0xB1, 
	0xB8, 0xAD, 0xBA, 0xB0, 0xFB, 0xA2, 0xB2, 0x9F, 0xFA, 0xB9, 0xCA, 0x9F, 0xB2, 0xBA, 0xB9, 0x9F, 
	0x00, 0x00, 0x00, 0xBA, 0x3E, 0x5D, 0xC1, 0xB7, 0x3F, 0x31, 0x3C, 0x37, 0x3F, 0x31, 0x3C, 0x37, 
	0x3F, 0x36, 0x3D, 0x37, 0x26, 0x4E, 0x47, 0x5B, 0x3C, 0x60, 0x67, 0x5F, 0x3E, 0x41, 0x3D, 0x5F, 
	0x3C, 0x4A, 0x47, 0x3B, 0x00, 0x4A, 0x3C, 0x3B, 0x00, 0x4A, 0x3C, 0x3B, 0x3C, 0x42, 0x4D, 0x5F, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x4B, 0x43, 0x40, 0x00, 0x00, 0x43, 0x4B, 
	0x00, 0x45, 0x43, 0x4B, 0x00, 0x4B, 0x43, 0x40, 0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x49, 0x44, 0x41, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x41, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x49, 0x00, 0x41, 0x43, 0x49, 0x00, 0x41, 0x43, 0x8E, 0x43, 0x30, 0x4B, 0xFB, 0x92, 0xC3, 0x99, 
	0xD2, 0xAC, 0x99, 0xAA, 0x00, 0xA5, 0xAC, 0xA9, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xC0, 0xA5, 0x94, 0x00, 0xA5, 0xAC, 0xA6, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0xD2, 0xA8, 0x99, 0xC0, 0xE9, 0xE0, 0xE7, 0xE1, 0xF4, 0xE0, 0xE5, 0xE3, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xDB, 0xE0, 0xE6, 0xEB, 0x00, 0xE0, 0xDB, 0xEB, 
	0x00, 0xE0, 0xDB, 0xEB, 0xE9, 0xE0, 0xDB, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xD2, 0xE0, 0xDB, 0xEB, 0xDB, 0x9E, 0xCA, 0x9F, 
	0xDB, 0xE0, 0xF0, 0xEB, 0xE7, 0xE0, 0xDB, 0xEB, 0xF5, 0xCE, 0xF0, 0xAE, 0xC3, 0xA2, 0xB9, 0xAD, 
	0xA2, 0xA1, 0xBA, 0xAD, 0x00, 0xAD, 0xBA, 0x9F, 0xE9, 0xBA, 0xB3, 0x9F, 0xE9, 0xB9, 0xD9, 0xB1, 
	0xFB, 0x92, 0xE7, 0x99, 0xFD, 0x7E, 0x6E, 0x0E, 0xF5, 0xE6, 0xF4, 0xB2, 0xD2, 0xA2, 0xA3, 0xB1, 
	0x00, 0x00, 0x00, 0xBA, 0x92, 0xA7, 0x41, 0xA8, 0x47, 0x58, 0x4D, 0x5B, 0x67, 0x58, 0x60, 0x5B, 
	0x60, 0x58, 0x59, 0x5B, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x5F, 0x58, 0x5B, 0x00, 0x00, 0x58, 0x5B, 0x00, 0x00, 0x58, 0x5B, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x41, 0x00, 0x44, 0x43, 0x49, 0x00, 0x41, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x44, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x4D, 0x43, 0x4A, 0x51, 0x3D, 0x43, 0x41, 0x45, 
	0x00, 0x00, 0x00, 0x43, 0x44, 0x4C, 0x43, 0x40, 0xF5, 0xB4, 0xC3, 0x45, 0xE9, 0xD7, 0xCC, 0x9B, 
	0xA7, 0xA5, 0xAB, 0xBF, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0xA5, 0x9D, 0xA9, 0xD2, 0xAC, 0xB3, 0x9C, 0xE9, 0xE4, 0xE6, 0xE3, 
	0x00, 0xD4, 0xF5, 0xE0, 0xF8, 0xF6, 0xFC, 0xD8, 0xFE, 0x01, 0xFC, 0x01, 0xF8, 0x01, 0xFC, 0x01, 
	0x00, 0xE0, 0xD4, 0xE4, 0xF5, 0xE0, 0xF4, 0xEB, 0x00, 0xE4, 0xE0, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xFB, 0xE0, 0xE6, 0xE3, 0xF5, 0xD6, 0xB2, 0x9F, 
	0xE7, 0x9E, 0xCA, 0xA1, 0xB2, 0xA0, 0xB9, 0xAD, 0xAE, 0xBA, 0xA2, 0xAD, 0x00, 0xBA, 0x91, 0xB7, 
	0xE9, 0xA0, 0xD4, 0xB7, 0xFB, 0xD9, 0xC2, 0xA2, 0xFB, 0xF0, 0xE9, 0x16, 0x50, 0xB2, 0xE6, 0x0F, 
	0x22, 0x0F, 0x08, 0x0E, 0x00, 0x00, 0x0F, 0x0E, 0xF8, 0xF0, 0xE6, 0x1E, 0xE9, 0xA0, 0xB9, 0xB7, 
	0x00, 0x00, 0x00, 0xBA, 0x95, 0xBA, 0x67, 0xB7, 0x00, 0x5F, 0x58, 0x5B, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x49, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x47, 0x43, 0x4A, 0x45, 
	0x47, 0x41, 0x4D, 0x43, 0x96, 0x44, 0x6C, 0x4B, 0xF5, 0xCE, 0xE6, 0xA7, 0xA3, 0xA8, 0xA7, 0xA9, 
	0x00, 0x9C, 0xA5, 0xA9, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xC2, 0x9D, 0xA4, 0xC0, 0xFA, 0xD9, 0xDB, 0xD6, 
	0xE7, 0xF7, 0xFC, 0xE3, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0xF8, 0xF6, 0xFC, 0x01, 
	0x00, 0x00, 0x00, 0xE0, 0xE7, 0xE0, 0xF0, 0xE3, 0xE7, 0xE0, 0xE6, 0xE3, 0xEC, 0xE4, 0xE0, 0xE3, 
	0xF4, 0xE0, 0xDB, 0xE3, 0xE7, 0xEB, 0xB2, 0x9E, 0xD2, 0xA2, 0xB3, 0xB1, 0x00, 0xBA, 0xA0, 0x97, 
	0x00, 0x97, 0xBA, 0xAD, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0xD2, 0xA0, 0xD9, 0xB1, 
	0xFD, 0x7E, 0x6E, 0x0E, 0x10, 0x0F, 0x08, 0x0E, 0x50, 0x0F, 0x22, 0x0E, 0x22, 0x00, 0xDB, 0x0E, 
	0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x0F, 0x0E, 0xF5, 0xF0, 0xDE, 0x8F, 0xFB, 0xA2, 0x99, 0x9F, 
	0x00, 0x00, 0x00, 0xBA, 0x47, 0xBA, 0xC4, 0xB1, 0x00, 0x46, 0x58, 0x5B, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x43, 0x49, 0x00, 0x44, 0x43, 0x00, 0x00, 0x4A, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x3D, 0x43, 0x49, 0x45, 0x4A, 0x43, 0x41, 0x51, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x4A, 0x43, 0x41, 0x45, 0x4D, 0x43, 0x49, 0x51, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x96, 0x43, 0x4A, 0x4B, 0xF5, 0xE0, 0x8F, 0xCE, 0xE7, 0xA4, 0xD7, 0xA8, 0x00, 0xC0, 0xA5, 0xBF, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x9C, 0xA5, 0xA9, 0xE9, 0xA8, 0x95, 0xA9, 
	0xFA, 0xCC, 0xD2, 0xE3, 0xDB, 0xE0, 0xF0, 0xEB, 0xF5, 0xF1, 0xFC, 0xD8, 0xFA, 0xE0, 0xE6, 0xEB, 
	0x00, 0x00, 0x00, 0xE0, 0xD2, 0xE0, 0xE6, 0xE3, 0xFB, 0xB8, 0xD9, 0xB1, 0xE7, 0xA0, 0xCC, 0xB1, 
	0xB2, 0xA2, 0x9E, 0xB7, 0xB2, 0x97, 0xAE, 0xB7, 0xFB, 0x9E, 0xCC, 0xB1, 0xFA, 0x9E, 0xCC, 0x9F, 
	0xA0, 0xAD, 0xBA, 0x9F, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0xD2, 0xAE, 0xF0, 0xB1, 
	0xF8, 0x0F, 0x09, 0x0E, 0x00, 0x00, 0x00, 0x0F, 0xDE, 0x0F, 0x09, 0x0E, 0xFA, 0xCC, 0x6E, 0x0E, 
	0xF5, 0x0F, 0x1E, 0x0E, 0xFB, 0xCC, 0xE7, 0x0F, 0xF9, 0x00, 0xE6, 0xD9, 0xFB, 0xBA, 0xA4, 0x9F, 
	0x00, 0x00, 0x00, 0xBA, 0x6C, 0xC5, 0xC4, 0xA1, 0x40, 0x54, 0x58, 0x46, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x47, 0x43, 0x4A, 0x45, 0x47, 0x43, 0x4A, 0x45, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x43, 0x45, 0x3D, 0x41, 0x4A, 0x48, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x49, 0x00, 0x41, 0x43, 0x00, 0x00, 0x00, 0x43, 0x44, 0x45, 0x43, 0x40, 
	0xF5, 0x95, 0xC3, 0x45, 0xF5, 0xA4, 0xC3, 0xAB, 0xB4, 0xA5, 0xAC, 0xA9, 0x00, 0xC0, 0xA5, 0xA6, 
	0x00, 0xA9, 0xA5, 0x93, 0xAC, 0xA5, 0xA8, 0xA6, 0xB3, 0xA5, 0xA4, 0x93, 0xB2, 0xA5, 0xCA, 0xA6, 
	0xDB, 0xA8, 0xB2, 0xA9, 0xB2, 0xA5, 0xAB, 0xA6, 0x00, 0xC0, 0xA5, 0xA9, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x04, 0xA5, 0xAC, 0x93, 0xF4, 0xA5, 0x99, 0x93, 0xFE, 0xA5, 0xB3, 0x93, 0xC3, 0xA8, 0xE0, 0xA9, 
	0xE7, 0xAC, 0xE8, 0xA6, 0xE7, 0xAC, 0xD8, 0x93, 0xD2, 0xAB, 0xD8, 0xA6, 0xD2, 0xAA, 0xAB, 0xA6, 
	0xFB, 0xCA, 0xE7, 0xAB, 0xFB, 0xE0, 0xF4, 0xE3, 0xE9, 0xE0, 0xF4, 0xEB, 0xD2, 0xE0, 0xE6, 0xD6, 
	0xE7, 0xC1, 0xD4, 0xA2, 0xC2, 0xA2, 0xA4, 0xB1, 0x92, 0xBA, 0xAE, 0xB7, 0xFB, 0xA0, 0xA3, 0xB1, 
	0xFB, 0xB8, 0xF0, 0x9F, 0xFB, 0xE6, 0xDE, 0x92, 0x96, 0x92, 0x6E, 0x0E, 0xE9, 0xE6, 0xE7, 0xD9, 
	0xA4, 0xBA, 0xB9, 0x9F, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0xD2, 0xA0, 0xE6, 0xB1, 
	0xDE, 0x08, 0x09, 0x0E, 0x50, 0x0F, 0x19, 0x0E, 0xE9, 0xD9, 0x6E, 0x0E, 0xFD, 0xCC, 0xE6, 0xD9, 
	0xFB, 0x92, 0xC3, 0x0F, 0xFB, 0x0F, 0x19, 0x0E, 0x50, 0xE6, 0xF9, 0xF0, 0x00, 0x9E, 0xE9, 0xB1, 
	0x00, 0x00, 0x00, 0xBA, 0x6C, 0xC6, 0xC5, 0x97, 0x4B, 0x00, 0x40, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x43, 0x45, 0x41, 0x43, 0x44, 0x45, 0x47, 0x43, 0x4A, 0x45, 0x56, 0x4A, 0x47, 0x48, 
	0x50, 0x44, 0x4D, 0x45, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x43, 0x41, 0x45, 
	0x3C, 0x48, 0x4D, 0x45, 0x3D, 0x43, 0x4A, 0x45, 0x00, 0x43, 0x44, 0x45, 0x00, 0x00, 0x00, 0x43, 
	0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x44, 0x43, 0xDE, 0x43, 0x6C, 0x40, 
	0xFB, 0xE5, 0xF5, 0xCE, 0xC3, 0xAB, 0x99, 0xA9, 0xE9, 0x9C, 0xB8, 0xA6, 0xE7, 0xD0, 0xE2, 0x9C, 
	0x3F, 0xF0, 0x6E, 0xB8, 0xD2, 0xE5, 0x6E, 0xE8, 0xD2, 0xE2, 0xE7, 0xD7, 0xC3, 0x09, 0xF0, 0xD8, 
	0xF4, 0xD4, 0x19, 0x95, 0x8E, 0xE5, 0xE6, 0xD7, 0xD2, 0xAB, 0xB3, 0x9C, 0x00, 0xC0, 0xA5, 0xA9, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xF5, 0xAC, 0xD7, 0x93, 0x3F, 0x14, 0x1E, 0x0E, 0x96, 0x00, 0x0F, 0x18, 0xDE, 0x73, 0xD9, 0x17, 
	0xDE, 0xE0, 0x1E, 0x0E, 0x00, 0x0E, 0x6E, 0x18, 0x96, 0xD7, 0xCC, 0x17, 0xE7, 0xB3, 0xD7, 0xAB, 
	0xB2, 0xBB, 0xBD, 0xA9, 0xC2, 0xBA, 0xB2, 0xB7, 0xC3, 0xBA, 0x91, 0xAD, 0x9E, 0xBA, 0xA2, 0xAD, 
	0x8E, 0xBA, 0xA4, 0x9F, 0xF5, 0xA4, 0xD9, 0x9F, 0xFB, 0x8F, 0xDE, 0x73, 0xDE, 0x92, 0xC3, 0x0E, 
	0x03, 0xD9, 0xC3, 0x0F, 0x10, 0x0F, 0x08, 0x0E, 0x00, 0x00, 0x08, 0x0F, 0xE9, 0x00, 0x96, 0xF0, 
	0x00, 0xBA, 0xB9, 0xB7, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0xE7, 0xA2, 0xDB, 0xAD, 
	0xE9, 0xE6, 0xF9, 0xD9, 0xFD, 0x7E, 0x6E, 0x0E, 0x96, 0x19, 0xE6, 0x0F, 0xE9, 0xE6, 0xF5, 0xF0, 
	0x08, 0x00, 0x0F, 0x0E, 0x00, 0x00, 0x0F, 0x0E, 0xF8, 0xE6, 0x25, 0xB2, 0xD2, 0xA2, 0xC3, 0xAD, 
	0x00, 0x00, 0x00, 0xBA, 0x8F, 0xC6, 0x6C, 0xAD, 0x45, 0x00, 0x40, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x66, 0x49, 0x47, 0x5B, 0x3C, 0x4E, 0x4D, 0x5F, 0x3C, 0x59, 0x4D, 0x53, 0x3E, 0x4C, 0x4A, 0x40, 
	0x44, 0x48, 0x43, 0x4B, 0x4A, 0x43, 0x44, 0x45, 0x66, 0x41, 0x4D, 0x43, 0x3C, 0x49, 0x4D, 0x6B, 
	0x3F, 0x87, 0x73, 0x7F, 0x56, 0x6D, 0x4D, 0x7F, 0x3C, 0x64, 0x4D, 0x7A, 0x66, 0x67, 0x47, 0x4C, 
	0x56, 0x41, 0x66, 0x43, 0x66, 0x43, 0x32, 0x45, 0x3E, 0x44, 0x4D, 0x45, 0x8E, 0x3D, 0x3C, 0x60, 
	0x8E, 0x35, 0x47, 0x40, 0x9A, 0xA5, 0xB9, 0x93, 0xF5, 0x99, 0xCE, 0x93, 0x3F, 0x0F, 0x08, 0x18, 
	0x0F, 0x00, 0x0E, 0x18, 0xF4, 0x18, 0x1E, 0x17, 0xE9, 0xE2, 0x50, 0xE0, 0x08, 0x18, 0x0F, 0x17, 
	0x00, 0x00, 0x18, 0x17, 0xC3, 0x0E, 0xCA, 0x17, 0xDB, 0xD7, 0xCC, 0x9B, 0xA8, 0xA5, 0x9D, 0xA6, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xDB, 0xA6, 0xD7, 0x93, 0x96, 0x00, 0x08, 0x18, 0x00, 0x00, 0x00, 0x18, 0xE7, 0x0E, 0xE4, 0x17, 
	0xD2, 0xD8, 0x1E, 0x18, 0x00, 0x00, 0x00, 0x18, 0x22, 0x18, 0xF3, 0x17, 0xE7, 0xD8, 0xA3, 0xA7, 
	0xCA, 0xBA, 0xB4, 0xAA, 0x00, 0x00, 0xBA, 0x97, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0xBA, 0xB1, 
	0xD2, 0xD4, 0xE6, 0xA0, 0x96, 0x0F, 0xC3, 0x0E, 0x00, 0x00, 0x0F, 0x0E, 0x00, 0x0F, 0x10, 0x0E, 
	0x00, 0x00, 0xC3, 0x0E, 0x00, 0x00, 0x00, 0x0F, 0x10, 0x0F, 0x08, 0x0E, 0xE9, 0xF0, 0xDE, 0xD9, 
	0xB4, 0xBA, 0x99, 0xB0, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0xF8, 0x97, 0xB2, 0xB1, 
	0x22, 0x92, 0xF9, 0x0F, 0x00, 0x00, 0x0F, 0x0E, 0x50, 0x00, 0x96, 0x0F, 0xFE, 0xE6, 0xF8, 0xF0, 
	0x22, 0x0F, 0x09, 0x0E, 0x8E, 0x0F, 0x1E, 0x0E, 0xFB, 0xF0, 0xDE, 0xD9, 0xCA, 0xBA, 0xAE, 0x9F, 
	0x00, 0x00, 0x00, 0xBA, 0x6C, 0xBA, 0xC4, 0xB1, 0x00, 0x54, 0x58, 0x46, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x5F, 0x58, 0x5B, 0x3F, 0x5D, 0x67, 0x8B, 0x32, 0x6F, 0x83, 0x8B, 
	0x32, 0x6F, 0x83, 0x8B, 0x66, 0x6D, 0x74, 0x7F, 0x73, 0x79, 0x74, 0x7F, 0x86, 0x6F, 0x79, 0x8B, 
	0x00, 0x00, 0x70, 0x79, 0x00, 0x00, 0x00, 0x79, 0x00, 0x6F, 0x79, 0x8B, 0x00, 0x79, 0x7A, 0x7F, 
	0x74, 0x79, 0x77, 0x8B, 0x73, 0x6F, 0x76, 0x8B, 0x00, 0x79, 0x73, 0x7F, 0x83, 0x79, 0x77, 0x7F, 
	0x71, 0x6F, 0x79, 0x7F, 0x81, 0xA5, 0x9B, 0xA9, 0xE7, 0xAB, 0xD6, 0xA6, 0xDE, 0x18, 0x09, 0x17, 
	0x00, 0x00, 0x18, 0x17, 0xD2, 0x18, 0x0F, 0x17, 0xDE, 0xE2, 0xF4, 0xE4, 0x22, 0x18, 0x0F, 0x17, 
	0x00, 0x18, 0x0E, 0x17, 0xF8, 0x95, 0x16, 0x17, 0xD2, 0xE2, 0xC2, 0x9A, 0xBD, 0xA5, 0xAB, 0xC0, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xE7, 0xA7, 0xD6, 0x93, 0xF5, 0x14, 0x7E, 0x18, 0xF9, 0x18, 0x19, 0x17, 0xDE, 0xB4, 0xE5, 0x18, 
	0xF8, 0xD7, 0x19, 0x18, 0x25, 0x18, 0xEC, 0x17, 0xD2, 0xD8, 0xCA, 0x18, 0xD2, 0xE2, 0xE6, 0x99, 
	0x91, 0xAB, 0xAE, 0x9C, 0x00, 0x97, 0xBA, 0xAD, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x97, 0xBA, 0xAD, 
	0xF4, 0xA2, 0xE6, 0xB1, 0x50, 0x00, 0x96, 0x0F, 0x00, 0x00, 0x00, 0x0F, 0x3F, 0x0F, 0x22, 0x0E, 
	0x3F, 0xF0, 0xF4, 0x0E, 0xFB, 0x0F, 0x6E, 0x0E, 0xFD, 0xD9, 0x25, 0x14, 0xFB, 0xE6, 0xF5, 0xD9, 
	0xB2, 0xBA, 0xCA, 0x9F, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0xE9, 0xBA, 0xCA, 0x9F, 
	0x50, 0xD9, 0xF9, 0x0F, 0x10, 0x0F, 0x08, 0x0E, 0x8E, 0x1E, 0xE7, 0x0F, 0xF9, 0xF0, 0xE6, 0xD9, 
	0xFA, 0xE6, 0xFD, 0xD9, 0xE9, 0xD9, 0xE6, 0x97, 0xE9, 0x97, 0xCA, 0x9F, 0xA2, 0xB1, 0xBA, 0xB0, 
	0x00, 0x00, 0x00, 0xBA, 0x6C, 0xBA, 0xC4, 0xB1, 0x00, 0x00, 0x58, 0x46, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x54, 0x58, 0x5B, 0x4D, 0x86, 0x77, 0x8B, 0x00, 0x00, 0x00, 0x79, 
	0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x70, 0x79, 
	0x00, 0x00, 0x79, 0x7F, 0x00, 0x6F, 0x79, 0x7F, 0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x79, 
	0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x79, 
	0x00, 0x7F, 0x79, 0x8B, 0xB3, 0xAA, 0x9B, 0x94, 0xF4, 0xA5, 0xCA, 0xA6, 0xE9, 0xE0, 0xE5, 0x06, 
	0xF8, 0x95, 0xF9, 0x0E, 0xF4, 0xE0, 0x7E, 0xCE, 0x00, 0x00, 0xE2, 0xD7, 0x96, 0xEC, 0xC3, 0xE0, 
	0x3F, 0xF3, 0xDE, 0xEB, 0xDE, 0xE2, 0xE6, 0xCE, 0x00, 0xCA, 0xD2, 0xCE, 0xAC, 0xA5, 0xAB, 0xC0, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0xC0, 0xA5, 0x93, 0x9B, 0xA5, 0x9D, 0xA6, 0xCC, 0xA5, 0xB3, 0xA6, 
	0xB3, 0xA5, 0x9B, 0xA6, 0xAB, 0xC0, 0xA5, 0xA6, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xC2, 0xA8, 0xE2, 0xA6, 0xE9, 0x95, 0x6E, 0x1A, 0x96, 0x0F, 0xE4, 0x18, 0xDE, 0x95, 0x92, 0x17, 
	0x96, 0x6C, 0x6E, 0x95, 0x50, 0x0E, 0xCA, 0x18, 0xDE, 0xE0, 0x7E, 0x18, 0xD2, 0xE2, 0xE7, 0xB4, 
	0xB4, 0xAB, 0xC1, 0xA6, 0x00, 0x00, 0xBA, 0xB1, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0xE9, 0xB3, 0xD9, 0xB0, 0xDE, 0x0F, 0x19, 0x0E, 0xF8, 0x0F, 0x10, 0x0E, 0xF5, 0xD9, 0x6E, 0x0E, 
	0x26, 0xE6, 0xF4, 0xD9, 0xFB, 0x14, 0xC3, 0x0E, 0x3F, 0x0F, 0x09, 0x0E, 0xF5, 0xF0, 0xDE, 0xD9, 
	0x00, 0xBA, 0xB2, 0xB1, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0xE9, 0xA2, 0x99, 0xB7, 
	0xFA, 0xE6, 0xE7, 0xD9, 0xFB, 0x6E, 0xF5, 0xD9, 0xFB, 0xB3, 0xD9, 0x9F, 0xFB, 0xA4, 0xE6, 0xB1, 
	0xC2, 0xBA, 0x99, 0xB7, 0x00, 0xAD, 0xBA, 0x9F, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x6C, 0xC5, 0xC4, 0xA1, 0x40, 0x54, 0x58, 0x46, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x4D, 0x58, 0x65, 0x5F, 0x67, 0x79, 0x74, 0x7F, 0x00, 0x00, 0x00, 0x79, 
	0x00, 0x00, 0x70, 0x79, 0x70, 0x6F, 0x79, 0x8B, 0x3F, 0x79, 0x6D, 0x8B, 0x04, 0x75, 0x7E, 0x8B, 
	0x04, 0x77, 0x25, 0x86, 0x04, 0x74, 0x6E, 0x7F, 0x04, 0x77, 0x50, 0x7F, 0x56, 0x86, 0x74, 0x7F, 
	0x73, 0x79, 0x75, 0x7F, 0x6B, 0x79, 0x70, 0x7F, 0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x79, 
	0x00, 0x00, 0x79, 0x6F, 0x83, 0xA6, 0xB6, 0x8B, 0xD2, 0xBC, 0x9B, 0xA6, 0x50, 0x95, 0xC3, 0x14, 
	0x10, 0x0E, 0x0F, 0x18, 0x25, 0x0E, 0x0F, 0x18, 0xF8, 0xE2, 0xF0, 0xE0, 0x50, 0x0F, 0x08, 0x18, 
	0x00, 0x00, 0x0E, 0x18, 0xF4, 0xD8, 0x7E, 0x17, 0xE7, 0xE2, 0xC2, 0xB3, 0xA7, 0xAA, 0xAC, 0xA9, 
	0xE7, 0xA5, 0xA4, 0xA6, 0xE6, 0xBD, 0xD5, 0xA6, 0xCC, 0xD1, 0xD7, 0xCF, 0xE0, 0xD1, 0xE1, 0xDD, 
	0xD4, 0xD1, 0xD8, 0xCF, 0xCC, 0xD1, 0xD7, 0xBB, 0xE9, 0x9D, 0xD0, 0x93, 0x00, 0xC0, 0xA5, 0x93, 
	0xE6, 0xC0, 0xCC, 0xA6, 0x26, 0x0E, 0xF0, 0x18, 0x00, 0x00, 0x00, 0x18, 0xFC, 0x18, 0x1E, 0x17, 
	0xE7, 0xD6, 0x09, 0x18, 0x00, 0x00, 0x00, 0x18, 0xDB, 0x18, 0x19, 0x17, 0xD2, 0xD7, 0xD9, 0x9A, 
	0xB4, 0xAB, 0xC1, 0x93, 0x00, 0x00, 0xBA, 0xB1, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0xFB, 0xB8, 0xD9, 0x9F, 0xFA, 0xF0, 0xDE, 0x14, 0xF8, 0x0F, 0x10, 0x0E, 0xFD, 0x1E, 0x3F, 0x0F, 
	0xFE, 0xE6, 0x6E, 0xD9, 0x00, 0x00, 0x0F, 0x0E, 0x00, 0x00, 0x0F, 0x0E, 0xE9, 0xF9, 0x22, 0xD9, 
	0xCC, 0xBA, 0xB3, 0x9F, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0xA2, 0xB1, 0xBA, 0xB7, 
	0xC2, 0xBA, 0xB2, 0xB7, 0xCA, 0xBA, 0xA4, 0x9F, 0x00, 0x97, 0xBA, 0x9F, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0xC6, 0x6C, 0x97, 0x00, 0x00, 0x40, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x4D, 0x5D, 0x60, 0x58, 0x7A, 0x79, 0x86, 0x7F, 0x70, 0x7F, 0x79, 0x8B, 
	0x6E, 0x7A, 0x76, 0x7F, 0x04, 0x77, 0x7E, 0x7D, 0x00, 0x50, 0x04, 0x3F, 0x04, 0x50, 0x4F, 0x7E, 
	0xDE, 0x77, 0x76, 0x89, 0x56, 0x77, 0xA3, 0x7F, 0x00, 0x00, 0x00, 0x50, 0x04, 0x7E, 0x3F, 0x7F, 
	0x6E, 0x8D, 0x83, 0x7D, 0x04, 0x75, 0x73, 0x86, 0x70, 0x6F, 0x79, 0x8B, 0x00, 0x00, 0x00, 0x79, 
	0x00, 0x00, 0x00, 0x79, 0xB8, 0x93, 0x77, 0x8B, 0xA3, 0xA5, 0xCA, 0xA6, 0x96, 0xE0, 0xE6, 0x0F, 
	0x00, 0x00, 0x18, 0x17, 0x00, 0x00, 0x18, 0x17, 0xDE, 0x95, 0xB2, 0xD8, 0xDE, 0x0F, 0x1E, 0x18, 
	0x09, 0x18, 0x0F, 0x17, 0xE7, 0x06, 0x92, 0x17, 0xC2, 0xD7, 0xCC, 0xA4, 0xB3, 0xA9, 0xAC, 0xA6, 
	0xD2, 0xD1, 0xE3, 0xDD, 0xF9, 0xD1, 0xF3, 0xCF, 0xFE, 0x00, 0xF3, 0xCD, 0xFC, 0x00, 0xB2, 0xD5, 
	0xFC, 0xD1, 0x92, 0xCF, 0x00, 0x00, 0x00, 0xD1, 0x8E, 0xD1, 0xD9, 0xDD, 0xDE, 0xA8, 0xB3, 0xA9, 
	0xE7, 0xBE, 0x9A, 0x93, 0x96, 0x06, 0x92, 0x18, 0xDE, 0x0E, 0xC2, 0x18, 0xF4, 0xD8, 0x7E, 0x17, 
	0x8E, 0xD7, 0xC3, 0x18, 0x3F, 0x18, 0x25, 0x17, 0xDE, 0x06, 0x1E, 0x18, 0xC3, 0xD8, 0xF0, 0xA4, 
	0xCA, 0xA8, 0x9E, 0xA6, 0x00, 0x00, 0xBA, 0xB1, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0xD2, 0x9E, 0xE6, 0xB1, 0x3F, 0x0F, 0xE6, 0x0E, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x0F, 0x09, 0x0E, 
	0xF5, 0x00, 0x25, 0xD9, 0x22, 0x0F, 0x09, 0x0E, 0x8E, 0x14, 0xC3, 0x0E, 0xFA, 0xCC, 0xE7, 0xC1, 
	0xAE, 0xB1, 0xBA, 0x9F, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x92, 0xC6, 0x6C, 0xAD, 0x3A, 0x58, 0x40, 0x5F, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x62, 0x58, 
	0x00, 0x62, 0x64, 0x58, 0x00, 0x62, 0x64, 0x58, 0x00, 0x62, 0x64, 0x58, 0x00, 0x62, 0x64, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x67, 0x63, 0x51, 0x87, 0x70, 0x6F, 0x79, 0x7F, 0x76, 0x79, 0x89, 0x7F, 
	0xFA, 0x95, 0xDB, 0x83, 0x4F, 0xDB, 0xF5, 0xD4, 0x00, 0x50, 0x04, 0x3F, 0x00, 0x8E, 0x04, 0x50, 
	0xF5, 0xD9, 0xDB, 0xD7, 0x4F, 0xE6, 0xF5, 0xD7, 0x04, 0x00, 0x4F, 0x50, 0x04, 0x50, 0x4F, 0x96, 
	0xD2, 0xD9, 0xE6, 0xCE, 0x04, 0x50, 0x8E, 0xCC, 0x56, 0x70, 0x73, 0x8B, 0x76, 0x79, 0x75, 0x7F, 
	0x00, 0x00, 0x70, 0x79, 0x78, 0x8C, 0x97, 0x7F, 0x9A, 0xA5, 0xAC, 0xA6, 0xE9, 0x92, 0xF8, 0xD8, 
	0x6E, 0x06, 0xE5, 0x18, 0xF4, 0x7E, 0xA3, 0x95, 0xF4, 0xE2, 0xDB, 0xD7, 0xE7, 0xE8, 0xF0, 0xD7, 
	0xE7, 0xE0, 0xF4, 0xD7, 0xF4, 0xE0, 0xB2, 0xD7, 0xE9, 0xA4, 0xCA, 0xAB, 0xD9, 0xB5, 0xA4, 0x93, 
	0x00, 0xCF, 0xD1, 0xDD, 0xFC, 0xD1, 0xCA, 0xCF, 0xFE, 0x00, 0xF7, 0x00, 0xFB, 0x00, 0x02, 0xB8, 
	0xA3, 0xD1, 0xD5, 0xCF, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0xA3, 0xD1, 0xCE, 0x9D, 
	0xC2, 0xA5, 0xA8, 0xA6, 0xD2, 0xBD, 0xCE, 0xAA, 0xC2, 0x9A, 0xCE, 0xA8, 0xE7, 0xD3, 0xD7, 0xA8, 
	0xC2, 0x9A, 0xD7, 0xA8, 0xC2, 0x9A, 0xF3, 0xAB, 0xC3, 0xA4, 0xE5, 0xA8, 0xE7, 0x9B, 0xB4, 0xAA, 
	0xB4, 0xAA, 0xC1, 0xA6, 0x00, 0xAD, 0xBA, 0xB1, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0xC2, 0xA2, 0xDB, 0xAD, 0x50, 0x08, 0xF0, 0x0F, 0xDE, 0x0F, 0x09, 0x0E, 0xFB, 0xD9, 0x25, 0x0E, 
	0xFA, 0xE6, 0xE7, 0xD9, 0xFB, 0xD4, 0xF4, 0xA2, 0xE9, 0xA2, 0xD9, 0xB7, 0xB2, 0xBA, 0x99, 0x9F, 
	0x00, 0x00, 0xA2, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0xAE, 0xBA, 0x92, 0xBA, 0x91, 0xB7, 0x34, 0x58, 0x3A, 0x5F, 0x3E, 0x59, 0x64, 0x5F, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x3D, 0x5B, 0x74, 0x8B, 0x00, 0x79, 0x75, 0x7F, 0x25, 0x06, 0x7E, 0x07, 
	0x7E, 0x0D, 0x16, 0x07, 0x00, 0x0D, 0x7E, 0x07, 0x1E, 0x0D, 0x16, 0x07, 0x16, 0x0D, 0x06, 0x0A, 
	0x16, 0x0D, 0x06, 0x07, 0x00, 0x0D, 0x06, 0x07, 0x05, 0x07, 0x0D, 0x0A, 0x05, 0x07, 0x0D, 0x0A, 
	0x00, 0x0D, 0x05, 0x07, 0x05, 0x07, 0x0D, 0x0A, 0x50, 0x0D, 0x16, 0x07, 0x25, 0x0D, 0x16, 0x69, 
	0x7A, 0x79, 0x71, 0x6F, 0x76, 0x6F, 0xAC, 0x8B, 0x00, 0xA6, 0xA5, 0x93, 0xD2, 0xAA, 0x9A, 0xA9, 
	0xC2, 0xA8, 0x9A, 0xBF, 0xA3, 0xA8, 0x9B, 0xBF, 0xB2, 0x9D, 0xA7, 0xA9, 0xB4, 0xAA, 0xAC, 0xA9, 
	0x9A, 0xA5, 0xAB, 0xA9, 0xA4, 0xA5, 0xA8, 0xBF, 0xBD, 0xA9, 0xA5, 0xA6, 0xFA, 0xCE, 0xDB, 0x9D, 
	0x00, 0x00, 0xD1, 0xCF, 0x00, 0x00, 0x00, 0xD1, 0xF4, 0xD1, 0x9A, 0xCF, 0xF8, 0xD1, 0xB4, 0xDD, 
	0x00, 0x00, 0xD5, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0xB2, 0xD1, 0xD7, 0xCF, 
	0xAB, 0xA5, 0xA8, 0xC0, 0x00, 0xC0, 0xA5, 0xA6, 0x00, 0x00, 0xA5, 0xA9, 0x00, 0x00, 0xA5, 0xA9, 
	0x00, 0xA9, 0xA5, 0xBF, 0x00, 0xA9, 0xA5, 0xBF, 0x00, 0x00, 0xA5, 0xBF, 0x00, 0xC0, 0xA5, 0xBF, 
	0xB3, 0xA5, 0xB8, 0x93, 0x00, 0x00, 0xBA, 0xB7, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0xFB, 0xA2, 0xB2, 0xB7, 0x03, 0xF0, 0xD2, 0xD9, 0xE9, 0xD9, 0xE6, 0xB9, 0xE9, 0xA0, 0xCC, 0x9F, 
	0xC2, 0xBA, 0xB9, 0xB7, 0x00, 0xAD, 0xBA, 0xB0, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0xA3, 0xBA, 0x9E, 0xAD, 
	0x00, 0xAD, 0xBA, 0xB1, 0xA4, 0xBA, 0xA2, 0xB1, 0xB8, 0xBA, 0xA2, 0xB7, 0x92, 0xBA, 0xAE, 0xB7, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0xAD, 0xBA, 0xB7, 0x56, 0xA2, 0xB9, 0x9F, 
	0x2A, 0xB6, 0xA4, 0xB7, 0x26, 0xA4, 0xB2, 0xB7, 0x3D, 0x5C, 0x60, 0x5B, 0x4D, 0x62, 0x60, 0x5F, 
	0x4D, 0x58, 0x60, 0x5F, 0x67, 0x58, 0x60, 0x5B, 0x4D, 0x58, 0x67, 0x5F, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 
	0x00, 0x5F, 0x58, 0x5B, 0x4D, 0x87, 0x64, 0x7F, 0x74, 0x79, 0x7A, 0x7F, 0x04, 0x16, 0x50, 0x0D, 
	0x8E, 0x76, 0xC3, 0x0D, 0xE9, 0x95, 0xE6, 0x83, 0x04, 0x25, 0x50, 0x1E, 0x04, 0x50, 0x4F, 0x25, 
	0xE9, 0x7E, 0xA3, 0xD7, 0xFB, 0x8F, 0xC2, 0xE2, 0x04, 0x3F, 0x50, 0x16, 0x04, 0x3F, 0x8E, 0x1E, 
	0xF4, 0xCA, 0xE6, 0x95, 0x4F, 0xB2, 0x8E, 0x16, 0x4F, 0x1E, 0x25, 0x31, 0x56, 0x35, 0x3E, 0x38, 
	0x3F, 0x79, 0x77, 0x7F, 0xB8, 0x79, 0x77, 0x8B, 0x00, 0xA6, 0xA5, 0x93, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xAA, 0xBF, 0xA5, 0xA6, 0x4F, 0xCC, 0xC2, 0xD7, 
	0x00, 0x00, 0xD1, 0xDD, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 
	0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0xA3, 0xD5, 0xE1, 0xD1, 
	0xA4, 0xA5, 0xAB, 0xA9, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x91, 0xA5, 0xC1, 0xA6, 0x00, 0xB1, 0xBA, 0xB7, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0xBA, 0xA4, 0x9F, 0xC2, 0xBA, 0xB4, 0x9F, 0xA0, 0xB1, 0xBA, 0x9F, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x8F, 0x85, 0x81, 0xB7, 
	0x00, 0xBA, 0xD0, 0x9F, 0xA4, 0xBA, 0xB6, 0xB7, 0x96, 0xAD, 0x9A, 0xB7, 0x78, 0x64, 0xC1, 0x85, 
	0x6A, 0xAE, 0x67, 0xB7, 0xC4, 0xBA, 0xA0, 0xB1, 0x00, 0xA1, 0xBA, 0xB1, 0x6C, 0xBA, 0x81, 0xB7, 
	0x6E, 0x85, 0x67, 0x63, 0x6C, 0x9B, 0x81, 0x54, 0x3F, 0x62, 0x67, 0x5B, 0x3E, 0x58, 0x64, 0x5F, 
	0x67, 0x58, 0x5C, 0x5F, 0x00, 0x00, 0x58, 0x5B, 0x62, 0x5F, 0x58, 0x5B, 0x64, 0x00, 0x62, 0x58, 
	0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x00, 0x59, 0x58, 
	0x51, 0x54, 0x58, 0x5B, 0x47, 0x71, 0x74, 0x7F, 0x56, 0x71, 0x6E, 0x7F, 0x04, 0x00, 0x26, 0x50, 
	0x8E, 0xDB, 0x50, 0xCA, 0xD2, 0xD7, 0xCC, 0xCE, 0x56, 0x50, 0x26, 0x3F, 0x4F, 0x50, 0x26, 0x3F, 
	0x00, 0xCA, 0xD2, 0xD7, 0x00, 0xCC, 0xD2, 0xD7, 0x00, 0x50, 0x56, 0x3F, 0x00, 0xE9, 0x26, 0x50, 
	0x00, 0x00, 0xCA, 0xD7, 0x03, 0x96, 0x26, 0xCC, 0x4F, 0x2C, 0x32, 0x2E, 0x4F, 0x2C, 0x3E, 0x2D, 
	0x47, 0x71, 0x74, 0x6F, 0x95, 0x71, 0x6D, 0x7F, 0xB0, 0xC0, 0xA5, 0xA6, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xDB, 0xAC, 0xB3, 0xA9, 
	0x00, 0xCF, 0xD1, 0xDD, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 
	0x00, 0x00, 0xD5, 0xD1, 0x00, 0xD1, 0xD6, 0xCF, 0xD6, 0xD1, 0xD5, 0xCF, 0xE6, 0xD1, 0xD9, 0xDD, 
	0x92, 0xA8, 0xAB, 0xC0, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xB3, 0xA5, 0xA4, 0xA6, 0x00, 0xB1, 0xBA, 0xB7, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x81, 0xA8, 0x64, 0x53, 
	0x78, 0xBA, 0x81, 0xB7, 0xB4, 0xAC, 0x81, 0x80, 0x78, 0xA7, 0x81, 0xB0, 0xC3, 0x85, 0x67, 0x5B, 
	0x8F, 0x4B, 0x78, 0x5F, 0x78, 0xC5, 0x78, 0xAB, 0x67, 0x62, 0xA4, 0x5F, 0xB3, 0x58, 0x3A, 0x5F, 
	0x4E, 0x58, 0x62, 0x5F, 0x00, 0x5F, 0x58, 0x5B, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x58, 0x5F, 0x00, 0x00, 0x58, 0x5F, 0x00, 0x00, 0x58, 0x5F, 0x00, 0x00, 0x58, 0x5F, 
	0x47, 0x58, 0x4D, 0x5F, 0x83, 0x79, 0x6D, 0x7F, 0x04, 0x6D, 0x74, 0x7F, 0x00, 0x00, 0x26, 0x50, 
	0x56, 0x00, 0x96, 0xCA, 0xE7, 0x00, 0xCC, 0xD7, 0x00, 0x50, 0x56, 0x3F, 0x00, 0x50, 0x26, 0x3F, 
	0x00, 0xCA, 0xE9, 0xD7, 0xE7, 0x00, 0xCC, 0xD7, 0x00, 0x00, 0x56, 0x50, 0x26, 0x50, 0xE9, 0x3F, 
	0x00, 0x00, 0xCA, 0xD7, 0x56, 0xE7, 0x3F, 0xCC, 0x00, 0x00, 0x03, 0x50, 0x04, 0x76, 0x50, 0x83, 
	0x71, 0x6F, 0x79, 0x8B, 0x95, 0x70, 0x76, 0x7F, 0xB6, 0xA5, 0xB1, 0xA9, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xE6, 0xA5, 0xA7, 0xA6, 
	0x00, 0x00, 0xD1, 0xCF, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 
	0x00, 0xD1, 0xD0, 0xCF, 0xE9, 0xD9, 0xDB, 0xCE, 0xE9, 0xCC, 0xE7, 0xD6, 0xD9, 0xD1, 0xD0, 0xCF, 
	0x00, 0xAB, 0xB2, 0xC0, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xB8, 0xA5, 0xA4, 0x93, 0x00, 0xB7, 0xBA, 0x9F, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x26, 0xBA, 0x9A, 0xB1, 0x6C, 0x3A, 0x9A, 0xAB, 0x6C, 0x85, 0xA4, 0x9D, 
	0xA3, 0x62, 0x78, 0x8D, 0x92, 0x5F, 0x4E, 0x5B, 0xFA, 0x62, 0x3E, 0x5F, 0x3C, 0x58, 0x49, 0x5B, 
	0x00, 0x58, 0x62, 0x5F, 0x00, 0x00, 0x58, 0x5B, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x64, 0x62, 0x59, 0x58, 
	0x00, 0x62, 0x64, 0x58, 0x00, 0x62, 0x64, 0x58, 0x00, 0x62, 0x64, 0x58, 0x64, 0x00, 0x59, 0x58, 
	0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 
	0x3D, 0x63, 0x60, 0x5B, 0x00, 0x6F, 0x79, 0x8B, 0x04, 0x6F, 0x73, 0x8B, 0x00, 0x00, 0x00, 0x50, 
	0x4F, 0xE7, 0x96, 0xCC, 0xE7, 0x00, 0xCC, 0xD7, 0x4F, 0x50, 0x56, 0x3F, 0x00, 0x00, 0x26, 0x50, 
	0x00, 0xCC, 0x8E, 0xD7, 0xDB, 0x00, 0xCC, 0xD7, 0x56, 0x00, 0x56, 0x50, 0x26, 0x50, 0xE9, 0x3F, 
	0x00, 0xCA, 0xCC, 0xD7, 0x56, 0xDB, 0x96, 0xCC, 0x00, 0x00, 0x00, 0x50, 0x04, 0x7E, 0x50, 0x73, 
	0x00, 0x6F, 0x79, 0x7F, 0x83, 0x79, 0x74, 0x8B, 0xB8, 0xA5, 0xC1, 0xA6, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xCC, 0xA8, 0xAC, 0xA9, 
	0x00, 0xD1, 0xD5, 0xDC, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 
	0xD0, 0xD1, 0xD5, 0xDC, 0xFB, 0xD7, 0xE7, 0xDC, 0xD7, 0xD1, 0xD0, 0xCF, 0x00, 0xD1, 0xE0, 0xCF, 
	0xC3, 0xAB, 0xA3, 0xC0, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0xC0, 0xA5, 0xA6, 0x00, 0xA9, 0xA5, 0xA6, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xB4, 0xBE, 0xAC, 0xA6, 0xB6, 0x97, 0xBA, 0xB1, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x99, 0xBA, 0xC4, 0xB7, 
	0xB8, 0xBA, 0xB6, 0xB1, 0x3F, 0xBA, 0xC4, 0xB1, 0x47, 0xB6, 0x9A, 0xB0, 0x8F, 0x58, 0x41, 0x5F, 
	0x3F, 0x58, 0x60, 0x5F, 0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x5C, 0x58, 0x59, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 
	0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 
	0x64, 0x58, 0x5C, 0x5F, 0x60, 0x58, 0x59, 0x5F, 0x00, 0x00, 0x58, 0x5F, 0x00, 0x00, 0x58, 0x5F, 
	0x67, 0x5F, 0x5D, 0x79, 0x00, 0x6F, 0x79, 0x7F, 0x04, 0x77, 0x50, 0x7F, 0x00, 0x00, 0x00, 0x50, 
	0x8E, 0xDB, 0x50, 0xCC, 0xD2, 0x00, 0xCC, 0xD7, 0x4F, 0x50, 0x26, 0x3F, 0x00, 0x00, 0x26, 0x50, 
	0x8E, 0xCC, 0xE9, 0xD7, 0xDB, 0x00, 0xCC, 0xD7, 0x03, 0x00, 0x56, 0x50, 0x26, 0x50, 0xE9, 0x3F, 
	0x00, 0xCA, 0xCC, 0xD7, 0x4F, 0x00, 0x96, 0xCA, 0x00, 0x00, 0x00, 0x50, 0x04, 0x00, 0x56, 0x50, 
	0x7A, 0x79, 0x89, 0x7F, 0x75, 0x79, 0x7A, 0x7F, 0x95, 0xA5, 0xB3, 0xBF, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x98, 0xA5, 0xA6, 0x8F, 0xA5, 0xAB, 0xA9, 0x99, 0xA5, 0xC9, 0xA6, 0x3C, 0xBE, 0x9B, 0xA6, 
	0x00, 0xA5, 0xAC, 0xC0, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xA9, 0xA5, 0xA6, 0xD2, 0x9D, 0xCC, 0xA6, 
	0xD0, 0x00, 0xD5, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 
	0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0xD9, 0xD1, 0xD4, 0xCF, 
	0xA3, 0xAB, 0x8F, 0xC0, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x2A, 0xA5, 0xCD, 0xA6, 
	0x6C, 0xA8, 0x81, 0xA9, 0x8F, 0xA8, 0x9B, 0xA9, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xB4, 0xA5, 0x9A, 0x93, 0xB8, 0xBA, 0x9E, 0xB1, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0xA2, 0xBA, 0xA2, 0xB1, 0xBA, 0xB0, 0x00, 0xAD, 0xBA, 0xB1, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0xB4, 0xAB, 0x81, 0xB7, 0x96, 0x85, 0x78, 0x54, 
	0xC3, 0x62, 0x4A, 0x5B, 0x96, 0x59, 0x78, 0x54, 0x49, 0x58, 0x3A, 0x5B, 0x00, 0x58, 0x62, 0x5B, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x62, 0x58, 0x5C, 0x00, 0x59, 0x58, 
	0x5C, 0x00, 0x59, 0x58, 0x5C, 0x00, 0x59, 0x58, 0x64, 0x62, 0x5C, 0x58, 0x64, 0x62, 0x5C, 0x58, 
	0x5C, 0x00, 0x59, 0x58, 0x64, 0x00, 0x59, 0x58, 0x64, 0x62, 0x5C, 0x58, 0x5C, 0x00, 0x59, 0x58, 
	0x5C, 0x00, 0x59, 0x58, 0x64, 0x62, 0x5C, 0x58, 0x5C, 0x00, 0x59, 0x58, 0x5C, 0x00, 0x59, 0x58, 
	0x64, 0x62, 0x5C, 0x58, 0x00, 0x00, 0x5C, 0x58, 0x00, 0x58, 0x5C, 0x5F, 0x64, 0x00, 0x5C, 0x58, 
	0x3D, 0x7A, 0x63, 0x7F, 0x00, 0x79, 0x75, 0x7F, 0x04, 0x83, 0x6E, 0x8B, 0x04, 0x1E, 0x50, 0x16, 
	0x4F, 0xCC, 0xD2, 0x16, 0xE9, 0xCE, 0xE6, 0x06, 0x04, 0x16, 0x50, 0x06, 0x04, 0x3F, 0x50, 0x16, 
	0x4F, 0x8F, 0xF5, 0xB4, 0xF8, 0x1E, 0xF0, 0x95, 0x04, 0x3F, 0x26, 0x16, 0x04, 0x3F, 0x50, 0x16, 
	0xF8, 0xB4, 0xE6, 0x76, 0x4F, 0x73, 0xDE, 0x06, 0x04, 0x1E, 0x50, 0x16, 0x04, 0x3F, 0x50, 0x16, 
	0x1E, 0x6D, 0x77, 0x7F, 0x6B, 0x6F, 0x79, 0x7F, 0x76, 0xAD, 0xA7, 0xA9, 0x00, 0xA9, 0xA5, 0x93, 
	0x8F, 0x84, 0x67, 0xA9, 0x8F, 0xBE, 0x99, 0x93, 0x8F, 0x85, 0x67, 0x5B, 0xB4, 0xA8, 0x9B, 0xA9, 
	0x00, 0xA5, 0xA8, 0xA9, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xBF, 0xA5, 0xA6, 0xE9, 0xAC, 0xCC, 0x94, 
	0xD7, 0xD1, 0xD6, 0xCF, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 
	0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0xE6, 0xD1, 0xCC, 0xDD, 
	0x00, 0xAB, 0xB2, 0xC0, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xA9, 0xA5, 0xA6, 0x6C, 0x38, 0x81, 0x8D, 
	0xA3, 0xAC, 0xA4, 0xA9, 0xDE, 0xA5, 0x9B, 0xA6, 0xA7, 0xA5, 0xA8, 0xC0, 0x00, 0x00, 0x00, 0xA5, 
	0x99, 0xA5, 0xA4, 0x93, 0xCA, 0xBA, 0xB8, 0x9F, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0xA3, 0xBA, 0x9E, 0xB1, 0x67, 0xBA, 0x60, 0xB7, 0x6A, 0x85, 0x99, 0xC8, 0x8F, 0xAE, 0x78, 0xA8, 
	0x9A, 0xBA, 0x85, 0xB7, 0x95, 0x84, 0x60, 0x80, 0x6A, 0x62, 0x78, 0x54, 0x00, 0x00, 0x62, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x58, 0x5F, 
	0x00, 0x00, 0x58, 0x5F, 0x00, 0x00, 0x58, 0x5F, 0x64, 0x62, 0x5C, 0x58, 0x00, 0x58, 0x64, 0x5F, 
	0x00, 0x58, 0x64, 0x5F, 0x00, 0x58, 0x64, 0x5F, 0x00, 0x58, 0x64, 0x5F, 0x00, 0x58, 0x64, 0x5F, 
	0x00, 0x58, 0x64, 0x5F, 0x00, 0x58, 0x64, 0x5F, 0x00, 0x58, 0x64, 0x5F, 0x00, 0x58, 0x64, 0x5F, 
	0x00, 0x58, 0x64, 0x5F, 0x00, 0x00, 0x64, 0x58, 0x00, 0x00, 0x59, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x47, 0x87, 0x83, 0x8B, 0x06, 0x79, 0x75, 0x8B, 0x4F, 0x05, 0x06, 0x07, 0x00, 0x07, 0x0D, 0x0A, 
	0x00, 0x07, 0x0D, 0x0A, 0x00, 0x00, 0x0D, 0x0A, 0x00, 0x07, 0x0D, 0x0A, 0x00, 0x07, 0x0D, 0x0A, 
	0x00, 0x07, 0x0D, 0x0A, 0x00, 0x00, 0x0D, 0x07, 0x00, 0x07, 0x0D, 0x0A, 0x00, 0x00, 0x0D, 0x0A, 
	0x00, 0x00, 0x0D, 0x0A, 0x00, 0x00, 0x0D, 0x0A, 0x00, 0x07, 0x0D, 0x0A, 0x05, 0x07, 0x0D, 0x0A, 
	0x50, 0x05, 0x1E, 0x0D, 0x71, 0x6F, 0x86, 0x7F, 0xD0, 0xC0, 0x83, 0xA6, 0x9A, 0xA5, 0xB6, 0xA6, 
	0x6C, 0xAC, 0x67, 0x8D, 0x6C, 0x54, 0x60, 0x94, 0xB2, 0xAB, 0x99, 0x9C, 0x00, 0xA9, 0xA5, 0xA6, 
	0x9A, 0xA5, 0xA4, 0xA9, 0xBB, 0xA5, 0xBE, 0xA6, 0x8F, 0xBE, 0x81, 0xA6, 0xA4, 0xB5, 0xAB, 0xA6, 
	0xE6, 0xD1, 0xD9, 0xCF, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 
	0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xD1, 0xE6, 0xD1, 0xCC, 0xDD, 
	0xB2, 0xAB, 0x92, 0xB5, 0x3C, 0xA5, 0xA7, 0xA6, 0x6C, 0xC9, 0xD0, 0xA9, 0x92, 0xBD, 0x67, 0x46, 
	0x3D, 0xAB, 0xA4, 0xA6, 0x6E, 0xCB, 0x9A, 0x9C, 0x3C, 0xBC, 0x9B, 0xA6, 0x00, 0xA5, 0x9D, 0xC0, 
	0x9B, 0xA5, 0xA8, 0xA6, 0xB2, 0xBA, 0xCA, 0xAD, 0x00, 0x97, 0xBA, 0xAD, 0xA3, 0x97, 0x81, 0xB0, 
	0x6E, 0x85, 0x81, 0xA8, 0xB2, 0x62, 0x41, 0x5F, 0xC3, 0x58, 0x49, 0x5B, 0x3F, 0x58, 0x60, 0x5B, 
	0x3E, 0x58, 0x3A, 0x46, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x64, 0x00, 0x62, 0x58, 0x00, 0x00, 0x64, 0x58, 
	0x00, 0x00, 0x64, 0x58, 0x00, 0x00, 0x64, 0x58, 0x00, 0x00, 0x64, 0x58, 0x00, 0x00, 0x64, 0x58, 
	0x00, 0x00, 0x64, 0x58, 0x00, 0x00, 0x64, 0x58, 0x64, 0x62, 0x59, 0x58, 0x64, 0x62, 0x59, 0x58, 
	0x64, 0x00, 0x59, 0x58, 0x64, 0x00, 0x59, 0x58, 0x64, 0x62, 0x59, 0x58, 0x64, 0x00, 0x59, 0x58, 
	0x64, 0x62, 0x59, 0x58, 0x64, 0x00, 0x59, 0x58, 0x64, 0x00, 0x59, 0x58, 0x64, 0x00, 0x59, 0x58, 
	0x00, 0x00, 0x59, 0x58, 0x00, 0x00, 0x59, 0x58, 0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x3E, 0x75, 0x83, 0x7F, 0x7E, 0x89, 0x6D, 0x7F, 0x04, 0x73, 0x3F, 0x0D, 0x56, 0x00, 0x50, 0x0D, 
	0x8E, 0xCA, 0xC3, 0x0D, 0xDE, 0xCE, 0xB2, 0x0D, 0x4F, 0x00, 0x25, 0x0D, 0x56, 0x00, 0x3F, 0x0D, 
	0x8E, 0xD4, 0xA3, 0x05, 0xE7, 0xCE, 0xA3, 0x05, 0x04, 0x06, 0x50, 0x05, 0x04, 0x06, 0x26, 0x05, 
	0xF5, 0xD7, 0xDB, 0x76, 0xFA, 0xCA, 0xE9, 0x06, 0x04, 0x3F, 0x50, 0x16, 0x4F, 0x50, 0x26, 0x6E, 
	0x4F, 0x6D, 0x7E, 0x7F, 0x70, 0x6F, 0x79, 0x8B, 0xCA, 0x77, 0xB8, 0xA6, 0xE9, 0x60, 0x67, 0xBC, 
	0x92, 0x81, 0x81, 0x62, 0x8F, 0x4B, 0x78, 0x5F, 0xD6, 0xA5, 0xBD, 0xA6, 0xA4, 0xA5, 0xB9, 0xA6, 
	0x3F, 0xBC, 0x9A, 0xA6, 0xC2, 0x81, 0x78, 0x8D, 0x96, 0x64, 0x6C, 0x8D, 0x96, 0x85, 0x6C, 0x9D, 
	0xF5, 0xD1, 0xD9, 0xDD, 0xE4, 0xD1, 0xEA, 0xDC, 0xEE, 0x00, 0xDF, 0xD1, 0xDF, 0x00, 0xDA, 0xD1, 
	0x00, 0x00, 0xDA, 0xD1, 0x00, 0xDC, 0xD1, 0xCF, 0x00, 0xCF, 0xD1, 0xDD, 0xD9, 0xD1, 0xD4, 0xDD, 
	0xB2, 0xAB, 0x92, 0xA5, 0x99, 0xA5, 0xB1, 0xA6, 0x96, 0x44, 0x78, 0x5B, 0x8E, 0x81, 0x6C, 0x54, 
	0x8E, 0x48, 0x78, 0x5B, 0x3D, 0x63, 0x67, 0x5B, 0xE6, 0xA2, 0x9A, 0xA9, 0xC9, 0xA5, 0xB7, 0xA9, 
	0xA8, 0xA5, 0xBE, 0xA6, 0x92, 0xB6, 0xCE, 0xAD, 0x78, 0xBA, 0x81, 0xB7, 0x6C, 0x85, 0x81, 0x5F, 
	0x8E, 0x58, 0x48, 0x5F, 0x45, 0x58, 0x62, 0x5F, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x62, 0x58, 
	0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x62, 0x58, 0x59, 0x00, 0x62, 0x58, 
	0x00, 0x00, 0x62, 0x58, 0x59, 0x00, 0x62, 0x58, 0x00, 0x62, 0x59, 0x58, 0x00, 0x62, 0x59, 0x58, 
	0x00, 0x62, 0x59, 0x58, 0x00, 0x62, 0x59, 0x58, 0x59, 0x00, 0x62, 0x58, 0x59, 0x00, 0x62, 0x58, 
	0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x62, 0x58, 
	0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x62, 0x58, 
	0x47, 0x7A, 0x61, 0x7F, 0x25, 0x5F, 0x60, 0x71, 0x3F, 0x60, 0x4D, 0x5F, 0x04, 0x4C, 0x26, 0x63, 
	0x03, 0x92, 0x6E, 0x5B, 0xF4, 0x46, 0x92, 0x5B, 0x4F, 0x4A, 0x3C, 0x5F, 0x4F, 0x67, 0x3F, 0x62, 
	0x4F, 0xCA, 0xE7, 0x67, 0xDB, 0xCE, 0xCC, 0x49, 0x04, 0x49, 0x3F, 0x58, 0x04, 0x4A, 0x3E, 0x58, 
	0xD2, 0xE0, 0xB2, 0x48, 0x8E, 0xCA, 0xA3, 0x57, 0x03, 0x62, 0x3F, 0x5F, 0x03, 0x59, 0x50, 0x62, 
	0x04, 0x77, 0x60, 0x7F, 0x5E, 0x6F, 0x5C, 0x7F, 0x8F, 0x63, 0x78, 0x93, 0x3C, 0x62, 0x67, 0x5F, 
	0x3C, 0x58, 0x3D, 0x5B, 0x8F, 0x58, 0x41, 0x5F, 0x67, 0x58, 0x3A, 0x46, 0x49, 0x58, 0x44, 0x5F, 
	0x4A, 0x58, 0x34, 0x5F, 0x4A, 0x58, 0x62, 0x5F, 0x59, 0x58, 0x62, 0x5F, 0x35, 0x58, 0x48, 0x5F, 
	0x47, 0x58, 0x4A, 0x5B, 0x4D, 0x58, 0x67, 0x5B, 0x6C, 0x58, 0x67, 0x46, 0x92, 0x40, 0x6C, 0x58, 
	0x8F, 0x40, 0x92, 0x58, 0xD9, 0x3A, 0x41, 0x5F, 0xD4, 0x58, 0x41, 0x5B, 0xE6, 0x58, 0x49, 0x5B, 
	0xB2, 0x4B, 0x81, 0x58, 0x3D, 0x58, 0x67, 0x46, 0x34, 0x58, 0x62, 0x5F, 0x59, 0x58, 0x62, 0x5F, 
	0x00, 0x00, 0x62, 0x58, 0x67, 0x58, 0x62, 0x5F, 0x3D, 0x58, 0x67, 0x46, 0x00, 0x58, 0x67, 0x46, 
	0x95, 0x4B, 0x49, 0x58, 0xE7, 0x58, 0x67, 0x5B, 0x34, 0x58, 0x38, 0x5F, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x59, 0x00, 0x62, 0x58, 0x64, 0x62, 0x59, 0x54, 0x00, 0x62, 0x64, 0x54, 0x00, 0x62, 0x64, 0x54, 
	0x64, 0x62, 0x5D, 0x54, 0x00, 0x62, 0x64, 0x54, 0x00, 0x62, 0x64, 0x54, 0x64, 0x62, 0x5D, 0x58, 
	0x00, 0x00, 0x5D, 0x58, 0x64, 0x00, 0x5D, 0x58, 0x00, 0x5D, 0x64, 0x58, 0x00, 0x5D, 0x64, 0x58, 
	0x00, 0x5D, 0x64, 0x58, 0x00, 0x5D, 0x64, 0x58, 0x64, 0x62, 0x59, 0x58, 0x64, 0x00, 0x59, 0x58, 
	0x5C, 0x00, 0x62, 0x58, 0x00, 0x62, 0x64, 0x58, 0x64, 0x00, 0x59, 0x58, 0x64, 0x00, 0x59, 0x58, 
	0x5C, 0x62, 0x59, 0x58, 0x00, 0x00, 0x64, 0x58, 0x00, 0x00, 0x64, 0x58, 0x64, 0x00, 0x59, 0x58, 
	0x5E, 0x58, 0x52, 0x5F, 0x00, 0x58, 0x62, 0x5B, 0x62, 0x5F, 0x58, 0x5B, 0x62, 0x5F, 0x58, 0x5B, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x58, 0x5F, 0x00, 0x5F, 0x58, 0x5B, 
	0x00, 0x00, 0x58, 0x5B, 0x00, 0x00, 0x58, 0x5B, 0x00, 0x00, 0x58, 0x5B, 0x00, 0x58, 0x62, 0x5F, 
	0x00, 0x5F, 0x58, 0x5B, 0x00, 0x00, 0x58, 0x5F, 0x00, 0x00, 0x58, 0x5F, 0x00, 0x00, 0x58, 0x5F, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x64, 0x00, 0x5C, 0x58, 0x64, 0x00, 0x5C, 0x58, 0x00, 0x00, 0x61, 0x58, 0x00, 0x00, 0x61, 0x58, 
	0x00, 0x00, 0x61, 0x58, 0x00, 0x00, 0x61, 0x58, 0x00, 0x00, 0x61, 0x58, 0x00, 0x00, 0x61, 0x58, 
	0x00, 0x00, 0x61, 0x58, 0x00, 0x00, 0x61, 0x58, 0x00, 0x00, 0x61, 0x58, 0x00, 0x00, 0x61, 0x58, 
	0x00, 0x00, 0x61, 0x58, 0x00, 0x00, 0x61, 0x58, 0x64, 0x00, 0x5C, 0x58, 0x00, 0x00, 0x64, 0x58, 
	0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x64, 0x58, 0x00, 0x00, 0x64, 0x58, 0x00, 0x00, 0x64, 0x58, 
	0x00, 0x62, 0x64, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x62, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
};

const u8 ImgAttr8[16640] __attribute__ ((aligned(4))) = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAA, 0x55, 0x57, 0xFD, 0xD1, 0x82, 0x02, 0x1D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xCB, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAA, 0x55, 0xFD, 0x5A, 0x2D, 0x26, 0xAF, 0x0F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xE2, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAA, 0xFF, 0x68, 0x00, 0xA0, 0x7F, 0xF5, 0x8B, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xE4, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x9F, 0x60, 0x02, 0x8A, 0xAB, 0xD5, 0x55, 0xA1, 0xE5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0x65, 0x2F, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x47, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x55, 
	0xFF, 0xF6, 0xA2, 0x76, 0x2F, 0x7D, 0xFF, 0xFF, 0x72, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xCF, 0x4B, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xEB, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x57, 
	0xF5, 0x80, 0x0A, 0xA8, 0xB5, 0xAA, 0xFF, 0xFF, 0x5C, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0x8D, 0xD2, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x51, 0xCA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xFD, 
	0x60, 0x26, 0x16, 0x27, 0xD5, 0xAA, 0xFF, 0xFF, 0x56, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0x25, 0x74, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x52, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0x68, 
	0x0A, 0x80, 0x7F, 0x6F, 0x55, 0xAA, 0xFF, 0xFF, 0x57, 0x2F, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA4, 0x35, 0x5D, 0x87, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xE3, 0xF8, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x55, 0x57, 0xF5, 0x8A, 
	0x20, 0x0B, 0xFF, 0xCB, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x47, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x35, 0x5F, 0x43, 0xF5, 0x55, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xC5, 0xF4, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x55, 0xFD, 0x60, 0x7C, 
	0xBD, 0xFF, 0xFF, 0xD1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x63, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0xB5, 0x57, 0xD8, 0x9F, 0x55, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xAD, 0xF6, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xFD, 0x68, 0x0A, 0x62, 
	0xD5, 0xD5, 0xFF, 0x78, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x98, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xE5, 0xA5, 0xFA, 0x09, 0xFD, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6C, 0x35, 0xF6, 0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0x68, 0xA0, 0xA0, 0xA7, 
	0x55, 0x55, 0xFF, 0x5C, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xA4, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xD2, 0xD5, 0x49, 0xF6, 0xA0, 0x2B, 0xF4, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0xB5, 0x5C, 0x47, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x55, 0xFF, 0xF5, 0x41, 0x8A, 0xB5, 0x76, 
	0xFF, 0xFF, 0xFF, 0x5E, 0x15, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x1F, 0x55, 0xFF, 0xFF, 0xFF, 0xA9, 
	0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xCB, 0xBF, 0xEB, 0x5E, 0x26, 0x0B, 0xA7, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xD5, 0x5E, 0x63, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x5F, 0xF5, 0x80, 0x7E, 0x2D, 0x1D, 0x6A, 
	0xFF, 0xFF, 0xFF, 0x57, 0x8D, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x87, 0xD5, 0xFF, 0xFF, 0xFF, 0xAB, 
	0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x8D, 0xFF, 0xEB, 0x57, 0x6A, 0xF5, 0x07, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0xD5, 0x57, 0x52, 0xE5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0xF6, 0xA0, 0x0A, 0xA2, 0x77, 0x8D, 0xAA, 
	0xFF, 0xFF, 0xFF, 0x57, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x02, 0xB5, 0xFF, 0xFF, 0xFF, 0xAB, 
	0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x35, 0xFF, 0xFF, 0x57, 0xDA, 0xFE, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xE1, 0x55, 0x57, 0x68, 0x39, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0x80, 0x08, 0x1A, 0x5F, 0xD5, 0xCB, 0xAA, 
	0xFF, 0xFF, 0xFF, 0x55, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x26, 0x2D, 0xFF, 0xFF, 0xFF, 0xA9, 
	0x8B, 0xBF, 0xFF, 0xFF, 0xFF, 0xFE, 0x78, 0x55, 0xFF, 0xFF, 0x55, 0xF2, 0x42, 0x7F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xC5, 0x55, 0xFF, 0xE8, 0x3F, 0x55, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x55, 0xFF, 0xF6, 0x2B, 0x58, 0x35, 0xFF, 0xFF, 0xD1, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0xD5, 0xAA, 0x55, 0x57, 0x62, 0xD3, 0x8F, 0x55, 0xFF, 0xFF, 0x5E, 
	0x9B, 0x55, 0xFF, 0xFF, 0xAA, 0x57, 0xE1, 0xE5, 0xFF, 0xFF, 0xFF, 0x78, 0x1F, 0xDF, 0xAA, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xAD, 0x5A, 0xFF, 0xD1, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x5F, 0xD6, 0x80, 0x96, 0x81, 0xEA, 0xFF, 0xFF, 0x7A, 0xD5, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0xB5, 0xAA, 0x57, 0xD8, 0x2F, 0xAA, 0x63, 0xD5, 0xFF, 0xFF, 0x5C, 
	0xB2, 0xD5, 0xFF, 0xFF, 0xAA, 0x5F, 0x85, 0x75, 0xFF, 0xFF, 0xFF, 0x7E, 0x1F, 0xFF, 0x2A, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x35, 0x61, 0xFF, 0xD2, 0x87, 0x95, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA2, 0xF6, 0x80, 0x51, 0x8A, 0x9F, 0xAA, 0xFF, 0xFF, 0x7C, 0xB5, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x35, 0xAA, 0xFE, 0x00, 0x7D, 0xAA, 0x98, 0xB5, 0xFF, 0xFF, 0x78, 
	0x74, 0xB5, 0xFF, 0xFF, 0xA8, 0xF4, 0x95, 0xE9, 0xFF, 0xFF, 0xFF, 0x57, 0x41, 0x55, 0xAA, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0x75, 0xC3, 0xFF, 0xF8, 0xA1, 0xE5, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBD, 0xA0, 0x2A, 0x89, 0xC7, 0xFF, 0xAA, 0xFF, 0xFF, 0x5E, 0x3F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x2D, 0x57, 0x40, 0x27, 0xD5, 0xAA, 0xA6, 0x2D, 0xFF, 0xFF, 0x70, 
	0xDC, 0x3D, 0xFF, 0xFF, 0xA7, 0x62, 0xD5, 0x2D, 0xFF, 0xF2, 0xFF, 0x57, 0x68, 0x22, 0xEA, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xF8, 0xEA, 0xCB, 0xFF, 0x78, 0x78, 0xF5, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0x55, 0x7F, 0xF6, 0x05, 0x68, 0x2D, 0xD1, 0xD5, 0xFF, 0xFF, 0x55, 0xA9, 0x00, 
	0x0A, 0x55, 0xFF, 0xFF, 0x57, 0x47, 0x5A, 0x0B, 0xDA, 0xFF, 0xFF, 0xFF, 0x8F, 0x95, 0x55, 0xD1, 
	0x57, 0x2F, 0x55, 0x56, 0xF6, 0x25, 0x58, 0x1A, 0xAA, 0x72, 0xD5, 0x55, 0xF5, 0x8B, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0xE1, 0xAA, 0xC7, 0xFF, 0x5C, 0x9C, 0x3D, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0x57, 0xF6, 0x80, 0x2A, 0x02, 0xB5, 0x78, 0xD5, 0xFF, 0xFF, 0x55, 0xA0, 0x29, 
	0x62, 0xD5, 0xFF, 0xFF, 0x56, 0xE0, 0x2A, 0x7D, 0xAA, 0xFF, 0xFF, 0xFF, 0x43, 0xE5, 0x57, 0xC9, 
	0x67, 0x43, 0xD5, 0x5E, 0x00, 0xA0, 0x20, 0xDA, 0xAA, 0xEA, 0x7F, 0xFF, 0xFE, 0x2F, 0xBF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA3, 0xC9, 0xAA, 0x6F, 0xFF, 0x5E, 0x97, 0x2D, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xA8, 0x7D, 0x60, 0xA4, 0xB5, 0x5F, 0xD5, 0x5E, 0xB5, 0xFF, 0xFF, 0x57, 0x81, 0x7F, 
	0xF8, 0xD5, 0xFF, 0xFF, 0x5F, 0x49, 0x1F, 0xD5, 0xAA, 0xFF, 0xFF, 0xFF, 0x90, 0xF5, 0x5D, 0x25, 
	0x55, 0x50, 0xBF, 0x95, 0x6A, 0x0A, 0xF9, 0x6A, 0xAB, 0x4F, 0xA7, 0xFF, 0x60, 0xBD, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0x05, 0xAA, 0x5F, 0xEB, 0x5D, 0x55, 0x8B, 0xBF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xA7, 0xE0, 0x0A, 0x50, 0xFF, 0xFF, 0x55, 0x5F, 0x2D, 0xFF, 0xFF, 0x5E, 0x1F, 0xFF, 
	0x7E, 0xB5, 0xFF, 0xFF, 0xFC, 0x1F, 0x47, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xA4, 0x36, 0x78, 0x95, 
	0x55, 0x66, 0x09, 0xD6, 0xFF, 0xFF, 0xE9, 0x2A, 0xAC, 0x1F, 0xD0, 0xA8, 0x22, 0x1D, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x5C, 0xB5, 0xFF, 0xFF, 0xEB, 0xAB, 0x4A, 0x63, 0xD5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x57, 0xFD, 0x40, 0x96, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0x45, 0xFF, 0xFF, 0x5A, 0xBD, 0xFF, 
	0xFD, 0x0A, 0x55, 0x57, 0x62, 0xFF, 0xE1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xD1, 0xE5, 
	0xFF, 0x52, 0x81, 0xEA, 0x55, 0x5F, 0x8D, 0x5F, 0xF4, 0xB5, 0xF8, 0x0A, 0xB4, 0x0F, 0x55, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x78, 0xD5, 0xFF, 0xFF, 0xE3, 0xAB, 0xEA, 0x78, 0x75, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x7D, 0x60, 0x92, 0x81, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0x73, 0xD5, 0xF5, 
	0x7F, 0x4A, 0x57, 0xF6, 0xA7, 0xFF, 0x78, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0x09, 0x15, 
	0xFF, 0x70, 0x7F, 0x2A, 0x56, 0x74, 0x3D, 0xFF, 0xA2, 0xF5, 0x6F, 0xFF, 0xDC, 0x83, 0xD5, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xA2, 0xE2, 0xD5, 0xFF, 0xFF, 0xEB, 0xAA, 0xD2, 0x5E, 0x9D, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x6F, 0xD8, 0x0A, 0x4B, 0xD3, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0xFF, 0xFF, 0x52, 0xF5, 0xD8, 
	0x27, 0xD2, 0xFD, 0x82, 0x7D, 0xFF, 0x5E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x89, 0x28, 0x37, 
	0x67, 0xFC, 0x97, 0xAA, 0x5B, 0xE2, 0xFF, 0x60, 0x27, 0xD5, 0x55, 0x55, 0x5F, 0xA0, 0x7D, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0x89, 0x55, 0xFF, 0xFF, 0xD7, 0xAA, 0xD2, 0x57, 0xAF, 0xBF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 
	0xF8, 0x82, 0xAA, 0x2F, 0xF4, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0xFF, 0xFF, 0x6F, 0x37, 0xE2, 
	0x8B, 0xF8, 0x80, 0x27, 0xD5, 0xFF, 0x57, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA1, 0xFC, 0x7E, 
	0x0A, 0x2A, 0x83, 0x6A, 0x5C, 0x0A, 0xA8, 0x0A, 0x75, 0x55, 0x55, 0x55, 0x57, 0x68, 0x2F, 0xEF, 
	0xFF, 0xFF, 0xFF, 0x55, 0xFE, 0x1D, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0x78, 0x55, 0xC3, 0xD5, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x7F, 
	0xF8, 0x15, 0x60, 0x3F, 0x54, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x35, 0xAA, 0x87, 0x37, 0x4A, 
	0x23, 0xFC, 0x2A, 0xF6, 0xFF, 0x55, 0x57, 0xCB, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x7A, 0xFA, 0xE8, 
	0xB6, 0xA0, 0xA3, 0xD5, 0x5E, 0x28, 0x0A, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x4B, 0xFD, 
	0xFF, 0xFF, 0xFF, 0x56, 0xF0, 0xF9, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0x7C, 0x95, 0x78, 0xBD, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xD6, 
	0x06, 0x0A, 0x09, 0xFE, 0x25, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x2D, 0xAA, 0x87, 0x2F, 0xE2, 
	0xB2, 0xDE, 0x15, 0xAA, 0xFF, 0x57, 0xD5, 0x52, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0x52, 0x09, 
	0xD7, 0xFE, 0x74, 0xBD, 0x7C, 0xBF, 0x7F, 0x5A, 0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0x7E, 0x58, 0x27, 
	0xFF, 0xFF, 0xFF, 0x67, 0x41, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x95, 0x5E, 0x2F, 0x95, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7D, 0x80, 
	0x56, 0x9A, 0x9F, 0x74, 0xE9, 0x45, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x45, 0xA9, 0xAF, 0x8D, 0xD2, 
	0x78, 0xB7, 0xC5, 0xAA, 0xFF, 0x7D, 0x7D, 0x74, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xA9, 0x5D, 
	0x55, 0x55, 0x55, 0x2F, 0x70, 0xD5, 0x55, 0xAA, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xD5, 0xD7, 0x0B, 
	0xFF, 0xFF, 0xFF, 0xBC, 0x26, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xE5, 0x55, 0x81, 0xD9, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xE0, 0x0A, 
	0x58, 0x7F, 0xFF, 0x73, 0xD1, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xEB, 0xAB, 0x1F, 0x47, 0xF8, 
	0xF4, 0x77, 0xE9, 0xAA, 0xFF, 0xD8, 0x0B, 0x5E, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x0D, 0x55, 
	0x55, 0x55, 0xD5, 0x81, 0xE2, 0x55, 0x55, 0xAA, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xF8, 0x2A, 0x2F, 
	0xFF, 0x55, 0x55, 0xF8, 0x77, 0xA5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xE0, 0xFF, 0x70, 0x7F, 
	0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x49, 0x56, 
	0x01, 0x55, 0x55, 0x53, 0xE2, 0xF2, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x52, 0x64, 0xBD, 0xCB, 0x78, 
	0x22, 0xD6, 0xD2, 0xAA, 0xFF, 0xC9, 0x61, 0x6B, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xAD, 0x55, 
	0xFF, 0xFF, 0xE0, 0x58, 0x2F, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xAA, 0x9C, 0x01, 0x4F, 
	0xFF, 0x55, 0x7F, 0x69, 0xFE, 0x35, 0x55, 0xEF, 0xFF, 0xFF, 0xFF, 0xEB, 0x78, 0xFF, 0x5E, 0x27, 
	0xE5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x24, 0x2A, 
	0x26, 0x25, 0x55, 0x6B, 0xE2, 0x74, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x52, 0xF5, 0x63, 0x5E, 
	0x0B, 0xD5, 0xFA, 0xAA, 0xD5, 0xAD, 0x78, 0xE9, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0xAF, 0x55, 
	0xFF, 0xFF, 0x50, 0x74, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xAA, 0xAB, 0xDA, 0xA2, 
	0xFF, 0x5B, 0xDA, 0x1D, 0x60, 0xB5, 0x5E, 0x2F, 0xFF, 0xFF, 0xFF, 0xD1, 0x5E, 0xBF, 0x57, 0xA0, 
	0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0x6D, 0x3F, 
	0x5A, 0x82, 0xD5, 0x53, 0x4A, 0x5E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xAB, 0xD5, 0x72, 0xD7, 
	0xFF, 0x96, 0xF2, 0x6B, 0x48, 0x15, 0x58, 0x6A, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0x89, 0xD5, 
	0xFF, 0xFF, 0x58, 0x63, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xD5, 0x5D, 0xFC, 0x1E, 
	0xFF, 0x5C, 0x02, 0x60, 0x22, 0xD5, 0xF8, 0xBF, 0xFF, 0xE3, 0xFF, 0xFC, 0x7F, 0xEF, 0x5F, 0xA0, 
	0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xD2, 0x4F, 0xAF, 
	0x4F, 0xFC, 0xB5, 0x58, 0x2A, 0x5F, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0x0F, 0x55, 0x78, 0xD5, 
	0x75, 0x67, 0xE0, 0xE4, 0x1D, 0x55, 0x78, 0xEA, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xAC, 0x28, 0xB5, 
	0xFF, 0xFF, 0x5D, 0x2F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x62, 0x47, 0xDA, 0x62, 0x55, 
	0xFF, 0x5C, 0x0A, 0x0A, 0xDB, 0x5F, 0x60, 0xEA, 0xAA, 0xEB, 0xFF, 0xFE, 0x9F, 0xF5, 0xF6, 0x0B, 
	0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xE3, 0x89, 0xCB, 
	0x63, 0xDD, 0xA5, 0x54, 0xB5, 0x57, 0x85, 0xFF, 0xFF, 0x55, 0x57, 0xE0, 0x63, 0xD5, 0x5C, 0x7F, 
	0xFD, 0xFD, 0x24, 0x5E, 0xB5, 0x55, 0x72, 0xFF, 0x7C, 0xB5, 0xFF, 0xAA, 0x55, 0xF8, 0x3E, 0x3F, 
	0x65, 0x55, 0x74, 0xBD, 0x5F, 0xE9, 0xFF, 0xFF, 0xFF, 0x55, 0xAA, 0x78, 0xAA, 0xA8, 0x02, 0x96, 
	0xFF, 0x5B, 0xD5, 0x7F, 0x45, 0xF4, 0x2A, 0xEA, 0xAA, 0xEB, 0xFF, 0xFF, 0x62, 0xF6, 0xA0, 0x7D, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xC5, 0xA9, 0x51, 
	0x78, 0x9F, 0x4E, 0x09, 0xD5, 0xF5, 0xEB, 0xFF, 0xFF, 0x55, 0xF6, 0x0B, 0x58, 0x75, 0x5E, 0x3F, 
	0xFF, 0xD0, 0xBC, 0x3E, 0xB5, 0x55, 0xE3, 0xFF, 0x5E, 0x1D, 0xFF, 0xAA, 0x5F, 0x41, 0xD7, 0x8F, 
	0x65, 0x5F, 0x62, 0xF5, 0xFD, 0x2D, 0xFF, 0xFF, 0xFF, 0x75, 0xAA, 0x5C, 0x05, 0x5D, 0x7E, 0xAA, 
	0xFF, 0x55, 0x5D, 0xF6, 0xB6, 0x80, 0x79, 0xEA, 0xAB, 0x47, 0xFF, 0xFF, 0xF0, 0x28, 0x9C, 0xBD, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x16, 0x3A, 0xF8, 
	0xDD, 0x08, 0x18, 0x62, 0xDF, 0xAF, 0x51, 0xFF, 0xFF, 0x7F, 0x80, 0xBD, 0x54, 0x3D, 0x5F, 0x2F, 
	0xF6, 0x09, 0xDE, 0x1E, 0x1F, 0xFF, 0x47, 0xFF, 0x57, 0xAD, 0xFF, 0xAA, 0xF6, 0x2F, 0x95, 0x8B, 
	0x95, 0xD6, 0x2F, 0xF5, 0x60, 0xB5, 0xFF, 0xFF, 0xFF, 0xAF, 0x55, 0x5F, 0x65, 0xD7, 0xDD, 0xA9, 
	0xFF, 0x55, 0x57, 0x40, 0x80, 0x27, 0xD3, 0xAA, 0xAD, 0x0B, 0xFF, 0xFF, 0x5E, 0x29, 0xD7, 0x2F, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0x94, 0xB4, 0xBE, 
	0x39, 0xA2, 0xF1, 0xF8, 0xF8, 0xA0, 0xF8, 0xFF, 0xFF, 0xE0, 0x07, 0xD5, 0x55, 0xAF, 0x57, 0x8A, 
	0xA0, 0x96, 0x57, 0x4D, 0x80, 0x02, 0x1F, 0xFF, 0x57, 0x47, 0xFF, 0x97, 0x62, 0x75, 0xC2, 0x61, 
	0xDE, 0x02, 0x5A, 0xA0, 0xA2, 0xD5, 0xFB, 0xFF, 0xFF, 0x62, 0x7F, 0xFF, 0xFE, 0x07, 0x57, 0xE1, 
	0xFF, 0xFF, 0xFF, 0x8A, 0x07, 0xF7, 0xCB, 0x55, 0xFE, 0x29, 0x7F, 0xFF, 0x57, 0x43, 0x4A, 0x47, 
	0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xF8, 0x58, 0x24, 0x00, 
	0x1F, 0x95, 0x74, 0xF9, 0x73, 0xD6, 0xBC, 0x7F, 0xFA, 0x02, 0x76, 0xFF, 0xFF, 0x4B, 0xD5, 0xD0, 
	0x2F, 0xFF, 0xAB, 0x4A, 0xD0, 0xA8, 0xB5, 0xFF, 0xAA, 0xE7, 0xFF, 0xD8, 0x27, 0xD7, 0x08, 0x7A, 
	0xD5, 0x8A, 0x02, 0x0A, 0xEB, 0x57, 0xE5, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x3E, 0xFF, 0xDA, 
	0xFF, 0xFF, 0xFE, 0x7F, 0x9F, 0x5F, 0x2D, 0x5F, 0xD8, 0x20, 0x29, 0x7D, 0xA0, 0xA7, 0xE2, 0x53, 
	0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0xD2, 0x61, 0x9D, 0x68, 
	0x0F, 0xAA, 0x5D, 0x07, 0x7A, 0x7F, 0x6C, 0x15, 0x80, 0x9F, 0xAA, 0xFF, 0xFF, 0x52, 0xF5, 0xD1, 
	0xD5, 0xFF, 0xAA, 0xE2, 0xFF, 0xFF, 0xD5, 0xFF, 0xAA, 0xE1, 0x7E, 0x02, 0x75, 0x57, 0x1E, 0xBC, 
	0xB5, 0xFF, 0xFF, 0xFF, 0x0D, 0xFD, 0x2D, 0xFF, 0xFF, 0x5F, 0x88, 0x0A, 0xA7, 0xF9, 0xFF, 0x76, 
	0xFF, 0xFF, 0xFF, 0x5E, 0xB7, 0x74, 0x35, 0xFE, 0x89, 0xD6, 0xA0, 0xAA, 0x02, 0x7D, 0xF8, 0x98, 
	0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA3, 0x4A, 0x07, 0x77, 0xF6, 
	0x6B, 0xAA, 0x5E, 0x75, 0x5E, 0x29, 0x7C, 0x28, 0x17, 0xF5, 0xAA, 0xFF, 0xFF, 0x54, 0xB5, 0xFA, 
	0xD5, 0xFF, 0xAA, 0xD2, 0xBD, 0x55, 0x55, 0xFF, 0xAB, 0x48, 0x82, 0x9F, 0xFD, 0x5E, 0x1E, 0xB5, 
	0x1D, 0x55, 0xFF, 0x74, 0x35, 0xD8, 0x35, 0xFF, 0xFF, 0x55, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 0x5D, 
	0xFF, 0xFF, 0xFF, 0x54, 0x7F, 0x62, 0xF5, 0xA0, 0x9F, 0x5F, 0xF5, 0x55, 0x5D, 0x55, 0xFD, 0xA6, 
	0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x85, 0x00, 0x9F, 0xD5, 0xF6, 
	0xB1, 0xEA, 0x72, 0xAD, 0x57, 0x80, 0x52, 0xFD, 0x1D, 0x55, 0xAA, 0xFF, 0xFF, 0x55, 0x2D, 0xFA, 
	0xD5, 0xFF, 0xAA, 0x78, 0x07, 0xD5, 0x55, 0xFF, 0x9C, 0x2F, 0xE3, 0xD7, 0x82, 0xFE, 0x9E, 0xB7, 
	0x8D, 0x55, 0x57, 0xE1, 0xD6, 0x8A, 0xF5, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0x57, 
	0xFF, 0xFF, 0x55, 0xF8, 0xEB, 0x82, 0xA0, 0x09, 0xDA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x42, 
	0x87, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xA3, 0x07, 0xFF, 0x74, 
	0xB8, 0xD5, 0xA3, 0xC5, 0x55, 0xF6, 0x0B, 0x6B, 0x8F, 0xAA, 0xFF, 0x55, 0xFD, 0x57, 0x8F, 0x78, 
	0xD5, 0xFF, 0xFF, 0x78, 0xDF, 0xFF, 0x55, 0x57, 0xD8, 0xB5, 0x70, 0xD6, 0x28, 0x26, 0x3D, 0x35, 
	0x47, 0x55, 0x58, 0x25, 0x80, 0x2F, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x56, 0xF1, 0x6A, 0x6A, 0xA5, 0xFF, 0xAA, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xF8, 
	0xA1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x5B, 0xBD, 0xFF, 0x74, 
	0x9C, 0xB5, 0x87, 0xE5, 0x5F, 0x80, 0xBD, 0xAA, 0xEB, 0xAA, 0xFF, 0x55, 0x81, 0xD5, 0x43, 0xF4, 
	0x55, 0xFF, 0xFF, 0x74, 0xB5, 0xBF, 0x57, 0xF6, 0x89, 0xD5, 0x54, 0x5C, 0xBF, 0x45, 0x24, 0xB5, 
	0x63, 0xD5, 0x5E, 0x8A, 0xA5, 0xF5, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 
	0xFF, 0xFF, 0x55, 0xC9, 0xAA, 0x7F, 0xFF, 0x55, 0xAA, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0x7E, 
	0xA8, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xD2, 0x6B, 0xB5, 0xFF, 0x76, 
	0xA5, 0x2D, 0x8F, 0x65, 0xF8, 0x27, 0xD5, 0xAA, 0xF1, 0xEA, 0xFF, 0xFE, 0x18, 0xB5, 0x92, 0xF4, 
	0x55, 0xFF, 0xFF, 0x5E, 0x3F, 0x27, 0xFD, 0x80, 0x9D, 0x55, 0x5E, 0x16, 0x1D, 0xE1, 0x82, 0xD5, 
	0x58, 0xD5, 0x57, 0xCF, 0xFF, 0x55, 0xFF, 0xE2, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 
	0xFF, 0xFF, 0x5B, 0x85, 0xAA, 0x55, 0xFF, 0x55, 0xAA, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0x57, 
	0x5A, 0x2D, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x47, 0x55, 0xFF, 0x7E, 
	0xC7, 0x8F, 0x89, 0x1D, 0x82, 0xF5, 0x55, 0xAA, 0x74, 0x5A, 0xFF, 0xA0, 0xFC, 0x35, 0xA8, 0xBC, 
	0x95, 0xFF, 0xFF, 0x5D, 0x2F, 0xA9, 0xE0, 0x27, 0xD5, 0x55, 0x57, 0x0F, 0x05, 0xE1, 0x56, 0x95, 
	0x54, 0xB5, 0x57, 0x9F, 0x55, 0x55, 0xFF, 0x8B, 0xFF, 0xFF, 0xFC, 0x2F, 0xFF, 0xFF, 0xF8, 0xBF, 
	0xFF, 0xFF, 0x5D, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 
	0xF8, 0x87, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xC5, 0x09, 0xEA, 0xFF, 0xAC, 
	0x60, 0x61, 0xDA, 0xD8, 0x2F, 0xFF, 0xFF, 0xFF, 0x5E, 0xB5, 0x74, 0x22, 0xDE, 0x35, 0xFE, 0x3E, 
	0xB5, 0xAA, 0x55, 0x57, 0xC5, 0xD8, 0x0B, 0xF6, 0xFF, 0xFF, 0xFF, 0xCB, 0xE0, 0x8F, 0x02, 0xD5, 
	0x5D, 0x3F, 0x5E, 0x39, 0xFF, 0xFF, 0xFC, 0x2F, 0xFF, 0xFF, 0xFF, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x5C, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD7, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 
	0x5E, 0xA1, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x14, 0x2B, 0x6A, 0xFF, 0xAB, 
	0xD8, 0x20, 0x7D, 0x89, 0xF5, 0xFF, 0xFF, 0xFF, 0x5F, 0x1D, 0x7A, 0xFD, 0x5C, 0xB5, 0xFF, 0x2D, 
	0xB5, 0xAA, 0x55, 0x5F, 0xD0, 0x8A, 0x9F, 0xAA, 0xFF, 0xFF, 0xFF, 0xD1, 0x7E, 0xBC, 0x18, 0xD5, 
	0x57, 0x87, 0x74, 0xF5, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x78, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 
	0x57, 0x68, 0xBD, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0x62, 0x9F, 0xAA, 0xFF, 0xA9, 
	0xF5, 0x58, 0xA2, 0x9D, 0x55, 0xFF, 0xFF, 0xFF, 0x57, 0x8D, 0x71, 0xD5, 0x74, 0x75, 0xFF, 0x8D, 
	0x35, 0xAA, 0x7F, 0xDA, 0x68, 0xBF, 0x6B, 0x6A, 0xFF, 0xFF, 0xFF, 0x78, 0xD5, 0xF6, 0xFE, 0x37, 
	0xF5, 0x43, 0xD2, 0xE5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0xE2, 0xD5, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 
	0x55, 0xD9, 0x0B, 0xD9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xA7, 0x7F, 0xAA, 0xFF, 0xAA, 
	0xFF, 0xFA, 0xD1, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0x55, 0xCB, 0x78, 0x7F, 0xF2, 0xD5, 0xFF, 0x89, 
	0x35, 0xAF, 0xD8, 0x80, 0x96, 0x3F, 0x59, 0x6A, 0xFF, 0xFF, 0xFF, 0x5C, 0xB5, 0x74, 0x74, 0x9E, 
	0x2F, 0x52, 0x4B, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x57, 0xCB, 0xFF, 0xFF, 0xFF, 0x57, 0x4B, 0xFF, 0x57, 0x2F, 0xFF, 0xFF, 0xFF, 0xAA, 0xFF, 
	0xFF, 0x78, 0x62, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xD0, 0x17, 0xFA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD0, 0xF4, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD3, 0x54, 0x00, 0x03, 0xFF, 0xFF, 0x5B, 
	0xB5, 0xF5, 0xE0, 0x2F, 0xFF, 0x8D, 0xA2, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x35, 0x5C, 0x1A, 0x5A, 
	0xA2, 0xF8, 0x2D, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x5F, 0x2D, 0xFF, 0xFF, 0xFF, 0x54, 0x2F, 0xFF, 0x5E, 0x1F, 0xFF, 0xFF, 0xFF, 0xAA, 0xFF, 
	0xFF, 0x5E, 0x56, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5B, 0xC6, 0x2F, 0x6A, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD8, 0x5E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xE7, 0x6A, 0xA7, 0xFF, 0xFF, 0x73, 
	0xFD, 0x60, 0x2D, 0xFF, 0xFF, 0xCB, 0xA2, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x2D, 0x57, 0x45, 0x73, 
	0xD8, 0x3C, 0xB5, 0xFF, 0xFF, 0xFF, 0x5E, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x5E, 0x35, 0xFF, 0xFF, 0xFF, 0x68, 0xFF, 0xFF, 0x74, 0x1F, 0xFF, 0xFF, 0xFF, 0xAA, 0xFF, 
	0xFF, 0x57, 0xD4, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0x25, 0x27, 0xAA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD8, 0xB7, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0xB5, 0xFF, 0xF5, 0xFF, 0xFF, 0x59, 
	0xD8, 0x0A, 0x55, 0xFF, 0xFF, 0x61, 0x89, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x45, 0x57, 0x89, 0x5A, 
	0x7D, 0xAD, 0x1D, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x78, 0xD5, 0xFF, 0xFF, 0xFF, 0xA7, 0xFF, 0xFF, 0x78, 0x9F, 0xFF, 0xFF, 0xFA, 0xFA, 0xFF, 
	0xFF, 0xFD, 0xD1, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0x1A, 0x27, 0xAA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF6, 0x2D, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x35, 0xFF, 0x55, 0xFF, 0xFF, 0x5C, 
	0x80, 0xAA, 0x55, 0xFF, 0xFF, 0x7A, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xEB, 0x5E, 0x3E, 0x5E, 
	0x1F, 0xC7, 0x8D, 0xFF, 0xFF, 0xFF, 0xC2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xD9, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xF0, 0xB5, 0xFF, 0xFF, 0x58, 0x7F, 0xFF, 
	0xFF, 0x56, 0x0B, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xF4, 0x54, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x74, 0x82, 0x59, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0x2D, 0xFF, 0xAA, 0xFF, 0x57, 0xE0, 
	0x05, 0x00, 0x02, 0xAA, 0xAA, 0xA8, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xD6, 0xB4, 0x97, 
	0x8F, 0xA5, 0x47, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0x55, 0xFF, 0xFF, 0x6B, 0xD5, 0xFF, 0xFF, 0xFF, 
	0x5F, 0x67, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xC0, 0xB5, 0xFF, 0xFF, 0x5F, 0x65, 0x55, 
	0x55, 0xA0, 0x9D, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xF2, 0x52, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x5E, 0x60, 0xA0, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0x47, 0xFF, 0xAA, 0xFF, 0xF8, 0x0B, 
	0xEB, 0xD6, 0x6A, 0x00, 0x00, 0xA6, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x5E, 0xB4, 0x35, 
	0xD8, 0xB5, 0xEB, 0xFF, 0xFF, 0xF4, 0x35, 0xFF, 0x57, 0xAF, 0xFF, 0x70, 0x7F, 0xFF, 0xFF, 0xFD, 
	0x7E, 0x9D, 0xA9, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x28, 0xBD, 0xFF, 0xFF, 0x57, 0xE0, 0xAA, 
	0xA8, 0x07, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE2, 0x8B, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x57, 0xD6, 0x58, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xE3, 0xFF, 0xAA, 0xFD, 0x80, 0x7F, 
	0xF2, 0xDF, 0xFF, 0x56, 0x55, 0x5F, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0xB6, 0xB4, 0x95, 
	0x5F, 0xDF, 0x81, 0xA5, 0x56, 0x80, 0x75, 0xFF, 0x7E, 0x3F, 0xFF, 0x5C, 0xA5, 0x55, 0x55, 0x58, 
	0xD0, 0x75, 0xAC, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x96, 0x2F, 0xFF, 0xFF, 0x55, 0xF8, 0x0A, 
	0xAA, 0x8F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5B, 0x48, 0x2F, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x55, 0xFF, 0xF9, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xF1, 0xFF, 0x9F, 0x60, 0x27, 0xD5, 
	0x74, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5D, 0x1E, 0xB8, 0xD5, 
	0x55, 0xF8, 0x14, 0x60, 0x00, 0x92, 0xD5, 0xFF, 0xF0, 0xFF, 0xFF, 0x57, 0x80, 0x2A, 0xA0, 0x02, 
	0xCB, 0xFF, 0xF6, 0x35, 0xFF, 0xFF, 0x55, 0x5F, 0xD9, 0x82, 0x67, 0xFF, 0xFF, 0xFF, 0x5D, 0x82, 
	0x06, 0xD3, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5D, 0x01, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x9F, 0xD2, 0x45, 0x55, 0xFF, 0xFF, 0xFF, 0xAA, 0x7A, 0xFF, 0xD8, 0x0A, 0x55, 0x55, 
	0x5E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0x11, 0xD5, 
	0x5D, 0x82, 0xFE, 0x36, 0xAA, 0xD1, 0xD5, 0xFF, 0xE9, 0xFF, 0xFF, 0xFF, 0xE8, 0xAA, 0x0A, 0x2F, 
	0x9F, 0xFF, 0x62, 0xD5, 0xFF, 0xFF, 0x55, 0xF6, 0x54, 0x28, 0x09, 0x57, 0xFF, 0xFF, 0xF7, 0xF4, 
	0x0A, 0x78, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0x9B, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xA9, 0xD8, 0xE3, 0xD5, 0xFF, 0xFF, 0xFF, 0xAA, 0x7C, 0x1D, 0x02, 0x7F, 0x62, 0xD7, 
	0x55, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x47, 0x87, 0x5F, 
	0xE0, 0x2F, 0x57, 0x2F, 0xFF, 0xCB, 0x7F, 0xFD, 0x0F, 0xFF, 0xFA, 0xFF, 0x7F, 0xD5, 0x5F, 0xF5, 
	0x75, 0x68, 0x21, 0xD5, 0xFF, 0xFF, 0x7D, 0x62, 0x62, 0x7D, 0x60, 0x09, 0x95, 0x57, 0x56, 0xAA, 
	0x7A, 0x5E, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x5B, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xD8, 0x7A, 0xD5, 0xFF, 0xFF, 0xFF, 0xAA, 0xF8, 0x02, 0x1F, 0xD5, 0x46, 0x3E, 
	0x0B, 0x8D, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xFF, 0xF6, 
	0x01, 0xF5, 0x57, 0x87, 0x5F, 0xAD, 0xFD, 0x60, 0x1D, 0xFF, 0xF8, 0xBF, 0x55, 0xFF, 0xFD, 0x55, 
	0xA0, 0x01, 0xE7, 0x95, 0xFF, 0xFF, 0xE0, 0xA0, 0x07, 0xD5, 0xFD, 0x80, 0x00, 0x2A, 0x00, 0x97, 
	0xFE, 0x97, 0x87, 0xBF, 0xFF, 0xFF, 0xFF, 0xFE, 0xE2, 0x4B, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xF4, 0xB4, 0xB5, 0xFF, 0xFF, 0xFF, 0xA7, 0x61, 0xD1, 0xD5, 0x57, 0x2F, 0x2C, 
	0xF1, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x9A, 0xA0, 
	0x9D, 0x55, 0x55, 0xA1, 0xD4, 0x2A, 0xA0, 0x09, 0xF5, 0xFF, 0xFC, 0xBF, 0x55, 0xFF, 0x55, 0x55, 
	0x80, 0x5F, 0xAD, 0xFF, 0xFF, 0xFD, 0x56, 0x02, 0x36, 0xFF, 0xFF, 0xF0, 0x88, 0xAA, 0x2B, 0xF6, 
	0xAD, 0x8A, 0xE3, 0xD5, 0x55, 0xFF, 0xFF, 0x57, 0xC9, 0x89, 0xDA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x78, 0x0A, 0xB5, 0xFF, 0xAA, 0x55, 0xF6, 0x2F, 0xF4, 0x75, 0x57, 0x0F, 0xC2, 
	0xD2, 0xD1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x45, 0xAA, 0xFF, 0xFF, 0x55, 0x57, 0x8F, 0x0A, 0x27, 
	0xFF, 0xFF, 0xFF, 0x78, 0xF6, 0x80, 0x02, 0x1D, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF4, 0xBF, 0xFF, 0xF5, 0x56, 0x00, 0xAF, 0x6A, 0xFF, 0xFF, 0xA5, 0xFF, 0xFF, 0xFD, 0xAA, 
	0xAB, 0xE2, 0x78, 0xBD, 0x55, 0xFF, 0xFF, 0x57, 0x85, 0x27, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x7E, 0x40, 0x2D, 0xFF, 0xAA, 0x5F, 0x82, 0xFD, 0x5E, 0x3D, 0x55, 0x4B, 0xC3, 
	0xD2, 0x78, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xAA, 0xFF, 0xFF, 0x55, 0x78, 0x1F, 0xC7, 0xF5, 
	0xFF, 0xFF, 0xFF, 0x5C, 0xB7, 0xFF, 0xFF, 0x5A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xE0, 0x65, 0x55, 0x6A, 0x00, 0x2B, 0xF5, 0xAA, 0xFF, 0xFF, 0xAA, 0x55, 0x55, 0x55, 0xAA, 
	0xAA, 0xF8, 0x5D, 0x2F, 0x95, 0xFF, 0xFF, 0x5E, 0x18, 0x97, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5F, 0xF6, 0x87, 0xFF, 0xA9, 0xD8, 0x27, 0xD5, 0x57, 0x2D, 0x7F, 0x60, 0x1A, 
	0x42, 0x5C, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0x51, 0x6A, 0xFF, 0xFF, 0x7F, 0x82, 0xF5, 0xD1, 0x55, 
	0xFF, 0xFF, 0xFF, 0x55, 0x1D, 0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xD8, 0x00, 0xAA, 0x08, 0xA5, 0xFF, 0x55, 0xAA, 0xFF, 0xFF, 0xAA, 0x55, 0x55, 0x55, 0xAA, 
	0xAA, 0xFD, 0x95, 0x81, 0xE5, 0xFF, 0xFF, 0x78, 0x89, 0x5F, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x57, 0xFD, 0x63, 0xFF, 0x7E, 0x82, 0xF5, 0x55, 0x57, 0x47, 0xE0, 0x26, 0x5E, 
	0x0A, 0x5D, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0x7A, 0xEA, 0xFF, 0xFF, 0xD8, 0x27, 0x55, 0x7A, 0xD5, 
	0xFF, 0xFF, 0xFF, 0x57, 0x87, 0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x74, 0x58, 0x80, 0x2B, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x8A, 0x70, 0x7F, 0x55, 0x55, 0xF8, 0x27, 0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 
	0x55, 0xAA, 0xFF, 0xFF, 0x7C, 0xA8, 0x7F, 0x68, 0x2F, 0xFF, 0xFF, 0xFF, 0xEB, 0x87, 0x85, 0x59, 
	0xF5, 0xAA, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x54, 0x75, 0x57, 0xF6, 0x02, 0x76, 0xFF, 0x7C, 0x75, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0x55, 0xFF, 0x57, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xF0, 0xE9, 0xFF, 0xFD, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE2, 0x5E, 0x1F, 0x95, 0x55, 0xD2, 0x17, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 
	0x55, 0xAA, 0xFF, 0xFF, 0x5C, 0x46, 0x2A, 0x29, 0xF5, 0xFF, 0xFF, 0xFF, 0x51, 0x1F, 0xE1, 0x82, 
	0xD5, 0x02, 0xC7, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0x3F, 0xFD, 0x80, 0x9F, 0xAA, 0xFF, 0x5E, 0x35, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x71, 0xE5, 0xFF, 0x7E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x56, 0xE1, 0xAA, 0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF4, 0x97, 0x8B, 0xD9, 0x5B, 0x4A, 0x27, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 
	0xFF, 0x6A, 0xFF, 0xFF, 0x5E, 0xE1, 0x41, 0x7F, 0x55, 0xFF, 0xFF, 0xFF, 0x7A, 0xA5, 0x4A, 0x1E, 
	0xB4, 0x98, 0x53, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x06, 0x80, 0x27, 0xF5, 0xAA, 0xFF, 0x57, 0x2D, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x54, 0xB9, 0xFF, 0xF0, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x5B, 0x4A, 0xAA, 0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFD, 0x65, 0xA0, 0x3D, 0xAE, 0x2A, 0x27, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 
	0x82, 0xF6, 0xFF, 0xFF, 0x57, 0xF0, 0xDB, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0x54, 0xA0, 0x16, 0xBE, 
	0xB4, 0x7F, 0x92, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xE2, 0x29, 0xD5, 0x55, 0xAA, 0xFF, 0x57, 0x8F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x35, 0xFF, 0x81, 0xD5, 0xFF, 0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x5F, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xCB, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x60, 0xA4, 0x2F, 0xFE, 0x16, 0x2B, 0xFF, 0xFF, 0x55, 0xFF, 0x5F, 0xF7, 0xF2, 
	0x20, 0x1F, 0xAA, 0xFF, 0xFF, 0xD8, 0x20, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xBF, 0xD7, 0xA8, 
	0x5D, 0x27, 0xA4, 0xF5, 0xAA, 0x55, 0x5F, 0x81, 0xF2, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 
	0x55, 0xFF, 0xFF, 0xFF, 0xAB, 0x2F, 0xFE, 0xAF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7D, 0x55, 0x55, 0xFF, 
	0x5E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF8, 0x29, 0x42, 0x74, 0x54, 0x27, 0xFF, 0xFF, 0x57, 0xDA, 0x2A, 0x7F, 0x85, 
	0xFF, 0x87, 0x6A, 0xFF, 0xFF, 0xF6, 0xA0, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0x5D, 0x15, 0x55, 0x61, 
	0x7F, 0x60, 0xBC, 0xB5, 0xAA, 0x57, 0xD0, 0x2F, 0x54, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x51, 
	0xD5, 0xFF, 0xFF, 0xFF, 0xA9, 0x8F, 0xFF, 0xF5, 0xFF, 0xFF, 0xFF, 0xFE, 0x07, 0xFF, 0xF5, 0xFF, 
	0x78, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5D, 0x42, 0x56, 0x22, 0xD2, 0xAF, 0xFF, 0xFF, 0x5E, 0x02, 0x00, 0x06, 0x95, 
	0xFF, 0xA1, 0xEA, 0xFF, 0xFF, 0x5F, 0xDA, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xAD, 0x5C, 0x1D, 
	0xE1, 0xD7, 0xDD, 0x3D, 0xAA, 0xFE, 0x02, 0xF7, 0x9E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 
	0xF5, 0xFF, 0xFF, 0xFF, 0xAA, 0x4B, 0xFF, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0xA5, 0x7F, 0xFF, 
	0xE2, 0xD5, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x57, 0xFE, 0x56, 0x0A, 0x87, 0x9D, 0xFF, 0xFF, 0x78, 0xAA, 0xAA, 0xA0, 0x55, 
	0xFF, 0xA8, 0x3A, 0xFF, 0xFF, 0x57, 0xDA, 0xC7, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xC7, 0x72, 0xC7, 
	0xAC, 0x95, 0x57, 0x2D, 0x9F, 0x60, 0x9F, 0x5E, 0x27, 0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 
	0xB5, 0xFF, 0xFF, 0xFF, 0xA9, 0x4B, 0xFF, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00, 0x0A, 0xBF, 
	0x47, 0xFF, 0xFF, 0xFF, 0xD2, 0xBF, 0xFF, 0xFC, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x62, 0x88, 0x0A, 0x3A, 0xFF, 0xAA, 0xD2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xB5, 0xFF, 0xFF, 0xFF, 0xD8, 0xE3, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x53, 0xC1, 
	0x1D, 0x15, 0x57, 0x4B, 0xD8, 0x0B, 0xD5, 0x58, 0xE2, 0x4B, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xA5, 
	0x1D, 0xFF, 0xAA, 0x55, 0x55, 0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xBF, 
	0x9D, 0xFF, 0xFF, 0xFF, 0x4B, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0xAA, 0x75, 0xD5, 0x60, 0x89, 0xA3, 0xA9, 0xEA, 0xFF, 0xAA, 0xE2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x35, 0xFF, 0xFF, 0xFF, 0xD8, 0xBA, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0x53, 0xC1, 
	0x2F, 0xED, 0x5F, 0x42, 0x2A, 0x7D, 0x55, 0x5B, 0xD2, 0xE1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 
	0x8D, 0xFF, 0xAA, 0x57, 0x60, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0xFF, 
	0xF5, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x80, 0x2A, 0x00, 0x00, 0x9C, 0x9B, 0x9F, 0xAA, 0xFF, 0xAB, 0x4A, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x35, 0xFF, 0xFF, 0xFF, 0xF6, 0x14, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0x5A, 0x4A, 
	0x81, 0x6D, 0xF6, 0x1E, 0x0F, 0x58, 0x2D, 0x53, 0xD2, 0x70, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 
	0xEB, 0xFF, 0xAA, 0xFE, 0x01, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 
	0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x8A, 0xAA, 0x97, 0xF8, 0xD3, 0x7D, 0xAA, 0xFF, 0xAB, 0x4A, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x35, 0xFF, 0xFF, 0xFF, 0xF6, 0x8D, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x16, 0x2A, 
	0xA0, 0x9F, 0x80, 0x7F, 0xCB, 0x67, 0xE1, 0x53, 0xD2, 0x54, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 
	0x51, 0xFF, 0xA7, 0x60, 0x9F, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0x55, 0xAA, 
	0xAA, 0xA9, 0xE0, 0x9F, 0x95, 0xD1, 0x8B, 0x35, 0xFF, 0xFF, 0xFF, 0x4A, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x54, 0xB5, 0xFF, 0xFF, 0xFF, 0x5E, 0x82, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x2D, 0xD9, 
	0x5F, 0xD8, 0x0B, 0xFF, 0xD3, 0xAF, 0xF8, 0xF2, 0xE9, 0x5E, 0x15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x78, 0x99, 0x68, 0x02, 0x0B, 0x8D, 0xFF, 0xFF, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAA, 0xFD, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x62, 0xFF, 0x55, 0xAA, 
	0xAA, 0xAA, 0x76, 0xAB, 0x6B, 0xC5, 0x85, 0xB5, 0xFF, 0xFF, 0xFF, 0xCA, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x58, 0xF5, 0xFF, 0xFF, 0xFF, 0x5F, 0x50, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x45, 0x55, 
	0x7D, 0x82, 0xF5, 0xFF, 0x7A, 0x47, 0xFE, 0x7C, 0x2D, 0x57, 0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x54, 0x00, 0x00, 0xA5, 0x5B, 0x8D, 0xFF, 0xFF, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAA, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFB, 0xFF, 0x58, 0xA7, 0xFD, 0xAA, 
	0xAA, 0xAA, 0x5F, 0xC1, 0xE7, 0x25, 0x2D, 0x75, 0xFF, 0xFF, 0xFF, 0xD2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x53, 0xD5, 0xFF, 0xFF, 0xFF, 0x57, 0xF6, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x57, 
	0xD8, 0x9D, 0x55, 0xFF, 0x5C, 0x92, 0x54, 0xDF, 0x55, 0x57, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x79, 0x62, 0xA5, 0x7F, 0xA9, 0x4D, 0xFF, 0xFC, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x7F, 0x4B, 0xFF, 0xFF, 0xFF, 0xFE, 0x3F, 0xE3, 0xFF, 0x5F, 0x60, 0x2B, 0xFF, 
	0xFF, 0x57, 0x58, 0xAF, 0xAC, 0xB8, 0xB7, 0xD5, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x47, 0x55, 0xFF, 0xFF, 0xFF, 0x55, 0xFD, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x52, 0xF8, 
	0x09, 0xD5, 0x55, 0xFF, 0x5F, 0x24, 0x02, 0xFE, 0x55, 0x55, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xE3, 0xFF, 0xFF, 0xFF, 0xA9, 0xC5, 0xFF, 0xFE, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFD, 0xFF, 0xFF, 0xFD, 0x2D, 0xFF, 0xFF, 0x55, 0xF6, 0xBF, 0xE3, 0xFF, 0xFF, 0xF8, 0x0A, 0x55, 
	0x55, 0x58, 0x02, 0x36, 0xF4, 0x82, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0x2A, 0xFF, 0xFF, 0xFF, 
	0x55, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAC, 0xA4, 0x75, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xA0, 
	0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0x47, 0xCD, 0x50, 0x9D, 0xA5, 0x5A, 0xD5, 0xFF, 0xAA, 0x55, 0x56, 
	0x09, 0x5F, 0xD6, 0xFF, 0xFF, 0x49, 0xFF, 0xFF, 0x6B, 0xFF, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xF5, 0xF5, 0x55, 0xA8, 0x35, 0xFF, 0xFF, 0x57, 0xE1, 0xFF, 0xE3, 0xFF, 0xFF, 0x5F, 0xA8, 0x00, 
	0x00, 0x0A, 0x9F, 0x6A, 0xF0, 0x25, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x4A, 0xFF, 0xFF, 0xFF, 
	0x54, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAC, 0x46, 0x35, 0xFF, 0xFF, 0xFF, 0x55, 0xD1, 0x56, 
	0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xAA, 0x4B, 0xCD, 0x98, 0x94, 0xB5, 0xFF, 0xAA, 0x57, 0x60, 
	0x27, 0x6A, 0xAA, 0xFF, 0xFF, 0xC9, 0xFF, 0xFF, 0xD0, 0x7F, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0x0A, 0xAA, 0x00, 0x90, 0xF5, 0xFF, 0xFF, 0x7F, 0x87, 0xFF, 0xEB, 0xFF, 0xFF, 0x56, 0xFD, 0x5A, 
	0xAA, 0x5F, 0xD5, 0xAA, 0xEA, 0xB7, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD0, 0xFF, 0xFF, 0xFF, 
	0x52, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA6, 0xC9, 0x2D, 0xFF, 0xFF, 0xFF, 0x5F, 0x8B, 0xFD, 
	0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0xEA, 0x4B, 0xAD, 0x61, 0x85, 0x1D, 0xFF, 0xAA, 0xF8, 0x09, 
	0x5F, 0xAA, 0xAA, 0xFF, 0xFF, 0xC9, 0xFF, 0xFF, 0x7E, 0xA5, 0xFF, 0x6A, 0xAA, 0xAA, 0xAA, 0xAA, 
	0x80, 0x00, 0xA9, 0xFB, 0xD5, 0xFF, 0xFF, 0xE8, 0x1F, 0xFF, 0xEB, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 
	0xFF, 0xFF, 0x55, 0xA3, 0x46, 0x17, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xFE, 0x2F, 0xFF, 0xFF, 
	0x4F, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xD1, 0x4F, 0xFF, 0xFF, 0xFF, 0xF8, 0x1D, 0xFF, 
	0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0x5A, 0x58, 0x35, 0x4F, 0xD1, 0x8D, 0xFF, 0x9D, 0x80, 0x7F, 
	0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0xE9, 0xFF, 0xFF, 0x5F, 0x42, 0x0B, 0x5F, 0xD5, 0xFF, 0xFF, 0x7F, 
	0xDA, 0xFF, 0x7F, 0x47, 0x55, 0x7F, 0xFD, 0x60, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5D, 0x1E, 0x2B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA7, 0x42, 0xAA, 0xAA, 
	0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0xA9, 0x55, 0x55, 0x5F, 0x82, 0x7A, 0xFF, 
	0xCB, 0x55, 0xFF, 0xFF, 0xFF, 0x5E, 0x35, 0xA9, 0xD5, 0xC7, 0xF8, 0x45, 0x55, 0x60, 0x0A, 0x2F, 
	0xAA, 0x55, 0xFF, 0x55, 0xFF, 0xE1, 0xFF, 0xFF, 0x5F, 0x60, 0x09, 0x69, 0xFF, 0xFF, 0xFF, 0x56, 
	0xAA, 0xFF, 0x5E, 0x1F, 0xFF, 0xF5, 0x68, 0x0B, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5C, 0xBE, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xF8, 0x2A, 0xA0, 
	0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0x22, 0xF5, 0x5F, 0xD8, 0x27, 0x6A, 0xFF, 
	0xE3, 0xD5, 0xFF, 0xFF, 0xFF, 0x5F, 0x25, 0x80, 0xF5, 0x52, 0xF8, 0xE1, 0xD6, 0x02, 0x97, 0xF5, 
	0xAA, 0x7F, 0x69, 0xD5, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xA1, 0x80, 0x0A, 0x95, 0x55, 0x55, 0x80, 
	0xAA, 0xFF, 0x50, 0x9A, 0xA8, 0x80, 0x0A, 0x7F, 0x55, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x78, 0xF4, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x5F, 0x42, 0x8B, 
	0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7D, 0xDA, 0x1F, 0xFE, 0x82, 0xF5, 0xAA, 0xFF, 
	0x72, 0xD5, 0xFF, 0xFF, 0xFF, 0x57, 0x8D, 0x2E, 0x35, 0x54, 0x02, 0x68, 0x00, 0x9F, 0x7F, 0x55, 
	0xA7, 0xDA, 0x00, 0xB5, 0xFF, 0xE1, 0x55, 0x55, 0x68, 0x27, 0xF6, 0xA8, 0x80, 0xAA, 0xAA, 0x0B, 
	0xAA, 0xFF, 0x58, 0x08, 0x00, 0xAA, 0x7F, 0xD5, 0x55, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xEB, 0xFF, 0xFE, 0xD2, 0xD3, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x57, 0xF4, 0x1F, 
	0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xD9, 0x8A, 0x80, 0x9F, 0x55, 0xAA, 0xFF, 
	0x54, 0xB5, 0xFF, 0xFF, 0xFF, 0x55, 0xCB, 0x1F, 0x25, 0x57, 0x89, 0xAF, 0xBF, 0xFF, 0xFF, 0x57, 
	0xF4, 0x80, 0xA8, 0x35, 0xFF, 0xD0, 0x2A, 0x28, 0x02, 0x7F, 0xFF, 0xFD, 0xD5, 0x55, 0x55, 0x7F, 
	0xFF, 0xFF, 0xA7, 0xFF, 0xD7, 0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xE8, 0x2F, 0x57, 0xE9, 0x09, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xBD, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x42, 0x0B, 0xFF, 0xFF, 0x55, 0x55, 
	0x5E, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xD3, 0x1F, 0xAD, 0x55, 0x58, 0x07, 0x41, 0x5A, 0x55, 0xFF, 
	0xF8, 0x15, 0xDC, 0xB5, 0xFF, 0xD2, 0x8A, 0x08, 0x2F, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAF, 0x57, 0x42, 0x25, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0xD5, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0xDB, 0xF5, 0xFF, 0xFF, 0x55, 0x55, 
	0x5F, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0x7A, 0x1F, 0x2D, 0x5F, 0x82, 0xAF, 0xFD, 0xAA, 0x5F, 0xD4, 
	0x09, 0x80, 0xB6, 0xBD, 0xFF, 0xD3, 0xFF, 0xFF, 0xF5, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x5E, 0x33, 0x5F, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0xBA, 0xD5, 0xFF, 0xFF, 0x5F, 0xFD, 
	0x57, 0x8D, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0x26, 0x35, 0xF4, 0x27, 0xBD, 0xAA, 0xA9, 0xF6, 0x80, 
	0x58, 0xA5, 0x1E, 0x1D, 0xFF, 0xF1, 0xD5, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xBF, 0xFF, 
	0xFF, 0xFF, 0x74, 0x79, 0x7F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x26, 0xB5, 0xFF, 0xFF, 0xF8, 0xAF, 
	0x57, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x20, 0xFF, 0x82, 0x7F, 0xF5, 0xAA, 0xBD, 0xA0, 0x2A, 
	0x89, 0xFF, 0xCD, 0x1D, 0xFF, 0xF2, 0xD5, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xAD, 0x55, 
	0xFF, 0xAA, 0xFA, 0x5A, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0x40, 0x35, 0xFF, 0x7F, 0xE2, 0x83, 
	0xD5, 0xEB, 0xAA, 0xFF, 0xFF, 0xFF, 0x5E, 0x15, 0xA0, 0x02, 0x2F, 0x55, 0x5F, 0xF6, 0x05, 0x58, 
	0x2F, 0xAB, 0xCE, 0x1D, 0xFF, 0x72, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xD5, 
	0xFF, 0xA8, 0xD1, 0x52, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xD8, 0x2D, 0xFF, 0xD7, 0x8F, 0xF8, 
	0xD5, 0xD1, 0x6A, 0xFF, 0xFF, 0xFF, 0x57, 0x00, 0x02, 0xA5, 0xF5, 0x55, 0xFD, 0x82, 0xF5, 0x91, 
	0xF5, 0xAB, 0xCD, 0x1D, 0xFF, 0x72, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0x58, 0xB5, 
	0xFF, 0xAB, 0xC9, 0x63, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xF8, 0xC9, 0xFD, 0x02, 0x15, 0x56, 
	0xB5, 0x7A, 0xEA, 0xFF, 0xFF, 0xFF, 0x5E, 0x1A, 0x95, 0x7F, 0x55, 0x5F, 0x60, 0x94, 0xA1, 0x63, 
	0x55, 0xAB, 0xCD, 0x2D, 0xFF, 0x72, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x2F, 
	0xFF, 0xA7, 0xA5, 0x47, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xF8, 0xE1, 0xFE, 0x96, 0x95, 0x56, 
	0xB5, 0x74, 0x5A, 0xFF, 0xFF, 0xFF, 0xD0, 0x7F, 0xFF, 0xFF, 0x55, 0x7E, 0x0A, 0x82, 0xFE, 0x63, 
	0x55, 0xAB, 0xCD, 0x2D, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8B, 
	0xFF, 0x5E, 0x16, 0x0A, 0x7A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0x7A, 0xFA, 0xEA, 0xEA, 0x78, 
	0xFF, 0x5C, 0xB5, 0xAA, 0x55, 0x56, 0x02, 0xBF, 0xF6, 0xFF, 0xFF, 0x78, 0x90, 0x2F, 0xFE, 0xA3, 
	0xFF, 0xAB, 0xED, 0x1D, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 
	0x7F, 0x74, 0x20, 0x2B, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x34, 0x79, 0xAA, 0xAA, 0x72, 
	0xFF, 0x5E, 0x35, 0xAA, 0x57, 0x40, 0x25, 0xF5, 0xAA, 0xFF, 0xFF, 0xF0, 0x4B, 0xF5, 0x56, 0xA3, 
	0xFF, 0xAB, 0xEF, 0x2D, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 
	0x29, 0xF2, 0x07, 0x9F, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x1E, 0x32, 0xEA, 0xAA, 0xE3, 
	0xFF, 0x57, 0x2D, 0xA9, 0xF4, 0x0B, 0x5F, 0x55, 0xAA, 0xFF, 0xFF, 0xD2, 0xAF, 0x55, 0x56, 0xAB, 
	0xFF, 0xAB, 0x8F, 0x2D, 0xFF, 0x78, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x0B, 0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0x57, 
	0x60, 0x62, 0xAF, 0x7F, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x47, 0x14, 0x2F, 0xFA, 0xC7, 
	0xFF, 0x57, 0x8F, 0x7C, 0x8A, 0xBF, 0xF5, 0x55, 0xAA, 0xFF, 0xFF, 0xD2, 0x1F, 0x55, 0x54, 0xAB, 
	0xFF, 0xAE, 0x17, 0x2D, 0xFF, 0x78, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0x57, 0x85, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5A, 0xD5, 0xFF, 0xFF, 
	0xDA, 0x85, 0x8B, 0xDA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0x60, 0xAF, 0x0A, 0xA9, 0xAD, 
	0xFF, 0x55, 0x82, 0x80, 0x02, 0x9D, 0xFF, 0xFD, 0xAA, 0xFF, 0xFF, 0xD2, 0x2D, 0xFF, 0x54, 0x6B, 
	0x55, 0xFC, 0x3B, 0x2D, 0xFF, 0xF8, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0x5D, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x54, 0xB5, 0xFF, 0xFF, 
	0x5F, 0xAD, 0x8B, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xDA, 0x07, 0xD8, 0xA0, 0x1D, 
	0xFF, 0x57, 0x8A, 0x0A, 0xA5, 0xD5, 0xF5, 0xA7, 0x6A, 0xFF, 0xFF, 0xD2, 0x1D, 0xFF, 0x54, 0x6B, 
	0xFD, 0x62, 0xEB, 0x2D, 0xFF, 0xF8, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0x35, 0xFF, 0xFF, 
	0x5E, 0x37, 0x07, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xFD, 0x4B, 0x5F, 0xFD, 0xB5, 
	0xFF, 0x7E, 0x1F, 0x55, 0x7D, 0x7F, 0x60, 0x02, 0xEA, 0xFF, 0xFF, 0xD2, 0x2D, 0xFF, 0x74, 0x51, 
	0x68, 0x25, 0xAB, 0x2D, 0xFF, 0xF4, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0xD5, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0x57, 0x2D, 0xFF, 0xFF, 
	0x74, 0x7E, 0x17, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xFD, 0x99, 0xD5, 0x57, 0xD5, 
	0xFF, 0xE0, 0x7F, 0xFF, 0xDF, 0xE0, 0x0A, 0xA8, 0x1A, 0xFF, 0xFF, 0xD2, 0x2D, 0xFF, 0x78, 0x58, 
	0x02, 0x55, 0xEB, 0x2D, 0xFF, 0xF4, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x4B, 0xFF, 0xFF, 0xAA, 0xF5, 0xFF, 0xFF, 0xFF, 0xCB, 0xFF, 0xAA, 
	0xFA, 0x60, 0x2B, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0xFF, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x5D, 0x64, 0xD5, 0x55, 0x55, 
	0x9A, 0x02, 0xB5, 0x57, 0xF5, 0x62, 0x55, 0x5E, 0xB5, 0xFF, 0xFF, 0xD2, 0x2D, 0x55, 0xFA, 0xEF, 
	0x56, 0x00, 0x77, 0x9F, 0xFF, 0xF8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0x2D, 0xFF, 0xFF, 0xAA, 0xDB, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xA8, 
	0xD0, 0x29, 0xAF, 0xAA, 0xAA, 0x55, 0x55, 0x57, 0xFF, 0xD5, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xFF, 0xFF, 0xD5, 0x55, 0x55, 0x55, 0xFD, 0xC6, 0xB5, 0x57, 0x7D, 
	0x00, 0x25, 0xD5, 0xFD, 0x60, 0x9F, 0xA2, 0xDC, 0xB5, 0xFF, 0xFF, 0xD2, 0x2D, 0x57, 0xE1, 0xA9, 
	0x60, 0xA5, 0x37, 0x9F, 0xFF, 0xF4, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0xB5, 0xFF, 0xFF, 0xAB, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 
	0xC4, 0x9F, 0x7D, 0xAA, 0xA5, 0xFF, 0xFF, 0xFD, 0x55, 0xBF, 0xDA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD1, 0xAF, 0xFD, 0x80, 
	0x09, 0x5F, 0x5F, 0xD8, 0x0A, 0xD4, 0x28, 0xBC, 0xB5, 0xFF, 0xFF, 0xD2, 0x1F, 0xF6, 0x05, 0xAA, 
	0x07, 0xFF, 0x25, 0x9F, 0xFF, 0xF4, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x42, 0xF5, 0xFF, 0xFF, 0xAF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 
	0xA6, 0x9F, 0xD5, 0x9F, 0xFE, 0xA0, 0xA0, 0xA8, 0xA0, 0x02, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x09, 0xF2, 0x02, 0xA0, 0x2B, 
	0xFF, 0xF7, 0xF8, 0x82, 0xAA, 0x8B, 0xFD, 0x3C, 0x35, 0xFF, 0xFF, 0xD2, 0x05, 0x80, 0x96, 0xAC, 
	0xBF, 0x57, 0x2D, 0x9F, 0xFF, 0xF4, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x55, 0x55, 0xFD, 0xAB, 0xFF, 0xFF, 0x55, 0x76, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 
	0x35, 0x27, 0x57, 0xFD, 0xF6, 0x88, 0xAA, 0x0A, 0x95, 0x60, 0x9F, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x62, 0x00, 0x26, 0x54, 0xAA, 0x26, 0x87, 0xE2, 0xA0, 0x0A, 0x2F, 
	0x75, 0xFD, 0xD0, 0x96, 0x98, 0x2F, 0xFF, 0xBC, 0xB5, 0xFF, 0xFF, 0xD2, 0xE0, 0x25, 0xA9, 0x5C, 
	0xBA, 0xAB, 0xAD, 0x1D, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x55, 0x5F, 0xD5, 0x0F, 0xFF, 0xFF, 0x55, 0xD8, 0x35, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 
	0x7D, 0x27, 0x76, 0xA0, 0x09, 0x7F, 0xFF, 0xFF, 0xFF, 0xDD, 0x27, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x0A, 0xAA, 0x49, 0x60, 0xAA, 0x81, 0x4B, 0xD3, 0xFD, 0x57, 0xFF, 
	0x5F, 0x58, 0x25, 0x81, 0x63, 0xF5, 0xFE, 0xBE, 0xB5, 0xFF, 0xFF, 0xDA, 0x7F, 0x50, 0x02, 0x5E, 
	0x3A, 0xAB, 0x8E, 0x1D, 0xFF, 0xF4, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x57, 0xDA, 0x68, 0x2D, 0xFF, 0xFF, 0x57, 0x6A, 0x1F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 
	0xFE, 0x27, 0xD0, 0x29, 0xD5, 0x7D, 0x57, 0x80, 0x00, 0x77, 0x05, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x1F, 0xFF, 0xD1, 0x4B, 0x7F, 0xF2, 0x8B, 0xD1, 0x5F, 0xFF, 0x55, 
	0x78, 0x02, 0xE2, 0x18, 0x6B, 0x55, 0xFE, 0xBE, 0xB5, 0xFF, 0xFF, 0xDA, 0x5E, 0x09, 0xF4, 0xDE, 
	0x3A, 0xAB, 0xCC, 0xBD, 0xFF, 0xF6, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF8, 0xA0, 0x28, 0x75, 0xFF, 0xFF, 0x7E, 0xA0, 0x8A, 0xBD, 0xFF, 0xFF, 0xFF, 0xAF, 0xE2, 
	0xD8, 0x9F, 0xE2, 0x80, 0x02, 0x87, 0x5C, 0x15, 0xAB, 0x2D, 0x89, 0xDA, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x1F, 0xFF, 0xD1, 0x4B, 0xFF, 0xF2, 0x8B, 0xD1, 0x55, 0x55, 0x55, 
	0xE0, 0xA8, 0x27, 0xFC, 0x6B, 0x55, 0xFE, 0xBC, 0xB5, 0xFF, 0xFF, 0xF8, 0x70, 0x7F, 0xF4, 0xDE, 
	0x3A, 0xAB, 0x8C, 0xBD, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x68, 0x00, 0x92, 0xCA, 0x55, 0xFF, 0x56, 0x88, 0x2A, 0xA5, 0xFF, 0xFF, 0x55, 0x59, 0xC2, 
	0x06, 0xBD, 0xD2, 0x0A, 0x2B, 0xD2, 0x76, 0xA5, 0xAF, 0x4A, 0x47, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x62, 0x2F, 0xFF, 0xD2, 0x8B, 0xFF, 0x52, 0x4B, 0xF9, 0xEA, 0xFF, 0xAB, 
	0xC1, 0x82, 0xBE, 0x5E, 0xAB, 0xFF, 0x55, 0x9C, 0xB5, 0xFF, 0xFF, 0x78, 0x61, 0xEA, 0xFE, 0xDE, 
	0xB5, 0x57, 0xAE, 0x35, 0xFF, 0x74, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x02, 0xA7, 0xCB, 0xAA, 0x55, 0xFD, 0x68, 0x2D, 0x80, 0x2A, 0x5F, 0xFF, 0xD5, 0x56, 0x75, 
	0x7D, 0xB5, 0xE2, 0x17, 0xFF, 0x7A, 0xD6, 0x2D, 0xAA, 0x4A, 0x4B, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x62, 0x2F, 0xFF, 0xD2, 0x8B, 0xFF, 0x72, 0x4B, 0xF9, 0xEA, 0xFF, 0xAB, 
	0xCA, 0x87, 0xEA, 0x5E, 0xAB, 0xFF, 0x55, 0x9C, 0xB5, 0xFF, 0xFF, 0x78, 0x63, 0xAA, 0xFC, 0xDE, 
	0xB5, 0x7E, 0x3E, 0x35, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA9, 0x97, 0xF6, 0x2D, 0xAA, 0xFF, 0xD6, 0x02, 0x7F, 0xD6, 0x00, 0x0A, 0x55, 0xFF, 0xFF, 0x8A, 
	0xA8, 0x35, 0xE2, 0x2F, 0xFF, 0x78, 0xDE, 0x15, 0xAA, 0xC2, 0x4B, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x62, 0x2F, 0xFF, 0xD2, 0x4B, 0xFF, 0x72, 0x4B, 0x71, 0xEA, 0xFF, 0xAB, 
	0xCA, 0x1D, 0xAA, 0x5E, 0xAB, 0xFF, 0x5E, 0x1C, 0x35, 0xFF, 0xFF, 0x78, 0x63, 0xAA, 0xFC, 0xDC, 
	0x3F, 0x60, 0x7C, 0x35, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x6A, 0xF5, 0xF5, 0xA8, 0x80, 0x1F, 0xF5, 0xFF, 0xFD, 0x58, 0x02, 0x0A, 0x20, 0x0F, 
	0x58, 0x35, 0xD2, 0x2F, 0xFF, 0x78, 0xDC, 0x15, 0xAA, 0xE2, 0xA3, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x2F, 0xFF, 0xD2, 0x4B, 0xFF, 0x52, 0x6B, 0x79, 0xEA, 0xFF, 0xAB, 
	0xCA, 0x15, 0xAA, 0x5E, 0xAB, 0xFF, 0x7C, 0xBC, 0x35, 0xFF, 0xFF, 0x78, 0x63, 0xAA, 0xFE, 0xD7, 
	0x28, 0x0A, 0xD4, 0xB5, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAB, 0x02, 0x00, 0x00, 0x00, 0x0A, 0x3D, 0xBF, 0xFF, 0xFF, 0xF6, 0xA0, 0xA0, 0xAA, 0x2F, 
	0xFC, 0x35, 0xE2, 0x25, 0xAA, 0x74, 0xDE, 0x95, 0x55, 0xE1, 0x5B, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x1F, 0x55, 0xF1, 0x4B, 0x55, 0xF2, 0x6B, 0x72, 0xEA, 0xFF, 0xAB, 
	0x48, 0xBF, 0xFF, 0x5E, 0xAB, 0x57, 0xF8, 0xDC, 0xB5, 0xFF, 0xFF, 0x78, 0x63, 0x55, 0xFE, 0x2B, 
	0x62, 0x95, 0x82, 0xEA, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAA, 0x45, 0xAA, 0xAA, 0xA5, 0x7F, 0xD2, 0xFF, 0xFF, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 
	0x5E, 0x1D, 0xD2, 0x25, 0xAA, 0x74, 0xDC, 0x95, 0x55, 0xD1, 0x5B, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x2F, 0xFF, 0xD1, 0x4B, 0xD5, 0xE1, 0x53, 0x72, 0xEA, 0xFF, 0xAB, 
	0x42, 0x3F, 0xFF, 0x5C, 0xA3, 0xFD, 0x81, 0x5E, 0xB5, 0xFF, 0xFF, 0x78, 0x63, 0x55, 0xFC, 0x6A, 
	0xFF, 0x58, 0x0B, 0x6A, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAA, 0x6F, 0xFF, 0xFF, 0xFF, 0xF5, 0xAA, 0xFF, 0xFF, 0xAA, 0x55, 0x55, 0x55, 0xFF, 0xD5, 
	0xA7, 0xAD, 0xD2, 0x25, 0xAA, 0x74, 0x5C, 0xB5, 0x5F, 0xE1, 0x53, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x85, 0xA8, 0x09, 0x62, 0x00, 0x0A, 0x53, 0x71, 0x6A, 0xFF, 0xA9, 
	0xE2, 0xBF, 0xFF, 0x56, 0x53, 0x68, 0x15, 0x5E, 0x35, 0xFF, 0xFF, 0x78, 0x63, 0x5F, 0xD2, 0xEA, 
	0x7D, 0x02, 0x9F, 0x2A, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xA9, 0xAF, 0x55, 0x55, 0xFF, 0x55, 0xAA, 0xFF, 0xFF, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0xA7, 0xAD, 0xD2, 0x0F, 0xFF, 0xF8, 0xDE, 0x25, 0xAA, 0x8A, 0x71, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x60, 0x02, 0x96, 0x54, 0xAA, 0x5A, 0x53, 0x72, 0xEA, 0xFF, 0xAA, 
	0xE2, 0xBF, 0xFF, 0x74, 0x58, 0x0A, 0xD2, 0xDE, 0x35, 0xFF, 0xFF, 0x78, 0x63, 0xF8, 0x09, 0xAF, 
	0x62, 0x9F, 0xD5, 0xAA, 0xFF, 0x74, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xA9, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAB, 0xAD, 0xD2, 0x8F, 0xFD, 0xA1, 0xEB, 0x8A, 0x0A, 0x1D, 0x79, 0xBD, 0xFF, 0xAA, 0x55, 0x55, 
	0x55, 0xAA, 0xFF, 0xFF, 0xD2, 0x5D, 0xAA, 0x56, 0x5F, 0xAA, 0x56, 0x7B, 0x72, 0xEA, 0xFF, 0xFF, 
	0xE2, 0x15, 0x55, 0xF8, 0xDF, 0x98, 0x08, 0x3C, 0xB5, 0xFF, 0xFF, 0x78, 0xFA, 0x62, 0xAA, 0xA0, 
	0x0A, 0xF6, 0xFF, 0xFF, 0xFF, 0xF8, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAB, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAB, 0x4D, 0x78, 0xE0, 0x80, 0x07, 0xAA, 0xF5, 0xFF, 0xF5, 0x79, 0x9D, 0xFF, 0xAA, 0x55, 0x55, 
	0x55, 0xAA, 0xFF, 0xFF, 0xD2, 0x60, 0x00, 0x09, 0x78, 0x00, 0x05, 0x7B, 0x72, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x15, 0x57, 0xE1, 0x57, 0x82, 0x9F, 0x9C, 0xB5, 0xFF, 0xFF, 0x78, 0xDE, 0x9F, 0xA0, 0x29, 
	0x7F, 0x6A, 0xFF, 0xFF, 0xFF, 0xF8, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAB, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA9, 0x4D, 0x78, 0x55, 0x55, 0xFD, 0xAA, 0xFD, 0x56, 0xB5, 0x79, 0x1D, 0xFF, 0xAA, 0x7F, 0xFF, 
	0xFF, 0xDA, 0xFF, 0xFF, 0xD2, 0x49, 0x55, 0x61, 0xE1, 0x95, 0xE1, 0x7B, 0x72, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x1D, 0xF6, 0x05, 0x5E, 0x27, 0xD5, 0x9C, 0xB5, 0xFF, 0xFF, 0x74, 0xD7, 0xFA, 0x09, 0x7F, 
	0xD5, 0xAA, 0xFF, 0xFF, 0xFF, 0xF4, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xA9, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA9, 0xC5, 0x78, 0x5D, 0xAA, 0xA7, 0xAB, 0x40, 0x02, 0x2D, 0x79, 0x1D, 0xFF, 0xA7, 0xE0, 0xA0, 
	0x02, 0x3F, 0xFF, 0xFF, 0xD2, 0xAF, 0xFF, 0xF2, 0xCB, 0xFF, 0xF2, 0x53, 0x72, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x2D, 0xA0, 0x96, 0x78, 0x75, 0x55, 0xAC, 0xB5, 0xFF, 0xFF, 0x5C, 0x28, 0x0B, 0x5F, 0xFF, 
	0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xF4, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x55, 0x1D, 0xFF, 0xFF, 0xAA, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0x55, 0x55, 0xFF, 0xFF, 
	0xAB, 0xC9, 0x78, 0x58, 0x00, 0x00, 0xDD, 0x2A, 0xAB, 0xCA, 0x73, 0x9D, 0x55, 0xFD, 0x80, 0x0A, 
	0xA0, 0x27, 0xF5, 0xAA, 0xD2, 0x87, 0xFF, 0x78, 0x4B, 0xFF, 0x72, 0x53, 0x72, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x6A, 0x80, 0x89, 0x72, 0xEA, 0xAB, 0x9C, 0x35, 0xFF, 0xFF, 0xAC, 0x82, 0x27, 0xF6, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x56, 0x3D, 0xFF, 0xFF, 0xAA, 0x5F, 0x5A, 0xAA, 0xAA, 0x57, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xAB, 0xC9, 0x78, 0x61, 0x9F, 0xFC, 0xBE, 0x17, 0xFF, 0xE2, 0x73, 0x9D, 0x5F, 0x60, 0x9F, 0xD5, 
	0xFF, 0x60, 0x9D, 0xAA, 0x78, 0x87, 0xFF, 0x78, 0x4B, 0xFF, 0x78, 0x53, 0x7A, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x76, 0x09, 0xFA, 0xFA, 0xEA, 0xAB, 0x9C, 0x35, 0xFF, 0xFF, 0xA1, 0xDF, 0xFD, 0xAA, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x5E, 0xB5, 0xFF, 0xFF, 0xA1, 0xF8, 0x00, 0x00, 0x00, 0x02, 0xA7, 0xFF, 0xE5, 0xFF, 0xFF, 
	0xAB, 0xC9, 0x74, 0xEB, 0x7F, 0xFE, 0x35, 0x2F, 0xFF, 0xE2, 0x5B, 0x1D, 0x7E, 0x09, 0xD5, 0x55, 
	0x55, 0x5D, 0x07, 0x6A, 0x78, 0x87, 0xFF, 0x78, 0x4B, 0xFF, 0x78, 0x53, 0x72, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x52, 0xBF, 0xF8, 0xFA, 0xEA, 0xAB, 0x9C, 0xB5, 0xFF, 0xFF, 0xAA, 0x75, 0x55, 0xAA, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x5C, 0xB5, 0xFF, 0xEF, 0xDF, 0x80, 0x28, 0x15, 0x62, 0xA8, 0x00, 0x2A, 0x3E, 0xFF, 0xFF, 
	0xAB, 0xC1, 0x74, 0x6B, 0xFF, 0xFD, 0x37, 0x2F, 0xFF, 0xE1, 0x5B, 0x1D, 0xE0, 0x9A, 0xD5, 0x7F, 
	0x55, 0x55, 0xA1, 0xDA, 0x78, 0x87, 0xFF, 0x7A, 0x43, 0xFF, 0x78, 0x63, 0x72, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x4F, 0xD5, 0xF4, 0xFA, 0xEA, 0xAB, 0x9C, 0xB5, 0xFF, 0xFF, 0xAA, 0x55, 0x55, 0xAA, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x35, 0xAA, 0xFD, 0xFE, 0xA7, 0x59, 0xFF, 0xF8, 0xFF, 0xA0, 0x16, 0x9F, 0x2A, 0xFF, 
	0xFF, 0xE1, 0x74, 0x63, 0xAA, 0xAA, 0x27, 0x2F, 0x55, 0xD1, 0x63, 0x97, 0xCB, 0x5F, 0xFF, 0xEA, 
	0xF5, 0xFF, 0x78, 0x7F, 0x78, 0x87, 0xFF, 0xF8, 0x6B, 0x55, 0xF8, 0x63, 0x72, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x8D, 0xFF, 0x78, 0xF2, 0xD5, 0x5D, 0x16, 0x3A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF4, 0xB5, 0xA8, 0xD8, 0x98, 0x75, 0x53, 0xE3, 0xD0, 0xFF, 0x8B, 0xD7, 0xE7, 0x6A, 0xFF, 
	0xFF, 0xE1, 0x5C, 0x93, 0xAA, 0xAB, 0xA7, 0x2F, 0x55, 0xD2, 0x63, 0x9D, 0x2D, 0x5E, 0x2A, 0x00, 
	0x35, 0xFF, 0x5E, 0x1F, 0x78, 0x87, 0xFF, 0xF2, 0x6B, 0xD5, 0xF8, 0x63, 0x72, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x85, 0xFF, 0x78, 0xF2, 0xD5, 0xF4, 0x96, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFA, 0xF5, 0xA9, 0xE0, 0x78, 0x55, 0x58, 0x55, 0x40, 0xFF, 0x87, 0x87, 0x4B, 0xCA, 0xFF, 
	0xFF, 0xE1, 0x5E, 0x93, 0xAA, 0xAB, 0x4D, 0x0F, 0xFF, 0xD1, 0x63, 0x9C, 0x35, 0x78, 0x58, 0x15, 
	0x2D, 0xFF, 0x57, 0x2F, 0x78, 0x4B, 0x55, 0xE1, 0x63, 0x55, 0xD2, 0x63, 0x72, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x85, 0xFF, 0x78, 0xF2, 0xFD, 0x82, 0xD1, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 
	0xFF, 0xF1, 0xE5, 0xAB, 0xA6, 0x50, 0xD5, 0x54, 0x28, 0xA8, 0xFF, 0xA1, 0x80, 0x02, 0xF2, 0xFF, 
	0xFF, 0xE1, 0x5E, 0x13, 0xEB, 0xFF, 0x0D, 0x85, 0xA0, 0x8A, 0x4B, 0xB4, 0x95, 0x72, 0x55, 0x55, 
	0x2D, 0xFF, 0x57, 0x87, 0x74, 0x60, 0x08, 0x0A, 0x58, 0x28, 0x09, 0x63, 0x72, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x85, 0xFF, 0x78, 0xF8, 0xA0, 0x26, 0x0B, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xFF, 0x51, 0xEA, 0x5F, 0xCD, 0x80, 0xD5, 0xF5, 0x55, 0xD4, 0xFF, 0x7A, 0x29, 0xE8, 0xBD, 0x55, 
	0xFF, 0xD1, 0x5C, 0x39, 0xFD, 0xD8, 0x15, 0xE0, 0x0A, 0x1D, 0x8B, 0x78, 0x6A, 0x70, 0xFF, 0x55, 
	0x15, 0xFF, 0xFF, 0x4B, 0xFC, 0x2A, 0xAA, 0x9A, 0xAA, 0xAA, 0xA8, 0x09, 0x72, 0x6A, 0xFF, 0xFF, 
	0xD2, 0x87, 0x55, 0xFA, 0xDE, 0x29, 0x80, 0x2F, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x54, 0xB5, 0x7D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x53, 0xEA, 0x57, 0xCA, 0xF4, 0xD5, 0xF5, 0xBF, 0xD8, 0xFF, 0x7B, 0x7D, 0xE9, 0x2F, 0xF5, 
	0xFF, 0xD1, 0x5E, 0xB6, 0x00, 0x01, 0xD5, 0x7D, 0x7F, 0xFF, 0x87, 0x78, 0xEA, 0x78, 0xFF, 0x56, 
	0x35, 0xFF, 0xFF, 0x43, 0xDE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x72, 0xEA, 0xFF, 0xFF, 
	0xDA, 0x8F, 0x5F, 0xE1, 0x57, 0x58, 0x29, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x54, 0xB5, 0xD7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x63, 0xE8, 0xFF, 0x45, 0xF8, 0xD5, 0xFD, 0xBF, 0xF4, 0xFF, 0x5B, 0x7D, 0xE1, 0x0B, 0xFF, 
	0xBF, 0xF2, 0xDE, 0x1F, 0xA9, 0xFF, 0xFF, 0xF7, 0xF5, 0x68, 0x27, 0x78, 0xEA, 0x5E, 0x3F, 0x58, 
	0xF5, 0xFF, 0xFF, 0x63, 0xD7, 0xDA, 0xA6, 0xAA, 0xA9, 0x55, 0x55, 0x57, 0xF2, 0xEA, 0xFF, 0xFF, 
	0xF2, 0x8F, 0xFA, 0x05, 0x7D, 0x09, 0x7F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0x37, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x63, 0x63, 0xE4, 0x09, 0xD8, 0xAA, 0xAA, 0x0A, 0x68, 0x20, 0x22, 0x08, 0x82, 0x02, 0x0B, 
	0xEF, 0xF2, 0xD7, 0x47, 0xAA, 0x6A, 0xA8, 0x00, 0x2A, 0x2A, 0x57, 0x78, 0x6A, 0x57, 0x8B, 0x53, 
	0xE5, 0xFF, 0xFF, 0x51, 0x75, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0xEA, 0xFF, 0xFF, 
	0xF8, 0x8F, 0x80, 0x55, 0x62, 0x7F, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x5E, 0x37, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x8B, 0x5F, 0x54, 0xA0, 0xAA, 0x2A, 0xA0, 0x0A, 0xAA, 0x00, 0x00, 0xAA, 0x02, 0x75, 0x61, 
	0xF5, 0x72, 0x69, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0xF9, 0xEA, 0xFF, 0xE0, 0x0B, 
	0xBF, 0xFF, 0xFF, 0x72, 0xB5, 0x7D, 0xFF, 0xFF, 0xFD, 0x7F, 0xFF, 0xF6, 0x7A, 0xEA, 0xFF, 0xFF, 
	0x78, 0xE2, 0x25, 0xA0, 0x09, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xAA, 0x55, 0x55, 0x55, 
	0xFF, 0xFF, 0xAA, 0xF5, 0x7C, 0x7A, 0xBE, 0xA3, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0x4B, 0x5E, 0x97, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0x5F, 0xFF, 0x55, 0xF8, 0x78, 
	0xBD, 0x72, 0x6A, 0xDA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA9, 0x77, 0xC1, 0xEA, 0xFF, 0x7E, 0x2D, 
	0xFF, 0xFF, 0xFF, 0x70, 0xB5, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x7A, 0xEA, 0xFF, 0xFF, 
	0x78, 0xF5, 0x56, 0x02, 0xBF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xAA, 0x55, 0x55, 0x7D, 
	0xFF, 0xFF, 0xA9, 0x9D, 0x78, 0x78, 0xB4, 0xD3, 0x5F, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0x6A, 0xAA, 
	0xFF, 0x4B, 0x5E, 0x63, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0x55, 0xAA, 0xE0, 0x1A, 
	0x3D, 0x70, 0xEA, 0xF5, 0x55, 0x55, 0x55, 0x55, 0x7F, 0xFF, 0x67, 0xA9, 0xEA, 0xFF, 0x57, 0xF5, 
	0xFF, 0xFF, 0xFF, 0x78, 0x3D, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x7A, 0xEA, 0xFF, 0xFF, 
	0x78, 0xDF, 0x80, 0x9F, 0xD5, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7A, 0x6A, 0x5B, 0xE5, 0xEB, 
	0xFF, 0xFF, 0xAB, 0x8B, 0x78, 0x74, 0xB4, 0xD1, 0xFA, 0xA0, 0x8B, 0xFF, 0xFF, 0xFF, 0x60, 0x00, 
	0xFF, 0x47, 0x5E, 0x43, 0x5F, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0x5F, 0x5F, 0xFF, 0xFF, 0xA0, 0x22, 
	0x3D, 0x78, 0xEA, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0x55, 0xAE, 0xA1, 0xEA, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0xFF, 0x78, 0x1D, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x72, 0xEA, 0xFF, 0xFF, 
	0x74, 0xA0, 0x1F, 0xF5, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0xEA, 0x5C, 0x35, 0xC3, 
	0xFF, 0xFF, 0xAA, 0xE1, 0xD8, 0x74, 0x3E, 0xB2, 0x00, 0x00, 0x8B, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 
	0xAA, 0x87, 0x5C, 0x7F, 0xFD, 0xF5, 0xFD, 0xFF, 0x95, 0x56, 0x7F, 0xFF, 0xFF, 0xFD, 0x61, 0x9B, 
	0xBD, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA4, 0x9B, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF8, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0xEA, 0xFF, 0xFF, 
	0x5E, 0x0A, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x55, 0x5C, 0x15, 0xC3, 
	0xF4, 0xB5, 0xAA, 0x70, 0xD9, 0x58, 0x18, 0x30, 0x2F, 0xFF, 0xF4, 0xFF, 0x55, 0x55, 0x55, 0xFF, 
	0xAA, 0x87, 0x5E, 0x95, 0xA2, 0xA0, 0x00, 0x08, 0x26, 0xD8, 0x00, 0x00, 0x2A, 0x80, 0xE2, 0x29, 
	0x7D, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0x5B, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF8, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0x6A, 0xFF, 0xFF, 
	0x57, 0xFF, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xD5, 0x57, 0x2D, 0x56, 
	0xF4, 0xB5, 0xAA, 0x78, 0x99, 0x65, 0x26, 0x97, 0xF5, 0xAA, 0xAA, 0xFA, 0xFF, 0xFF, 0xF5, 0xFF, 
	0xA9, 0x8F, 0x5E, 0x00, 0x09, 0xD8, 0x9A, 0x56, 0x3F, 0xF6, 0x9A, 0x9A, 0x7F, 0x6A, 0xE0, 0x08, 
	0xBD, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0x57, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF4, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0x6A, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE8, 0x55, 0x5E, 0x2F, 0xBC, 
	0xF8, 0x35, 0xAA, 0x7A, 0x8D, 0x0F, 0xBF, 0xDD, 0x55, 0xAA, 0xAA, 0xF8, 0x00, 0x02, 0xAA, 0xAA, 
	0xAB, 0x2F, 0x7C, 0x2A, 0x09, 0x58, 0xAA, 0x56, 0x3F, 0xF4, 0x1A, 0x9A, 0x7D, 0x68, 0x3D, 0x7D, 
	0x27, 0x78, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xC3, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFC, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0x6A, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE6, 0xB5, 0x5C, 0x2F, 0x1E, 
	0xDA, 0x35, 0x9F, 0xF2, 0x0F, 0x0F, 0xD5, 0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xAA, 0xAA, 0x80, 0x00, 
	0xAB, 0x2F, 0xFE, 0x3F, 0x07, 0xD8, 0xB5, 0x5C, 0x9F, 0xF6, 0xB5, 0xF9, 0xBE, 0xD8, 0xBD, 0x3F, 
	0x27, 0xF8, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x55, 0x55, 0x5C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0x6A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0x35, 0x76, 0xAD, 0x3A, 
	0xC6, 0x7F, 0xDA, 0x02, 0x0D, 0xDA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFE, 0xAA, 
	0xAB, 0x2F, 0xF6, 0x3F, 0x07, 0xD8, 0xB5, 0x5C, 0x9F, 0xF6, 0xB5, 0xF9, 0xBE, 0xD8, 0xBD, 0x2D, 
	0x27, 0xF4, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x6A, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x55, 0x55, 0x5C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0x6A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x41, 0x1D, 0x71, 0xAC, 0xB9, 
	0xA6, 0xDA, 0x80, 0xA7, 0xF9, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xA9, 0x1F, 0xF4, 0xBF, 0x87, 0xD8, 0xB5, 0x5E, 0x9F, 0xF6, 0xB5, 0xF9, 0xBE, 0xD9, 0x2F, 0x6E, 
	0x1F, 0xF4, 0x5A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x6A, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x57, 0xD5, 0x5E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x43, 0x2D, 0xCB, 0x14, 0xF8, 
	0x34, 0x0A, 0x7F, 0xF5, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xA8, 0x1F, 0xF4, 0xBF, 0x87, 0xD8, 0x35, 0x5E, 0x9F, 0xF6, 0xB5, 0xF9, 0xBE, 0xD1, 0x02, 0x76, 
	0x9F, 0xF4, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x6A, 0xFF, 0xFF, 0xFF, 
	0xFE, 0xF6, 0x2F, 0x5E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x63, 0x8F, 0x8F, 0x81, 0x78, 
	0xF4, 0x3F, 0x55, 0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x5E, 0x3D, 0xF4, 0xBF, 0x8B, 0xF8, 0xB5, 0x5E, 0x9F, 0xF8, 0xBF, 0x72, 0xBE, 0xD2, 0xFA, 0x21, 
	0x36, 0x74, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 
	0x57, 0xE8, 0x2B, 0xDC, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0x6A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0xF1, 0xEB, 0x2F, 0x87, 0x72, 
	0xEB, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x5E, 0x35, 0xF4, 0xFF, 0x8B, 0xF8, 0xB5, 0x5E, 0x9F, 0xF8, 0xBF, 0x72, 0xBE, 0xD2, 0xFF, 0xA3, 
	0xFA, 0x76, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 
	0x57, 0x87, 0xF4, 0xBC, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x6A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x76, 0xA2, 0x94, 0x51, 0x35, 0x2D, 0x59, 
	0x57, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0x5C, 0xB5, 0xF8, 0xFF, 0x8B, 0xF8, 0xB5, 0x5E, 0x9F, 0xF8, 0xBF, 0x72, 0xBE, 0xD2, 0xFF, 0xA3, 
	0xEA, 0x7E, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 
	0x5E, 0xBD, 0xA0, 0xBC, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x1D, 0x8A, 0xB8, 0xB6, 0xBD, 0x5D, 
	0x95, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x5E, 0xB5, 0xF8, 0xFF, 0x8B, 0xF8, 0xB5, 0x56, 0x9F, 0xF8, 0xBF, 0x52, 0xBE, 0xD2, 0xFF, 0xA1, 
	0xDA, 0x7E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 0xFF, 
	0x5E, 0x1C, 0x97, 0x5C, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x83, 0xD0, 0x14, 0x95, 0x75, 0x55, 
	0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 
	0x5A, 0x5A, 0x78, 0xFF, 0x8B, 0xF8, 0x95, 0xFE, 0x9F, 0xF8, 0x3F, 0x72, 0x7F, 0xE2, 0xFF, 0xA3, 
	0xDA, 0x7C, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xD5, 0xFF, 0xFF, 0xFF, 
	0x5C, 0x96, 0x3F, 0x5E, 0x9F, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x5F, 0xF8, 0x7E, 0x16, 0xBF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xF5, 0x55, 0x57, 0x57, 0x55, 0x55, 0xD5, 0xD5, 0xAA, 0xAA, 
	0x71, 0xEA, 0x78, 0xFF, 0x8B, 0xF8, 0xB5, 0xFE, 0x9F, 0xF8, 0x3F, 0x72, 0xBF, 0xE2, 0xFF, 0xA1, 
	0xDA, 0x5C, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xD5, 0xFF, 0xFF, 0xFF, 
	0x57, 0x88, 0xB5, 0x5E, 0x9F, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0x78, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xF5, 0x5D, 0x37, 0x97, 0xEF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x50, 0xAA, 0xAA, 0xAA, 0x96, 0xAA, 0xAA, 0xA6, 0x25, 0xAA, 0xAA, 
	0x73, 0xEA, 0x78, 0xFF, 0x8B, 0xF8, 0x35, 0xFE, 0x9F, 0xF8, 0x3F, 0x52, 0x9F, 0xD2, 0xFF, 0xA1, 
	0xDA, 0x5E, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xD5, 0xFF, 0xFF, 0xFF, 
	0x57, 0xE9, 0x55, 0x5E, 0x1F, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0x74, 0x5A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7D, 0xFF, 0x57, 0xD6, 0x2D, 0xD5, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x58, 0x80, 0x00, 0x00, 0x18, 0x00, 0x00, 0x26, 0x25, 0xAA, 0xAA, 
	0x73, 0xEA, 0x78, 0xFF, 0x87, 0xF8, 0xB5, 0xFE, 0x9F, 0xF8, 0xAF, 0x73, 0x9F, 0xE2, 0xFF, 0xA1, 
	0x7A, 0x5E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x95, 0xFF, 0xFF, 0xFF, 
	0x56, 0xFF, 0x55, 0x5E, 0x1F, 0xFF, 0xFF, 0xFF, 0xA7, 0xF5, 0xFF, 0xFF, 0x74, 0x1A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xAC, 0x2E, 0xA8, 0x95, 0x55, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xFF, 0xFF, 0xFF, 0xD7, 0xFF, 0xFF, 0xD5, 0xD7, 0xFF, 0xFE, 
	0xA3, 0xEA, 0xF8, 0xFF, 0x8B, 0xF8, 0xB5, 0xFE, 0x1F, 0xF8, 0xAF, 0x72, 0x9F, 0xE2, 0xFF, 0xFB, 
	0xB5, 0x5C, 0xB5, 0xFF, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xAA, 0x7E, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5E, 0x1F, 0xFF, 0xFF, 0x55, 0xFD, 0x2D, 0xFF, 0xFF, 0x54, 0xB5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0x5D, 0x49, 0x82, 0xAA, 0x2F, 0xD9, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0x80, 
	0xA3, 0x6A, 0xD2, 0xFF, 0x87, 0xF8, 0x35, 0xFE, 0x9F, 0xF8, 0x2F, 0x72, 0x9F, 0xE2, 0xFF, 0xFA, 
	0xB5, 0x5C, 0xB5, 0xFF, 0xAA, 0x7D, 0x55, 0xFF, 0xD5, 0xFF, 0xAA, 0xD8, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5E, 0x1F, 0xFF, 0xFF, 0x5F, 0x68, 0x09, 0xFF, 0xFF, 0x5C, 0xB5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0x5C, 0x9A, 0x4B, 0x87, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xAA, 
	0x43, 0x6A, 0xD2, 0xFF, 0x87, 0xF8, 0xB5, 0xFE, 0x9F, 0xF8, 0xBF, 0x72, 0x9F, 0xE2, 0xFF, 0xFA, 
	0xB5, 0x5E, 0x35, 0xFF, 0xA9, 0xF5, 0x5F, 0x6A, 0xF5, 0xFF, 0xA9, 0xC0, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5E, 0x9F, 0xFF, 0xFF, 0x7E, 0x20, 0xA7, 0xFF, 0xFF, 0x5E, 0x35, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0x7A, 0xCB, 0x5D, 0x7D, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xAA, 
	0xAA, 0xAA, 0xAB, 0x6A, 0xAA, 0xAA, 0xDA, 0xAA, 0xAA, 0xB6, 0xAA, 0xAA, 0x9E, 0xBF, 0xFF, 0xFF, 
	0x4B, 0xAA, 0xD2, 0xFF, 0x07, 0xF8, 0xB5, 0xFE, 0x9F, 0xF8, 0xAF, 0x72, 0x9F, 0xE2, 0xFF, 0xF8, 
	0x35, 0x5E, 0x1D, 0xFF, 0xAD, 0x83, 0xF8, 0x80, 0xBD, 0xFF, 0xAB, 0x48, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5C, 0x9F, 0xFF, 0xFF, 0x78, 0x62, 0x9F, 0xFF, 0xFF, 0x5E, 0x35, 0xFF, 0xFF, 
	0xFF, 0xFB, 0xD2, 0xDA, 0xFF, 0xFF, 0xF1, 0x4F, 0x75, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFE, 0x00, 
	0x00, 0x00, 0x8B, 0x4A, 0x00, 0xA0, 0xD2, 0x00, 0x00, 0xB8, 0x00, 0x00, 0x2C, 0xBF, 0x55, 0xFF, 
	0x8B, 0x55, 0xD2, 0xAA, 0x25, 0x58, 0xAA, 0xAA, 0x9F, 0xF8, 0xAA, 0xAA, 0x95, 0x62, 0xAA, 0xA8, 
	0xBF, 0xAC, 0x1F, 0xAA, 0xF6, 0x09, 0xD1, 0x82, 0x9D, 0xFF, 0xAB, 0x48, 0xB5, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5E, 0x9F, 0xFF, 0xAA, 0xE3, 0x89, 0x75, 0x55, 0xFF, 0x5E, 0xB5, 0xFF, 0xFF, 
	0x55, 0x5D, 0x2F, 0xDF, 0x55, 0x7D, 0x61, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFD, 0x7F, 0xFF, 0xFF, 0x5F, 0xFF, 0xFF, 0xD7, 0xFF, 0xFF, 0xD7, 0xFF, 0xFF, 0xFF, 
	0x87, 0x57, 0xD2, 0xAA, 0x25, 0x58, 0xAA, 0xA6, 0x1F, 0xFA, 0xA6, 0x98, 0x9F, 0x62, 0xAA, 0x94, 
	0xBF, 0xA5, 0x1F, 0xAA, 0xD2, 0x2F, 0x8E, 0x27, 0xD5, 0xFF, 0xA9, 0xEA, 0xB5, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5C, 0x9F, 0xFF, 0xA9, 0xC5, 0x2B, 0xDF, 0xD5, 0xFF, 0x5C, 0xB5, 0xFF, 0xFF, 
	0x7D, 0x74, 0x2E, 0x14, 0x3F, 0x60, 0xA7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 
	0xAA, 0xAA, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 
	0x87, 0x5F, 0xE0, 0x00, 0x0A, 0xA0, 0x00, 0x00, 0x25, 0xA0, 0x00, 0x00, 0x0A, 0x80, 0x00, 0x00, 
	0xA7, 0x67, 0x1F, 0xA9, 0xC6, 0x3E, 0xB8, 0x9F, 0x55, 0xFF, 0xAA, 0xE0, 0x35, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5E, 0x9F, 0xFF, 0xAB, 0x8E, 0x17, 0xF6, 0x75, 0xFF, 0x5E, 0x35, 0xFF, 0xFF, 
	0xEB, 0x70, 0x78, 0x98, 0xB8, 0x0A, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 
	0xAA, 0xAA, 0xD7, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 
	0x8F, 0x7E, 0x6A, 0x7F, 0xFF, 0xFF, 0xD5, 0xFF, 0x75, 0xFD, 0x7F, 0xFF, 0x7F, 0xF5, 0xF7, 0xFF, 
	0x01, 0xD7, 0xAF, 0xAB, 0xA4, 0x7A, 0xD1, 0x7F, 0x55, 0xFF, 0xAA, 0xD0, 0x35, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5E, 0x9F, 0xFF, 0xAB, 0xA4, 0x9F, 0x60, 0x2F, 0xFF, 0x5E, 0x35, 0xFF, 0xFF, 
	0xE3, 0xEA, 0x66, 0x2E, 0x02, 0x7D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 
	0xAA, 0xAA, 0xE0, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBF, 0xFF, 
	0x2F, 0x78, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xB6, 0xB7, 0xAD, 0x5D, 0x32, 0xE1, 0x4B, 0xEA, 0x55, 0x55, 0x5F, 0x58, 0xB5, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5E, 0x1F, 0x55, 0xFD, 0xB8, 0xBD, 0x09, 0x9D, 0x55, 0x5C, 0x35, 0xAA, 0xF5, 
	0xD1, 0xC6, 0x2C, 0x3E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF5, 0x5A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBF, 0xFF, 
	0x2D, 0x78, 0x4F, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAC, 
	0x26, 0x37, 0x8D, 0x5E, 0xB3, 0xC7, 0x87, 0xAA, 0x5F, 0x55, 0xFA, 0x7E, 0x35, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5C, 0x1F, 0x7F, 0xFD, 0xB0, 0x78, 0x17, 0xFF, 0xD5, 0x5C, 0x35, 0xA7, 0xA7, 
	0xE1, 0x6E, 0x1E, 0xB5, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x2D, 0x78, 0x8B, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAC, 
	0x1C, 0x37, 0x8D, 0xDC, 0x63, 0x25, 0x2F, 0xAA, 0xFF, 0xF7, 0x60, 0x7C, 0x35, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5E, 0x1F, 0x5A, 0x9D, 0xB2, 0xE2, 0x1F, 0x69, 0xB5, 0x5E, 0xB5, 0xAB, 0x82, 
	0xE6, 0x2D, 0x97, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x1F, 0x78, 0x47, 0x55, 0x56, 0xAA, 0x9A, 0x55, 0x55, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xF5, 0x5A, 
	0xA8, 0x37, 0x8D, 0xF8, 0xC5, 0x16, 0x1F, 0xA9, 0x62, 0x2E, 0x83, 0xD8, 0xB5, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5C, 0x9F, 0xE0, 0x0A, 0xB1, 0x44, 0xB6, 0x82, 0xB5, 0x5E, 0xBD, 0xAA, 0xFA, 
	0x8E, 0x35, 0xD5, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xAA, 0xAA, 0x02, 0x40, 0x00, 0x00, 0x50, 0x00, 0x01, 0xF0, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x1F, 0xF4, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0xF5, 0xFF, 0xFF, 0xFF, 0xF6, 
	0xA9, 0x9B, 0x6C, 0x3E, 0xCE, 0x7C, 0x1D, 0x57, 0x60, 0xAD, 0x67, 0x41, 0xB5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xAA, 0xAA, 0x5C, 0x9F, 0x58, 0x58, 0x79, 0x96, 0x61, 0x87, 0xD5, 0x5C, 0x3D, 0x55, 0x7A, 
	0x4B, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0xAA, 0xAA, 0xA8, 
	0xAA, 0xAA, 0x55, 0xD5, 0x55, 0x55, 0xEA, 0xAA, 0xAA, 0xFA, 0xAA, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x92, 0x9D, 0xAA, 0xA0, 0x02, 0xA8, 0xAA, 0xA2, 0x0A, 0x28, 0x00, 0x00, 0x0A, 0x80, 0x00, 0x08, 
	0x1F, 0x4B, 0x6E, 0x1D, 0xE6, 0xF4, 0xB5, 0x55, 0xF4, 0xA2, 0x66, 0x8F, 0xB5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xAA, 0xAA, 0x5E, 0x1F, 0x5D, 0x9C, 0xBA, 0xB6, 0x0E, 0x1F, 0x55, 0x5C, 0x1D, 0x7F, 0x62, 
	0xE7, 0xE5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xB0, 0x2F, 0x40, 0x0A, 0x0A, 0xA0, 0x00, 0x00, 0x09, 0x58, 0x2A, 0xAA, 0x9D, 0x5A, 0x6A, 0x56, 
	0x1F, 0x2B, 0x6D, 0xA9, 0x65, 0xF8, 0x7F, 0xFF, 0xFD, 0x70, 0xE1, 0x6F, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAA, 0xAA, 0x5C, 0x1F, 0xFF, 0xCD, 0x38, 0x74, 0x3E, 0xBF, 0xFF, 0xDE, 0x1F, 0xD8, 0x07, 
	0x75, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xBA, 0x07, 0x42, 0x0A, 0x89, 0x68, 0x20, 0x2A, 0x09, 0x58, 0xA2, 0xA8, 0x95, 0x58, 0x6A, 0x55, 
	0x1F, 0xAB, 0x4F, 0x61, 0xCB, 0x7A, 0xDA, 0x82, 0xA9, 0x1C, 0x53, 0x86, 0x2A, 0x0A, 0x02, 0x0A, 
	0xAA, 0x5F, 0x5D, 0xFC, 0x1F, 0xA8, 0xAF, 0x9C, 0xF4, 0x5C, 0x25, 0x02, 0x9E, 0xB6, 0x02, 0xFD, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 
	0xFF, 0x80, 0xAA, 0xAA, 0xAA, 0xAA, 0xA0, 0x02, 0xFE, 0xAA, 0xAA, 0xAA, 0xFE, 0xAA, 0xAA, 0xAB, 
	0x7A, 0x4B, 0x4A, 0x2A, 0x09, 0xA8, 0x09, 0x85, 0x25, 0x58, 0x8A, 0x18, 0x25, 0x60, 0xAA, 0xAA, 
	0x1F, 0x57, 0x4F, 0xA2, 0xC3, 0x70, 0x00, 0x02, 0xA8, 0x2E, 0x3F, 0x82, 0x8A, 0x2A, 0xA0, 0xA0, 
	0xA0, 0x00, 0x00, 0x00, 0x0A, 0xA8, 0x35, 0x4D, 0xBA, 0x5C, 0x0A, 0xAA, 0x00, 0x2A, 0x2F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0xAA, 0xAA, 0x04, 0xAA, 0xAA, 0x03, 
	0xFF, 0x80, 0xAA, 0xAA, 0xAA, 0xAA, 0x90, 0x02, 0xFC, 0xAA, 0x00, 0x00, 0x7C, 0xAA, 0xAA, 0x0B, 
	0xF4, 0x53, 0x8C, 0x18, 0x02, 0x80, 0x01, 0x4E, 0x25, 0x5A, 0x87, 0xA8, 0x25, 0xA0, 0x00, 0x00, 
	0x1F, 0xFF, 0x46, 0x32, 0xEB, 0x7A, 0x9F, 0xFF, 0xFF, 0xFB, 0x56, 0xFF, 0xFF, 0xFF, 0xFD, 0xF5, 
	0x55, 0x5A, 0xAA, 0xAA, 0x95, 0x5F, 0xD6, 0xDB, 0xEF, 0x5B, 0xFF, 0xFD, 0x5A, 0xAF, 0xD5, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x5F, 0x55, 0x55, 0x5F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0x58, 0x3C, 0xF2, 0xA9, 0xAA, 0xA8, 0xDC, 0x0A, 0x00, 0x03, 0xD8, 0x0A, 0xA8, 0xAA, 0xAA, 
	0x26, 0xAA, 0x88, 0x75, 0x55, 0x5F, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0xFF, 0x55, 0x55, 0x55, 0xFF, 0xF5, 0x55, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x02, 0x56, 0x77, 0xD7, 0xFF, 0x57, 0xFF, 0xFD, 0xFF, 0xFF, 0x57, 0xFD, 0xFF, 0xFF, 0x7D, 0xF7, 
	0x6A, 0x2A, 0x55, 0xDD, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0xFF, 0x55, 0x55, 0x55, 0xFF, 0x55, 0x55, 0x55, 0xFF, 0x55, 0x55, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0xAA, 0x55, 0x55, 0xAA, 0x55, 0x55, 0xAA, 
	0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xBF, 0xFD, 0xAA, 0xAA, 0xA9, 0xFF, 0xFF, 0xFF, 
	0x2F, 0x9B, 0xC9, 0x2D, 0xFF, 0xFF, 0xBF, 0x9B, 0xFF, 0xFF, 0xFE, 0xAF, 0xD5, 0xEF, 0xFB, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x0A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA0, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0xA9, 0xFF, 0xFF, 0xFE, 
	0xD5, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
};
