#include "../include.h"

// format: Attribute compressed 8x8/4 colors 8-bit paletted pixel graphics
// compression ratio: 31%
// required memory: 16640 B pixels, 4160 B attributes (20800 B total, unpacked 66560 B)
// image width: 320 pixels
// image height: 208 lines
// image pixels pitch: 80 bytes
// image attribute pitch: 160 bytes
const u16 ImgAttr7_Pal[256] __attribute__ ((aligned(4))) = {
	0xE861, 0xC041, 0x8821, 0x1041, 0x0020, 0x6412, 0x532E, 0x95D9, 0x0331, 0x028D, 0x9E3A, 0x465E, 0x2C75, 0x8556, 0x0497, 0x03F3, 
	0x09C8, 0x3EBF, 0x3DDB, 0x3538, 0x232F, 0x4EBF, 0x428A, 0x161E, 0x157A, 0x124A, 0x2BD1, 0x4EBE, 0x4EFF, 0x56FF, 0x3208, 0x3E3C, 
	0x4EBD, 0x3F1F, 0x0945, 0x4EFE, 0x575F, 0x2145, 0x08A2, 0x5FDF, 0x67FF, 0x5570, 0x12C7, 0x44EE, 0x0C4A, 0x164E, 0x1F30, 0x5611, 
	0x1B89, 0x442B, 0x0A44, 0x3CEB, 0x348A, 0x3389, 0x44AB, 0x4CEC, 0x55AD, 0x4D2C, 0x44EB, 0x4CAB, 0x19C4, 0x2B27, 0x2245, 0x1923, 
	0x55AB, 0x4469, 0x4CAA, 0x44E9, 0x44A9, 0x4D2A, 0x664D, 0x2AC5, 0x4CEA, 0x4408, 0x3BC8, 0x556A, 0x4CE9, 0x3366, 0x4CA9, 0x0861, 
	0x18E3, 0x4D29, 0x55AA, 0x7F0E, 0x65EB, 0x5DEA, 0x08A1, 0x5DAA, 0x65AB, 0x5D2A, 0x4D27, 0x764C, 0x5CEA, 0x652B, 0x4CC7, 0x6DEB, 
	0x4C48, 0x648B, 0x656A, 0x6DAB, 0x5CA9, 0x4466, 0x1141, 0x4BA7, 0x3303, 0xDF9A, 0x2A22, 0xD736, 0x42A4, 0xB5F2, 0x2985, 0xEFF7, 
	0xE7B6, 0xCEB5, 0xEFF6, 0x52A8, 0x844D, 0xAD71, 0x6329, 0x9CEF, 0x5B03, 0xEFB7, 0xC633, 0xE791, 0xEFB5, 0xEFB6, 0x3A06, 0xF7F8, 
	0xADE2, 0x6B83, 0xDF0F, 0x73AB, 0x9D22, 0x8423, 0xEF57, 0xDF15, 0xFFF2, 0xDED4, 0xFFD4, 0xFFFA, 0xCE4F, 0xB58E, 0x18A1, 0x49E1, 
	0xFE02, 0x6AA1, 0x5A21, 0xFE45, 0xEDE5, 0x6AA2, 0x2101, 0xCCA1, 0xF5A2, 0x8322, 0x7AE2, 0x9BA3, 0xEDA5, 0xD525, 0xA3A1, 0xE522, 
	0xBC22, 0xCCA2, 0xC462, 0x49A1, 0x9362, 0xED64, 0xFDE5, 0xA3C3, 0xCCC4, 0xF5A5, 0xE565, 0xBC64, 0xAC24, 0xD4A1, 0xB3E1, 0xFD82, 
	0xED22, 0xD4A2, 0x51E1, 0x72A1, 0x6A61, 0xED65, 0xCC21, 0xE4C2, 0x82C1, 0x9B61, 0xCC62, 0xCC63, 0xE4C4, 0xBC23, 0xED24, 0xFDA5, 
	0xF565, 0x9B01, 0x3920, 0x4161, 0xB360, 0xBB80, 0xCBC0, 0xDC40, 0xFCE1, 0xDC43, 0x6A21, 0xB3A2, 0x59A1, 0xAB62, 0x8261, 0xC361, 
	0x92A1, 0xB321, 0x30E0, 0x9260, 0x71E0, 0xAAC1, 0x8A61, 0x7A21, 0x8A20, 0x61A0, 0xB2C1, 0x4920, 0xBB21, 0xCB62, 0x28E1, 0xA260, 
	0x79E0, 0x9A61, 0x71E1, 0x9220, 0x81E0, 0x71A0, 0x5940, 0x38E0, 0x79E1, 0x28A0, 0x9A20, 0x89E0, 0x79A0, 0x9221, 0xA200, 0x91E0, 
	0x6140, 0x81A0, 0x91A0, 0x7140, 0x40C0, 0x30A0, 0x9160, 0x8940, 0x38A0, 0x58C0, 0x1840, 0x2040, 0x68A0, 0x3840, 0x4840, 0x5820, 
};

const u8 ImgAttr7_Attr[4160] __attribute__ ((aligned(4))) = {
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x3C, 0x12, 0x2B, 0x24, 0x00, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x16, 0x1C, 0x11, 0x27, 
	0xF5, 0x1C, 0x16, 0x27, 0xF5, 0x12, 0xE2, 0x24, 0xE9, 0xE4, 0xDB, 0x1F, 0xE9, 0xE0, 0xE6, 0xE3, 
	0x6E, 0x1C, 0xD7, 0x27, 0x00, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x12, 0x24, 0x1C, 0x27, 
	0x50, 0x2B, 0x35, 0x24, 0x3F, 0x1C, 0x1F, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x3E, 0x1C, 0x2B, 0x27, 
	0x3C, 0x43, 0x35, 0x38, 0x3C, 0x1C, 0x31, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x6E, 0x1C, 0x12, 0x27, 0xF8, 0x1C, 0x16, 0x27, 0xF5, 0x13, 0xE2, 0x24, 0xF5, 0xE0, 0xDB, 0x83, 
	0xE7, 0xE0, 0xE6, 0xEB, 0xE9, 0xE0, 0xF0, 0xE3, 0xFB, 0xE0, 0xE6, 0xEB, 0x00, 0x00, 0x00, 0xE0, 
	0xFB, 0xE0, 0xF3, 0x76, 0xE7, 0x1C, 0x05, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 
	0x26, 0x1C, 0x1A, 0x24, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 0x3E, 0x1C, 0x2B, 0x27, 
	0x4A, 0x3A, 0x36, 0x39, 0x66, 0x37, 0x3D, 0x24, 0x3F, 0x1B, 0x35, 0x27, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 0x3E, 0x38, 0x43, 0x1C, 
	0x41, 0x00, 0x44, 0x43, 0x3F, 0x43, 0x3D, 0x24, 0x3F, 0x1C, 0x1A, 0x27, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x1E, 0x1C, 0x0B, 0x24, 0xF8, 0x1C, 0x73, 0x27, 0xF5, 0x12, 0xE2, 0x24, 
	0xFB, 0xE0, 0xF4, 0x76, 0xE9, 0xE0, 0xF0, 0xEB, 0x00, 0x00, 0xFF, 0xE0, 0xF5, 0x74, 0xE0, 0x7F, 
	0xFD, 0x76, 0xE0, 0x7F, 0x00, 0x00, 0x00, 0xE0, 0xFA, 0xE0, 0xE6, 0xE3, 0xE9, 0xE0, 0xE6, 0xEB, 
	0xF5, 0xE0, 0xE6, 0xEB, 0xF9, 0xD8, 0xE0, 0x12, 0xDE, 0x1C, 0x76, 0x27, 0x2A, 0x1C, 0x29, 0x27, 
	0x22, 0x2B, 0x35, 0x23, 0x19, 0x1C, 0x12, 0x24, 0x3C, 0x1B, 0x14, 0x24, 0x3E, 0x3A, 0x35, 0x2F, 
	0x35, 0x3A, 0x36, 0x37, 0x3C, 0x3A, 0x49, 0x37, 0x3F, 0x29, 0x35, 0x24, 0x00, 0x00, 0x15, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x13, 0x00, 0x15, 0x1C, 0x3C, 0x20, 0x3A, 0x27, 0x00, 0x00, 0x6A, 0x43, 
	0x41, 0x00, 0x44, 0x43, 0x3D, 0x43, 0x4A, 0x45, 0x3F, 0x1F, 0x3D, 0x24, 0x3F, 0x1C, 0x1A, 0x27, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 0xF8, 0x1C, 0x16, 0x27, 
	0xF5, 0x1F, 0xCA, 0x24, 0xF5, 0xE8, 0xE6, 0x05, 0xE9, 0xE0, 0xE6, 0xE1, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xF4, 0xEB, 0xE7, 0x83, 0xE0, 0x7B, 0x3F, 0x89, 0x83, 0x7F, 
	0x6E, 0x71, 0x76, 0x7F, 0xF5, 0xE0, 0xE6, 0xD0, 0xE7, 0xE0, 0xE5, 0xEB, 0xFB, 0xE0, 0xE6, 0xE3, 
	0x00, 0x00, 0xE9, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xF8, 0x76, 0xE0, 0x20, 0x3F, 0x2B, 0x2A, 0x2F, 
	0x3C, 0x2B, 0x3D, 0x29, 0x26, 0x1B, 0x35, 0x27, 0x3E, 0x20, 0x2B, 0x27, 0x3C, 0x3A, 0x35, 0x39, 
	0x3C, 0x3A, 0x49, 0x39, 0x47, 0x3A, 0x49, 0x39, 0x3C, 0x3A, 0x35, 0x2F, 0x3F, 0x1C, 0x31, 0x27, 
	0x0C, 0x1C, 0x15, 0x24, 0x3E, 0x12, 0x35, 0x24, 0x3C, 0x44, 0x3D, 0x4B, 0x3C, 0x43, 0x4D, 0x4B, 
	0x3D, 0x43, 0x41, 0x45, 0x49, 0x00, 0x41, 0x43, 0x3E, 0x49, 0x3D, 0x45, 0x3F, 0x0C, 0x3D, 0x24, 
	0x12, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0xDE, 0x1C, 0x95, 0x27, 0xFA, 0xD9, 0xDB, 0xD0, 
	0xE7, 0xE3, 0xE5, 0xB1, 0xF5, 0xE0, 0xE6, 0xD5, 0xF8, 0xE4, 0xD9, 0xC4, 0xE9, 0xE0, 0xDB, 0xEB, 
	0xE7, 0x00, 0xEC, 0xE0, 0xF5, 0xE0, 0xE6, 0xEB, 0xF5, 0x82, 0xE0, 0x88, 0x73, 0x7B, 0x75, 0x7F, 
	0x7E, 0x86, 0x74, 0x8B, 0xF4, 0x84, 0xE0, 0x8B, 0xFD, 0x01, 0xFF, 0x01, 0xF5, 0xF2, 0xFC, 0xEE, 
	0xE9, 0xE0, 0xDB, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0xF5, 0xE0, 0xF0, 0xE3, 0xE7, 0x2B, 0xD7, 0x29, 
	0x3F, 0x2B, 0x31, 0x29, 0x3C, 0x31, 0x3D, 0x2B, 0x3C, 0x3A, 0x35, 0x39, 0x00, 0x00, 0x36, 0x3A, 
	0x4A, 0x00, 0x31, 0x3A, 0x3F, 0x3A, 0x31, 0x39, 0x3F, 0x36, 0x3D, 0x39, 0x3F, 0x35, 0x3D, 0x2B, 
	0x00, 0x00, 0x00, 0x1C, 0x3E, 0x1C, 0x2B, 0x27, 0x3C, 0x43, 0x4A, 0x4B, 0x3C, 0x43, 0x3D, 0x4B, 
	0x3C, 0x43, 0x4D, 0x4B, 0x3C, 0x43, 0x4A, 0x45, 0x3C, 0x43, 0x3D, 0x4B, 0x3E, 0x43, 0x4D, 0x39, 
	0x56, 0x1C, 0x35, 0x27, 0x00, 0x00, 0x15, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x00, 0x00, 0x00, 0x1C, 0x6E, 0x1C, 0x06, 0x27, 0xE7, 0xAC, 0xD7, 0xAA, 0xC2, 0x9D, 0xA4, 0xA5, 
	0xFA, 0xE0, 0xDB, 0xD8, 0xE7, 0xE4, 0xE5, 0xA0, 0xF5, 0xE4, 0xE6, 0xB1, 0xFA, 0xE5, 0xF4, 0xE4, 
	0xE9, 0xE0, 0xE6, 0xEB, 0xFB, 0xE0, 0xD2, 0xEB, 0xF8, 0xE0, 0xE6, 0xEE, 0xE7, 0x8C, 0x95, 0x88, 
	0x92, 0x84, 0x85, 0x80, 0xF5, 0x84, 0x91, 0x80, 0xE7, 0xE0, 0xE6, 0xEB, 0xE7, 0xE0, 0xE6, 0xEB, 
	0xE9, 0xE0, 0xDB, 0xE3, 0xF5, 0xE0, 0xE6, 0xE3, 0xF4, 0xCE, 0xE0, 0x9F, 0xE7, 0xD8, 0xD4, 0xB1, 
	0xDE, 0x2B, 0x95, 0x29, 0x3C, 0x2B, 0x3D, 0x29, 0x3C, 0x3A, 0x3D, 0x38, 0x35, 0x00, 0x36, 0x3A, 
	0x35, 0x00, 0x31, 0x3A, 0x3E, 0x3A, 0x47, 0x38, 0x3E, 0x3A, 0x4D, 0x39, 0x3D, 0x3B, 0x36, 0x3A, 
	0x14, 0x1C, 0x15, 0x27, 0x3E, 0x39, 0x43, 0x24, 0x00, 0x00, 0x00, 0x43, 0x4A, 0x00, 0x41, 0x43, 
	0x47, 0x00, 0x49, 0x43, 0x3D, 0x00, 0x41, 0x43, 0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x56, 0x43, 0x4D, 0x39, 0x3F, 0x15, 0x35, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 
	0x14, 0x1C, 0x15, 0x24, 0xE7, 0x8D, 0x95, 0x20, 0xC2, 0xA5, 0xA7, 0xA9, 0x00, 0x00, 0x9D, 0xA5, 
	0xD2, 0xA8, 0xB3, 0xA5, 0xFB, 0xE0, 0xF4, 0xD8, 0xE7, 0x00, 0xF0, 0xE0, 0x00, 0x00, 0x00, 0xE0, 
	0xE9, 0xE0, 0xDB, 0xEB, 0xFE, 0xF6, 0xF9, 0xEE, 0xFD, 0xF1, 0xDB, 0xEE, 0xF4, 0x99, 0xE0, 0x82, 
	0xE7, 0x84, 0x92, 0x80, 0xF5, 0x78, 0xE6, 0x84, 0xFA, 0xE6, 0xF5, 0xCA, 0xF4, 0xE5, 0xE6, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xF0, 0xEB, 0xF5, 0xE0, 0xE6, 0xEB, 0xD2, 0xE4, 0xE5, 0xB6, 
	0xDE, 0x9A, 0xE5, 0x9D, 0x3F, 0x3A, 0x3D, 0x38, 0x00, 0x00, 0x00, 0x3A, 0x31, 0x00, 0x36, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x3C, 0x3A, 0x35, 0x24, 0x3C, 0x43, 0x4A, 0x39, 0x00, 0x00, 0x00, 0x43, 0x47, 0x44, 0x4A, 0x43, 
	0x3C, 0x49, 0x3D, 0x45, 0x3C, 0x41, 0x4D, 0x43, 0x3C, 0x41, 0x4A, 0x43, 0x3F, 0x41, 0x47, 0x45, 
	0x26, 0x4A, 0x47, 0x29, 0x3F, 0x1C, 0x13, 0x27, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x15, 0x1C, 
	0xE7, 0x13, 0x95, 0x24, 0xDB, 0xA8, 0xA4, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xAC, 0x00, 0x9D, 0xA5, 0xD2, 0xAB, 0xCA, 0xA5, 0xFB, 0xE0, 0xE6, 0xE3, 0x00, 0x00, 0x00, 0xE0, 
	0x00, 0x00, 0x00, 0xE0, 0xFA, 0xE0, 0xE6, 0xEB, 0xE7, 0xE0, 0xF0, 0xEB, 0xE7, 0xE4, 0xE6, 0xE1, 
	0xE9, 0xE0, 0xDB, 0xD3, 0xDB, 0x00, 0xE6, 0xE0, 0xE7, 0xE5, 0xE6, 0xE0, 0xFB, 0xE0, 0xDB, 0xEB, 
	0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xE6, 0xE3, 0xF4, 0xD8, 0xE0, 0x9F, 
	0xF5, 0xE0, 0xE6, 0xE3, 0xDE, 0x78, 0xCA, 0x39, 0x3F, 0x36, 0x3D, 0x38, 0x3C, 0x3A, 0x3D, 0x37, 
	0x3E, 0x3A, 0x35, 0x39, 0x31, 0x00, 0x36, 0x3A, 0x3C, 0x3A, 0x35, 0x39, 0x3C, 0x3A, 0x4A, 0x39, 
	0x3C, 0x15, 0x0C, 0x27, 0x3C, 0x43, 0x4A, 0x45, 0x3E, 0x43, 0x4A, 0x45, 0x3C, 0x43, 0x3D, 0x4B, 
	0x00, 0x00, 0x4A, 0x43, 0x49, 0x00, 0x41, 0x43, 0x47, 0x43, 0x49, 0x4B, 0x47, 0x43, 0x49, 0x4B, 
	0x47, 0x43, 0x3D, 0x45, 0x3F, 0x37, 0x3D, 0x24, 0x26, 0x1C, 0x1A, 0x27, 0xDE, 0x1C, 0x76, 0x27, 
	0xE7, 0xAC, 0xB4, 0xAA, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x81, 0x00, 0xAA, 0xA5, 
	0xCA, 0xA5, 0x95, 0xA6, 0xA4, 0x00, 0xA8, 0xA5, 0xE9, 0xAC, 0xD4, 0xA5, 0xFB, 0xE0, 0xDB, 0xE3, 
	0xF5, 0xE0, 0xE6, 0xEB, 0xFB, 0xE0, 0xDB, 0xEB, 0xF5, 0xE0, 0xF0, 0xC1, 0xF4, 0xD8, 0xD9, 0xB7, 
	0xE7, 0xD8, 0xE0, 0xB1, 0xE9, 0xE0, 0xE6, 0xE3, 0x00, 0x00, 0x00, 0xE0, 0xE9, 0xE0, 0xE7, 0xEB, 
	0xFA, 0xE0, 0xDB, 0xE3, 0xF5, 0xE0, 0xE6, 0xEB, 0xE9, 0xE0, 0xE6, 0xEB, 0xE9, 0xE0, 0xE6, 0xE3, 
	0x00, 0x00, 0x00, 0xE0, 0xDE, 0x00, 0xFC, 0xE0, 0xDE, 0x3A, 0xB4, 0x38, 0x3E, 0x3A, 0x35, 0x39, 
	0x31, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x3E, 0x45, 0x43, 0x24, 0x00, 0x00, 0x00, 0x43, 0x4A, 0x00, 0x44, 0x43, 0x49, 0x00, 0x44, 0x43, 
	0x49, 0x00, 0x41, 0x43, 0x41, 0x00, 0x44, 0x43, 0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x00, 0x43, 
	0x4A, 0x43, 0x41, 0x45, 0x3C, 0x43, 0x47, 0x45, 0x3F, 0x4D, 0x3E, 0x39, 0xDE, 0x9B, 0xCA, 0x8D, 
	0x91, 0xA5, 0xAB, 0xA9, 0x02, 0xA5, 0xAC, 0x93, 0x02, 0x99, 0x00, 0xA6, 0xF4, 0x85, 0x00, 0xA6, 
	0xFC, 0x00, 0x01, 0xAB, 0xCA, 0xA5, 0xA7, 0xA6, 0x96, 0xAA, 0xAB, 0xA5, 0xD2, 0xD0, 0xD4, 0xAA, 
	0xF5, 0x00, 0xE5, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xF5, 0xE0, 0xF0, 0xE3, 0xF5, 0xE4, 0xE6, 0xAE, 
	0xF5, 0xE4, 0xE6, 0xA0, 0xE9, 0xE0, 0xDB, 0xEB, 0xF5, 0xE0, 0xDB, 0xE3, 0xE7, 0xE4, 0xE6, 0xD3, 
	0xD2, 0xEB, 0xE6, 0xA2, 0x00, 0x00, 0xF0, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0xF5, 0xE0, 0xE6, 0xE3, 
	0xF5, 0xE0, 0xD9, 0xEB, 0xF4, 0x00, 0xE5, 0xE0, 0xF5, 0x78, 0xE0, 0x5C, 0x31, 0x00, 0x3B, 0x3A, 
	0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x31, 0x3A, 0x35, 0x3A, 0x49, 0x37, 0x35, 0x00, 0x31, 0x3A, 
	0x3E, 0x44, 0x47, 0x43, 0x3C, 0x41, 0x3D, 0x43, 0x3E, 0x43, 0x41, 0x45, 0x3E, 0x00, 0x41, 0x43, 
	0x47, 0x44, 0x49, 0x43, 0x41, 0x00, 0x44, 0x43, 0x3D, 0x43, 0x49, 0x45, 0x3C, 0x43, 0x4A, 0x45, 
	0x3C, 0x43, 0x4D, 0x45, 0x3F, 0x43, 0x3D, 0x4B, 0xD2, 0x64, 0x92, 0x62, 0xA3, 0x9D, 0xA7, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0xFC, 0xA5, 0xEE, 0xA6, 0xFC, 0x81, 0x00, 0x94, 0x00, 0x00, 0x00, 0x00, 
	0xFC, 0xA8, 0x00, 0xA6, 0x00, 0xA5, 0x85, 0xA6, 0x00, 0x00, 0x00, 0xA5, 0xC2, 0xA5, 0xAC, 0xBF, 
	0xE9, 0xE0, 0xDB, 0xD0, 0x00, 0x00, 0x00, 0xE0, 0xE9, 0x00, 0xD9, 0xE0, 0xFB, 0xE0, 0xE6, 0xE3, 
	0xF5, 0xE0, 0xF4, 0xEB, 0xF8, 0x00, 0xEC, 0xE0, 0xF5, 0xE0, 0xE6, 0xD1, 0xF4, 0xD8, 0xE0, 0xB7, 
	0xE7, 0xE0, 0xF0, 0xD5, 0xE9, 0xE0, 0xDB, 0xE1, 0x00, 0x00, 0x00, 0xE0, 0xD2, 0xE0, 0xF0, 0xD0, 
	0xD2, 0xA0, 0xD8, 0xA1, 0xC3, 0xA0, 0xB8, 0xBA, 0x6C, 0xAB, 0x60, 0xB1, 0x36, 0x00, 0x3B, 0x3A, 
	0x3E, 0x3A, 0x35, 0x37, 0x31, 0x00, 0x36, 0x3A, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x3A, 
	0x00, 0x00, 0x00, 0x43, 0x3C, 0x43, 0x4D, 0x4B, 0x3E, 0x43, 0x47, 0x45, 0x3C, 0x43, 0x4D, 0x45, 
	0x00, 0x00, 0x4D, 0x43, 0x49, 0x00, 0x41, 0x43, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x41, 0x43, 
	0x49, 0x00, 0x41, 0x43, 0xDE, 0x43, 0xB4, 0x4B, 0xE7, 0xAC, 0xB8, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xFC, 0xA5, 0xAC, 0xA6, 0xFC, 0xA5, 0x01, 0xA6, 
	0xFD, 0xA5, 0xAB, 0x93, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0xD2, 0xA8, 0xB8, 0xA5, 0xE9, 0xE0, 0xDB, 0xE3, 0xE9, 0xE0, 0xDB, 0xEB, 0xDB, 0xE0, 0xE6, 0xEB, 
	0xD2, 0xE0, 0xE6, 0xEB, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0xE7, 0xE0, 0xE7, 0xEB, 0xD9, 0xA1, 
	0xE7, 0xE0, 0xE6, 0xE3, 0xD2, 0xC1, 0xD4, 0xB1, 0xE7, 0xA0, 0xD7, 0xBA, 0xD2, 0xA2, 0xB3, 0xB1, 
	0xE9, 0x31, 0x8F, 0xB1, 0xF5, 0xA2, 0xCC, 0xB7, 0x6A, 0xA2, 0x81, 0xA1, 0x3C, 0x37, 0x49, 0x5F, 
	0x3F, 0x37, 0x4D, 0x54, 0x3E, 0x5C, 0x4A, 0x58, 0x3C, 0x3B, 0x4A, 0x54, 0x3C, 0x3B, 0x4A, 0x58, 
	0x00, 0x00, 0x00, 0x43, 0x49, 0x00, 0x44, 0x43, 0x41, 0x00, 0x44, 0x43, 0x41, 0x00, 0x44, 0x43, 
	0x41, 0x00, 0x44, 0x43, 0x00, 0x00, 0x44, 0x43, 0x00, 0x00, 0x44, 0x43, 0x3D, 0x43, 0x4A, 0x45, 
	0x6E, 0x43, 0x4D, 0x4B, 0xD2, 0x9B, 0xCA, 0x9D, 0xA7, 0xA5, 0xA8, 0xA9, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x9D, 0xA5, 0xD2, 0x9B, 0xE0, 0xB5, 0xE7, 0x01, 0xFC, 0xF2, 0xFE, 0x01, 0xFC, 0x01, 
	0xE7, 0xE0, 0xF0, 0xEB, 0xE7, 0xE0, 0xF0, 0xEB, 0xE7, 0xE0, 0xF0, 0xD0, 0xF5, 0xA2, 0xD8, 0xAD, 
	0xDB, 0xA0, 0x99, 0xBA, 0xE7, 0xBA, 0xB9, 0xB1, 0xFB, 0x0F, 0xA3, 0xB1, 0x50, 0x7E, 0xE6, 0x0F, 
	0x19, 0x00, 0x0F, 0x0E, 0xF5, 0xB9, 0x8F, 0xB1, 0x78, 0xBA, 0x81, 0xB7, 0x00, 0x46, 0x58, 0x5B, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x49, 0x00, 0x44, 0x43, 0x00, 0x00, 0x4A, 0x43, 0x3D, 0x43, 0x49, 0x45, 0x4A, 0x00, 0x41, 0x43, 
	0x3D, 0x00, 0x41, 0x43, 0x00, 0x00, 0x00, 0x43, 0x4A, 0x00, 0x41, 0x43, 0x00, 0x00, 0x44, 0x43, 
	0xD2, 0x81, 0xE2, 0x5C, 0xCC, 0xA5, 0xA7, 0xA9, 0xAC, 0xA5, 0xA8, 0xA6, 0x92, 0xA5, 0x99, 0xA6, 
	0xB2, 0xA5, 0xAB, 0xA6, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xF5, 0xA5, 0xA4, 0x93, 0xF4, 0xA5, 0xCE, 0xA6, 
	0xDB, 0xA5, 0xB9, 0xA6, 0xD2, 0xA8, 0xCE, 0xA9, 0xFA, 0xE0, 0xF4, 0xD5, 0xF5, 0xE0, 0xF9, 0xD8, 
	0xE7, 0xD0, 0xE0, 0xBA, 0xF5, 0xA2, 0xCA, 0xB1, 0xF5, 0xA0, 0xCC, 0xB1, 0xE9, 0x35, 0xCC, 0xB1, 
	0xB9, 0xBA, 0xA0, 0x9F, 0xD2, 0xA0, 0xF0, 0xBA, 0xDE, 0x0F, 0x09, 0x0E, 0xE9, 0x8F, 0xDB, 0x0F, 
	0xE9, 0x7E, 0x6E, 0x0E, 0xF5, 0xB9, 0xE6, 0xB1, 0x6C, 0xBA, 0xC5, 0xAD, 0x4B, 0x00, 0x40, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x66, 0x43, 0x4D, 0x58, 0x3C, 0x4C, 0x4D, 0x46, 0x50, 0x43, 0x4A, 0x45, 0x66, 0x43, 0x4D, 0x63, 
	0x3C, 0x59, 0x4A, 0x7F, 0x3C, 0x43, 0x4A, 0x63, 0x56, 0x41, 0x47, 0x43, 0x96, 0x49, 0x47, 0x43, 
	0xDE, 0xAC, 0x95, 0xA9, 0xDE, 0x2B, 0x73, 0xA6, 0xDE, 0x1A, 0xE2, 0x18, 0xE7, 0x95, 0xCA, 0x18, 
	0xC2, 0x06, 0xCA, 0x18, 0xDB, 0xA8, 0x99, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xDE, 0x0C, 0x6C, 0x94, 0xC2, 0x0E, 0x16, 0x18, 
	0xDE, 0x0E, 0x7E, 0x18, 0xDE, 0xA4, 0xE2, 0x13, 0xA3, 0xBA, 0x9A, 0xA5, 0xA3, 0xBA, 0xA4, 0xB1, 
	0xE9, 0x31, 0xCC, 0xB1, 0xDE, 0x08, 0x6E, 0x0E, 0xF4, 0x0F, 0x6E, 0x0E, 0xDE, 0x08, 0xF0, 0x0F, 
	0xB3, 0xBA, 0xB9, 0x9F, 0xE7, 0xBA, 0xA3, 0xAD, 0xE9, 0x7E, 0xE6, 0x0F, 0xDE, 0x7E, 0xE6, 0x0F, 
	0x50, 0x0F, 0x09, 0x0E, 0xDE, 0xBA, 0xCC, 0xB1, 0x6C, 0xBA, 0xC5, 0xAD, 0x45, 0x00, 0x40, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x5F, 0x58, 0x5B, 0x3E, 0x86, 0x61, 0x8B, 0x3C, 0x79, 0x74, 0x7F, 0x73, 0x79, 0x7A, 0x7F, 
	0x00, 0x79, 0x70, 0x7F, 0x00, 0x79, 0x7A, 0x7F, 0x76, 0x79, 0x77, 0x7F, 0x73, 0x79, 0x74, 0x7F, 
	0xA4, 0x89, 0x9C, 0x79, 0xD2, 0x29, 0xB4, 0xA9, 0xF4, 0x0E, 0xB4, 0x18, 0xDE, 0x78, 0xE2, 0x18, 
	0xDE, 0x76, 0xCA, 0x18, 0xD2, 0xAB, 0xD7, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xCA, 0xA5, 0xAC, 0xA6, 
	0xB3, 0xA5, 0xAC, 0xA6, 0x00, 0x00, 0x00, 0xA5, 0xDE, 0x61, 0x95, 0x94, 0xDE, 0x14, 0xCA, 0x17, 
	0xDE, 0x73, 0x92, 0x18, 0xD2, 0xE8, 0x7E, 0x2B, 0xB4, 0xBA, 0x9E, 0xA5, 0x00, 0x00, 0x00, 0xBA, 
	0xDE, 0x08, 0xCC, 0xAB, 0xDE, 0x0F, 0x6E, 0x0E, 0xE9, 0xCC, 0xDB, 0x0F, 0xF5, 0xD9, 0xC3, 0x0F, 
	0xB2, 0xBA, 0xCA, 0xB1, 0xE9, 0xBA, 0xB3, 0xB7, 0x96, 0xCC, 0xDB, 0x0F, 0xF5, 0x35, 0xCC, 0xB1, 
	0xF5, 0xBA, 0xD9, 0xB7, 0xE9, 0xBA, 0xCA, 0xB7, 0x6C, 0xBA, 0xC4, 0xB1, 0x40, 0x54, 0x58, 0x46, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x67, 0x52, 0x64, 0x58, 0x83, 0x79, 0x89, 0x7F, 0x50, 0x6B, 0x83, 0x79, 0x04, 0x77, 0x3F, 0x7F, 
	0x4F, 0x8D, 0x6E, 0x79, 0x04, 0x77, 0x3F, 0x7F, 0x6E, 0x7A, 0x77, 0x79, 0x00, 0x00, 0x70, 0x79, 
	0x9B, 0x79, 0x9C, 0x7F, 0xDE, 0x61, 0x95, 0xA9, 0x22, 0x18, 0x0E, 0x17, 0xDE, 0x73, 0x92, 0x18, 
	0x6E, 0x0E, 0x73, 0x18, 0xDB, 0xA7, 0xD7, 0x9C, 0xE6, 0xCF, 0xD5, 0xA9, 0xF9, 0xD0, 0x01, 0xDC, 
	0xE6, 0xD1, 0xD7, 0xCF, 0xDB, 0xA8, 0xD1, 0xA9, 0x96, 0x0C, 0xD9, 0xA9, 0xF4, 0x0E, 0x7E, 0x18, 
	0xDE, 0x0E, 0x95, 0x18, 0xC2, 0x9A, 0x92, 0x18, 0xB4, 0xBA, 0xB9, 0xA5, 0x00, 0x00, 0x00, 0xBA, 
	0x96, 0x14, 0xF0, 0xB1, 0xF5, 0x0F, 0x19, 0x0E, 0x25, 0x0F, 0xCC, 0x0E, 0x8E, 0x92, 0xE6, 0x0F, 
	0xCA, 0xBA, 0xB9, 0xB7, 0x00, 0x00, 0xA2, 0xBA, 0xA3, 0xBA, 0x9A, 0xB1, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x6C, 0x00, 0xC6, 0xBA, 0x3A, 0x00, 0x40, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x62, 0x58, 0x64, 0x00, 0x62, 0x58, 0x64, 0x00, 0x62, 0x58, 
	0x67, 0x5B, 0x58, 0x79, 0x16, 0x79, 0x6D, 0x7F, 0xFA, 0x0D, 0x92, 0x07, 0x26, 0x0D, 0x1E, 0x07, 
	0xD2, 0x0D, 0x95, 0x07, 0x4F, 0x05, 0x50, 0x0A, 0x8E, 0x0D, 0xD9, 0x07, 0x50, 0x0D, 0x73, 0x7F, 
	0x9B, 0x79, 0x8C, 0x7F, 0xF5, 0xBE, 0xB3, 0xA6, 0xC3, 0x61, 0xCA, 0xBE, 0xDB, 0xAC, 0xD7, 0xB5, 
	0xDB, 0xAC, 0xD7, 0xC0, 0xC2, 0xAC, 0xB8, 0xA9, 0xFC, 0xD1, 0xCA, 0xCF, 0xF4, 0xD5, 0x00, 0xDD, 
	0xA3, 0xB9, 0xD5, 0xD1, 0xA3, 0xD1, 0xD7, 0xB6, 0xD2, 0xBE, 0x99, 0xA9, 0xC2, 0xA8, 0xD7, 0xA5, 
	0xDB, 0xA8, 0xCE, 0xA5, 0xE6, 0xA8, 0x9B, 0xA5, 0xB3, 0xBA, 0xB8, 0xA5, 0x00, 0x00, 0x00, 0xBA, 
	0xE9, 0x1A, 0xCC, 0xAD, 0xE9, 0x1A, 0xA3, 0xB1, 0xF5, 0xBA, 0xD9, 0xB7, 0xD2, 0xBA, 0xB3, 0xB7, 
	0x00, 0x00, 0xA2, 0xBA, 0xA3, 0x00, 0xAE, 0xBA, 0xA4, 0x00, 0xA2, 0xBA, 0xB4, 0xBA, 0xA0, 0xB7, 
	0x00, 0x00, 0x00, 0xBA, 0xC2, 0xBA, 0x9E, 0xB7, 0x96, 0xBA, 0x9A, 0xB7, 0x4D, 0x62, 0x4E, 0x5F, 
	0x67, 0x58, 0x60, 0x5F, 0x67, 0x58, 0x64, 0x5F, 0x00, 0x00, 0x00, 0x58, 0x64, 0x00, 0x5C, 0x58, 
	0x67, 0x75, 0x58, 0x7F, 0x26, 0x6D, 0x1E, 0x7F, 0x8E, 0xCA, 0xC2, 0x83, 0x04, 0x50, 0x26, 0x25, 
	0xD2, 0x8F, 0xDB, 0xD7, 0x04, 0x50, 0x8E, 0x1E, 0x4F, 0xB2, 0xE7, 0xB4, 0x56, 0x30, 0x3E, 0x2D, 
	0x95, 0x71, 0x77, 0x7F, 0xB0, 0xC0, 0xA5, 0x93, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0xE7, 0xA5, 0xCA, 0xA6, 0x00, 0xCF, 0xD1, 0xDD, 0x00, 0x00, 0x00, 0xD1, 
	0xD6, 0x00, 0xD5, 0xD1, 0xE6, 0xD1, 0xD0, 0xCF, 0xB4, 0xA5, 0xAB, 0xA9, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 0xB3, 0xBA, 0xA4, 0xA5, 0x00, 0x00, 0x00, 0xBA, 
	0xC2, 0xBA, 0xB3, 0xB7, 0x00, 0xBA, 0xA0, 0xB7, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x78, 0xBA, 0x81, 0x9D, 0x95, 0xBA, 0x9B, 0x9D, 0xC3, 0x85, 0x81, 0xA8, 
	0x8F, 0xAC, 0x81, 0xA8, 0x6C, 0xAC, 0x81, 0xAB, 0x6C, 0x62, 0x60, 0x5F, 0x3C, 0x58, 0x60, 0x5F, 
	0x67, 0x58, 0x5C, 0x5B, 0x64, 0x00, 0x62, 0x58, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x59, 0x5F, 
	0x4D, 0x79, 0x63, 0x7F, 0x04, 0x77, 0x50, 0x7F, 0x56, 0xCC, 0xDE, 0xD7, 0x56, 0x50, 0x26, 0x3F, 
	0xE9, 0xCA, 0xCC, 0xD7, 0x56, 0x50, 0x8E, 0x3F, 0x56, 0xCC, 0xDE, 0xD7, 0x04, 0x6E, 0x50, 0x76, 
	0x76, 0x79, 0x6D, 0x7F, 0xC1, 0xA5, 0xAD, 0xA6, 0x00, 0x00, 0x00, 0xA5, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0x00, 0x00, 0xA5, 0xCC, 0xA5, 0xAC, 0xA6, 0x00, 0x00, 0xD5, 0xD1, 0x00, 0x00, 0x00, 0xD1, 
	0xD2, 0xD0, 0xE2, 0xD1, 0xD2, 0xD1, 0xD4, 0xCF, 0xA3, 0xA5, 0xAB, 0xC0, 0x00, 0x00, 0x00, 0xA5, 
	0x00, 0xA9, 0xA5, 0xA6, 0x00, 0x00, 0x00, 0xA5, 0x9A, 0xB1, 0xBA, 0xA9, 0x00, 0x00, 0x00, 0xBA, 
	0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0xBA, 0x99, 0xBA, 0xC4, 0xB1, 
	0x92, 0xBA, 0xAE, 0xB1, 0x6C, 0x84, 0x81, 0x80, 0x8F, 0x58, 0x60, 0x5B, 0x3F, 0x58, 0x49, 0x5F, 
	0x00, 0x00, 0x62, 0x58, 0x00, 0x00, 0x00, 0x58, 0x5C, 0x00, 0x59, 0x58, 0x64, 0x58, 0x5C, 0x5F, 
	0x64, 0x62, 0x5C, 0x58, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x58, 0x5C, 0x5F, 
	0x67, 0x79, 0x63, 0x7F, 0x04, 0x83, 0x3F, 0x79, 0x8E, 0xCC, 0xE7, 0x73, 0x4F, 0x3F, 0x50, 0x16, 
	0xE9, 0xB2, 0xE6, 0xB4, 0x04, 0x50, 0x8E, 0x1E, 0x4F, 0xCA, 0xDE, 0x95, 0x4F, 0x25, 0x50, 0x16, 
	0x76, 0x79, 0x7A, 0x7F, 0x95, 0xA5, 0xA2, 0xA9, 0x92, 0xA5, 0x85, 0xA6, 0x6C, 0xAA, 0x85, 0x94, 
	0xAC, 0x00, 0xA8, 0xA5, 0xE9, 0xA5, 0xCA, 0xA6, 0xCE, 0x00, 0xD0, 0xD1, 0x00, 0x00, 0x00, 0xD1, 
	0x00, 0x00, 0x00, 0xD1, 0xCC, 0xD1, 0xD4, 0xDD, 0xB2, 0xA5, 0xAB, 0xC0, 0x4D, 0xA5, 0x85, 0x94, 
	0x8F, 0xA8, 0x9B, 0xA9, 0xA7, 0x00, 0xA8, 0xA5, 0x9A, 0x9F, 0xBA, 0xA6, 0x00, 0x00, 0x00, 0xBA, 
	0x6C, 0xBA, 0x9B, 0xB1, 0x8F, 0xBA, 0x81, 0x9F, 0x9A, 0xBA, 0x81, 0xA8, 0x8F, 0x62, 0x81, 0x84, 
	0x8F, 0x58, 0x49, 0x5B, 0x49, 0x58, 0x45, 0x5B, 0x00, 0x00, 0x00, 0x58, 0x5C, 0x00, 0x59, 0x58, 
	0x5C, 0x58, 0x59, 0x5F, 0x64, 0x62, 0x5C, 0x58, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x62, 0x5C, 0x58, 
	0x64, 0x62, 0x5C, 0x58, 0x64, 0x58, 0x5C, 0x5F, 0x64, 0x62, 0x5C, 0x58, 0x64, 0x00, 0x5C, 0x58, 
	0x47, 0x7A, 0x74, 0x7F, 0x56, 0x0D, 0x16, 0x07, 0x8E, 0x0D, 0xB2, 0x0A, 0x4F, 0x0D, 0x3F, 0x0A, 
	0xD2, 0x0D, 0xD4, 0x07, 0x4F, 0x0D, 0x1E, 0x0A, 0xD2, 0x0D, 0x73, 0x0A, 0x26, 0x0D, 0x1E, 0x0A, 
	0x3F, 0x71, 0x06, 0x7F, 0x8F, 0x9D, 0x81, 0xA6, 0x6C, 0x62, 0x81, 0x5B, 0x92, 0xA5, 0xA7, 0xA6, 
	0xC3, 0xAA, 0x81, 0xA6, 0x6E, 0xAC, 0x81, 0x94, 0xDB, 0xD1, 0xE5, 0xCF, 0xEE, 0x00, 0xDA, 0xD1, 
	0x00, 0x00, 0xDA, 0xD1, 0xE6, 0xD1, 0xD9, 0xDD, 0x8F, 0xA5, 0xBD, 0xA9, 0xC3, 0x62, 0x78, 0x9D, 
	0x6A, 0x85, 0x81, 0x8D, 0x8F, 0xA5, 0xBD, 0xA9, 0xCA, 0xB1, 0xA2, 0xA5, 0x92, 0xA2, 0x81, 0xA8, 
	0x8F, 0x62, 0x81, 0x63, 0xC2, 0x58, 0x60, 0x5B, 0x3E, 0x00, 0x45, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x62, 0x58, 0x64, 0x00, 0x62, 0x58, 0x00, 0x62, 0x64, 0x58, 0x64, 0x62, 0x59, 0x58, 
	0x64, 0x62, 0x59, 0x58, 0x64, 0x62, 0x59, 0x58, 0x64, 0x62, 0x59, 0x58, 0x64, 0x62, 0x59, 0x58, 
	0x64, 0x62, 0x59, 0x58, 0x64, 0x62, 0x59, 0x58, 0x59, 0x00, 0x62, 0x58, 0x00, 0x00, 0x62, 0x58, 
	0x47, 0x58, 0x5C, 0x87, 0x56, 0x59, 0x3D, 0x58, 0xE9, 0x58, 0x92, 0x46, 0x56, 0x59, 0x47, 0x58, 
	0xD2, 0x58, 0x95, 0x5B, 0x4F, 0x5C, 0x47, 0x58, 0xDE, 0x45, 0xCA, 0x58, 0x03, 0x62, 0x3F, 0x58, 
	0x67, 0x77, 0x58, 0x7F, 0x6A, 0x58, 0x67, 0x5B, 0x6E, 0x58, 0x4A, 0x5B, 0x67, 0x58, 0x41, 0x5B, 
	0x49, 0x58, 0x62, 0x5F, 0x4A, 0x58, 0x59, 0x5F, 0x4D, 0x58, 0x4A, 0x5B, 0x6C, 0x40, 0x67, 0x58, 
	0xB2, 0x40, 0x43, 0x58, 0xD9, 0x58, 0x49, 0x5B, 0x6C, 0x40, 0x60, 0x58, 0x34, 0x00, 0x62, 0x58, 
	0x67, 0x00, 0x62, 0x58, 0x3D, 0x58, 0x67, 0x46, 0x78, 0x58, 0x49, 0x5B, 0x34, 0x00, 0x38, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x64, 0x62, 0x5C, 0x58, 0x64, 0x62, 0x5D, 0x58, 0x61, 0x62, 0x5D, 0x58, 0x61, 0x62, 0x5D, 0x58, 
	0x61, 0x00, 0x5D, 0x58, 0x64, 0x00, 0x5D, 0x58, 0x64, 0x00, 0x5D, 0x58, 0x64, 0x62, 0x59, 0x58, 
	0x64, 0x00, 0x62, 0x58, 0x64, 0x00, 0x59, 0x58, 0x64, 0x00, 0x59, 0x58, 0x64, 0x00, 0x59, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
	0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x58, 
};

const u8 ImgAttr7[16640] __attribute__ ((aligned(4))) = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xE2, 0x80, 0x02, 0x1D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA9, 0x4B, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0x55, 0x55, 0xFF, 0xFD, 0xFA, 0x26, 0x2A, 0xAF, 0x0F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA9, 0x62, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0x55, 0x55, 0xFF, 0x58, 0x00, 0x80, 0xBF, 0xFD, 0x8B, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA9, 0x64, 0xBF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0x55, 0x7F, 0xDA, 0x02, 0x88, 0x09, 0xD5, 0x55, 0xA1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA9, 0x65, 0x2F, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x4B, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0x5F, 0xDA, 0x00, 0xA8, 0x25, 0x55, 0x55, 0x55, 0xA0, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAB, 0x65, 0x4B, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 
	0xF6, 0x80, 0x00, 0x00, 0x95, 0x55, 0x55, 0x55, 0xA8, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAB, 0xA5, 0x50, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xA2, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xFE, 
	0xA0, 0x28, 0x20, 0x0A, 0x55, 0x55, 0x55, 0x55, 0xAA, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA9, 0xA5, 0x58, 0x1D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0xA0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0x80, 
	0x02, 0x00, 0xAA, 0x8A, 0x55, 0x55, 0x55, 0x55, 0xAA, 0x0F, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA4, 0x95, 0x56, 0x0B, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xE3, 0x58, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0x00, 
	0x20, 0x0B, 0xD5, 0xCB, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0xCF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5E, 0x35, 0x5F, 0x41, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 0xC5, 0x78, 0x35, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xF7, 0xFD, 0xE0, 0x94, 
	0xBF, 0xFF, 0x55, 0xE1, 0xD5, 0x55, 0xFF, 0xFF, 0x55, 0x53, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x74, 0x35, 0x57, 0x50, 0xBF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 0xAD, 0x7A, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0x60, 0x0A, 0xA2, 
	0xD7, 0xD5, 0x55, 0x78, 0xD5, 0x55, 0xFF, 0xFF, 0x55, 0x78, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xE5, 0xA5, 0x5A, 0x0B, 0xFD, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5E, 0x35, 0x56, 0x0D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x7F, 0xD4, 0x00, 0xA0, 0x29, 
	0xD5, 0x55, 0x55, 0x5C, 0xB5, 0x55, 0xFF, 0xFF, 0x55, 0x5E, 0x3D, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 
	0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD2, 0xD5, 0x49, 0x56, 0xA0, 0x27, 0xFD, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5C, 0xB5, 0x5E, 0x8B, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x5F, 0xDA, 0x00, 0x88, 0xB5, 0x75, 
	0x55, 0x55, 0x55, 0x5E, 0x1D, 0x55, 0xFF, 0xFF, 0x55, 0x57, 0x2F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAD, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xC2, 0x95, 0x69, 0x55, 0xAA, 0x02, 0xAB, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xD5, 0x5D, 0x83, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5F, 0xF6, 0x80, 0x28, 0x0A, 0x1D, 0x55, 
	0x55, 0x55, 0x55, 0x57, 0x8D, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0x0B, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x8A, 0x55, 0x69, 0x55, 0xAA, 0xAA, 0x07, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD2, 0xD5, 0x57, 0xA2, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xF6, 0xA0, 0x00, 0x00, 0xAA, 0x85, 0x55, 
	0x55, 0x55, 0x55, 0x57, 0xCB, 0x55, 0xFF, 0xFF, 0x55, 0x57, 0x00, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x87, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x2A, 0x55, 0x55, 0x55, 0x6A, 0xA8, 0x1D, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE2, 0x55, 0x57, 0xA8, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0x08, 0x2A, 0xAA, 0xAA, 0xEB, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0xE3, 0xD5, 0xFF, 0xFF, 0x55, 0x78, 0x28, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8B, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 0x78, 0xAA, 0x55, 0x55, 0x55, 0x5A, 0x80, 0x75, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xFF, 0xFF, 0x68, 0x3F, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFE, 0x29, 0x60, 0xBF, 0xFF, 0xFF, 0xA2, 0xAA, 
	0xAA, 0xAA, 0xFF, 0xFF, 0x72, 0xD5, 0x55, 0x55, 0x5F, 0x42, 0x51, 0x8F, 0x55, 0x55, 0x55, 0x5E, 
	0xA3, 0xFF, 0x55, 0x55, 0x55, 0x57, 0xD1, 0xD5, 0x55, 0x55, 0x55, 0x78, 0x27, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x06, 0xFA, 0xFF, 0x6A, 0x2F, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xDF, 0xD6, 0x80, 0xAA, 0x02, 0xD5, 0xFF, 0xFF, 0xA0, 0xAA, 
	0xAA, 0xAA, 0xFF, 0xFF, 0x5C, 0xB5, 0x55, 0x57, 0xF8, 0x2F, 0xAA, 0x63, 0xD5, 0x55, 0x55, 0x5C, 
	0xB2, 0xFF, 0x55, 0x55, 0x55, 0x5F, 0x87, 0x55, 0x55, 0x55, 0x55, 0x7E, 0x2F, 0xFF, 0xBF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1A, 0xE3, 0xFF, 0x5A, 0x87, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xF5, 0x80, 0x51, 0x8A, 0xAF, 0x55, 0xFF, 0xFF, 0xA8, 0xAA, 
	0xAA, 0xAA, 0xFF, 0xFF, 0x5E, 0x35, 0x55, 0xFE, 0x80, 0x7D, 0xAA, 0x90, 0xB5, 0x55, 0x55, 0x78, 
	0x58, 0xFF, 0x55, 0x55, 0x55, 0xF4, 0xBF, 0x65, 0x55, 0x5F, 0x55, 0x57, 0x81, 0x75, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xAA, 0xC3, 0xFF, 0x5A, 0x83, 0xD5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x7F, 0x60, 0x2A, 0x8B, 0xCB, 0xF5, 0x55, 0xFF, 0xFF, 0xA8, 0x2A, 
	0xAA, 0xAA, 0xFF, 0xFF, 0x57, 0x2D, 0xFF, 0x60, 0x2F, 0xD5, 0xAA, 0xA4, 0x2D, 0x55, 0x55, 0x70, 
	0x54, 0x3F, 0x55, 0x55, 0x5F, 0x62, 0xFD, 0xA5, 0x55, 0x7A, 0xD5, 0x57, 0x60, 0x22, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x6A, 0xC3, 0xFF, 0x5A, 0xA0, 0xF5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0x5F, 0x58, 0x0A, 0x80, 0x2D, 0x51, 0xD5, 0x55, 0xFF, 0xFF, 0xA9, 0x00, 
	0x0A, 0xAA, 0xFF, 0xFF, 0x57, 0x89, 0x68, 0x0B, 0xF5, 0x55, 0xAA, 0xA9, 0x87, 0x55, 0x55, 0xE2, 
	0x55, 0x0F, 0x55, 0x55, 0xF6, 0x29, 0x60, 0xB5, 0x55, 0x70, 0xD5, 0x55, 0x5A, 0x8B, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xE1, 0xAA, 0xCB, 0xFF, 0x56, 0xA8, 0x3D, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5B, 0xF6, 0x00, 0x00, 0x00, 0x75, 0x78, 0xF5, 0x55, 0xFF, 0xFF, 0xA0, 0x25, 
	0xD2, 0xAA, 0xFF, 0xFF, 0x55, 0xE0, 0x22, 0x7D, 0x55, 0x55, 0xAA, 0xAA, 0x81, 0xD5, 0x57, 0x4A, 
	0x65, 0x43, 0xD5, 0x5D, 0x00, 0xA0, 0x00, 0xD5, 0x55, 0xE8, 0xBF, 0xFF, 0x56, 0x2F, 0xBF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xCA, 0xAA, 0x8F, 0xFF, 0x55, 0xAA, 0x2D, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x56, 0x7E, 0xA0, 0x28, 0x2A, 0xAA, 0x55, 0x5C, 0x35, 0x55, 0xFF, 0xFF, 0x81, 0xFF, 
	0xF4, 0xAA, 0xFF, 0xFF, 0x57, 0x4A, 0x2F, 0xD5, 0x55, 0x55, 0xAA, 0xAA, 0xA0, 0xF5, 0x5D, 0x0A, 
	0x55, 0x50, 0xBF, 0x55, 0xAA, 0x0A, 0xF2, 0xD5, 0x57, 0x8F, 0xA7, 0xFF, 0xA0, 0xBF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x06, 0xAA, 0xAF, 0xEB, 0x55, 0xAA, 0x8B, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x5F, 0xE0, 0x0A, 0xA0, 0xAA, 0xAA, 0x55, 0x55, 0x2D, 0x55, 0xFF, 0xFE, 0x1F, 0xFF, 
	0xFE, 0x2A, 0xFF, 0xFF, 0x76, 0x2F, 0x47, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xA8, 0xB5, 0x74, 0x2A, 
	0x55, 0x6A, 0x02, 0xD5, 0xFF, 0xFF, 0xE3, 0x55, 0x5E, 0x2F, 0xE0, 0x00, 0x02, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5C, 0xBF, 0xFF, 0xFF, 0xC3, 0x57, 0x80, 0xA1, 0xDF, 0x55, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xF7, 0xFF, 0x40, 0xA8, 0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0x4F, 0x55, 0xAA, 0xA0, 0x7F, 0x7F, 
	0xFD, 0x0A, 0x55, 0x57, 0x40, 0x75, 0xE1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x3F, 0xD1, 0xD5, 
	0x55, 0x52, 0x81, 0xD5, 0x55, 0x5F, 0x8D, 0x55, 0xF8, 0x35, 0xF8, 0x02, 0x76, 0x0F, 0x55, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xC3, 0x57, 0x40, 0xA0, 0xF7, 0x55, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFD, 0xD0, 0xA2, 0x82, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x55, 0xAA, 0xA1, 0xFF, 0xF5, 
	0x7F, 0x4A, 0x55, 0xF8, 0x0B, 0xD5, 0x78, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x0F, 0xA9, 0x95, 
	0x75, 0x70, 0x7F, 0x55, 0x55, 0x74, 0x3D, 0x7D, 0x82, 0xF5, 0x6F, 0xFF, 0xDE, 0x83, 0xD5, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE2, 0xFF, 0xFF, 0xFF, 0xC3, 0x55, 0xE0, 0xA8, 0x3D, 0x55, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xDF, 0xD8, 0x09, 0x4B, 0xE3, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xD5, 0xAA, 0xA0, 0xFF, 0xD0, 
	0x07, 0xE2, 0x7D, 0x80, 0xBD, 0x55, 0x5E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x45, 0x28, 0xB7, 
	0x47, 0xFC, 0x25, 0x55, 0x57, 0xE0, 0xFF, 0x60, 0x07, 0xD5, 0x55, 0x55, 0x55, 0xA0, 0x7D, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x8A, 0xFF, 0xFF, 0xFF, 0xEB, 0x55, 0xE0, 0xAA, 0x0F, 0x55, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xF5, 0x82, 0x66, 0x05, 0x78, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0x75, 0xAA, 0x85, 0xBF, 0x40, 
	0x03, 0xF8, 0x80, 0x27, 0xD5, 0x55, 0x57, 0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA3, 0xFE, 0x7D, 
	0x00, 0x2A, 0x03, 0xD5, 0x5E, 0x02, 0xA8, 0x0A, 0xFD, 0x55, 0x55, 0x55, 0x55, 0x68, 0x2F, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0x2A, 0xFF, 0xFF, 0xFF, 0xEB, 0x55, 0x78, 0xAA, 0x81, 0xD5, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x7F, 
	0x60, 0x2A, 0x60, 0x95, 0x5C, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xB5, 0xAA, 0x87, 0xBF, 0x42, 
	0x21, 0xFC, 0x2A, 0xF5, 0x55, 0x55, 0x55, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x90, 0xFA, 0xE8, 
	0xB6, 0xA8, 0x22, 0xD5, 0x5E, 0x00, 0x02, 0x9F, 0xD5, 0x55, 0x55, 0x55, 0x55, 0xDA, 0x82, 0xFD, 
	0xFF, 0xFF, 0xFF, 0xFE, 0xF0, 0xAA, 0xFF, 0xFF, 0xFF, 0xEB, 0x55, 0x7E, 0xAA, 0xA0, 0xBD, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xDA, 
	0x0A, 0x00, 0x09, 0xD6, 0x2D, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x2D, 0xAA, 0x87, 0xAF, 0xE2, 
	0xA2, 0xFD, 0x15, 0x55, 0x55, 0x57, 0x55, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA4, 0xD2, 0x09, 
	0xD7, 0xFD, 0xA8, 0xBD, 0x7C, 0x1A, 0x7F, 0xD5, 0x55, 0x79, 0x55, 0x55, 0x55, 0x5E, 0xA0, 0x27, 
	0xFF, 0xFF, 0xFF, 0xEF, 0x41, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5E, 0xAA, 0xA8, 0x2F, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7D, 0x80, 
	0xA8, 0x20, 0x9D, 0x54, 0xEB, 0x45, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x4F, 0xAA, 0x0F, 0xAF, 0xE0, 
	0xA8, 0x7F, 0xCD, 0x55, 0x55, 0x7D, 0x7D, 0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA8, 0xA9, 0x5D, 
	0x55, 0x55, 0xAA, 0x2F, 0x70, 0x6A, 0x55, 0x55, 0x55, 0x7A, 0xD5, 0x55, 0x55, 0x55, 0xAA, 0x0B, 
	0xFF, 0xFF, 0xFF, 0xBC, 0x06, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 0x6A, 0xAA, 0x81, 0xD5, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xE8, 0x0A, 
	0xA0, 0xAA, 0x55, 0x59, 0xF9, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xEB, 0xA9, 0x1F, 0x67, 0xF0, 
	0xA8, 0x7F, 0xE9, 0x55, 0x55, 0xD0, 0x2B, 0x5E, 0xBF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA9, 0x0F, 0x55, 
	0x55, 0x55, 0xAA, 0x81, 0xE2, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x78, 0x00, 0x2F, 
	0x55, 0x55, 0xF7, 0xF8, 0x77, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xEF, 0xD2, 0xAA, 0x90, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5F, 0x81, 0x6A, 
	0x02, 0x6A, 0x55, 0x53, 0xD1, 0x72, 0xD5, 0x55, 0xFF, 0xFF, 0x55, 0xF2, 0xA8, 0xBD, 0xCB, 0x74, 
	0x02, 0xD5, 0xD2, 0xAA, 0xFF, 0xC9, 0x62, 0xD7, 0x2D, 0x55, 0xFF, 0xFF, 0x55, 0x57, 0x2D, 0x55, 
	0x55, 0x55, 0xDA, 0xA0, 0x0F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x7E, 0x02, 0x8F, 
	0x55, 0x55, 0xFF, 0x49, 0xFE, 0xB5, 0x55, 0xD5, 0x55, 0x55, 0xFF, 0xEB, 0xF8, 0xAA, 0xA4, 0x27, 
	0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5E, 0x24, 0x22, 
	0x2A, 0x25, 0x55, 0x5B, 0xE1, 0x58, 0x75, 0x55, 0xFF, 0xFF, 0x55, 0x78, 0xA0, 0xF5, 0x63, 0xFE, 
	0x0B, 0xD5, 0xF0, 0xAA, 0xF7, 0xAD, 0x78, 0xD7, 0xCB, 0x55, 0xFF, 0xFF, 0x55, 0x57, 0x8F, 0x55, 
	0x55, 0x55, 0xFA, 0x98, 0x3D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x57, 0xD8, 0x02, 
	0x55, 0x5B, 0xD6, 0x25, 0x60, 0x75, 0x5D, 0x95, 0x55, 0x55, 0xFF, 0xE2, 0xFE, 0x2A, 0xAA, 0x80, 
	0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x74, 0xAE, 0x15, 
	0x62, 0x82, 0xD5, 0x53, 0xC5, 0x5C, 0x35, 0x55, 0xFF, 0xFF, 0x55, 0x5C, 0x09, 0xD5, 0x72, 0xDF, 
	0xFF, 0x55, 0xF0, 0xAA, 0x48, 0x15, 0x58, 0xD5, 0xE3, 0xD5, 0xFF, 0xFF, 0x55, 0x57, 0x01, 0xD5, 
	0x55, 0x55, 0xF6, 0x81, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xAF, 0xFF, 0xFF, 0xFC, 0x26, 
	0x55, 0x5C, 0x02, 0xA0, 0x22, 0xD5, 0xF6, 0x55, 0x55, 0x69, 0xFF, 0xFC, 0x7F, 0x8A, 0xA9, 0x80, 
	0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD2, 0x47, 0x8D, 
	0x47, 0xF4, 0xB5, 0x78, 0x25, 0x55, 0x2D, 0x55, 0xFF, 0xFF, 0x55, 0x7E, 0x07, 0x55, 0x78, 0xFF, 
	0x75, 0x57, 0xD0, 0xAA, 0x1D, 0x55, 0x78, 0xD5, 0x78, 0xD5, 0xFF, 0xFF, 0x55, 0x5E, 0x00, 0xB5, 
	0x55, 0x55, 0xFF, 0x07, 0x55, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x6A, 0xDF, 0xF5, 0x40, 0x59, 
	0x55, 0x5C, 0x08, 0x0A, 0xDB, 0x5F, 0x40, 0xD5, 0x55, 0xEB, 0xFF, 0xFE, 0x9F, 0xDA, 0xA8, 0x07, 
	0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xC2, 0x87, 0xCB, 
	0xA3, 0xFF, 0xA5, 0xDC, 0xB5, 0x57, 0x8F, 0x55, 0xFF, 0xFF, 0x57, 0xE0, 0xA1, 0xD5, 0x54, 0xBF, 
	0x55, 0x7E, 0xA4, 0xA8, 0xB5, 0x55, 0x72, 0xD5, 0x7C, 0xB5, 0xFF, 0xFF, 0x55, 0xF8, 0x2A, 0x1D, 
	0x65, 0x55, 0xFC, 0x3D, 0x5F, 0xE5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0x20, 0x00, 0x01, 0x96, 
	0x55, 0x5B, 0xF5, 0x7F, 0x4F, 0xF4, 0x28, 0xD5, 0x55, 0xCB, 0xFF, 0xFF, 0x62, 0x58, 0x00, 0x7F, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x8A, 0x95, 0x51, 
	0x58, 0xBF, 0x4E, 0x07, 0x55, 0x55, 0xEB, 0x55, 0xFF, 0xFF, 0xFE, 0x0B, 0xA0, 0x75, 0x5C, 0x3F, 
	0x5F, 0xE0, 0x54, 0x28, 0xB5, 0x55, 0xE3, 0x55, 0x5D, 0x1D, 0xFF, 0xFF, 0x5F, 0x81, 0xAA, 0x0F, 
	0x65, 0x5F, 0xE2, 0xFF, 0xFE, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x7C, 0x0A, 0xA6, 0xFE, 0xAA, 
	0x55, 0x55, 0xFF, 0xF6, 0xBE, 0x80, 0xBA, 0xD5, 0x57, 0x8B, 0xFF, 0xFF, 0xF0, 0x00, 0x28, 0xBF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x2A, 0xBA, 0xF8, 
	0x66, 0x0A, 0x18, 0x52, 0x55, 0xA5, 0xD1, 0xD5, 0xFF, 0xFF, 0xA0, 0xBD, 0xA8, 0x3D, 0x55, 0x2F, 
	0xF6, 0x0A, 0x55, 0x28, 0x1F, 0xFF, 0x4B, 0x55, 0x57, 0xAD, 0xFF, 0xFF, 0xF4, 0x2F, 0xAA, 0x89, 
	0x95, 0xDA, 0xAF, 0xFF, 0xA0, 0xB5, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xDF, 0x69, 0x6B, 0xFF, 0xA9, 
	0x55, 0x55, 0xFF, 0x40, 0x80, 0x27, 0xE3, 0x55, 0x5F, 0x0B, 0xFF, 0xFF, 0xFD, 0x02, 0xAA, 0x2F, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0x28, 0xBC, 0xBE, 
	0x1A, 0x62, 0xF2, 0xF8, 0x58, 0xA0, 0xF8, 0xD5, 0xFF, 0xE0, 0x27, 0xD5, 0xAA, 0x0F, 0x57, 0x82, 
	0x80, 0xAA, 0x55, 0x8A, 0x8A, 0xAA, 0x2D, 0x55, 0x57, 0x47, 0xFF, 0xFF, 0x80, 0xF5, 0x82, 0xA1, 
	0xDE, 0x00, 0x5A, 0xA0, 0x22, 0xD5, 0xFB, 0xFF, 0xFF, 0xA0, 0xFF, 0xFF, 0xF6, 0x0B, 0xFF, 0xE9, 
	0xFF, 0xFF, 0x57, 0x8A, 0x09, 0xF7, 0xCB, 0x55, 0xFE, 0x2A, 0x7F, 0xFF, 0xFF, 0x43, 0x4A, 0x8B, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xF8, 0xA0, 0x96, 0x00, 
	0x1D, 0x55, 0x58, 0xD2, 0x51, 0xFE, 0xBC, 0x7F, 0xFA, 0x0A, 0xFD, 0x55, 0x55, 0xCB, 0xD5, 0xD2, 
	0x2F, 0x55, 0x57, 0x8A, 0xDA, 0x28, 0xB5, 0x55, 0x55, 0xEB, 0x57, 0xD8, 0x09, 0xAA, 0x88, 0x90, 
	0xD5, 0xAA, 0x02, 0x2A, 0xEB, 0x57, 0xEB, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0xBD, 0xFF, 0xD0, 
	0xFF, 0xFF, 0x55, 0xFF, 0x2D, 0x5F, 0x2D, 0x5F, 0xD0, 0x00, 0x2A, 0x55, 0xAA, 0xAB, 0xE2, 0xA1, 
	0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xD2, 0x82, 0xBD, 0xA8, 
	0x05, 0x55, 0x56, 0x09, 0x52, 0xFF, 0x6C, 0x15, 0x82, 0x9F, 0x55, 0x55, 0x55, 0x72, 0xF5, 0xD9, 
	0xD5, 0x55, 0x55, 0xE2, 0xFF, 0xFF, 0xD5, 0x55, 0x55, 0xE2, 0x56, 0x02, 0x9A, 0xAA, 0x3E, 0x14, 
	0xB5, 0xFF, 0x5F, 0xFF, 0x8D, 0x7D, 0x2F, 0xFF, 0xFF, 0xFF, 0x88, 0x0A, 0xAB, 0xF5, 0xFF, 0xF4, 
	0xFF, 0xFF, 0x55, 0x5E, 0x35, 0x74, 0x3F, 0xFE, 0x01, 0xDA, 0x00, 0x00, 0x02, 0x7D, 0xF8, 0x28, 
	0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 0x4A, 0x09, 0x7F, 0xF4, 
	0x6B, 0x55, 0x56, 0x95, 0x54, 0x27, 0x94, 0x08, 0x1F, 0xF5, 0x55, 0x55, 0x55, 0x5C, 0xB5, 0x7A, 
	0xD5, 0x55, 0x55, 0xE0, 0x7D, 0x55, 0x55, 0x55, 0x57, 0x48, 0x82, 0x9F, 0x9A, 0xA8, 0x3D, 0x1A, 
	0x1D, 0x55, 0x55, 0x74, 0xBD, 0xD8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 0xFE, 
	0xFF, 0xFF, 0x55, 0x7C, 0xB5, 0x62, 0xF5, 0xA0, 0x2F, 0x5F, 0xF6, 0xA9, 0xFF, 0x55, 0x5D, 0x0A, 
	0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5F, 0x00, 0x17, 0xFF, 0xF4, 
	0xB2, 0xD5, 0x50, 0x25, 0x55, 0x80, 0xA2, 0xFD, 0x1D, 0x55, 0x55, 0x55, 0x55, 0x57, 0x2D, 0x7A, 
	0xD5, 0x55, 0x55, 0x78, 0xA7, 0xD5, 0x55, 0x55, 0x5D, 0x2F, 0x63, 0xD7, 0x00, 0xA8, 0xBD, 0x19, 
	0x0D, 0x55, 0x55, 0xE1, 0xF6, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x78, 0xD7, 0x82, 0xA0, 0x09, 0xF5, 0x55, 0x5F, 0xFF, 0x55, 0x55, 0x57, 0x62, 
	0x8B, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5C, 0x21, 0x5F, 0xFF, 0xF4, 
	0xB8, 0xD5, 0x63, 0xC5, 0x55, 0x56, 0xA7, 0xFF, 0x8F, 0x55, 0x55, 0x57, 0xFD, 0x55, 0x07, 0x74, 
	0xD5, 0x55, 0x55, 0x78, 0x89, 0xF5, 0x55, 0x5F, 0xD8, 0xB5, 0x70, 0xDE, 0x14, 0x2A, 0x3D, 0x1A, 
	0x8B, 0x55, 0x56, 0x0A, 0x00, 0x2F, 0xEF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0xD2, 0x55, 0x60, 0xA9, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xF8, 
	0xA2, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xA2, 0xFF, 0xFF, 0xF6, 
	0xBC, 0xB5, 0x4F, 0xC5, 0x55, 0x80, 0x7F, 0xFF, 0xC3, 0x55, 0x55, 0x5F, 0x81, 0x55, 0x81, 0xF6, 
	0x55, 0x55, 0x55, 0x74, 0x20, 0x9F, 0x57, 0xF6, 0x89, 0xD5, 0x54, 0x7C, 0x7F, 0x49, 0x2C, 0xAA, 
	0xA1, 0xD5, 0x5E, 0x02, 0x29, 0xF5, 0xFF, 0xFE, 0xBF, 0xFF, 0x57, 0x55, 0x55, 0x55, 0xEF, 0xFF, 
	0xFF, 0xFF, 0x55, 0xC2, 0x55, 0x7F, 0xFD, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x7D, 
	0x28, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE2, 0x81, 0xFF, 0xFF, 0xF6, 
	0xAF, 0x2D, 0x8F, 0x85, 0x58, 0x25, 0xFF, 0xFF, 0xF2, 0xD5, 0x57, 0xFE, 0x28, 0x55, 0xA0, 0xF6, 
	0x55, 0x55, 0x55, 0x5E, 0x2A, 0x27, 0xFD, 0x80, 0x9D, 0x55, 0x5E, 0x3E, 0x3F, 0xE2, 0x82, 0x6A, 
	0xA0, 0xD5, 0x57, 0x4F, 0xFD, 0x55, 0xFF, 0xEA, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xEA, 0xFF, 
	0xFF, 0xFF, 0x57, 0x8A, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x57, 
	0xAA, 0x2D, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xC2, 0x89, 0xFF, 0xFF, 0xFE, 
	0xC7, 0x8F, 0x47, 0x15, 0x82, 0x55, 0xFF, 0xFF, 0x78, 0xF5, 0x5D, 0xA0, 0xFC, 0xB5, 0xA8, 0xBE, 
	0x95, 0x55, 0x55, 0x5D, 0x0A, 0xA9, 0xE0, 0x2B, 0xD5, 0x55, 0x57, 0x0F, 0x07, 0xE2, 0x55, 0xAA, 
	0xA8, 0x35, 0x57, 0x1D, 0x55, 0x55, 0xFF, 0xAB, 0xFF, 0xFF, 0x5D, 0x55, 0x55, 0x55, 0xFA, 0xBF, 
	0x55, 0x55, 0xFF, 0x26, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 
	0xFA, 0x87, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0x8A, 0x0A, 0xD5, 0xFF, 0xFE, 
	0x60, 0x82, 0xDA, 0xD8, 0x2F, 0xFF, 0xFF, 0xFF, 0x5C, 0xB5, 0x74, 0x22, 0xDE, 0xB5, 0xA8, 0x3D, 
	0xB5, 0x55, 0xFF, 0xFF, 0xCF, 0x6A, 0x01, 0xFF, 0xFF, 0xFF, 0x57, 0xCB, 0xE2, 0x8F, 0x02, 0x55, 
	0xAA, 0x1D, 0xFE, 0xB5, 0xFF, 0xFF, 0xFC, 0x2F, 0xFF, 0xFF, 0xFF, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFC, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 
	0x5E, 0xA2, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFD, 0x28, 0x2B, 0xD5, 0xFF, 0xFF, 
	0x58, 0x00, 0x7D, 0x89, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x1D, 0x72, 0xFD, 0x5C, 0xB5, 0xA9, 0x2D, 
	0xB5, 0x55, 0xFF, 0xFF, 0xF0, 0xAA, 0x2F, 0xFF, 0xFF, 0xFF, 0x55, 0xE2, 0xFE, 0xBC, 0x34, 0x55, 
	0xA9, 0x85, 0xF8, 0xF5, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xF0, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 
	0x57, 0xA8, 0xBD, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFC, 0x80, 0xA7, 0x55, 0xFF, 0xFF, 
	0xD5, 0xA0, 0x82, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x8D, 0x71, 0xD5, 0x74, 0x75, 0xAA, 0x8F, 
	0xB5, 0x55, 0xFF, 0xF5, 0xE8, 0xB5, 0x81, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xD7, 0xF6, 0xFE, 0x95, 
	0xAA, 0x41, 0xF2, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x56, 0xD2, 0x6A, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 
	0x55, 0xEA, 0x0B, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xF8, 0x09, 0x9D, 0x55, 0xFF, 0xFF, 
	0xFF, 0xD0, 0xD2, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xCB, 0x70, 0x7F, 0xF2, 0xD5, 0xAA, 0x47, 
	0xB5, 0x5F, 0xF5, 0x80, 0x9D, 0x15, 0xA2, 0xFF, 0xFF, 0xFF, 0x55, 0x5C, 0xB5, 0x74, 0xF4, 0x96, 
	0x26, 0xA2, 0xCB, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x5B, 0xC9, 0xAA, 0xFF, 0xFF, 0xFF, 0x8B, 0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x76, 0x80, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x56, 0xE0, 0x15, 0xF5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xD8, 0xF4, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD3, 0xFE, 0x00, 0x03, 0x55, 0xAA, 0xA1, 
	0xB5, 0xF6, 0x80, 0x0A, 0x57, 0x8D, 0xA2, 0xFF, 0xFF, 0xFF, 0x55, 0x5E, 0x35, 0x5E, 0x22, 0x58, 
	0xA2, 0x58, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x6F, 0x06, 0xAA, 0xFF, 0xFF, 0xFC, 0x2F, 0xFF, 0xFE, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x5D, 0xA8, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5B, 0x4A, 0x27, 0xD5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xD8, 0x5E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xDF, 0xAA, 0xA7, 0x55, 0xAA, 0x91, 
	0xFD, 0xA0, 0x0A, 0xAA, 0x55, 0xCB, 0xA2, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 0x2D, 0x57, 0x49, 0x93, 
	0xF4, 0x14, 0x35, 0x55, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x5C, 0x1A, 0xAA, 0xFF, 0xFF, 0xE8, 0xFF, 0xFF, 0xF8, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x57, 0xA8, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x6F, 0x0A, 0x27, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xD4, 0xB7, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x7C, 0xB5, 0xFF, 0xFD, 0x55, 0xAA, 0xA2, 
	0xD8, 0x02, 0xAA, 0xAA, 0x55, 0x61, 0x89, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 0x47, 0x57, 0x82, 0x50, 
	0xFF, 0x06, 0x1D, 0x55, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x70, 0x5A, 0xAA, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xF8, 0x2F, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 
	0x55, 0xFF, 0xA2, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5C, 0x2A, 0x27, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xF6, 0x2F, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5E, 0x35, 0x55, 0x55, 0x55, 0xAA, 0xA4, 
	0x80, 0x00, 0xAA, 0xAA, 0x55, 0x7A, 0xAF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xC3, 0x5D, 0x3C, 0x54, 
	0x3F, 0x49, 0x0F, 0x55, 0xFF, 0xFF, 0xC2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD1, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0xBF, 0xFF, 0xFF, 0xF6, 0xBF, 0xFF, 
	0xFF, 0x56, 0x0B, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x74, 0x08, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF8, 0x82, 0xA2, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x2D, 0x55, 0x55, 0x55, 0x57, 0x60, 
	0x06, 0xAA, 0x02, 0xAA, 0xAA, 0xA8, 0xBD, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0xDE, 0xBC, 0xA9, 
	0x8F, 0xA5, 0x4B, 0xFF, 0x55, 0x75, 0xAF, 0x55, 0x55, 0x55, 0xFF, 0xEB, 0xD5, 0x55, 0x55, 0x5F, 
	0xFF, 0x45, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6A, 0x7F, 0xFF, 0xFF, 0xFF, 0x89, 0x55, 
	0x55, 0x60, 0x9D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xF2, 0xA0, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x60, 0x00, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x47, 0x55, 0x55, 0x57, 0xF8, 0x09, 
	0xCB, 0x55, 0xAA, 0x00, 0x00, 0x06, 0x3D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x5C, 0x7C, 0xAA, 
	0xD0, 0xB5, 0x43, 0xFF, 0xF5, 0x54, 0xB5, 0x55, 0x57, 0x55, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFE, 
	0xFE, 0x15, 0x57, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0xC0, 0xAA, 
	0xA8, 0x0F, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x02, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xD6, 0xA0, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x55, 0x55, 0xFD, 0x80, 0x7D, 
	0x72, 0xD5, 0xFF, 0xAA, 0xAA, 0x9F, 0xAD, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xBC, 0x7C, 0xAA, 
	0x5F, 0x5D, 0x02, 0x55, 0x56, 0x80, 0x75, 0x55, 0x7E, 0xB5, 0xFF, 0xFC, 0xA5, 0x55, 0x55, 0x60, 
	0xF8, 0x55, 0x5D, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x9A, 0xAF, 0xFF, 0xFF, 0xFF, 0xF8, 0x0A, 
	0xAA, 0x8F, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x80, 0x0A, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF5, 0xDA, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0xD5, 0x7F, 0xA0, 0x27, 0x55, 
	0x54, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x5D, 0x1C, 0x74, 0x6A, 
	0x55, 0xD8, 0x28, 0x60, 0x00, 0x22, 0xD5, 0x55, 0xFA, 0xF5, 0xFF, 0xFF, 0x80, 0x2A, 0xA8, 0x02, 
	0x41, 0x55, 0xF8, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0x69, 0x02, 0xA9, 0xFF, 0xFF, 0xFF, 0x5D, 0x82, 
	0xA5, 0x63, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0x02, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD2, 0x87, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xFF, 0xD8, 0x0A, 0xFD, 0x55, 
	0x5E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x2D, 0x22, 0xAA, 
	0x5D, 0x82, 0x64, 0x36, 0xA9, 0xF1, 0xD5, 0x7F, 0xE1, 0xD5, 0xFF, 0xFF, 0xD8, 0x00, 0x00, 0xAF, 
	0x25, 0x55, 0x80, 0xD5, 0xFF, 0xFF, 0xFF, 0xF6, 0xA8, 0x08, 0x02, 0x95, 0xFF, 0xFF, 0xFF, 0xF8, 
	0x26, 0x98, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0xA1, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD8, 0xE3, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0x1E, 0x02, 0x7F, 0x52, 0xD5, 
	0x55, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x4B, 0x09, 0xA9, 
	0xE0, 0x2D, 0xA9, 0x2F, 0xFF, 0xCB, 0x7F, 0xFE, 0x0F, 0x55, 0xFA, 0xFF, 0x7F, 0xDA, 0x5F, 0xF5, 
	0x55, 0xA8, 0x02, 0xD5, 0xFF, 0xFF, 0xFF, 0xA2, 0x80, 0x7D, 0xA0, 0x0A, 0xAA, 0x57, 0xD5, 0xAA, 
	0x76, 0xA6, 0x1D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD8, 0x72, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x02, 0x2F, 0xD5, 0x4E, 0x3E, 
	0x27, 0x8D, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE1, 0x55, 0x58, 
	0x02, 0xD5, 0xAA, 0x47, 0x5F, 0xAF, 0xFD, 0x60, 0x2D, 0x55, 0xF8, 0xBF, 0x55, 0x7F, 0xFD, 0x55, 
	0x80, 0x02, 0xEB, 0x55, 0xFF, 0xFF, 0xDA, 0xA0, 0x07, 0xDF, 0xFE, 0x80, 0x00, 0x00, 0x00, 0xA7, 
	0xFD, 0xA9, 0x07, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 0xD2, 0x81, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD6, 0x3C, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0x41, 0xE2, 0xF5, 0x57, 0x2F, 0xA4, 
	0xF9, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE0, 0x20, 0x00, 
	0x9D, 0x55, 0xAA, 0xA3, 0xD4, 0x2A, 0xA0, 0x09, 0xF5, 0x55, 0xFC, 0xBF, 0x55, 0x55, 0x55, 0x55, 
	0xAA, 0x9F, 0xAD, 0x55, 0x5F, 0xF6, 0xAA, 0x00, 0xBF, 0xFF, 0xFF, 0xF8, 0x80, 0x00, 0x2B, 0xFD, 
	0x5F, 0x8A, 0x81, 0xFF, 0x55, 0x55, 0x55, 0x57, 0xCA, 0x89, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xF8, 0x0A, 0x2A, 0x55, 0x55, 0x55, 0xF8, 0x2F, 0xF4, 0x95, 0x55, 0x0F, 0x42, 
	0xF2, 0x62, 0xD5, 0x55, 0xFF, 0xFF, 0x57, 0x47, 0x55, 0x55, 0x55, 0x55, 0x5F, 0x8F, 0x08, 0xA7, 
	0xFF, 0xFF, 0xFF, 0xF8, 0xF6, 0x80, 0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF4, 0xBF, 0xFF, 0xD5, 0xA8, 0x00, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x55, 
	0x57, 0xE2, 0xA0, 0x7F, 0x55, 0x55, 0x55, 0x57, 0x8A, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFE, 0x40, 0x2A, 0x55, 0x55, 0x5F, 0x80, 0xFD, 0x5E, 0x35, 0x55, 0x4B, 0x41, 
	0xF2, 0x90, 0xD5, 0x55, 0xFF, 0xFF, 0x55, 0xEB, 0x55, 0x55, 0x55, 0x55, 0xF8, 0x2F, 0xCB, 0xF5, 
	0xFF, 0xFF, 0xFF, 0xFC, 0xB7, 0xFF, 0xFF, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xE0, 0x6A, 0x9A, 0xA0, 0x00, 0x29, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0xF8, 0xAA, 0x2F, 0x55, 0x55, 0x55, 0x5E, 0x20, 0x97, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xD6, 0x0A, 0x55, 0x57, 0xF8, 0x2F, 0xD5, 0x57, 0x0D, 0x55, 0x50, 0x1A, 
	0xC1, 0xA4, 0xB5, 0x55, 0xFF, 0xFF, 0x55, 0xF1, 0xD5, 0x55, 0x55, 0x7F, 0x82, 0xF5, 0xE1, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x1D, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xD8, 0x00, 0x00, 0x00, 0x2A, 0xFF, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x7E, 0xAA, 0x83, 0xD5, 0x55, 0x55, 0x74, 0x02, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xFD, 0x82, 0xD5, 0xFD, 0x82, 0xFD, 0x55, 0x57, 0x49, 0xE0, 0x16, 0x96, 
	0x06, 0xA6, 0x2D, 0x55, 0xFF, 0xFF, 0x55, 0x7A, 0xD5, 0x55, 0x5F, 0xD8, 0x2F, 0x55, 0x7A, 0xD5, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x74, 0xF5, 0xAA, 0x97, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x5F, 0xAA, 0xA0, 0xB5, 0x55, 0x55, 0xF0, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xFD, 0xA8, 0x7F, 0x68, 0x2F, 0x55, 0x55, 0x55, 0xE3, 0x8F, 0x85, 0x55, 
	0x5A, 0x55, 0x8D, 0x55, 0xFF, 0xFF, 0x55, 0x74, 0x75, 0x57, 0xFE, 0x02, 0xFD, 0x55, 0x54, 0x75, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0x55, 0x55, 0x57, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x70, 0xD7, 0xFF, 0xFD, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFA, 0xD5, 0x55, 0x55, 0x55, 
	0x55, 0x57, 0x6A, 0xA8, 0x2F, 0x55, 0x55, 0xE2, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xFD, 0x88, 0x2A, 0x29, 0xF5, 0x55, 0x55, 0x55, 0x51, 0x1F, 0xE1, 0x82, 
	0x6A, 0x02, 0xCB, 0x55, 0xFF, 0xFF, 0x55, 0x5C, 0x3F, 0xFD, 0x80, 0xAF, 0x55, 0x55, 0x5E, 0x35, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xA2, 0xD5, 0x55, 0x7E, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xE2, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 0x95, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x56, 0xAA, 0x89, 0xD5, 0x57, 0x8A, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD5, 0xFF, 0xFF, 0xFF, 0x62, 0x42, 0x7F, 0x55, 0x55, 0x55, 0x55, 0x78, 0x6F, 0x4A, 0x3E, 
	0x98, 0x74, 0xA3, 0x55, 0xFF, 0xFF, 0x55, 0x5E, 0x0A, 0xA8, 0x2B, 0xF5, 0x55, 0x55, 0x57, 0x2D, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0x75, 0x55, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x57, 0x4A, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xA5, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0xAA, 0xA0, 0xBD, 0x5D, 0x0A, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 
	0x82, 0xFD, 0xFF, 0xFF, 0xFF, 0xD0, 0xD3, 0xD5, 0x55, 0x55, 0x55, 0x55, 0x54, 0x60, 0x26, 0xBE, 
	0x18, 0xFF, 0xA2, 0xD5, 0xFF, 0xFF, 0x55, 0xF8, 0xE2, 0xA9, 0xFD, 0x55, 0x55, 0x55, 0x57, 0x8D, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0x35, 0x57, 0xA9, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xCB, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0x57, 0x6A, 0x56, 0x2F, 0xFE, 0x2A, 0x0B, 0xD5, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xD0, 
	0x20, 0x3F, 0x55, 0x55, 0xFF, 0xE8, 0x20, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x3F, 0x55, 0xA8, 
	0x56, 0x27, 0xA4, 0xF5, 0x55, 0x55, 0x5D, 0x81, 0x52, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xCB, 
	0x55, 0x55, 0xFF, 0xFF, 0xA9, 0x1F, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFE, 0x7D, 0x55, 0xFF, 0xFF, 
	0xFC, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0xFA, 0x95, 0x42, 0x74, 0xA8, 0x2B, 0x55, 0x55, 0x57, 0xD8, 0x09, 0x7F, 0x0A, 
	0x55, 0x4F, 0xD5, 0x55, 0xFF, 0xF6, 0x80, 0x9A, 0xFF, 0xFF, 0xFF, 0xFF, 0x5D, 0x2D, 0x55, 0x61, 
	0x55, 0x60, 0xBE, 0xB5, 0x55, 0x57, 0xE0, 0x25, 0x54, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD2, 
	0xD5, 0x55, 0xFF, 0xFF, 0xAA, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 
	0xF0, 0x5A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x5D, 0x69, 0x56, 0x22, 0xA2, 0xAF, 0x55, 0x55, 0x5E, 0x00, 0x00, 0x04, 0x2A, 
	0x55, 0x53, 0xD5, 0x55, 0xFF, 0xFF, 0xF8, 0x26, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x0D, 0x54, 0x2D, 
	0x62, 0x55, 0xDD, 0x3D, 0x55, 0x76, 0x02, 0xF5, 0xA6, 0x15, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 
	0xF5, 0x55, 0xFF, 0xFF, 0xAA, 0x47, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0xA5, 0xBF, 0xFF, 
	0xE1, 0x6A, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x57, 0xFD, 0x56, 0x0A, 0x09, 0x2D, 0x55, 0x55, 0x78, 0x2A, 0xAA, 0xA0, 0xAA, 
	0x55, 0x54, 0xB5, 0x55, 0xFF, 0xFF, 0xF8, 0x8A, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xCB, 0x52, 0xC5, 
	0x2C, 0x95, 0x57, 0x2D, 0x5F, 0x60, 0x9D, 0x5C, 0x29, 0x05, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5C, 
	0x35, 0x55, 0xFF, 0xFF, 0xAA, 0x47, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00, 0x02, 0xBF, 
	0x89, 0xAA, 0xFF, 0xFF, 0xE0, 0xBF, 0xFF, 0xFC, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xFF, 0xFF, 0xFF, 0xFD, 0x60, 0x00, 0x15, 0xB5, 0x55, 0x55, 0xE0, 0xAA, 0xAA, 0xAA, 0xAA, 
	0x55, 0x54, 0xB5, 0x55, 0xFF, 0xFF, 0xF4, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE3, 0x53, 0xE9, 
	0x3F, 0x15, 0x57, 0x4B, 0xD8, 0x2B, 0xD5, 0x58, 0xF1, 0x49, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5F, 
	0x2D, 0x55, 0xFF, 0xFF, 0xA6, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xF5, 0xAA, 0xBF, 
	0x26, 0xAA, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x5A, 0xAA, 0xF5, 0xD5, 0x60, 0x0B, 0x01, 0x57, 0xD5, 0x55, 0x55, 0xC0, 0xAA, 0xAA, 0xAA, 0xAA, 
	0x55, 0x56, 0x3D, 0x55, 0xFF, 0xFF, 0xF4, 0x10, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x72, 0x53, 0xE9, 
	0x2F, 0x45, 0x5F, 0x42, 0x02, 0x7F, 0x55, 0x5B, 0xF9, 0x61, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 
	0x8F, 0x55, 0xFF, 0xFF, 0x60, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5F, 0xFF, 0xFF, 
	0x5A, 0xAA, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x56, 0x80, 0x08, 0x00, 0x00, 0xBC, 0xA1, 0x7F, 0x55, 0x55, 0x57, 0x80, 0xAA, 0xAA, 0xAA, 0xAA, 
	0x55, 0x56, 0x3D, 0x55, 0xFF, 0xFF, 0xFD, 0x28, 0xBF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0x5A, 0xC5, 
	0x4B, 0x45, 0xF6, 0x1E, 0x0F, 0x5A, 0x2D, 0x53, 0xF9, 0x50, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xC3, 0x55, 0xFF, 0xFE, 0x01, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xFF, 0x02, 0xAA, 0x9F, 0xF8, 0xA1, 0xFF, 0x55, 0x55, 0x57, 0x80, 0xAA, 0xAA, 0xAA, 0xAA, 
	0x55, 0x56, 0x3D, 0x55, 0xFF, 0xFF, 0xFD, 0x86, 0x3F, 0xFF, 0xFF, 0xFF, 0x55, 0x5C, 0x16, 0x25, 
	0x50, 0x95, 0xA2, 0x7F, 0xCB, 0x67, 0xE1, 0x53, 0xF1, 0x54, 0xBF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xF2, 0xD5, 0xFF, 0x80, 0x1F, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x55, 0x55, 0x55, 
	0x55, 0x57, 0xE0, 0xA5, 0x5D, 0xE2, 0x02, 0xBF, 0xFF, 0xFF, 0x57, 0x8A, 0xAA, 0xAA, 0xFF, 0xFF, 
	0xAA, 0xA8, 0xB5, 0x55, 0xFF, 0xFF, 0x5E, 0x80, 0xAD, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x2F, 0xD5, 
	0x5F, 0xF8, 0x0B, 0xFF, 0x61, 0xAF, 0xF0, 0x52, 0xE9, 0x5E, 0x15, 0x55, 0xFF, 0xFF, 0x55, 0x55, 
	0xA0, 0xAA, 0xA0, 0x02, 0x5F, 0x06, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6A, 0xFD, 0x55, 0x55, 
	0x55, 0x55, 0x76, 0x09, 0xD7, 0x4A, 0x0A, 0x7F, 0xFF, 0xFF, 0x55, 0xC2, 0xAA, 0xAA, 0xFF, 0xFF, 
	0xAA, 0xA0, 0xF5, 0x55, 0xFF, 0xFF, 0x5F, 0x60, 0x05, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x47, 0x55, 
	0x7D, 0x82, 0xFF, 0xFF, 0x78, 0xC7, 0xFC, 0xA4, 0x2D, 0x57, 0xAD, 0x55, 0xFF, 0xFF, 0x55, 0x55, 
	0xA8, 0x00, 0x00, 0xA5, 0xFF, 0x86, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x55, 0xFF, 0xFF, 0xFF, 0x5F, 0xFB, 0xFF, 0x58, 0x2B, 0xFD, 0x55, 
	0x55, 0x55, 0x7F, 0x42, 0xDF, 0x0A, 0x0A, 0x7F, 0xFF, 0xFF, 0x55, 0xE2, 0xAA, 0xAA, 0xFF, 0xFF, 
	0xAA, 0xA1, 0xD5, 0x55, 0xFF, 0xFF, 0x57, 0xDA, 0x8B, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x57, 
	0xD8, 0x9F, 0xFF, 0xFF, 0x5C, 0x92, 0x74, 0xA9, 0x55, 0x55, 0x4B, 0x55, 0xFF, 0xFF, 0x55, 0x55, 
	0xA2, 0x40, 0x29, 0x7F, 0x57, 0x86, 0xFF, 0xFC, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x89, 0x55, 0xFF, 0xFF, 0xFE, 0xBF, 0xE3, 0xFF, 0x5F, 0x80, 0x95, 0xFF, 
	0xFF, 0xFF, 0xD8, 0x27, 0x5E, 0x18, 0x29, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xAA, 0xAA, 0xFF, 0xFF, 
	0xAA, 0x8B, 0xD5, 0x55, 0xFF, 0xFF, 0x55, 0x7D, 0xAA, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 0xF6, 
	0x09, 0xF5, 0xFF, 0xFF, 0x55, 0x2E, 0x02, 0xA8, 0x55, 0x55, 0xE1, 0x55, 0xFF, 0xFF, 0x55, 0x55, 
	0x82, 0xF5, 0x57, 0xFF, 0x57, 0x4A, 0xFF, 0xFE, 0x9F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x56, 0x2D, 0x55, 0xFF, 0xFF, 0xF8, 0x7F, 0xE3, 0xFF, 0x55, 0xFA, 0x02, 0xAA, 
	0xA6, 0xA8, 0x0A, 0x7D, 0x78, 0x82, 0xA7, 0xFF, 0xFF, 0xFF, 0x55, 0x7E, 0x2A, 0xAA, 0xFF, 0xFF, 
	0xAA, 0x0F, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x5D, 0xA4, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xA0, 
	0xBF, 0x55, 0xFF, 0xFF, 0x55, 0x8B, 0x66, 0xA0, 0x25, 0x55, 0x7A, 0xD5, 0xFF, 0xFF, 0x55, 0x7E, 
	0x09, 0xFF, 0xFF, 0xFF, 0x57, 0x4A, 0xFF, 0xFF, 0x6B, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF7, 0xF5, 0x56, 0x80, 0x35, 0x55, 0xFF, 0xFF, 0xE2, 0xFF, 0xE3, 0xFF, 0x55, 0x5F, 0x80, 0x00, 
	0x00, 0x02, 0x9F, 0xD5, 0xD0, 0x25, 0x9F, 0xFF, 0xFF, 0xFF, 0x55, 0x5F, 0x42, 0xAA, 0xFF, 0xFF, 
	0xA8, 0x3D, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x5D, 0xCE, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x64, 
	0x75, 0x55, 0xFF, 0xFF, 0x55, 0xE3, 0xAA, 0x4B, 0xC5, 0x78, 0xB4, 0xB5, 0xFF, 0xFF, 0x57, 0xE0, 
	0x27, 0xFF, 0xFF, 0xFF, 0x55, 0xC1, 0xFF, 0xFF, 0xD0, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0A, 0xAA, 0x00, 0x20, 0xF5, 0x55, 0xFF, 0xFF, 0x8B, 0xFF, 0xEB, 0xFF, 0x55, 0x55, 0xFD, 0x6A, 
	0xAA, 0x9F, 0xD5, 0x55, 0xC0, 0xB7, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 0xF0, 0xAA, 0xFF, 0xFF, 
	0xA0, 0xF5, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x5D, 0xCB, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0x8B, 0xDE, 
	0x3D, 0x55, 0xFF, 0xFF, 0x55, 0x72, 0x6A, 0x4B, 0x85, 0x61, 0x8D, 0x15, 0xFF, 0xFF, 0xF8, 0x0B, 
	0x5F, 0xFF, 0xFF, 0xFF, 0x55, 0xC1, 0xFF, 0xFF, 0x7E, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x80, 0x00, 0xAA, 0xD3, 0xD5, 0x55, 0xFF, 0xE8, 0x1F, 0xFF, 0xEB, 0xFF, 0x55, 0x55, 0x55, 0xFF, 
	0xFF, 0xF5, 0x55, 0x57, 0x8A, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFD, 0x0A, 0xFF, 0xFF, 
	0x87, 0xD5, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x57, 0xF1, 0x45, 0xFF, 0xFF, 0xFF, 0xF8, 0x2D, 0x57, 
	0xAD, 0x55, 0xFF, 0xFF, 0x55, 0x58, 0xAA, 0x90, 0x15, 0x4F, 0xF3, 0x8D, 0xFF, 0xFF, 0x80, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE1, 0xFF, 0xFF, 0x5F, 0x82, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x87, 0x55, 0x7F, 0xFD, 0xA0, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5D, 0x08, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x80, 0xAA, 0xA8, 
	0x2F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0x02, 0x55, 0x55, 0x7F, 0x82, 0xF5, 0x57, 
	0xCB, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 0x1A, 0x59, 0xD5, 0xCF, 0xF8, 0x8A, 0xAA, 0xA0, 0x09, 0x5F, 
	0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xE1, 0x55, 0x55, 0x55, 0x60, 0x0A, 0xAA, 0x95, 0x55, 0x55, 0x66, 
	0xFF, 0xFF, 0x5E, 0x1F, 0xFF, 0xF5, 0xA0, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0x28, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xF8, 0x0A, 0xA0, 
	0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00, 0xF5, 0x57, 0xD8, 0x2F, 0xD5, 0x55, 
	0xE3, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x26, 0x40, 0x55, 0x51, 0xF8, 0x42, 0xA8, 0x02, 0x95, 0xF5, 
	0xFF, 0xFF, 0x69, 0xD5, 0x55, 0xE1, 0x55, 0x55, 0x55, 0xA2, 0x80, 0x02, 0xAA, 0xAA, 0xAA, 0x80, 
	0xFF, 0xFF, 0x70, 0xAA, 0xA8, 0x00, 0x02, 0xBF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x78, 0xA8, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x7F, 0x80, 0x8B, 
	0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x60, 0x1F, 0xF6, 0x82, 0xFD, 0x55, 0x55, 
	0x72, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x85, 0x2E, 0x35, 0x74, 0x22, 0x80, 0x00, 0x25, 0x7F, 0x55, 
	0xFF, 0xDA, 0x00, 0x75, 0x55, 0xE2, 0xAA, 0xAA, 0xA8, 0x07, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x0B, 
	0xFF, 0xFF, 0x78, 0x08, 0x00, 0x0A, 0x9F, 0xD5, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xEB, 0xFF, 0x55, 0xD2, 0x82, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 0xF8, 0x2F, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x0A, 0xA0, 0x9F, 0x55, 0x55, 0x55, 
	0x74, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0x49, 0x3F, 0x95, 0x57, 0xA9, 0x05, 0xA9, 0x5F, 0xD5, 0x57, 
	0xFD, 0x80, 0xA8, 0xB5, 0x55, 0xE0, 0x00, 0x00, 0x02, 0x7D, 0xFF, 0xF5, 0x6A, 0xAA, 0xAA, 0x7F, 
	0xFF, 0xFF, 0x5F, 0xFF, 0xFF, 0xFF, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xE8, 0x2F, 0x57, 0xCA, 0x09, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x5F, 0x7D, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0xC2, 0xA7, 0xF5, 0x55, 0x55, 0x55, 
	0x5E, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0x61, 0xBF, 0xA5, 0x55, 0x98, 0x2F, 0xD7, 0xFF, 0x55, 0x7F, 
	0x60, 0x2A, 0xA8, 0xB5, 0x55, 0xD2, 0x8A, 0xAA, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAF, 0x57, 0x80, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x57, 0xD5, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0xDB, 0xF5, 0x55, 0x55, 0x55, 0x55, 
	0x5F, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0x90, 0xBF, 0xA5, 0x57, 0x82, 0x5F, 0xFF, 0xFF, 0x5F, 0xD8, 
	0x0A, 0x80, 0x28, 0xBD, 0x55, 0xD3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x5E, 0x22, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0xBA, 0xD5, 0x55, 0x55, 0x5F, 0xFD, 
	0x57, 0x8D, 0xFF, 0xFF, 0xFF, 0xFF, 0x98, 0xAD, 0x35, 0xF4, 0x09, 0x7F, 0xFF, 0xFF, 0xF6, 0x00, 
	0xA8, 0x2A, 0x28, 0x1D, 0x55, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xBF, 0xFF, 
	0xFF, 0xFF, 0x74, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x2E, 0x75, 0x55, 0x55, 0xF8, 0x0F, 
	0x57, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xA4, 0xA0, 0x7F, 0x80, 0x97, 0xFF, 0xFF, 0xFF, 0xA0, 0x0A, 
	0x02, 0x55, 0x8A, 0x1D, 0x55, 0x72, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xAD, 0x55, 
	0x55, 0x55, 0x70, 0xA2, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x40, 0x2A, 0xFF, 0xFF, 0xC2, 0x81, 
	0xD5, 0xE3, 0x55, 0x55, 0x55, 0x55, 0xA8, 0x2A, 0x80, 0x0A, 0x9F, 0x55, 0xFF, 0xF8, 0x09, 0x58, 
	0x0F, 0xAB, 0x8A, 0x1F, 0x55, 0x72, 0x6A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xD5, 
	0x55, 0x55, 0xE2, 0xA2, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0x0A, 0xFF, 0xF7, 0x8F, 0xF8, 
	0xD5, 0xD2, 0xD5, 0x55, 0x55, 0x55, 0xAA, 0x00, 0x00, 0xA5, 0xF5, 0x55, 0xFD, 0x82, 0x55, 0x91, 
	0xFA, 0xAB, 0x8A, 0x1F, 0x55, 0x72, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x75, 
	0x55, 0x57, 0x4A, 0xA1, 0x1D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x8A, 0xFD, 0x00, 0x15, 0x56, 
	0x75, 0x72, 0xD5, 0x55, 0x55, 0x55, 0xA8, 0x2A, 0xA9, 0x7F, 0x55, 0x5F, 0xD8, 0x28, 0x02, 0x63, 
	0xAA, 0xAB, 0x8A, 0x1F, 0x55, 0x72, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x2F, 
	0x55, 0x5F, 0x0A, 0x89, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xA2, 0xFC, 0x96, 0x95, 0x56, 
	0x75, 0x78, 0xF5, 0x55, 0x55, 0x57, 0xA0, 0xBF, 0x5F, 0xFF, 0x55, 0x7E, 0x0A, 0x82, 0x74, 0xA3, 
	0xAA, 0xAB, 0x8A, 0x1F, 0x55, 0x70, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x83, 
	0xD5, 0x5E, 0x1A, 0x25, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xA0, 0xFA, 0xD5, 0xD5, 0x7A, 
	0xD5, 0x5C, 0xB5, 0x55, 0x55, 0x7E, 0x02, 0x7F, 0xFF, 0xFF, 0x55, 0x78, 0xA0, 0x95, 0xFC, 0xA3, 
	0xAA, 0xAB, 0x8A, 0x1F, 0x55, 0x78, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD0, 
	0xBF, 0x74, 0x00, 0x97, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x28, 0x79, 0x55, 0x55, 0x72, 
	0xD5, 0x5E, 0x35, 0x55, 0x57, 0xE0, 0x25, 0xF5, 0xFF, 0xFF, 0x55, 0xF0, 0x89, 0x55, 0xFC, 0xA3, 
	0xAA, 0xAB, 0x8A, 0x1F, 0x55, 0x78, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x7E, 
	0xA9, 0xF0, 0x09, 0x7F, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x24, 0x32, 0xD5, 0x55, 0xE3, 
	0x55, 0x57, 0x2D, 0x57, 0xF8, 0x07, 0x5F, 0x55, 0xFF, 0xFF, 0x55, 0xE0, 0x85, 0x55, 0xFC, 0xAB, 
	0xAA, 0xAB, 0x0A, 0x1F, 0x55, 0x78, 0x6A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x0B, 0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0x55, 0x57, 
	0x62, 0x42, 0x05, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x89, 0x1C, 0x9F, 0xF5, 0xC7, 
	0x55, 0x57, 0x8F, 0xFE, 0x80, 0x7F, 0xF5, 0x55, 0xFF, 0xFF, 0x55, 0xE0, 0x25, 0x55, 0xFC, 0xAB, 
	0xAA, 0xAE, 0x2A, 0x1F, 0x55, 0x78, 0x6A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xBF, 0xFF, 0x55, 0x57, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 
	0xF5, 0x8A, 0x01, 0xF5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0x60, 0xAD, 0xAA, 0xA9, 0xAD, 
	0xAA, 0xAA, 0x82, 0x80, 0x29, 0x5F, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xD2, 0x2D, 0x55, 0xFC, 0xAB, 
	0xFF, 0xF4, 0x2A, 0x1F, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFA, 0xFF, 0xFF, 0x55, 0x5D, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 
	0xFF, 0x2A, 0x01, 0xD5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xDA, 0x07, 0xD6, 0xA0, 0x1D, 
	0xAA, 0xA9, 0x0A, 0x0A, 0x57, 0xF7, 0xFD, 0x67, 0xD5, 0x55, 0xFF, 0xD2, 0x2D, 0x55, 0xFC, 0xAB, 
	0xFF, 0x82, 0xAA, 0x1F, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x74, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 
	0xDD, 0x29, 0x0A, 0xD5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFD, 0x8B, 0x55, 0xFD, 0xB5, 
	0xAA, 0xA4, 0x2F, 0x55, 0x7D, 0x7F, 0x60, 0x01, 0xD5, 0x55, 0xFF, 0xD2, 0x2D, 0x55, 0xF4, 0x61, 
	0x68, 0x26, 0xAA, 0x1F, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD2, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 
	0xFC, 0xA6, 0x29, 0xD5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFD, 0x9A, 0xD5, 0x57, 0xD5, 
	0xAA, 0x40, 0x9F, 0xFF, 0xFF, 0xD8, 0x0A, 0xA8, 0xB5, 0x55, 0xFF, 0xD2, 0x2D, 0x55, 0xF4, 0x58, 
	0x02, 0x5A, 0xAA, 0x1F, 0x55, 0x78, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x8B, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 
	0xF8, 0x60, 0x2B, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x64, 0x55, 0x55, 0x57, 
	0x98, 0x09, 0x75, 0x57, 0xF6, 0x00, 0xAA, 0xA8, 0x35, 0x55, 0xFF, 0xD2, 0x2D, 0x55, 0xFA, 0x65, 
	0x96, 0x00, 0xAA, 0x1F, 0x55, 0x78, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0x2D, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFE, 
	0xD0, 0x01, 0xAF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xFF, 0xFF, 0x56, 0x5A, 0xAA, 0x95, 0xFD, 0xC6, 0xB5, 0x57, 0xFD, 
	0x00, 0x1F, 0xD5, 0xFD, 0x80, 0x2A, 0x80, 0xA8, 0x35, 0x55, 0xFF, 0xD2, 0x2D, 0x57, 0xE1, 0xA9, 
	0x60, 0xAD, 0x2A, 0x1F, 0x55, 0x78, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0x35, 0xFF, 0xFF, 0xFF, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xC8, 0x1F, 0x7D, 0x55, 0x5F, 0xFF, 0xFF, 0xFD, 0x6A, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xD1, 0xAD, 0xFD, 0x80, 
	0x09, 0xFF, 0x7F, 0xD8, 0x0A, 0xA0, 0x28, 0xA8, 0x35, 0x55, 0xFF, 0xD2, 0x2F, 0xF6, 0x09, 0xAA, 
	0x0B, 0xFF, 0x0A, 0x1F, 0x55, 0x78, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0xF5, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0A, 0x1F, 0xD5, 0x7F, 0xFD, 0xA0, 0xAA, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x00, 0x00, 0xAA, 0x02, 0xAA, 0xAA, 0x07, 0xF2, 0x02, 0x80, 0x2B, 
	0x7F, 0xFF, 0xF6, 0x02, 0xAA, 0x02, 0x55, 0x28, 0x35, 0x55, 0xFF, 0xD2, 0x0A, 0x00, 0x96, 0xA4, 
	0x3F, 0xFF, 0x0A, 0x1F, 0x55, 0x74, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x56, 0xAB, 0xD5, 0x55, 0x55, 0x96, 0x26, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xDE, 
	0x2A, 0x27, 0xFF, 0xF5, 0x58, 0x00, 0x00, 0x02, 0xAA, 0x80, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x60, 0x00, 0x0A, 0xA8, 0x00, 0x2A, 0x87, 0xEA, 0x80, 0x02, 0x9F, 
	0xFF, 0xFD, 0x60, 0x96, 0xA0, 0x9F, 0xFF, 0x28, 0xB5, 0x55, 0x55, 0xD2, 0xA0, 0x25, 0xA9, 0xA8, 
	0x75, 0x57, 0x0A, 0x1D, 0x55, 0x7C, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x6A, 0x0F, 0x55, 0x55, 0x55, 0x58, 0x9A, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xF4, 
	0xA8, 0x17, 0xFE, 0xA0, 0x02, 0xAA, 0x55, 0x55, 0xAA, 0xAA, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x0A, 0xAA, 0x82, 0xA0, 0x00, 0x82, 0x4B, 0xD3, 0xFD, 0x57, 0xFF, 
	0xFF, 0x68, 0x0A, 0x82, 0xA1, 0xF5, 0xFD, 0x28, 0xB5, 0x55, 0x55, 0xDA, 0xA9, 0x60, 0x02, 0xA8, 
	0xB5, 0x57, 0x08, 0x1D, 0x55, 0x78, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x57, 0x56, 0xA8, 0x2D, 0x55, 0x55, 0x57, 0x6A, 0xA5, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xF0, 
	0xA8, 0x97, 0xF0, 0x2A, 0xAA, 0xAA, 0xAA, 0x80, 0x00, 0xA9, 0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x15, 0xFF, 0xE2, 0x89, 0x7F, 0xF2, 0x8B, 0xD3, 0x55, 0xFF, 0x55, 
	0xF6, 0x02, 0xA0, 0x28, 0x8B, 0x55, 0xFD, 0x28, 0xB5, 0x55, 0x55, 0xDA, 0xAA, 0x09, 0xF4, 0x68, 
	0xB5, 0x57, 0x88, 0x3D, 0x55, 0x78, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD5, 0xA8, 0x00, 0xB5, 0x55, 0x55, 0x7D, 0xA0, 0xAA, 0x7D, 0x55, 0xFF, 0xFF, 0x5F, 0xE2, 
	0x80, 0x9F, 0xD2, 0x80, 0x00, 0x0A, 0xA8, 0x2A, 0xAA, 0x0A, 0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x27, 0xFF, 0xE2, 0x89, 0xFF, 0xF2, 0x8B, 0xD1, 0x55, 0x55, 0x55, 
	0xD0, 0xA8, 0x09, 0xFC, 0x8B, 0x55, 0xFD, 0x28, 0xB5, 0x55, 0x55, 0xF8, 0xA0, 0xBF, 0xF4, 0xA4, 
	0xB5, 0x57, 0x08, 0xBD, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x6A, 0xA8, 0x00, 0x91, 0xD5, 0x55, 0x55, 0xDA, 0x80, 0x0A, 0xA9, 0xFD, 0xFF, 0xFF, 0xD7, 0xC0, 
	0x0A, 0x7F, 0xD2, 0x0A, 0x57, 0xD2, 0x98, 0x5F, 0xFF, 0x4A, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x15, 0xFF, 0xE2, 0x8B, 0xFF, 0xF2, 0x89, 0xF9, 0x55, 0x55, 0x57, 
	0xC2, 0x82, 0x7D, 0x5E, 0x0B, 0x55, 0xFF, 0x28, 0xB5, 0x55, 0x55, 0xF8, 0xA1, 0xFF, 0xFC, 0xA4, 
	0xB5, 0x57, 0x08, 0xB5, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x02, 0xA7, 0xCB, 0x55, 0x55, 0x7D, 0xA8, 0x2F, 0x80, 0x2A, 0x95, 0xFF, 0xFF, 0xF6, 0x5A, 
	0x96, 0x7F, 0xE2, 0x29, 0xFF, 0xFA, 0x68, 0x7F, 0xFF, 0xCA, 0x82, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x25, 0xFF, 0xD2, 0x8B, 0xFF, 0xF2, 0x89, 0xF9, 0x55, 0x55, 0x57, 
	0x4A, 0x05, 0xD5, 0x5E, 0x0B, 0x55, 0xFF, 0x28, 0x35, 0x55, 0x55, 0xF8, 0xA3, 0xFF, 0xFC, 0xA4, 
	0xB5, 0x7E, 0x28, 0xB5, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x9F, 0xFE, 0x1D, 0x55, 0xFF, 0x5A, 0x02, 0x7F, 0xF6, 0x00, 0x02, 0x95, 0xFF, 0xFF, 0x80, 
	0x28, 0xBF, 0xE2, 0x25, 0xFF, 0xF8, 0x64, 0x7F, 0xFF, 0xCA, 0x82, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x25, 0xFF, 0xD2, 0x8B, 0xFF, 0xF2, 0x41, 0x71, 0x55, 0x55, 0x57, 
	0x4A, 0x15, 0x55, 0x5E, 0x0B, 0x55, 0xFD, 0x28, 0x35, 0x55, 0x55, 0xF8, 0xA3, 0xFF, 0xFC, 0xA4, 
	0x3F, 0x60, 0xA8, 0xB5, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x6A, 0xF5, 0xFF, 0x5A, 0x80, 0x2F, 0xFF, 0xFF, 0xFF, 0xA0, 0x00, 0x0A, 0xA8, 0x05, 
	0xA0, 0xBF, 0xD2, 0x25, 0xFF, 0xF4, 0x64, 0x7F, 0xFF, 0xE2, 0x02, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x25, 0xFF, 0xD2, 0x8B, 0xFF, 0xF2, 0x81, 0x79, 0x55, 0x55, 0x57, 
	0xCA, 0x15, 0x55, 0x5E, 0x0B, 0x55, 0xFE, 0x28, 0x35, 0x55, 0x55, 0xF8, 0xA3, 0xFF, 0xFC, 0xAA, 
	0x28, 0x02, 0xA8, 0x75, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x02, 0x7F, 0x95, 0x5F, 0xFF, 0xF6, 0xAA, 0x00, 0x00, 0xAF, 
	0xFD, 0x2A, 0xD2, 0x25, 0xFF, 0xF4, 0xA8, 0xBF, 0xFF, 0xE1, 0xA2, 0x7F, 0xFF, 0xFF, 0x55, 0x55, 
	0x55, 0x55, 0xFF, 0xFF, 0xD2, 0x25, 0xFF, 0xD2, 0x4B, 0xFF, 0xF1, 0x6B, 0xF2, 0x55, 0xFF, 0xFF, 
	0xCA, 0x15, 0x55, 0x5E, 0xAB, 0xFF, 0xF8, 0x64, 0xB5, 0x55, 0x55, 0x78, 0x63, 0xFF, 0x54, 0x2A, 
	0x80, 0xAA, 0x82, 0xD5, 0x55, 0x78, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAA, 0x8A, 0xAA, 0xAA, 0xAA, 0xBF, 0xF5, 0x55, 0x55, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 
	0xFD, 0x2A, 0xD2, 0x25, 0xFF, 0xF4, 0xA8, 0xBF, 0xFF, 0xD1, 0xA2, 0x7F, 0xFF, 0xFF, 0x55, 0x55, 
	0x55, 0x55, 0xFF, 0xFF, 0xD2, 0x25, 0xFF, 0xE1, 0x4B, 0xFF, 0xE1, 0x5B, 0x72, 0x55, 0xFF, 0xFF, 
	0xEA, 0x15, 0x55, 0x5C, 0xA3, 0xFF, 0x81, 0xA4, 0xB5, 0x55, 0x55, 0x78, 0x63, 0xFF, 0x54, 0xAA, 
	0xAA, 0xA8, 0x0B, 0xD5, 0x55, 0x78, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAA, 0xAF, 0xFF, 0xFF, 0xFF, 0xF5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xD5, 
	0xFF, 0x0A, 0xD2, 0x25, 0xFF, 0xFC, 0xA8, 0x7F, 0xFF, 0xE1, 0xA2, 0x7F, 0xFF, 0xFF, 0x55, 0x55, 
	0x55, 0x55, 0xFF, 0xFF, 0xD2, 0x8A, 0xA8, 0x0A, 0xA2, 0x00, 0x05, 0x53, 0x72, 0x55, 0xFF, 0xFF, 
	0xE2, 0x15, 0x55, 0x54, 0xA3, 0xD8, 0x15, 0xA4, 0x35, 0x55, 0x55, 0x78, 0x63, 0xFF, 0x60, 0xAA, 
	0xAA, 0x00, 0xBF, 0x55, 0x55, 0x78, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xA9, 0xAF, 0x5F, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0xFF, 0x0A, 0xD2, 0x05, 0xFF, 0xF4, 0xA4, 0x1F, 0x55, 0x8A, 0xA2, 0x7F, 0xFF, 0xFF, 0x55, 0x55, 
	0x55, 0x55, 0xFF, 0xFF, 0xD2, 0xA0, 0x02, 0xAA, 0xA8, 0xAA, 0x55, 0x53, 0x72, 0x55, 0xFF, 0xFF, 
	0xE2, 0x15, 0x55, 0x74, 0x90, 0x09, 0x50, 0x64, 0x35, 0x55, 0x55, 0x78, 0x63, 0xF6, 0x02, 0xAA, 
	0x00, 0x27, 0xF5, 0x55, 0x55, 0x78, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xA9, 0x2D, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0xFF, 0x06, 0xF2, 0x89, 0x56, 0xA2, 0x69, 0x00, 0x00, 0x2A, 0xA2, 0x7F, 0xFF, 0xFF, 0x55, 0x55, 
	0x55, 0x55, 0xFF, 0xFF, 0xD2, 0xA6, 0xAA, 0x5A, 0xA5, 0xAA, 0x55, 0x51, 0x72, 0xD5, 0xFF, 0xFF, 
	0xE2, 0x15, 0x55, 0xF8, 0x66, 0x94, 0x06, 0x14, 0x35, 0x55, 0x55, 0x78, 0x58, 0x80, 0xAA, 0x80, 
	0x29, 0xFD, 0x55, 0x55, 0x55, 0x78, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAB, 0x2D, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0xFF, 0x8A, 0xF8, 0xA0, 0x00, 0x0A, 0xAA, 0x6A, 0xA9, 0x6A, 0xA2, 0x7F, 0xFF, 0xFF, 0x55, 0x5F, 
	0xD5, 0x55, 0xFF, 0xFF, 0xD2, 0xA0, 0x00, 0x0A, 0x90, 0x00, 0x05, 0x51, 0x72, 0xD5, 0xFF, 0xFF, 
	0xD2, 0x15, 0x57, 0x62, 0xA9, 0x82, 0xFF, 0x14, 0x3D, 0x55, 0x55, 0x78, 0x66, 0x25, 0xA0, 0x05, 
	0x7F, 0xD5, 0x55, 0x55, 0x55, 0x78, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAB, 0x1D, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0xFF, 0x8A, 0xF8, 0xAA, 0xAA, 0xAA, 0xAA, 0x5A, 0xA8, 0xAA, 0xA2, 0x7F, 0xFF, 0xFF, 0x7F, 0xFF, 
	0xFF, 0xF5, 0xFF, 0xFF, 0xF2, 0x82, 0x55, 0x62, 0x42, 0x95, 0xE1, 0x51, 0x72, 0xD5, 0xFF, 0xFF, 
	0xD2, 0x1D, 0xF6, 0x0A, 0xA4, 0x2F, 0xFF, 0x14, 0x3D, 0x55, 0x55, 0x78, 0x69, 0x58, 0x09, 0x7F, 
	0xF5, 0x55, 0x55, 0x55, 0x55, 0x78, 0x6A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xA9, 0x9D, 0x55, 0x55, 0x55, 0x55, 0x5F, 0xFF, 0xFF, 0xD5, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0xFF, 0x4A, 0xF8, 0xAA, 0x00, 0x0A, 0xA9, 0x80, 0x00, 0x06, 0xA2, 0x7F, 0xFF, 0xFF, 0xEA, 0x00, 
	0x02, 0xBF, 0xFF, 0xFF, 0xF2, 0x85, 0xFF, 0xF2, 0x49, 0xFF, 0xF2, 0x53, 0x72, 0xD5, 0xFF, 0xFF, 
	0xD2, 0x2D, 0xA0, 0xAA, 0x90, 0xFF, 0xFF, 0xA4, 0x3D, 0x55, 0x55, 0x7C, 0x28, 0x09, 0x5F, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x78, 0x2A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFD, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x57, 0x4A, 0xF4, 0xA0, 0x00, 0x00, 0x66, 0x25, 0x57, 0xCA, 0xA2, 0x7F, 0xFF, 0xFD, 0x42, 0xA5, 
	0xA8, 0x2B, 0xFF, 0xFF, 0xFA, 0x85, 0xFF, 0xF8, 0x8B, 0xFF, 0xF2, 0xA1, 0x72, 0xD5, 0xFF, 0xFF, 
	0xD2, 0x80, 0x00, 0x02, 0xA0, 0xD5, 0xFF, 0x24, 0x35, 0x55, 0xFF, 0xFE, 0x00, 0xAF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x3D, 0x55, 0xFF, 0xFF, 0xFF, 0x56, 0xAA, 0xAA, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x57, 0xC2, 0xF4, 0xA2, 0xA5, 0x54, 0x96, 0x17, 0xFF, 0xC2, 0xA2, 0x7F, 0xFF, 0x60, 0x9F, 0xFF, 
	0xFF, 0xE0, 0x9F, 0xFF, 0xFA, 0x85, 0xFF, 0xF8, 0x8B, 0xFF, 0xF8, 0xA1, 0xBA, 0xD5, 0xFF, 0xFF, 
	0xD2, 0xA8, 0x09, 0x72, 0xA0, 0xD5, 0xFF, 0x24, 0x35, 0x55, 0xFF, 0xFB, 0xFF, 0xFD, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x35, 0x55, 0xFF, 0xF7, 0xF6, 0x00, 0x00, 0x00, 0x02, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x57, 0xC2, 0xF4, 0x82, 0xB5, 0x5E, 0x1A, 0x1F, 0xFF, 0xC2, 0xA2, 0x7F, 0xFE, 0x09, 0xFF, 0xFF, 
	0x55, 0x7D, 0x07, 0xFF, 0xFA, 0x85, 0xFF, 0xF8, 0x8B, 0xFF, 0xF8, 0xA1, 0x72, 0xD5, 0xFF, 0xFF, 
	0xD2, 0xA0, 0xBF, 0x78, 0xA0, 0xD5, 0xFF, 0x24, 0x35, 0x55, 0xFF, 0xFF, 0x7D, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x35, 0x55, 0xDF, 0xFF, 0x60, 0x28, 0x15, 0x62, 0xA8, 0x02, 0x26, 0x7F, 0xFF, 0xFF, 
	0x57, 0xC2, 0xF4, 0x81, 0x55, 0x5E, 0x19, 0x1F, 0xFF, 0xE2, 0xA2, 0x7F, 0xD0, 0x9A, 0xFD, 0xFF, 
	0x55, 0x55, 0x81, 0xFF, 0xF8, 0x85, 0xFF, 0xFA, 0x83, 0xFF, 0xF8, 0x61, 0x72, 0xD5, 0xFF, 0xFF, 
	0xD2, 0x85, 0xD5, 0x78, 0xA0, 0xD5, 0xFF, 0x24, 0xB5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xB5, 0x55, 0x7D, 0x7E, 0x0A, 0xA2, 0xF5, 0xF8, 0xAA, 0xA0, 0x2A, 0x9F, 0xBF, 0xFF, 
	0x55, 0xC2, 0xFC, 0xA1, 0x55, 0x55, 0x29, 0x2F, 0xFF, 0xE2, 0xA2, 0x7F, 0x41, 0xA5, 0x5F, 0x40, 
	0xF5, 0x55, 0xA0, 0x7F, 0xF8, 0x85, 0xFF, 0xF8, 0x83, 0xFF, 0xF8, 0x61, 0x72, 0xD5, 0xFF, 0xFF, 
	0xD2, 0x85, 0x55, 0x78, 0xA0, 0xD5, 0xFF, 0x28, 0xB5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF4, 0xB5, 0x55, 0xD8, 0xA0, 0xAA, 0xA2, 0xD9, 0xD0, 0xAA, 0x8B, 0xE7, 0x47, 0xFF, 0xFF, 
	0x55, 0xC2, 0xFE, 0x22, 0x55, 0x57, 0x85, 0x2F, 0xFF, 0xD2, 0x82, 0x7F, 0x26, 0xA4, 0x00, 0x00, 
	0x35, 0x55, 0xA8, 0x1F, 0xF8, 0x85, 0xFF, 0xF2, 0x83, 0xFF, 0xF8, 0x61, 0x72, 0xD5, 0xFF, 0xFF, 
	0xF2, 0x85, 0x55, 0x78, 0xA0, 0xD5, 0xF4, 0x98, 0xB5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF8, 0xF5, 0x57, 0xE0, 0x70, 0xAA, 0xA0, 0x55, 0x40, 0xAA, 0x8B, 0x85, 0x81, 0xEF, 0xFF, 
	0x55, 0xE2, 0xFE, 0x22, 0x55, 0x57, 0x45, 0x0F, 0xFF, 0xE2, 0x81, 0x7E, 0x1A, 0x90, 0xA8, 0x2A, 
	0x2D, 0x55, 0xAA, 0x2F, 0xF4, 0x89, 0x55, 0xE2, 0xA1, 0xFF, 0xD2, 0xA1, 0x72, 0xD5, 0xFF, 0xFF, 
	0xF2, 0x85, 0x55, 0x78, 0xA0, 0xFD, 0x42, 0x52, 0xD5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xFF, 0xF2, 0xD5, 0x57, 0xAA, 0xA0, 0xAA, 0xA8, 0x2A, 0xA8, 0xAA, 0xA2, 0x80, 0x00, 0xFB, 0xFF, 
	0x55, 0xE2, 0xFE, 0x21, 0xD7, 0xFF, 0x05, 0x87, 0x68, 0x02, 0x81, 0x7C, 0x9A, 0x90, 0xAA, 0xAA, 
	0x2D, 0x55, 0xAA, 0x07, 0xF4, 0xA0, 0x00, 0x0A, 0xA0, 0x00, 0x09, 0x43, 0xF2, 0xD5, 0xFF, 0xFF, 
	0xF2, 0x85, 0x55, 0x78, 0xA0, 0x60, 0x26, 0x0B, 0xD5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 
	0xAA, 0x91, 0xD5, 0x5F, 0x46, 0x00, 0x80, 0x00, 0xAA, 0xA0, 0xAA, 0xA0, 0x2A, 0x80, 0xBF, 0xFF, 
	0x55, 0xE2, 0x5E, 0x22, 0x55, 0xA0, 0x2A, 0x80, 0x00, 0x2A, 0x81, 0x74, 0xD5, 0x70, 0xAA, 0xAA, 
	0x1F, 0xFF, 0x55, 0xCB, 0xFC, 0x2A, 0xAA, 0xAA, 0xAA, 0xA0, 0x00, 0x02, 0xF2, 0x55, 0xFF, 0xFF, 
	0xF2, 0x89, 0x55, 0x5A, 0xA8, 0x02, 0x80, 0xAF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x54, 0xB5, 0x7D, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x93, 0xD5, 0x57, 0x42, 0xA0, 0x80, 0x00, 0x2A, 0xA0, 0xAA, 0xA2, 0xAA, 0x80, 0x2F, 0xFF, 
	0x55, 0xE2, 0x5E, 0x28, 0x00, 0x02, 0xAA, 0xAA, 0xAA, 0xAA, 0x89, 0xF8, 0xD5, 0x78, 0xAA, 0xA8, 
	0x3F, 0xFF, 0x55, 0xC3, 0xDD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xF2, 0x55, 0xFF, 0xFF, 
	0xFA, 0x85, 0x55, 0x62, 0xAA, 0xA0, 0x09, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x54, 0xB5, 0xD5, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xA3, 0xD5, 0xFF, 0x8A, 0xA0, 0x80, 0x00, 0x2A, 0xA0, 0xAA, 0xA2, 0xAA, 0x80, 0x0B, 0xFF, 
	0x55, 0xD2, 0xDD, 0x2A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x80, 0x29, 0xF8, 0xD5, 0x5E, 0x2A, 0xA8, 
	0xFF, 0xFF, 0x55, 0xE3, 0xF7, 0x6A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA9, 0xF2, 0x55, 0xFF, 0xFF, 
	0xF2, 0x85, 0x56, 0x0A, 0xAA, 0x02, 0xBF, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0x55, 0x55, 0x57, 0xDE, 0xB7, 0x4B, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x43, 0xD7, 0xD4, 0x02, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0xA7, 
	0xD5, 0xF0, 0xD7, 0x8A, 0xAA, 0x80, 0x00, 0x00, 0x00, 0x00, 0xAB, 0xF8, 0xD5, 0x5F, 0x0A, 0xA1, 
	0xEF, 0xFF, 0x55, 0x51, 0x77, 0xD5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5F, 0xF2, 0xD5, 0xFF, 0xFF, 
	0xF8, 0x85, 0x80, 0xAA, 0x80, 0xAF, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0x55, 0x55, 0x5D, 0x5E, 0xB7, 0x8B, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x43, 0x5F, 0x00, 0xAA, 0xAA, 0xAA, 0x5A, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x56, 0x61, 
	0xF5, 0xF0, 0xD7, 0x40, 0x00, 0x0A, 0x02, 0xAA, 0xAA, 0x95, 0x5F, 0xF2, 0xD5, 0x55, 0xD0, 0x07, 
	0xBF, 0xFF, 0x55, 0x72, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xD5, 0xFF, 0xFF, 
	0xF8, 0x80, 0x2A, 0xA0, 0x29, 0xFD, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0x55, 0xF5, 0x7C, 0x92, 0xBC, 0xA3, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x4B, 0x5E, 0x02, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x58, 0x7A, 
	0xBD, 0xF0, 0xD5, 0xDA, 0xA9, 0x55, 0x55, 0x55, 0x55, 0x57, 0xFF, 0x42, 0xD5, 0x55, 0x7E, 0x2D, 
	0xFF, 0xFF, 0x55, 0x70, 0x75, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xD5, 0xFF, 0xFF, 
	0xF8, 0xAA, 0xAA, 0x01, 0x7F, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xBE, 
	0xFF, 0xFF, 0x57, 0x9D, 0x78, 0xB0, 0xB4, 0xE3, 0x5F, 0xFF, 0xFE, 0x55, 0xFF, 0xFF, 0xEA, 0xAA, 
	0xAA, 0x47, 0x5E, 0x02, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x60, 0x1A, 
	0xBD, 0x70, 0xD5, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x02, 0xD5, 0x55, 0x57, 0xF5, 
	0xFF, 0xFF, 0x55, 0x78, 0xBD, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xD5, 0xFF, 0xFF, 
	0xF4, 0xAA, 0x80, 0x9F, 0xD5, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFB, 0xE5, 0xEB, 
	0xFF, 0xFF, 0x57, 0x8B, 0x7A, 0xB8, 0xB8, 0xD1, 0xFA, 0xA0, 0x0B, 0x55, 0xFF, 0xFF, 0xE0, 0x00, 
	0xAA, 0x47, 0x5E, 0x02, 0x5F, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0xA2, 
	0xBD, 0x70, 0xD5, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0xD5, 0x55, 0x55, 0x55, 
	0xFF, 0xFF, 0x55, 0x78, 0xBD, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xD5, 0xFF, 0xFF, 
	0xF4, 0x00, 0x27, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xE2, 0xFF, 0xFC, 0x35, 0xC3, 
	0xFF, 0xFF, 0x55, 0xC2, 0xDA, 0xB8, 0x3C, 0xB2, 0x00, 0x00, 0x03, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x87, 0xFD, 0x95, 0xFF, 0xF5, 0xFF, 0xFF, 0x95, 0x56, 0xFF, 0xFF, 0xFF, 0xFD, 0x61, 0x9B, 
	0x7F, 0xF8, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5D, 0x22, 0xEA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x78, 0xBD, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xD5, 0xFF, 0xFF, 
	0x5E, 0x0A, 0xBF, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xC3, 0x55, 0x5E, 0x3F, 0x69, 
	0xF4, 0x75, 0x55, 0x70, 0xDA, 0x98, 0x28, 0x30, 0x2F, 0xFF, 0xFE, 0xFF, 0x55, 0x55, 0x55, 0x55, 
	0xAA, 0x0F, 0xFD, 0x2A, 0xAA, 0xA0, 0x00, 0x00, 0x26, 0x68, 0x00, 0x00, 0xAA, 0x80, 0x62, 0x29, 
	0xFF, 0xF8, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x82, 0xEA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x78, 0x9D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x55, 0xFF, 0xFF, 
	0x57, 0xFF, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE2, 0xD5, 0x57, 0x2F, 0x56, 
	0xF4, 0x75, 0x55, 0x78, 0xAA, 0x6A, 0x2A, 0x9B, 0xF5, 0x55, 0xFF, 0xFA, 0xFF, 0xFF, 0xF5, 0x55, 
	0xAA, 0x0F, 0xFD, 0x00, 0x09, 0xF4, 0xB5, 0x5C, 0x3F, 0xF4, 0x95, 0x5A, 0xFF, 0x60, 0x60, 0x08, 
	0xBF, 0xF8, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x8A, 0xEA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x58, 0x1D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x55, 0xFF, 0xFF, 
	0x55, 0xF5, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE8, 0x55, 0x5D, 0x2F, 0x96, 
	0xF8, 0xB5, 0x55, 0x72, 0x86, 0x05, 0xBF, 0xDD, 0x55, 0x55, 0xFF, 0xF8, 0x00, 0x02, 0xAA, 0xAA, 
	0xA9, 0x0F, 0xFE, 0x22, 0x05, 0xD4, 0x95, 0x5E, 0x3F, 0xF4, 0x15, 0x5A, 0xFF, 0x60, 0x16, 0x7D, 
	0x2F, 0xF8, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x82, 0xEA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x55, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xC4, 0x35, 0x5E, 0x2F, 0x96, 
	0xDA, 0xB5, 0x7F, 0xF2, 0x0F, 0x0F, 0xD5, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0x80, 0x00, 
	0xA9, 0x2F, 0xFE, 0x00, 0x09, 0xD4, 0xB5, 0x5C, 0x3F, 0xF4, 0x95, 0x5A, 0xFF, 0x60, 0xBD, 0x3F, 
	0x27, 0xF8, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xE2, 0xEA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x55, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xCA, 0x35, 0x78, 0xAD, 0x36, 
	0xCA, 0x7F, 0x5A, 0xA2, 0xAD, 0xF5, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0x7F, 0xFF, 0xFD, 0x55, 
	0xA9, 0x2F, 0xF6, 0x00, 0x09, 0xD6, 0xB5, 0x5C, 0x3F, 0xF4, 0x95, 0x5A, 0xFF, 0x60, 0x3D, 0x2D, 
	0x27, 0xF4, 0x6A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xF8, 0x6A, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x55, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xEB, 0x2D, 0x72, 0xAC, 0xB9, 
	0xA6, 0xDA, 0x80, 0xA7, 0xF5, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 
	0xAA, 0x1F, 0xF4, 0x00, 0x09, 0xD6, 0xB5, 0x5E, 0x3F, 0xF4, 0x95, 0x5A, 0xFF, 0x62, 0x2F, 0x6E, 
	0x1F, 0xF4, 0x5A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x76, 0x6A, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xD5, 0x5C, 0x2F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xD5, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xEB, 0x0D, 0xC3, 0x94, 0xF8, 
	0x34, 0x0A, 0xBF, 0xF5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 
	0xA8, 0x3F, 0xF4, 0x00, 0x09, 0xD6, 0xB5, 0x5E, 0x3F, 0xF4, 0x95, 0x5A, 0xFF, 0x62, 0x02, 0x76, 
	0x9F, 0xF4, 0x1A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x76, 0x6A, 0xAA, 0xFF, 0xFF, 
	0xFE, 0xFC, 0xAF, 0x5C, 0x2F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xD5, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE3, 0x8F, 0x8F, 0xA9, 0xF8, 
	0xF4, 0x3F, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA8, 0x3D, 0xF4, 0x2A, 0x0B, 0xF6, 0x35, 0x5E, 0x1F, 0xF8, 0x35, 0x7A, 0xFF, 0x62, 0x90, 0x03, 
	0xBD, 0x78, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x40, 0x02, 0xDE, 0x2F, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0xF0, 0x6A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x5F, 0x57, 0xF2, 0xCB, 0x2F, 0x8B, 0x72, 
	0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xA8, 0xB5, 0xF4, 0xAA, 0x8B, 0xF6, 0x35, 0x5E, 0x1F, 0xF8, 0x15, 0x7A, 0xFF, 0x62, 0xA9, 0xA3, 
	0xF5, 0x74, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x0A, 0xA0, 0x7E, 0x2F, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0xF0, 0x6A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x78, 0x82, 0x94, 0xD1, 0x3F, 0x0D, 0x59, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xA8, 0xB5, 0xF4, 0xAA, 0x8B, 0xF6, 0x35, 0x5E, 0x1F, 0xF8, 0x35, 0x7A, 0xFF, 0x62, 0xAA, 0xA3, 
	0xD5, 0x7C, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFD, 0x2A, 0x00, 0x7E, 0x2F, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0xF0, 0x6A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x70, 0x25, 0x8A, 0xB8, 0xBE, 0x3D, 0x5D, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA8, 0x75, 0xF4, 0xAA, 0x8B, 0xF6, 0x35, 0x56, 0x1F, 0xF8, 0x15, 0x5A, 0xFF, 0x62, 0xAA, 0xA3, 
	0xF5, 0x7C, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFD, 0x28, 0x29, 0x5E, 0x2F, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0xF0, 0x6A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x56, 0x83, 0xD0, 0x38, 0xB5, 0x75, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0xA0, 0xF5, 0xF4, 0xAA, 0x8B, 0xF6, 0x15, 0x56, 0x2F, 0xFA, 0x35, 0x7A, 0xFF, 0x62, 0xAA, 0xA3, 
	0xF5, 0x7C, 0x35, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFD, 0x24, 0xBF, 0x5E, 0x2F, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0xF0, 0x6A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x5F, 0xF8, 0x7E, 0x16, 0x55, 0xD5, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xD5, 0xD5, 0x55, 0x55, 
	0xA2, 0xD5, 0xF4, 0xAA, 0x8B, 0xF6, 0x35, 0x56, 0x1F, 0xFA, 0x35, 0x7A, 0x7F, 0x62, 0xAA, 0xA1, 
	0xF5, 0x5C, 0x35, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x00, 0x75, 0x5E, 0x2F, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0xF8, 0x6A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0xF5, 0x5D, 0x37, 0x57, 0x55, 0x55, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xAA, 0xAA, 0xAA, 0xB6, 0xAA, 0xAA, 0xA6, 0x15, 0x55, 0x55, 
	0xA2, 0xD5, 0xF8, 0xAA, 0x89, 0xF6, 0x35, 0x56, 0x2F, 0xFA, 0x15, 0x5A, 0x7F, 0x62, 0xAA, 0xA1, 
	0xF5, 0x5E, 0x35, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x42, 0x55, 0x5E, 0x2F, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0xF4, 0x5A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x7D, 0xFF, 0x97, 0xD6, 0x1D, 0xD5, 0x55, 0x55, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x80, 0x00, 0x00, 0x38, 0x00, 0x00, 0x26, 0x25, 0x55, 0x55, 
	0xA2, 0xD5, 0xF8, 0xAA, 0x89, 0xF6, 0x35, 0x56, 0x2F, 0xFA, 0xA5, 0x7B, 0x7F, 0xE2, 0xAA, 0xA1, 
	0xF5, 0x5E, 0x35, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x74, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFD, 0xFF, 0x55, 0x5E, 0x2F, 0x55, 0xFF, 0xFF, 0xA7, 0xF5, 0xFF, 0xFF, 0xF4, 0x9A, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xE3, 0xAC, 0x2E, 0x00, 0x95, 0x55, 0x55, 0x55, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0xD7, 0xFF, 0xFD, 
	0xA1, 0xD5, 0xF8, 0xAA, 0x89, 0xF6, 0x1A, 0xA8, 0x1F, 0xF6, 0xA5, 0x5A, 0x5F, 0x62, 0xAA, 0xA2, 
	0x75, 0x5E, 0x35, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x7E, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x2F, 0x55, 0x55, 0x55, 0xF5, 0x2D, 0xFF, 0xFF, 0x7C, 0x9A, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5F, 0x82, 0x02, 0x8A, 0x2F, 0xD9, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFA, 0xAA, 0x80, 
	0xA1, 0xD5, 0xF0, 0xAA, 0x89, 0xF6, 0x1A, 0xA8, 0x1F, 0xF6, 0x25, 0x5A, 0x5F, 0x62, 0xAA, 0xA0, 
	0xB5, 0x5E, 0x35, 0x55, 0x55, 0x7D, 0x55, 0xFF, 0xFF, 0xFF, 0x55, 0xD8, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x2F, 0x55, 0x55, 0x5F, 0x68, 0x09, 0xFF, 0xFF, 0x5C, 0x1A, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x7E, 0xA8, 0x4B, 0x0B, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFD, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFA, 0xAA, 0xAA, 
	0x83, 0xD5, 0xD2, 0xAA, 0x89, 0xF6, 0x1A, 0xA4, 0x1F, 0xF6, 0x95, 0x5A, 0x5F, 0x62, 0xAA, 0xA0, 
	0xB5, 0x5E, 0x35, 0x55, 0x57, 0xF5, 0x5F, 0x6A, 0xFF, 0xFF, 0x57, 0xC0, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x2F, 0x55, 0x55, 0x7E, 0x20, 0xA7, 0xFF, 0xFF, 0x5C, 0x1A, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x7A, 0x4B, 0x6D, 0x7D, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xAA, 
	0xAA, 0xAA, 0xAB, 0x6A, 0xAA, 0xAA, 0xDA, 0xAA, 0xAA, 0xB6, 0xAA, 0xAA, 0x9E, 0xBF, 0xFF, 0xFF, 
	0x8B, 0x55, 0xD2, 0xAA, 0x09, 0xF4, 0x1A, 0xA4, 0x1F, 0xF6, 0xA5, 0x5A, 0x5F, 0x62, 0xAA, 0xA0, 
	0xB5, 0x5E, 0x1D, 0x55, 0x5F, 0x83, 0xF6, 0x80, 0x3F, 0xFF, 0x57, 0x48, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0x2F, 0x55, 0x55, 0x78, 0x62, 0x9F, 0xFF, 0xFF, 0x5C, 0x1A, 0xFF, 0xFF, 
	0x55, 0x57, 0xF5, 0xF5, 0x55, 0x55, 0xF1, 0x47, 0x75, 0xD5, 0x55, 0x55, 0xFF, 0xFF, 0xFE, 0x00, 
	0x00, 0x00, 0x8B, 0x4A, 0xAA, 0xA0, 0xD2, 0x8A, 0xA8, 0xB8, 0xAA, 0xAA, 0x2C, 0xBF, 0xFF, 0xFF, 
	0x8B, 0x55, 0xD2, 0xAA, 0x09, 0xF4, 0x1A, 0xA8, 0x1F, 0xF6, 0xA5, 0x5A, 0x5F, 0x62, 0xAA, 0xA8, 
	0xB5, 0x5D, 0x2D, 0x55, 0x76, 0x0B, 0xE2, 0x82, 0xBF, 0xFF, 0x57, 0x48, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0x2F, 0x55, 0x55, 0xE3, 0x8A, 0xFF, 0xFF, 0xFF, 0x5C, 0x1A, 0xFF, 0xFF, 
	0x55, 0x5D, 0x2F, 0x5F, 0xD5, 0xFD, 0x61, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8B, 0x57, 0xD2, 0xAA, 0x05, 0xF4, 0x1A, 0xA4, 0x1F, 0xF6, 0xA5, 0x58, 0x7F, 0xE2, 0x6A, 0x94, 
	0xBD, 0x5F, 0x2D, 0x55, 0xE2, 0x2F, 0x86, 0x27, 0xFF, 0xFF, 0x57, 0x68, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0x2F, 0x55, 0x57, 0xCA, 0x29, 0xFF, 0xFF, 0xFF, 0x5C, 0x1A, 0xFF, 0xFF, 
	0x7D, 0x78, 0x2E, 0x14, 0x3F, 0x60, 0xA7, 0x75, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x87, 0x5F, 0xE0, 0x00, 0x0A, 0xA8, 0x00, 0x00, 0x0A, 0xA8, 0x00, 0x00, 0x2A, 0x80, 0x00, 0x00, 
	0x0B, 0xDF, 0x2D, 0x57, 0xCA, 0x3C, 0x38, 0x9F, 0xFF, 0xFF, 0x55, 0xE0, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0x2F, 0x55, 0x57, 0x8C, 0x27, 0xFD, 0xFF, 0xFF, 0x5C, 0x1A, 0xFF, 0xFF, 
	0xEB, 0x70, 0xB8, 0x28, 0xB8, 0x0A, 0xFD, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xD7, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x87, 0x7E, 0x6A, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0x75, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xFF, 
	0x02, 0xFF, 0xAD, 0x57, 0xA8, 0x70, 0xE2, 0x7D, 0xFF, 0xFF, 0x55, 0xE0, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0x2F, 0x55, 0x57, 0x28, 0x1F, 0xE0, 0x2F, 0xFF, 0x5C, 0x1A, 0xFF, 0xFF, 
	0xE3, 0xEA, 0xAA, 0x2E, 0x02, 0x7F, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xFF, 
	0x0F, 0xF4, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x28, 0x7F, 0xAD, 0x5D, 0x30, 0xD3, 0x81, 0xD5, 0x55, 0x55, 0xFF, 0xF6, 0xB5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x27, 0x57, 0xFF, 0x98, 0x7D, 0x02, 0x9D, 0x55, 0xFE, 0x1A, 0x55, 0xF5, 
	0xE1, 0xC6, 0x2C, 0x3E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF5, 0x5A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0xBF, 0xFF, 
	0x2F, 0xFA, 0x47, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5D, 
	0x28, 0x7F, 0xAD, 0x5E, 0xB3, 0xC7, 0x0B, 0x55, 0x5F, 0x55, 0xFA, 0xFD, 0x35, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0x27, 0x7F, 0xFD, 0xBA, 0x78, 0x27, 0xFF, 0xD5, 0xFE, 0x1A, 0x57, 0xAF, 
	0xE2, 0xAE, 0x1E, 0xB5, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x2F, 0xF8, 0x8B, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5D, 
	0x28, 0x7F, 0xAF, 0xDE, 0x63, 0xAD, 0x27, 0x55, 0xFF, 0xF7, 0x60, 0xFE, 0x35, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x27, 0xDA, 0x9D, 0x9A, 0xEA, 0x1F, 0xA9, 0x75, 0xFD, 0x1A, 0x57, 0x80, 
	0xE8, 0x2D, 0xB7, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x1F, 0xF8, 0x47, 0xFF, 0xFD, 0x55, 0x75, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 
	0x28, 0x7F, 0xAF, 0xF4, 0xC5, 0x3E, 0x1D, 0x57, 0x6A, 0x5D, 0x83, 0xF6, 0xB5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0x27, 0xE0, 0x89, 0x99, 0x4C, 0xB6, 0x02, 0x75, 0xFD, 0x16, 0x55, 0xF2, 
	0x86, 0x35, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0xAA, 0xAA, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x40, 0x00, 0x00, 0x50, 0x00, 0x01, 0xF8, 0x00, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x1D, 0xF4, 0x9D, 0x55, 0x55, 0x57, 0x55, 0x55, 0x55, 0x55, 0x5A, 0x5A, 0xAA, 0xAA, 0xAA, 0xA0, 
	0x2A, 0xFF, 0x6C, 0x36, 0xC4, 0x5C, 0x1D, 0x57, 0x40, 0x2E, 0x8B, 0x42, 0xB5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x27, 0xF8, 0x98, 0x91, 0x94, 0x61, 0x09, 0xD5, 0xFD, 0x16, 0x55, 0x7A, 
	0x4B, 0x75, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0x55, 0x55, 0x55, 0x56, 
	0x55, 0x55, 0x55, 0xD5, 0x55, 0x55, 0xD5, 0x55, 0x55, 0xF5, 0x55, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA2, 0x5D, 0x0A, 0x00, 0x02, 0xA8, 0xAA, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x1F, 0xDF, 0x6E, 0x26, 0x6A, 0xD4, 0xB5, 0x55, 0xF4, 0x82, 0x4A, 0x05, 0xB5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x27, 0x5F, 0x2C, 0x1A, 0xB8, 0x2D, 0x2F, 0x55, 0xFD, 0x26, 0x5F, 0x62, 
	0xD7, 0xD5, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xB0, 0x1F, 0x80, 0x00, 0x0A, 0xA8, 0x00, 0x00, 0x0A, 0xA8, 0x2A, 0x80, 0x2A, 0xA0, 0x80, 0x00, 
	0x1F, 0x7F, 0x4D, 0x82, 0xAA, 0x78, 0x7F, 0xFF, 0xFD, 0x90, 0x42, 0xAD, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x27, 0xFF, 0xCD, 0x38, 0x78, 0x3E, 0x3F, 0xFF, 0xFD, 0x25, 0xDA, 0x07, 
	0x75, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xBA, 0x07, 0x80, 0x00, 0x02, 0xA8, 0x20, 0x2A, 0x0A, 0xA8, 0x00, 0xA0, 0x2A, 0xA0, 0x80, 0x00, 
	0x1F, 0xFF, 0x4D, 0x82, 0x49, 0x72, 0xDA, 0xAA, 0xAA, 0x24, 0x53, 0x88, 0x0A, 0xAA, 0x00, 0x0A, 
	0xAA, 0xFF, 0xFF, 0xFE, 0x2D, 0x5A, 0xA7, 0x24, 0x74, 0x5C, 0x2A, 0xA9, 0xFD, 0x18, 0x02, 0xFD, 
	0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x57, 
	0xFF, 0x6A, 0xAA, 0xAA, 0xAA, 0xAA, 0x5A, 0xA9, 0xFD, 0x55, 0x55, 0x55, 0xFE, 0xAA, 0xAA, 0xAB, 
	0xF6, 0x4B, 0x8A, 0x00, 0x02, 0xA8, 0x09, 0x0A, 0x0A, 0xA8, 0x08, 0x28, 0x2A, 0xA0, 0xAA, 0xAA, 
	0x1F, 0xFF, 0xCF, 0xA2, 0xC3, 0x78, 0x00, 0x2A, 0x00, 0x2E, 0xBF, 0x80, 0x80, 0x2A, 0xA2, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0A, 0x80, 0x3F, 0xEF, 0xBA, 0xFC, 0x0A, 0xAA, 0x08, 0x02, 0x2F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0B, 
	0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x90, 0x02, 0xFE, 0x00, 0x00, 0x00, 0xBE, 0x00, 0x00, 0x0B, 
	0xFC, 0x63, 0x8E, 0x10, 0x02, 0xA0, 0x02, 0x86, 0x0A, 0xAA, 0x0B, 0xA8, 0x2A, 0x80, 0x00, 0x00, 
	0x1F, 0xFF, 0xC6, 0x32, 0xE3, 0x7A, 0x9F, 0xFF, 0xFF, 0xFB, 0x56, 0xFF, 0xFF, 0xFF, 0xFD, 0xF5, 
	0x55, 0xAA, 0xAA, 0xAA, 0xA9, 0x5F, 0xFE, 0xFB, 0xEF, 0xFB, 0xFF, 0xFD, 0x6A, 0x2F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0x55, 0x55, 0x5F, 0x55, 0x55, 0x5F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0x58, 0xBC, 0x70, 0x8A, 0xAA, 0xA0, 0x64, 0x00, 0x00, 0x03, 0x68, 0x0A, 0xA0, 0xAA, 0xAA, 
	0x06, 0x00, 0x80, 0xB5, 0x75, 0x5F, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x5F, 0xF5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x02, 0x64, 0xB5, 0xD5, 0xFF, 0xFF, 0xF7, 0xDE, 0x9A, 0xA9, 0x55, 0xF6, 0x55, 0x7D, 0x7F, 0x55, 
	0x40, 0x00, 0x7F, 0xDD, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 
	0xA5, 0x99, 0xDF, 0x7F, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x5A, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x00, 0xBF, 0xFC, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0xFE, 
	0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
};
