#include "../include.h"

// format: Attribute compressed 4x4/2 colors 8-bit paletted pixel graphics
// compression ratio: 25%
// required memory: 8320 B pixels, 8320 B attributes (16640 B total, unpacked 66560 B)
// image width: 320 pixels
// image height: 208 lines
// image pixels pitch: 80 bytes
// image attribute pitch: 160 bytes
const u16 ImgAttr6_Pal[256] __attribute__ ((aligned(4))) = {
	0xE861, 0xC041, 0x8821, 0x1041, 0x0020, 0x6412, 0x532E, 0x95D9, 0x0331, 0x028D, 0x9E3A, 0x465E, 0x2C75, 0x8556, 0x0497, 0x03F3, 
	0x09C8, 0x3EBF, 0x3DDB, 0x3538, 0x232F, 0x4EBF, 0x428A, 0x161E, 0x157A, 0x124A, 0x2BD1, 0x4EBE, 0x4EFF, 0x56FF, 0x3208, 0x3E3C, 
	0x4EBD, 0x3F1F, 0x0945, 0x4EFE, 0x575F, 0x2145, 0x08A2, 0x5FDF, 0x67FF, 0x5570, 0x12C7, 0x44EE, 0x0C4A, 0x164E, 0x1F30, 0x5611, 
	0x1B89, 0x442B, 0x0A44, 0x3CEB, 0x348A, 0x3389, 0x44AB, 0x4CEC, 0x55AD, 0x4D2C, 0x44EB, 0x4CAB, 0x19C4, 0x2B27, 0x2245, 0x1923, 
	0x55AB, 0x4469, 0x4CAA, 0x44E9, 0x44A9, 0x4D2A, 0x664D, 0x2AC5, 0x4CEA, 0x4408, 0x3BC8, 0x556A, 0x4CE9, 0x3366, 0x4CA9, 0x0861, 
	0x18E3, 0x4D29, 0x55AA, 0x7F0E, 0x65EB, 0x5DEA, 0x08A1, 0x5DAA, 0x65AB, 0x5D2A, 0x4D27, 0x764C, 0x5CEA, 0x652B, 0x4CC7, 0x6DEB, 
	0x4C48, 0x648B, 0x656A, 0x6DAB, 0x5CA9, 0x4466, 0x1141, 0x4BA7, 0x3303, 0xDF9A, 0x2A22, 0xD736, 0x42A4, 0xB5F2, 0x2985, 0xEFF7, 
	0xE7B6, 0xCEB5, 0xEFF6, 0x52A8, 0x844D, 0xAD71, 0x6329, 0x9CEF, 0x5B03, 0xEFB7, 0xC633, 0xE791, 0xEFB5, 0xEFB6, 0x3A06, 0xF7F8, 
	0xADE2, 0x6B83, 0xDF0F, 0x73AB, 0x9D22, 0x8423, 0xEF57, 0xDF15, 0xFFF2, 0xDED4, 0xFFD4, 0xFFFA, 0xCE4F, 0xB58E, 0x18A1, 0x49E1, 
	0xFE02, 0x6AA1, 0x5A21, 0xFE45, 0xEDE5, 0x6AA2, 0x2101, 0xCCA1, 0xF5A2, 0x8322, 0x7AE2, 0x9BA3, 0xEDA5, 0xD525, 0xA3A1, 0xE522, 
	0xBC22, 0xCCA2, 0xC462, 0x49A1, 0x9362, 0xED64, 0xFDE5, 0xA3C3, 0xCCC4, 0xF5A5, 0xE565, 0xBC64, 0xAC24, 0xD4A1, 0xB3E1, 0xFD82, 
	0xED22, 0xD4A2, 0x51E1, 0x72A1, 0x6A61, 0xED65, 0xCC21, 0xE4C2, 0x82C1, 0x9B61, 0xCC62, 0xCC63, 0xE4C4, 0xBC23, 0xED24, 0xFDA5, 
	0xF565, 0x9B01, 0x3920, 0x4161, 0xB360, 0xBB80, 0xCBC0, 0xDC40, 0xFCE1, 0xDC43, 0x6A21, 0xB3A2, 0x59A1, 0xAB62, 0x8261, 0xC361, 
	0x92A1, 0xB321, 0x30E0, 0x9260, 0x71E0, 0xAAC1, 0x8A61, 0x7A21, 0x8A20, 0x61A0, 0xB2C1, 0x4920, 0xBB21, 0xCB62, 0x28E1, 0xA260, 
	0x79E0, 0x9A61, 0x71E1, 0x9220, 0x81E0, 0x71A0, 0x5940, 0x38E0, 0x79E1, 0x28A0, 0x9A20, 0x89E0, 0x79A0, 0x9221, 0xA200, 0x91E0, 
	0x6140, 0x81A0, 0x91A0, 0x7140, 0x40C0, 0x30A0, 0x9160, 0x8940, 0x38A0, 0x58C0, 0x1840, 0x2040, 0x68A0, 0x3840, 0x4840, 0x5820, 
};

const u8 ImgAttr6_Attr[8320] __attribute__ ((aligned(4))) = {
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x1A, 0x1C, 0x19, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x1C, 0x27, 0x14, 0x1C, 0x6E, 0x1C, 0xD2, 0x20, 0xE7, 0x7E, 0xF5, 0xE4, 0xF4, 0xE4, 
	0xA3, 0x24, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x24, 
	0x3E, 0x13, 0x19, 0x24, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x3D, 0x23, 0x3C, 0x29, 0x1C, 0x27, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x27, 0x16, 0x1C, 
	0xDE, 0x20, 0xDE, 0x29, 0xF5, 0xE0, 0xD2, 0xE0, 0xF4, 0xE4, 0xE0, 0xEB, 0x00, 0xE0, 0x00, 0xE0, 
	0xE6, 0xE4, 0x1E, 0x24, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x24, 
	0x35, 0x37, 0x3C, 0x39, 0x3F, 0x1C, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1F, 0x1C, 
	0x47, 0x38, 0x47, 0x43, 0x19, 0x24, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x27, 0x14, 0x1C, 0x50, 0x23, 0xF8, 0x13, 0xF5, 0xD9, 
	0xF4, 0xE4, 0xE7, 0xE4, 0x00, 0xE0, 0xF5, 0xE4, 0xE6, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 
	0x00, 0xE0, 0xF0, 0x83, 0x14, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 
	0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0x30, 0x1C, 
	0x49, 0x3A, 0x36, 0x3A, 0x3E, 0x37, 0x3E, 0x24, 0x0C, 0x24, 0x1C, 0x27, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0x30, 0x23, 
	0x68, 0x43, 0x49, 0x43, 0x3C, 0x2B, 0x1B, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x1C, 0x24, 0x14, 0x24, 0x6E, 0x23, 0xE7, 0x0C, 0xF5, 0xF0, 0xE7, 0xE4, 0xE7, 0xE4, 0xE0, 0xEB, 
	0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE5, 0xE0, 0xF8, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 
	0x00, 0xE0, 0xDB, 0xE4, 0xF4, 0x13, 0x1A, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x24, 
	0x19, 0x23, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0x14, 0x1C, 0x2A, 0x39, 
	0x36, 0x3A, 0x36, 0x3A, 0x31, 0x3A, 0x3D, 0x31, 0x3C, 0x3D, 0x10, 0x20, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x14, 0x1C, 0x3E, 0x45, 
	0x41, 0x43, 0x00, 0x43, 0x47, 0x41, 0x3E, 0x23, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x27, 0x14, 0x24, 0xC3, 0x23, 
	0xF5, 0x76, 0xF8, 0xE5, 0xF5, 0xE0, 0xE0, 0xE3, 0x00, 0xE0, 0x00, 0xE0, 0xD2, 0xE4, 0xE7, 0xE4, 
	0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 0xE7, 0xE4, 0xE0, 0xEB, 0xF4, 0xE0, 
	0xF4, 0xEB, 0xE7, 0xE4, 0xE0, 0xEB, 0xF0, 0x83, 0x1A, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1A, 0x24, 
	0x2A, 0x29, 0x1A, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x24, 0x30, 0x1C, 0x3D, 0x38, 0x31, 0x3A, 
	0x00, 0x3A, 0x31, 0x3A, 0x00, 0x3A, 0x35, 0x3A, 0x3F, 0x13, 0x10, 0x23, 0x1C, 0x27, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x27, 0x3D, 0x2F, 0x43, 0x40, 
	0x49, 0x43, 0x44, 0x43, 0x4D, 0x43, 0x3C, 0x3D, 0x19, 0x24, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x24, 0x14, 0x1C, 0xC3, 0x20, 0xE7, 0x06, 0xE9, 0xEC, 0xE7, 0xE0, 
	0xE6, 0xE0, 0xF5, 0xE4, 0xE7, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0xFF, 0xE0, 0xE6, 0x8D, 0xC3, 0x79, 
	0xB2, 0x7F, 0xFE, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE6, 0xE4, 0xFB, 0xEC, 0xF5, 0xEC, 0xF4, 0xE0, 
	0xE0, 0xE3, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE6, 0x74, 0x12, 0x24, 0x1A, 0x1C, 0x2A, 0x2F, 
	0x31, 0x2B, 0x3C, 0x2F, 0x14, 0x1C, 0x15, 0x1C, 0x19, 0x23, 0x2A, 0x20, 0x3E, 0x29, 0x3A, 0x39, 
	0x3A, 0x39, 0x35, 0x37, 0x47, 0x37, 0x3E, 0x37, 0x3E, 0x36, 0x3E, 0x24, 0x15, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x24, 0x35, 0x23, 0x6A, 0x43, 0x00, 0x43, 
	0x00, 0x43, 0x41, 0x43, 0x43, 0x45, 0x3D, 0x41, 0x3C, 0x35, 0x22, 0x24, 0x15, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 
	0x1F, 0x24, 0x6E, 0x1C, 0xE6, 0x1F, 0xF5, 0xE2, 0xF5, 0xE5, 0xE7, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 
	0x00, 0xE0, 0x00, 0xE0, 0xF5, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0xC2, 0xB3, 0x6D, 0x7F, 0x25, 0x86, 
	0x6E, 0x79, 0xE6, 0x71, 0xDB, 0xE4, 0xF4, 0xE4, 0xE7, 0xE4, 0x00, 0xE0, 0xE7, 0xE4, 0xF5, 0xE4, 
	0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xA3, 0x1F, 0x2A, 0x12, 0x35, 0x2B, 
	0x3C, 0x2B, 0x3E, 0x2B, 0x3F, 0x20, 0x1C, 0x24, 0x1F, 0x1C, 0x2A, 0x24, 0x47, 0x39, 0x3E, 0x37, 
	0x3E, 0x39, 0x3E, 0x3A, 0x4A, 0x3A, 0x3D, 0x39, 0x35, 0x37, 0x3E, 0x20, 0x14, 0x24, 0x15, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x0B, 0x1C, 0x2A, 0x20, 0x4D, 0x43, 0x00, 0x43, 0x00, 0x43, 
	0x00, 0x43, 0x44, 0x43, 0x00, 0x43, 0x4D, 0x43, 0x47, 0x3D, 0x66, 0x35, 0x19, 0x24, 0x15, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0x16, 0x1C, 0xC3, 0x23, 
	0xF5, 0x73, 0xF5, 0xE0, 0xE7, 0xE0, 0xF4, 0xE4, 0xDB, 0xD0, 0xE7, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 
	0x00, 0xE0, 0x00, 0xE0, 0xDB, 0xE0, 0xE7, 0xE4, 0xE0, 0xE3, 0xE6, 0x8C, 0x83, 0x79, 0x6E, 0x86, 
	0x7E, 0x83, 0x77, 0x7F, 0xF4, 0xA4, 0xE0, 0xEB, 0x00, 0xE0, 0xE7, 0xE0, 0xDB, 0xE4, 0xE7, 0xE4, 
	0xE9, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xF4, 0xE4, 0x3E, 0x13, 0x3E, 0x2B, 
	0x35, 0x2B, 0x3D, 0x2B, 0x3F, 0x35, 0x19, 0x24, 0x14, 0x24, 0x3C, 0x39, 0x3E, 0x37, 0x3A, 0x39, 
	0x00, 0x3A, 0x31, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x3D, 0x3B, 0x3C, 0x35, 0x19, 0x24, 
	0x00, 0x1C, 0x12, 0x1C, 0x2A, 0x1C, 0x47, 0x29, 0x3E, 0x51, 0x41, 0x43, 0x49, 0x43, 0x41, 0x43, 
	0x00, 0x43, 0x41, 0x43, 0x00, 0x43, 0x49, 0x43, 0x3D, 0x48, 0x47, 0x3D, 0x66, 0x4D, 0x3C, 0x23, 
	0x1F, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0x6E, 0x1C, 0xFA, 0xCC, 0xF5, 0xE5, 
	0xF4, 0xD0, 0xDB, 0xD0, 0xF9, 0xE0, 0xDB, 0xD3, 0xD9, 0x9F, 0xE7, 0xE4, 0xE7, 0xE4, 0x00, 0xE0, 
	0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 0xE7, 0xAC, 0x7E, 0x82, 0x74, 0x8A, 0x74, 0x7F, 
	0x7E, 0x7F, 0x86, 0x79, 0xE6, 0x86, 0xE0, 0xEB, 0xFD, 0xF6, 0xF8, 0x01, 0xFF, 0x01, 0xE0, 0xEB, 
	0xE7, 0xEB, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE0, 0xE3, 0xC3, 0x2B, 0x14, 0x2B, 
	0x00, 0x2B, 0x00, 0x2B, 0x35, 0x2B, 0x3F, 0x49, 0x3E, 0x3A, 0x36, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 
	0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x36, 0x3A, 0x3A, 0x37, 0x36, 0x39, 0x3F, 0x36, 0x3C, 0x31, 
	0x00, 0x1C, 0x12, 0x1C, 0x3E, 0x1C, 0x19, 0x24, 0x47, 0x29, 0x3E, 0x45, 0x3C, 0x44, 0x43, 0x4B, 
	0x43, 0x45, 0x4A, 0x4C, 0x00, 0x43, 0x41, 0x43, 0x3E, 0x45, 0x3E, 0x4A, 0x3C, 0x3D, 0x19, 0x24, 
	0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x14, 0x1C, 0xF4, 0x76, 0xC2, 0xA4, 0xE7, 0xD8, 
	0xE6, 0xD8, 0xE6, 0x9F, 0xDB, 0xE4, 0xE6, 0xD5, 0xE6, 0xE4, 0xE6, 0xE4, 0xE7, 0xEB, 0x00, 0xE0, 
	0x00, 0xE0, 0xE6, 0xE4, 0xF4, 0xE4, 0xF4, 0xE4, 0xF8, 0xD6, 0xDE, 0x7B, 0x76, 0x82, 0x83, 0x79, 
	0x76, 0x79, 0x78, 0x8C, 0x95, 0x84, 0xF8, 0xE4, 0xFF, 0x01, 0xFF, 0x01, 0xF8, 0xF6, 0x00, 0xE0, 
	0xE6, 0xE4, 0xE7, 0xE4, 0x00, 0xE0, 0xE0, 0xEB, 0xE7, 0xE4, 0xD2, 0xE4, 0xF0, 0xEB, 0xC3, 0x37, 
	0x31, 0x2B, 0x3C, 0x2B, 0x47, 0x37, 0x3E, 0x39, 0x3E, 0x37, 0x31, 0x3A, 0x36, 0x3A, 0x00, 0x3A, 
	0x00, 0x3A, 0x31, 0x3A, 0x3A, 0x37, 0x3E, 0x39, 0x3E, 0x49, 0x3F, 0x49, 0x47, 0x37, 0x3D, 0x35, 
	0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0x1A, 0x24, 0x3C, 0x43, 0x47, 0x45, 0x3E, 0x45, 0x47, 0x43, 
	0x3C, 0x4C, 0x3E, 0x43, 0x3E, 0x43, 0x3C, 0x41, 0x47, 0x4B, 0x3C, 0x43, 0x3D, 0x44, 0x6A, 0x31, 
	0x14, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x24, 0xDB, 0x20, 0xE7, 0xA4, 0x9B, 0xB5, 0xC3, 0xAA, 
	0xE9, 0xE0, 0xE0, 0xE4, 0xF4, 0xE0, 0xDB, 0xE4, 0xE7, 0xE4, 0xE6, 0xB1, 0xFB, 0xE5, 0xFA, 0xE0, 
	0xF4, 0xE4, 0xDB, 0xE4, 0xE0, 0xEB, 0x00, 0xE0, 0x00, 0xE0, 0xDE, 0xD6, 0x73, 0x7B, 0x78, 0x82, 
	0x81, 0x84, 0x00, 0x84, 0x84, 0x80, 0xE6, 0x84, 0xE6, 0xE4, 0xC2, 0xE4, 0xDB, 0xE0, 0x00, 0xE0, 
	0xE0, 0xE3, 0xF5, 0xEB, 0xE7, 0xE4, 0xF4, 0xEB, 0xF4, 0xE4, 0xF0, 0xE4, 0xCC, 0xB1, 0xE7, 0xEB, 
	0x6E, 0x2B, 0x35, 0x2B, 0x3E, 0x2B, 0x47, 0x29, 0x3D, 0x39, 0x3E, 0x37, 0x35, 0x3A, 0x00, 0x3A, 
	0x00, 0x3A, 0x35, 0x3A, 0x3E, 0x39, 0x3E, 0x39, 0x47, 0x3A, 0x49, 0x3A, 0x00, 0x3A, 0x3D, 0x3A, 
	0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0x2A, 0x2F, 0x43, 0x4B, 0x47, 0x51, 0x47, 0x43, 0x3E, 0x43, 
	0x43, 0x40, 0x00, 0x43, 0x00, 0x43, 0x43, 0x45, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x4D, 0x43, 
	0x3E, 0x29, 0x14, 0x1C, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0x7E, 0x24, 0xDB, 0xB8, 0x9D, 0xC0, 0x00, 0xA5, 0x99, 0xB5, 
	0xE7, 0xCE, 0xE7, 0xE4, 0xF0, 0xA1, 0xE7, 0xD8, 0xF4, 0xE4, 0xF4, 0xEB, 0xE6, 0xE4, 0xE0, 0xE3, 
	0xF5, 0xE4, 0xE0, 0xEB, 0x00, 0xE0, 0xD2, 0xE4, 0xF8, 0xEE, 0xE6, 0xE0, 0xE6, 0x8D, 0x76, 0x7B, 
	0x85, 0x84, 0x00, 0x84, 0x00, 0x84, 0xA3, 0x84, 0xF5, 0xE6, 0xE6, 0xE0, 0xF4, 0xE0, 0xF4, 0xE4, 
	0xE7, 0xE4, 0xF0, 0xE0, 0xE7, 0xE4, 0xF4, 0xEB, 0xCC, 0xB1, 0xE6, 0xD5, 0xE6, 0xCD, 0xF0, 0xE0, 
	0xF4, 0x95, 0x19, 0x2B, 0x35, 0x2B, 0x3C, 0x36, 0x3E, 0x3A, 0x3D, 0x3A, 0x36, 0x3A, 0x36, 0x3A, 
	0x36, 0x3A, 0x00, 0x3A, 0x31, 0x3A, 0x31, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x31, 0x3A, 0x36, 0x3A, 
	0x00, 0x1C, 0x15, 0x1C, 0x35, 0x24, 0x3E, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 
	0x00, 0x43, 0x00, 0x43, 0x49, 0x43, 0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 0x00, 0x43, 0x00, 0x43, 
	0x4A, 0x43, 0x3E, 0x2B, 0x19, 0x24, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x19, 0x24, 0xE7, 0xB3, 0xB3, 0x9D, 0xA5, 0xA9, 0x00, 0xA5, 0xA5, 0xA9, 
	0xC3, 0x9D, 0xD2, 0xA7, 0xF5, 0xE0, 0xE7, 0xE4, 0xDB, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 
	0xF5, 0xE0, 0xE7, 0xE4, 0xF8, 0xEB, 0xFC, 0x00, 0xF4, 0x00, 0xC3, 0xE4, 0xF3, 0xE0, 0xB2, 0x8C, 
	0x92, 0x84, 0x84, 0x80, 0x78, 0x84, 0xA3, 0x84, 0xE9, 0xB4, 0xE9, 0xE6, 0xE7, 0xF0, 0xE0, 0xE4, 
	0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 0xE6, 0xE4, 0xDB, 0xE4, 0xDB, 0xC6, 0xE5, 0xE0, 
	0xF9, 0xE4, 0xDE, 0x76, 0x3E, 0x2B, 0x41, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x31, 0x3A, 0x41, 0x3A, 
	0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x36, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 
	0x00, 0x1C, 0x14, 0x24, 0x47, 0x39, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 0x49, 0x43, 
	0x00, 0x43, 0x4D, 0x43, 0x4D, 0x43, 0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 0x43, 0x45, 0x00, 0x43, 
	0x00, 0x43, 0x4A, 0x43, 0x3C, 0x4A, 0x19, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x12, 0x24, 0xE6, 0x83, 0xB2, 0x9D, 0xA5, 0xA9, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0xCA, 0xAA, 0xE7, 0xCE, 0xD2, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 
	0x00, 0xE0, 0xF5, 0xE4, 0xE6, 0xE4, 0xF4, 0xE0, 0xE7, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0xF4, 0xD7, 
	0xC3, 0x80, 0xF4, 0x85, 0xF5, 0xE6, 0xFE, 0xE6, 0x00, 0xE6, 0xE9, 0xE6, 0xE6, 0xE5, 0x00, 0xE0, 
	0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xF0, 0xE0, 0xE7, 0xE4, 0xE5, 0xE0, 0xE7, 0xD3, 0xE7, 0xD8, 
	0xA3, 0x9F, 0xF4, 0xE3, 0x3C, 0x39, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x31, 0x3A, 0x36, 0x3A, 
	0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 
	0x19, 0x24, 0x66, 0x39, 0x43, 0x45, 0x49, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 
	0x4D, 0x43, 0x47, 0x49, 0x4A, 0x43, 0x00, 0x43, 0x00, 0x43, 0x49, 0x43, 0x3F, 0x41, 0x3E, 0x44, 
	0x3E, 0x41, 0x3C, 0x29, 0x19, 0x1C, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x15, 0x1C, 0xC3, 0x20, 0xC2, 0xB8, 0xA4, 0xB5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0xA8, 0xA5, 0xB2, 0xA8, 0xD2, 0xB8, 0xF4, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 
	0x00, 0xE0, 0xE0, 0xE3, 0xF5, 0xE4, 0x00, 0xE0, 0xE0, 0xEB, 0xF4, 0xE0, 0xF4, 0xEB, 0xE7, 0xE4, 
	0xF5, 0xE4, 0xE6, 0xE4, 0xE6, 0xE0, 0xE6, 0xD4, 0xDB, 0xE5, 0xDB, 0xE0, 0xE7, 0xE4, 0x00, 0xE0, 
	0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xF4, 0xE4, 0xF8, 0xEB, 0xCC, 0x9F, 0xEC, 0xE0, 
	0xF5, 0xD8, 0xDB, 0xE4, 0xDE, 0x78, 0x3E, 0x3A, 0x3E, 0x36, 0x3C, 0x36, 0x35, 0x3A, 0x00, 0x3A, 
	0x35, 0x3A, 0x36, 0x3A, 0x00, 0x3A, 0x31, 0x3A, 0x3E, 0x37, 0x3D, 0x3A, 0x3D, 0x3A, 0x3C, 0x36, 
	0x3C, 0x45, 0x3E, 0x3A, 0x3E, 0x3A, 0x49, 0x43, 0x00, 0x43, 0x00, 0x43, 0x4A, 0x43, 0x3D, 0x43, 
	0x3C, 0x4A, 0x3C, 0x45, 0x3E, 0x49, 0x3E, 0x41, 0x3C, 0x44, 0x3C, 0x43, 0x3E, 0x45, 0x3E, 0x44, 
	0x47, 0x43, 0x3C, 0x35, 0x3F, 0x1C, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 
	0x7E, 0x1C, 0xE7, 0xB8, 0xAB, 0x9C, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0xA5, 0xA9, 0xA3, 0xA8, 0xE9, 0xD8, 0xE5, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 
	0x00, 0xE0, 0xE0, 0xE3, 0xE9, 0xE4, 0xFA, 0xE0, 0xF4, 0xE4, 0xE6, 0xE4, 0xDB, 0xD0, 0xDB, 0xE4, 
	0xF4, 0xD8, 0xE7, 0xEB, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xF5, 0xE4, 0xE7, 0xE4, 
	0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE9, 0xE4, 0xDB, 0xE4, 0xE7, 0xE4, 
	0xE7, 0xE4, 0xF4, 0xE4, 0xF9, 0xE4, 0xA3, 0x37, 0x3D, 0x39, 0x47, 0x38, 0x3E, 0x37, 0x3C, 0x3A, 
	0x3E, 0x37, 0x00, 0x3A, 0x36, 0x3A, 0x36, 0x3A, 0x35, 0x3A, 0x3C, 0x3A, 0x3C, 0x3A, 0x4A, 0x3A, 
	0x13, 0x24, 0x19, 0x23, 0x3E, 0x4C, 0x3C, 0x44, 0x3E, 0x43, 0x3E, 0x49, 0x3E, 0x41, 0x3E, 0x45, 
	0x43, 0x4B, 0x00, 0x43, 0x00, 0x43, 0x43, 0x45, 0x3D, 0x51, 0x47, 0x45, 0x4A, 0x43, 0x43, 0x4B, 
	0x43, 0x45, 0x3D, 0x43, 0x3C, 0x35, 0x19, 0x24, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1A, 0x24, 
	0xF4, 0x81, 0xCC, 0xA8, 0xA5, 0xA9, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xBD, 0xA5, 0xDB, 0xA8, 0xE9, 0xE4, 0x00, 0xE0, 0xE0, 0xEB, 
	0xE7, 0xE4, 0xE7, 0xE4, 0xF5, 0xE4, 0xE7, 0xE4, 0xF5, 0xE4, 0xDB, 0xE4, 0xE6, 0xC6, 0xE6, 0xCE, 
	0xF0, 0xB1, 0xE7, 0xE4, 0xDB, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xF5, 0xE4, 
	0xE0, 0xE3, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 0xF4, 0xEB, 0xE9, 0xE4, 0xF5, 0xE4, 0xDB, 0xE4, 
	0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xF8, 0xE4, 0x6E, 0x39, 0x47, 0x37, 0x3E, 0x37, 0x3A, 0x39, 
	0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x36, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 
	0x15, 0x1C, 0x3D, 0x20, 0x43, 0x45, 0x4A, 0x43, 0x41, 0x43, 0x43, 0x4B, 0x00, 0x43, 0x00, 0x43, 
	0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 0x49, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 
	0x00, 0x43, 0x00, 0x43, 0x3D, 0x43, 0x3C, 0x3D, 0x3E, 0x20, 0x12, 0x24, 0x15, 0x1C, 0xCC, 0x1F, 
	0xA3, 0xA8, 0xA5, 0xA9, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x81, 0xA5, 
	0x95, 0xA9, 0xA5, 0xA9, 0x00, 0xA5, 0x00, 0xA5, 0xA8, 0xA5, 0xC2, 0xB9, 0xF5, 0xE4, 0xE7, 0xE4, 
	0xDB, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 0xE6, 0x9E, 0xE6, 0xD0, 0xDB, 0xDC, 
	0xF8, 0xE4, 0xD9, 0xB1, 0xE7, 0xEC, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xF5, 0xE4, 
	0xE9, 0xE4, 0xF4, 0xE4, 0xF4, 0xEB, 0xE7, 0xE4, 0xE0, 0xEB, 0x00, 0xE0, 0xE7, 0xE4, 0xF4, 0xE4, 
	0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xF8, 0xD7, 0x35, 0x39, 0x00, 0x3A, 0x35, 0x37, 
	0x31, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x36, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 
	0x30, 0x24, 0x3E, 0x51, 0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 0x41, 0x43, 0x00, 0x43, 0x41, 0x43, 
	0x41, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 
	0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x3D, 0x43, 0x47, 0x49, 0x3C, 0x31, 0x6E, 0x20, 0xF4, 0xCE, 
	0xA4, 0xB5, 0x00, 0xA5, 0x00, 0xA5, 0x81, 0x9C, 0xF6, 0x9C, 0x01, 0x94, 0xFC, 0xAA, 0xF9, 0x00, 
	0x02, 0x00, 0x01, 0xAB, 0xA5, 0xA6, 0x00, 0xA5, 0x00, 0xA5, 0x9A, 0xA5, 0xC2, 0xAA, 0xDB, 0xE4, 
	0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xDB, 0xE0, 0xE7, 0xE4, 0xE7, 0xE4, 0xF4, 0xD8, 
	0xE7, 0xE4, 0xF4, 0xD8, 0xDB, 0xE4, 0xE7, 0xE4, 0xE0, 0xEB, 0xE7, 0xE0, 0xE7, 0xEB, 0xE7, 0xE4, 
	0xDB, 0xEB, 0xF4, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 
	0xF4, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE0, 0xEB, 0x6E, 0x64, 0x3B, 0x3A, 0x31, 0x3A, 
	0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x31, 0x3A, 0x35, 0x37, 0x35, 0x3A, 0x35, 0x3A, 0x36, 0x3A, 
	0x66, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x4A, 0x43, 0x44, 0x43, 0x00, 0x43, 0x41, 0x43, 
	0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 
	0x44, 0x43, 0x4A, 0x45, 0x3C, 0x48, 0x3C, 0x43, 0x3C, 0x41, 0x3C, 0x48, 0xC2, 0xCE, 0x9B, 0xB5, 
	0xA5, 0xA6, 0x00, 0xA5, 0xA5, 0xA6, 0x01, 0x9D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xB4, 0xA9, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xB3, 0xAA, 0xE7, 0xD8, 
	0xE6, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 0xF4, 0xD3, 0xF0, 0xAE, 
	0xE6, 0xA1, 0xE7, 0xE0, 0xF4, 0xE4, 0xE9, 0xE4, 0xE7, 0xE3, 0xDB, 0xD8, 0xDB, 0xE4, 0xF4, 0xD8, 
	0xD9, 0xB1, 0xE7, 0xEB, 0xF0, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE0, 0xEB, 
	0xD2, 0xE4, 0x00, 0xE0, 0xE0, 0xE3, 0xF4, 0xE4, 0xE7, 0xD0, 0x7E, 0x39, 0x00, 0x3A, 0x00, 0x3A, 
	0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x36, 0x3A, 0x31, 0x3A, 0x36, 0x3A, 
	0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x43, 0x45, 0x49, 0x43, 0x44, 0x43, 0x00, 0x43, 0x00, 0x43, 
	0x41, 0x43, 0x41, 0x43, 0x44, 0x43, 0x00, 0x43, 0x4A, 0x43, 0x4D, 0x43, 0x41, 0x43, 0x43, 0x45, 
	0x43, 0x45, 0x43, 0x45, 0x3E, 0x45, 0x3C, 0x44, 0x41, 0x45, 0xE7, 0x95, 0xA3, 0xA7, 0xAB, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x02, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xFC, 0x00, 0x85, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xA8, 0xA5, 0xCC, 0xAA, 
	0xD2, 0xE5, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xEB, 0xE5, 0xE4, 
	0xF5, 0xE4, 0xE7, 0xE4, 0xE6, 0xE4, 0x00, 0xE0, 0xD2, 0xE4, 0xDB, 0xC5, 0xDB, 0xA1, 0xE6, 0xE4, 
	0xDB, 0xD8, 0xF0, 0xE0, 0xE7, 0xEB, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 
	0xF5, 0xE4, 0xDB, 0xAE, 0xDB, 0xAE, 0xCA, 0xBA, 0xBA, 0xB7, 0x6C, 0x5C, 0x00, 0x3A, 0x36, 0x3A, 
	0x31, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 
	0x3E, 0x4C, 0x47, 0x43, 0x3E, 0x41, 0x3C, 0x41, 0x3E, 0x45, 0x00, 0x43, 0x00, 0x43, 0x4A, 0x43, 
	0x3D, 0x44, 0x44, 0x43, 0x44, 0x43, 0x00, 0x43, 0x00, 0x43, 0x49, 0x43, 0x3E, 0x45, 0x3E, 0x44, 
	0x3E, 0x43, 0x3E, 0x44, 0x3E, 0x51, 0x43, 0x4B, 0xC2, 0x41, 0xA3, 0xBD, 0xAB, 0xC0, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x78, 0xA5, 0xF6, 0xAA, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xFC, 0x00, 0xD9, 0xA9, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xA5, 0xBF, 
	0xD2, 0xB8, 0xE7, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xDB, 0xE4, 0xF5, 0xE4, 0xE9, 0xE0, 
	0xF4, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 0xE0, 0xEB, 0xDB, 0xE1, 
	0xDB, 0xE4, 0xE6, 0xD0, 0xE7, 0xD3, 0xF8, 0xE4, 0x00, 0xE0, 0xE0, 0xEB, 0xDB, 0xE4, 0xF4, 0xB8, 
	0xA3, 0xBA, 0xBA, 0xAD, 0xBA, 0xAD, 0x00, 0xBA, 0x00, 0xBA, 0x6C, 0x84, 0x00, 0x3A, 0x00, 0x3A, 
	0x35, 0x37, 0x47, 0x36, 0x31, 0x3A, 0x3A, 0x37, 0x3A, 0x37, 0x3A, 0x37, 0x3A, 0x37, 0x3A, 0x39, 
	0x43, 0x40, 0x00, 0x43, 0x3E, 0x45, 0x3E, 0x48, 0x3E, 0x43, 0x3E, 0x43, 0x3E, 0x43, 0x3C, 0x43, 
	0x4D, 0x43, 0x00, 0x43, 0x00, 0x43, 0x44, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 
	0x44, 0x43, 0x00, 0x43, 0x44, 0x43, 0xC3, 0x45, 0xF5, 0xD7, 0x99, 0xAA, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xA5, 0xA6, 0xE5, 0x9C, 0x01, 0xA8, 0x01, 0xAA, 
	0x99, 0x9C, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x9A, 0xB5, 0xD2, 0xCD, 0xD2, 0xE4, 0xE7, 0xE4, 0xE7, 0xE4, 0xE7, 0xE4, 0xE0, 0xEB, 0x00, 0xE0, 
	0xF4, 0xE4, 0xEC, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE0, 0xF4, 0xEB, 0xE6, 0xB6, 
	0xE6, 0xE0, 0xE7, 0xD8, 0xCC, 0xAD, 0xF5, 0xD3, 0xDB, 0xCE, 0xDB, 0xAE, 0x91, 0xBA, 0xAE, 0xBA, 
	0xA2, 0xB7, 0xC2, 0xAD, 0xC2, 0xBA, 0xB3, 0xBA, 0x00, 0xBA, 0x6C, 0xAB, 0x3C, 0x3A, 0x3F, 0x36, 
	0x3E, 0x37, 0x3C, 0x62, 0x47, 0x58, 0x47, 0x59, 0x3E, 0x49, 0x3C, 0x49, 0x3C, 0x49, 0x3E, 0x5D, 
	0x00, 0x43, 0x00, 0x43, 0x43, 0x40, 0x43, 0x4B, 0x43, 0x45, 0x43, 0x4B, 0x44, 0x43, 0x00, 0x43, 
	0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x49, 0x43, 0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 0x00, 0x43, 
	0x41, 0x43, 0x41, 0x43, 0x3E, 0x43, 0xD2, 0x95, 0xB2, 0xA8, 0xAC, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xA5, 0xA9, 0xAC, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x92, 0xAA, 0xD2, 0xD8, 0xE6, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0xDB, 0xE0, 0xDB, 0xE4, 
	0xDB, 0xE0, 0xE7, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 0xE6, 0xA2, 
	0xE6, 0xE4, 0xF4, 0xE4, 0xDB, 0xC1, 0xB3, 0x97, 0xBA, 0x97, 0xBA, 0xB1, 0xB2, 0xB1, 0xDB, 0xBA, 
	0xE9, 0xB4, 0xDE, 0x14, 0xF8, 0xCC, 0xC3, 0xBA, 0x00, 0xBA, 0x6C, 0xAB, 0x4D, 0x5F, 0x67, 0x5F, 
	0x64, 0x54, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x58, 0x5B, 0x58, 0x5B, 0x58, 0x5B, 0x00, 0x58, 
	0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 0x41, 0x43, 0x00, 0x43, 
	0x00, 0x43, 0x41, 0x43, 0x00, 0x43, 0x44, 0x43, 0x00, 0x43, 0x00, 0x43, 0x4A, 0x43, 0x4A, 0x43, 
	0x00, 0x43, 0x43, 0x4B, 0xC3, 0x67, 0xDB, 0xCE, 0xAC, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x9D, 0xA5, 0xA3, 0xAA, 0xE7, 0xD8, 0xF5, 0xE0, 0xFF, 0xF2, 0xFF, 0x01, 0xFF, 0x01, 
	0xD4, 0xE0, 0xE7, 0xE4, 0xE0, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xE0, 0xF8, 0xE4, 0xE7, 0xCD, 
	0xE6, 0xA0, 0xB3, 0xBA, 0xA0, 0xBA, 0x91, 0xBA, 0xDB, 0xA1, 0xDE, 0xD0, 0xFB, 0x7E, 0xE7, 0x7E, 
	0x19, 0x0F, 0x0F, 0x0E, 0xF8, 0x7E, 0xA3, 0xBA, 0x00, 0xBA, 0x78, 0xB1, 0x58, 0x5B, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x44, 0x43, 0x00, 0x43, 
	0x00, 0x43, 0x44, 0x43, 0x00, 0x43, 0x00, 0x43, 0x44, 0x43, 0x00, 0x43, 0x00, 0x43, 0x4D, 0x43, 
	0x3D, 0x43, 0x6E, 0x45, 0xE7, 0xA4, 0x99, 0xB5, 0xA5, 0xA9, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0xB4, 0xB5, 0xD2, 0xD7, 0xF9, 0xF2, 0x01, 0x00, 0x01, 0x00, 0xF9, 0x01, 
	0x00, 0xE0, 0xDB, 0xE4, 0xDB, 0xE4, 0xE0, 0xEB, 0xF4, 0xE4, 0xDB, 0xD0, 0xA3, 0xBA, 0xA0, 0xBA, 
	0xBA, 0xAD, 0x00, 0xBA, 0x00, 0xBA, 0xDB, 0x97, 0xDE, 0x14, 0x09, 0x0F, 0x3F, 0x0F, 0xC3, 0x0E, 
	0x00, 0x0F, 0x0F, 0x0E, 0xDE, 0xB2, 0xA3, 0xB1, 0x00, 0xBA, 0x9A, 0xB1, 0x58, 0x46, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x43, 0x41, 0x43, 0x4A, 0x43, 0x00, 0x43, 0x00, 0x43, 0x4D, 0x43, 0x41, 0x43, 0x00, 0x43, 
	0x00, 0x43, 0x44, 0x43, 0x00, 0x43, 0x00, 0x43, 0x49, 0x43, 0x4A, 0x43, 0x00, 0x43, 0x00, 0x43, 
	0x3D, 0x45, 0xC3, 0xE8, 0xE6, 0xAC, 0xA5, 0xA9, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0xA5, 0xA9, 0xB2, 0xAA, 0xE9, 0xE0, 0xF9, 0xE4, 0xF9, 0xEB, 0xF4, 0xE0, 
	0x00, 0xE0, 0xF4, 0xE4, 0xDB, 0xA2, 0xDB, 0xBA, 0xB3, 0xAD, 0xB8, 0xB1, 0xE7, 0xBA, 0xDB, 0xAD, 
	0xBA, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 0xDB, 0xA2, 0x25, 0x0F, 0x00, 0x0F, 0x3F, 0x0F, 0xDE, 0x7E, 
	0x50, 0x0F, 0xDE, 0x73, 0xE6, 0xD9, 0xCC, 0xB1, 0x00, 0xBA, 0x95, 0xBA, 0x58, 0x54, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x3D, 0x43, 0x4D, 0x43, 0x00, 0x43, 0x00, 0x43, 
	0x43, 0x45, 0x4D, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 0x00, 0x43, 0x43, 0x4B, 
	0xC2, 0x60, 0xC2, 0xA7, 0xA7, 0xC0, 0xA5, 0xA6, 0xA5, 0xA6, 0xAB, 0xA9, 0x99, 0xA9, 0x92, 0xC0, 
	0xA3, 0xAA, 0x99, 0xA9, 0xA5, 0xC0, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xB3, 0xA5, 0xCA, 0xA9, 0xCC, 0xA9, 0xCC, 0xAA, 
	0xE6, 0x9D, 0xD9, 0x9D, 0xE6, 0x9D, 0xB4, 0xA9, 0xD2, 0xA4, 0xE7, 0xE4, 0xF8, 0xE4, 0xDB, 0xE4, 
	0xE6, 0xAE, 0xB2, 0xBA, 0xA4, 0xB1, 0xE7, 0xBA, 0xDB, 0x9E, 0xE9, 0xCC, 0xDE, 0x16, 0xF5, 0xF0, 
	0xB9, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 0xDB, 0xBA, 0x25, 0x0F, 0x22, 0x0F, 0xDE, 0x16, 0xE6, 0xD9, 
	0xDE, 0x16, 0x50, 0x0F, 0xDE, 0xE6, 0xE9, 0xA2, 0x00, 0xBA, 0x78, 0xBA, 0x40, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x43, 0x45, 0x41, 0x43, 0x4D, 0x43, 0x3C, 0x49, 0x3E, 0x43, 0x00, 0x43, 0x00, 0x43, 0x41, 0x43, 
	0x47, 0x48, 0x4D, 0x43, 0x44, 0x43, 0x00, 0x43, 0x00, 0x43, 0x00, 0x43, 0x44, 0x43, 0x8F, 0x45, 
	0xE9, 0xE0, 0xB4, 0xAA, 0xCC, 0xA9, 0xE6, 0xBB, 0x96, 0xD4, 0xDE, 0xE0, 0xE7, 0xE2, 0xDB, 0x73, 
	0x6E, 0xB4, 0xE7, 0xE2, 0xB2, 0xA8, 0xA5, 0xA9, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xD9, 0xAA, 0x6E, 0x1A, 0x19, 0x18, 0xDB, 0x06, 
	0x6E, 0x73, 0x6E, 0x18, 0xC3, 0x0C, 0xCC, 0xA7, 0xB3, 0xBC, 0xA3, 0xAD, 0xB2, 0xBA, 0xA0, 0xBA, 
	0xA3, 0xB1, 0xDB, 0xA0, 0xF5, 0x7E, 0xDE, 0x16, 0xDE, 0x16, 0x09, 0x0F, 0x08, 0x0F, 0xDE, 0xF0, 
	0xB9, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 0xDB, 0xA1, 0xF8, 0xF0, 0xDE, 0x16, 0xE7, 0x08, 0xF5, 0xE6, 
	0x0F, 0x0E, 0x0F, 0x0E, 0xDE, 0xB2, 0xC2, 0xBA, 0x00, 0xBA, 0x6C, 0xB6, 0x4B, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x3C, 0x59, 0x3E, 0x62, 0x47, 0x5F, 0x3D, 0x4B, 0x43, 0x45, 0x41, 0x43, 0x3E, 0x43, 0x3E, 0x61, 
	0x6E, 0x79, 0x3E, 0x86, 0x3E, 0x77, 0x3C, 0x4E, 0x56, 0x43, 0x3C, 0x43, 0x3D, 0x43, 0x3F, 0x67, 
	0x3C, 0x49, 0xA4, 0xA9, 0xD9, 0x9D, 0x10, 0x18, 0x0E, 0x18, 0x7E, 0x18, 0x96, 0xE0, 0x0F, 0x18, 
	0x18, 0x17, 0xB2, 0x18, 0xE6, 0x99, 0xA8, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xD9, 0xA6, 0x19, 0x18, 0x00, 0x18, 0xF0, 0x18, 
	0x6E, 0x1A, 0x00, 0x18, 0xC3, 0x18, 0xDB, 0xD0, 0xB4, 0xBC, 0xBA, 0x97, 0x00, 0xBA, 0xBA, 0xB1, 
	0xDB, 0x9E, 0xDE, 0x0F, 0x0F, 0x0E, 0x10, 0x0F, 0xC3, 0x0E, 0x00, 0x0F, 0x09, 0x0F, 0xE9, 0xD9, 
	0xB3, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 0xDB, 0xAD, 0xDE, 0x16, 0x0F, 0x0E, 0x50, 0x0F, 0xF8, 0xF0, 
	0x19, 0x0E, 0x25, 0x0F, 0xE9, 0xD9, 0xB3, 0xB1, 0x00, 0xBA, 0x9A, 0xBA, 0x58, 0x46, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x58, 0x5F, 0x47, 0x7A, 0x73, 0x7F, 0x4D, 0x7F, 0x7E, 0x86, 0x76, 0x79, 0x79, 0x7F, 
	0x70, 0x79, 0x00, 0x79, 0x79, 0x7F, 0x7A, 0x79, 0x77, 0x7F, 0x76, 0x7F, 0x73, 0x6F, 0x74, 0x79, 
	0x86, 0x7F, 0x9B, 0xA5, 0xD9, 0xAA, 0x25, 0x18, 0x18, 0x17, 0x6E, 0x18, 0xE7, 0xE0, 0x08, 0x18, 
	0x0E, 0x18, 0x7E, 0x2B, 0xC2, 0xD7, 0xAB, 0xC0, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xD9, 0x9D, 0xC2, 0x0C, 0x7E, 0x18, 0xDB, 0x06, 
	0x6E, 0x76, 0xA3, 0x18, 0xB2, 0x06, 0xDB, 0xD7, 0x99, 0x9D, 0xBA, 0xAD, 0x00, 0xBA, 0xBA, 0xAD, 
	0xDB, 0xA1, 0x96, 0x0F, 0x00, 0x0F, 0x25, 0x0F, 0xDE, 0x16, 0xDE, 0x0F, 0xDE, 0x7E, 0xF5, 0xF0, 
	0xCC, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 0xC3, 0xB1, 0xE7, 0x16, 0x09, 0x0F, 0xDE, 0x08, 0xE6, 0xD9, 
	0xFB, 0xF0, 0xE7, 0xCE, 0xA3, 0xB1, 0xBA, 0x9F, 0x00, 0xBA, 0x9A, 0xBA, 0x58, 0x46, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x58, 0x5F, 0x61, 0x79, 0x00, 0x79, 0x00, 0x79, 0x00, 0x79, 0x00, 0x79, 0x70, 0x79, 
	0x79, 0x7F, 0x79, 0x6F, 0x00, 0x79, 0x00, 0x79, 0x00, 0x79, 0x00, 0x79, 0x00, 0x79, 0x00, 0x79, 
	0x79, 0x7F, 0x99, 0x9C, 0xCC, 0xA9, 0xDB, 0x95, 0xF4, 0x16, 0x6E, 0xE0, 0xE2, 0xD7, 0xDE, 0xE0, 
	0x96, 0xEC, 0xE7, 0xD7, 0xD2, 0xCA, 0xAB, 0xB5, 0x00, 0xA5, 0xA5, 0xA6, 0xAC, 0x9C, 0xCA, 0x9C, 
	0x9A, 0xA9, 0xA5, 0xA6, 0x00, 0xA5, 0x00, 0xA5, 0xE6, 0xAA, 0xDE, 0x73, 0xE6, 0x0E, 0xC3, 0x76, 
	0x6E, 0x95, 0xC3, 0x0E, 0xC3, 0x76, 0xE7, 0xD7, 0xB8, 0x9D, 0xBA, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 
	0xDB, 0xA0, 0x96, 0x0F, 0x25, 0x0F, 0xDE, 0x73, 0xDE, 0xE6, 0xDE, 0x1A, 0x10, 0x0F, 0xDE, 0xD9, 
	0xB2, 0xA1, 0x00, 0xBA, 0x00, 0xBA, 0xA3, 0xA1, 0xD2, 0xD9, 0xF5, 0xCC, 0xDB, 0x9E, 0xE7, 0xBA, 
	0xCA, 0xAD, 0xBA, 0xB7, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x95, 0xBA, 0x58, 0x46, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x65, 0x58, 0x83, 0x79, 0x00, 0x79, 0x70, 0x79, 0x79, 0x7F, 0x73, 0x7F, 0x50, 0x87, 
	0x26, 0x7A, 0x50, 0x87, 0x56, 0x71, 0x6E, 0x79, 0x77, 0x79, 0x70, 0x79, 0x00, 0x79, 0x00, 0x79, 
	0x79, 0x6F, 0x9B, 0x82, 0xCC, 0xA5, 0xDE, 0x73, 0x19, 0x18, 0x10, 0x18, 0xF9, 0xE0, 0x19, 0x18, 
	0x0E, 0x18, 0x7E, 0x13, 0xE7, 0xD7, 0xA7, 0xB5, 0xCA, 0xA9, 0xCE, 0xBC, 0xD9, 0xD1, 0xD8, 0xDC, 
	0xE0, 0xD1, 0xD9, 0xD1, 0xCC, 0xAA, 0xA5, 0xA9, 0xCC, 0xA9, 0xC3, 0x0E, 0x00, 0x18, 0x7E, 0x18, 
	0x6E, 0x06, 0x00, 0x18, 0x6E, 0x18, 0xE7, 0xCE, 0xB8, 0x9D, 0xBA, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 
	0xDB, 0xA0, 0xDE, 0x7E, 0xDE, 0x0F, 0xDE, 0x0F, 0x6E, 0xD9, 0x0F, 0x0E, 0x0F, 0x0E, 0x50, 0xF0, 
	0xB4, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 0xBA, 0xB1, 0xA3, 0xB1, 0x9A, 0xB1, 0xBA, 0xB7, 0x00, 0xBA, 
	0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x6C, 0xB6, 0x40, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x67, 0x58, 0x87, 0x79, 0x79, 0x7F, 0x73, 0x86, 0x3F, 0x7A, 0x04, 0x50, 0x4F, 0x50, 
	0x7E, 0x7A, 0x96, 0x89, 0x00, 0x50, 0x26, 0x77, 0x73, 0x8C, 0x6E, 0x71, 0x79, 0x8B, 0x00, 0x79, 
	0x00, 0x79, 0x83, 0x7B, 0xB2, 0xA9, 0xDE, 0x16, 0x18, 0x17, 0x18, 0x17, 0xC3, 0xB4, 0x6E, 0x18, 
	0x08, 0x18, 0xA3, 0x0C, 0xDB, 0xB8, 0x9B, 0xA9, 0xF0, 0xDC, 0xF0, 0xDC, 0xFC, 0x01, 0xF9, 0x00, 
	0xF0, 0xD1, 0x00, 0xD1, 0xDB, 0xDC, 0xA3, 0xA5, 0xB2, 0x9C, 0xC3, 0x1A, 0xDE, 0x18, 0xA3, 0x13, 
	0xDE, 0x76, 0x25, 0x18, 0x6E, 0x13, 0xE6, 0xB8, 0xB8, 0xAA, 0xBA, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 
	0xDB, 0xA2, 0xC2, 0x0F, 0x00, 0x0F, 0x25, 0x0F, 0x25, 0xD9, 0x10, 0x0F, 0xDE, 0x0F, 0xE9, 0xD4, 
	0xA2, 0xB7, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 
	0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x92, 0xBA, 0x4B, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x62, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 
	0x00, 0x58, 0x60, 0x75, 0x79, 0x7F, 0x77, 0x7F, 0xE9, 0x76, 0xFA, 0xD9, 0x04, 0x50, 0x04, 0x50, 
	0xF4, 0xE2, 0xFA, 0xD9, 0x04, 0x50, 0x4F, 0x96, 0xE7, 0xD4, 0x03, 0xC3, 0x6E, 0x7F, 0x83, 0x7F, 
	0x70, 0x79, 0xA4, 0x89, 0x9B, 0xA9, 0xE9, 0xCA, 0xCC, 0x0C, 0xDB, 0x95, 0xDB, 0xE8, 0xF4, 0xD7, 
	0xF4, 0xE0, 0xE6, 0xD7, 0xDB, 0xA7, 0xB3, 0x94, 0xD1, 0xCF, 0xF0, 0xDC, 0xFC, 0x00, 0xFC, 0x00, 
	0xD9, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 0xCC, 0xCB, 0x99, 0xA9, 0xCC, 0xA8, 0xD9, 0xAB, 0xCC, 0xBD, 
	0xD9, 0xAB, 0xE6, 0xA7, 0xE6, 0xA7, 0xA3, 0xAB, 0xB8, 0xA9, 0xBA, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 
	0xC2, 0x97, 0xC2, 0x0F, 0x10, 0x0F, 0x50, 0x7E, 0xF5, 0xE6, 0xF5, 0xB8, 0xDB, 0xA1, 0x91, 0xB1, 
	0xA2, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 
	0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0xAE, 0xBA, 0xB4, 0xAD, 0x36, 0x58, 0x67, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x60, 0x71, 0x75, 0x79, 0x25, 0x05, 0x1E, 0x07, 0x7E, 0x07, 0x16, 0x07, 0x16, 0x07, 
	0x16, 0x07, 0x06, 0x07, 0x05, 0x0A, 0x05, 0x07, 0x05, 0x07, 0x0D, 0x07, 0x6E, 0x0D, 0x1E, 0x07, 
	0x7A, 0x6F, 0x9B, 0x7F, 0xA5, 0xA6, 0xB2, 0xB5, 0x92, 0xBE, 0xB3, 0xBE, 0x9A, 0xB5, 0xA4, 0x9C, 
	0x9B, 0x9C, 0xAC, 0xC0, 0x9D, 0xA9, 0xC2, 0xCD, 0xD1, 0xCF, 0x00, 0xD1, 0xD9, 0xDC, 0xE6, 0xDC, 
	0xD5, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 0xCC, 0xDC, 0xA8, 0xA5, 0xA5, 0xA9, 0xA5, 0xA9, 0xA5, 0xA9, 
	0xA5, 0xBF, 0xA5, 0xBF, 0xA5, 0xBF, 0xA5, 0xBF, 0x9A, 0xA9, 0xBA, 0xB7, 0x00, 0xBA, 0x00, 0xBA, 
	0xC2, 0xAD, 0xE9, 0xD9, 0xE7, 0xD4, 0xDB, 0xB1, 0xCA, 0xA1, 0xBA, 0xB7, 0x00, 0xBA, 0x00, 0xBA, 
	0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0xC1, 0xBA, 0xBA, 0xAD, 0xA7, 0xBA, 0x9E, 0xBA, 0xB8, 0xB1, 
	0x00, 0xBA, 0x00, 0xBA, 0xBA, 0xB1, 0xB4, 0xB1, 0x78, 0xAD, 0xDE, 0xA0, 0x4A, 0x5B, 0x67, 0x58, 
	0x67, 0x58, 0x67, 0x5F, 0x67, 0x5F, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x5C, 0x58, 0x64, 0x58, 
	0x58, 0x5F, 0x60, 0x79, 0x75, 0x79, 0x56, 0x06, 0x96, 0x74, 0xE7, 0x73, 0x26, 0x6E, 0x4F, 0x3F, 
	0xE7, 0xCA, 0xDE, 0x92, 0x56, 0x1E, 0x03, 0x6E, 0xE6, 0x95, 0x03, 0x7E, 0x50, 0x35, 0x25, 0x34, 
	0x74, 0x6F, 0x83, 0x7F, 0xA5, 0x93, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0xA5, 0xA6, 0xE9, 0xE2, 0xD1, 0xDD, 0x00, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 
	0x00, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 0xCC, 0xD1, 0x9B, 0xB5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xB8, 0xA9, 0xBA, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 
	0xA4, 0xBA, 0xB2, 0xB1, 0xBA, 0xB7, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 
	0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x78, 0xA1, 0xD0, 0xBA, 0x9E, 0xB1, 0x8F, 0xB7, 0x9A, 0x64, 
	0x6C, 0xAD, 0xAE, 0xBA, 0xBA, 0xB1, 0x78, 0xB7, 0x6C, 0x85, 0x78, 0x62, 0x47, 0x58, 0x3D, 0x58, 
	0x60, 0x58, 0x58, 0x5B, 0x58, 0x5B, 0x59, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 
	0x58, 0x5B, 0x73, 0x79, 0x3F, 0x79, 0x4F, 0x50, 0x8E, 0xCC, 0xDB, 0xD7, 0x26, 0x50, 0x56, 0x50, 
	0xD2, 0xD7, 0xD2, 0xCA, 0x56, 0x50, 0x26, 0x50, 0xCA, 0xD7, 0x56, 0xC3, 0x3F, 0x2D, 0x3C, 0x2D, 
	0x76, 0x86, 0x81, 0x86, 0xA5, 0xA9, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xCC, 0xAA, 0xD1, 0xCF, 0x00, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 
	0xD5, 0xD1, 0xD6, 0xD1, 0xD0, 0xD1, 0xF0, 0xDC, 0x9A, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xB8, 0xA9, 0xBA, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 
	0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 
	0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x81, 0x80, 0x78, 0xAD, 0x95, 0xAB, 0x78, 0xA2, 0x6C, 0x5F, 
	0x6C, 0x63, 0x78, 0xAB, 0x81, 0x63, 0x67, 0x58, 0x4C, 0x58, 0x58, 0x5F, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x58, 0x5F, 0x58, 0x5F, 0x58, 0x5F, 0x58, 0x5F, 
	0x4D, 0x54, 0x77, 0x79, 0x6E, 0x86, 0x26, 0x50, 0x96, 0xCA, 0xDB, 0xD7, 0x56, 0x50, 0x26, 0x50, 
	0xE9, 0xD7, 0xDB, 0xD7, 0x56, 0x50, 0x8E, 0x50, 0xCA, 0xD7, 0x26, 0xDB, 0x03, 0x50, 0x03, 0x83, 
	0x70, 0x7F, 0x76, 0x79, 0xAD, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x9A, 0xA9, 0xD1, 0xCF, 0x00, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 
	0xD0, 0xD1, 0xD2, 0xD7, 0xD2, 0xD7, 0xD7, 0xCF, 0xB2, 0x9D, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xB8, 0xA9, 0xBA, 0xB7, 0x00, 0xBA, 0x00, 0xBA, 
	0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 
	0x00, 0xBA, 0x92, 0xBA, 0x78, 0x84, 0x95, 0x84, 0x92, 0x5F, 0x67, 0x5F, 0x3C, 0x58, 0x4D, 0x58, 
	0x62, 0x58, 0x58, 0x5B, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x64, 0x58, 
	0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x5C, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 
	0x4A, 0x63, 0x79, 0x7F, 0x6E, 0x7F, 0x00, 0x50, 0x8E, 0xCC, 0xDB, 0xD7, 0x56, 0x50, 0x26, 0x50, 
	0x8E, 0xE2, 0xE6, 0xD7, 0x56, 0x50, 0x8E, 0x50, 0xCC, 0xD7, 0x8E, 0xCC, 0x00, 0x50, 0x26, 0x7E, 
	0x79, 0x7F, 0x74, 0x7F, 0xC1, 0xA9, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xCA, 0xA5, 0xD5, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 
	0xD0, 0xD1, 0xD2, 0xD5, 0xD6, 0xD1, 0xE0, 0xD1, 0xC3, 0x9D, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0xA5, 0xA9, 0xA5, 0xA6, 0x00, 0xA5, 0x00, 0xA5, 0x9A, 0xA5, 0xBA, 0xAD, 0x00, 0xBA, 0x00, 0xBA, 
	0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0xC1, 0xBA, 
	0x9E, 0xBA, 0xB3, 0xAD, 0x95, 0xAD, 0x67, 0x54, 0x4D, 0x58, 0x62, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x5C, 0x58, 0x5C, 0x5F, 0x64, 0x58, 
	0x64, 0x5F, 0x5C, 0x58, 0x64, 0x58, 0x64, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x58, 0x5F, 0x58, 0x5F, 
	0x64, 0x71, 0x79, 0x6F, 0x56, 0x71, 0x00, 0x50, 0x8E, 0xE6, 0xDB, 0xD7, 0x56, 0x50, 0x26, 0x50, 
	0xE9, 0xE2, 0xE6, 0xD7, 0x56, 0x50, 0x8E, 0x50, 0xCC, 0xD7, 0x96, 0xCA, 0x00, 0x50, 0x56, 0x50, 
	0x89, 0x79, 0x6D, 0x79, 0x95, 0xA5, 0x00, 0xA5, 0xA5, 0xBF, 0x9A, 0xC0, 0xCB, 0xA5, 0x78, 0xA5, 
	0xAC, 0xA5, 0x00, 0xA5, 0xA5, 0xA6, 0xC2, 0x9C, 0xD5, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 
	0x00, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 0xD4, 0xDC, 0xA3, 0x9D, 0x00, 0xA5, 0x00, 0xA5, 0x81, 0x9C, 
	0x78, 0x9D, 0x9A, 0x9D, 0x00, 0xA5, 0x00, 0xA5, 0xB3, 0x9C, 0xC1, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 
	0x00, 0xBA, 0xA2, 0xBA, 0xBA, 0x9F, 0xBA, 0xAD, 0x00, 0xBA, 0x00, 0xBA, 0x95, 0xA1, 0x6C, 0x64, 
	0x6C, 0x58, 0x6C, 0x58, 0x41, 0x54, 0x62, 0x58, 0x00, 0x58, 0x00, 0x58, 0x62, 0x58, 0x5C, 0x58, 
	0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 
	0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 
	0x64, 0x86, 0x75, 0x79, 0x50, 0x6D, 0x26, 0x16, 0x8E, 0x73, 0xE7, 0x76, 0x26, 0x16, 0x26, 0x1E, 
	0xFB, 0x92, 0xE6, 0x73, 0x56, 0x1E, 0x03, 0x1E, 0xE6, 0x95, 0x8E, 0x73, 0x26, 0x16, 0x4F, 0x1E, 
	0x83, 0x86, 0x70, 0x6F, 0x81, 0xA5, 0xA5, 0xA6, 0x78, 0x9D, 0x95, 0xA6, 0x6C, 0x63, 0x99, 0xA5, 
	0xA8, 0xA5, 0x00, 0xA5, 0xA5, 0xA6, 0xC2, 0x9D, 0xCE, 0xDC, 0x00, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 
	0x00, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 0xCC, 0xDC, 0xB2, 0x9D, 0x00, 0xA5, 0xA5, 0xA6, 0x78, 0x5B, 
	0x95, 0x9D, 0xB4, 0xA9, 0xBD, 0xA5, 0x00, 0xA5, 0xA4, 0xA9, 0xB3, 0xB1, 0x00, 0xBA, 0x00, 0xBA, 
	0xA4, 0xAD, 0x67, 0xAD, 0x95, 0xA2, 0x6C, 0xA2, 0x9A, 0xB1, 0x81, 0x84, 0x78, 0x63, 0x62, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x58, 0x5F, 
	0x58, 0x5F, 0x58, 0x5F, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 
	0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x59, 0x58, 0x00, 0x58, 
	0x67, 0x79, 0x74, 0x7F, 0x1E, 0x0D, 0x0D, 0x07, 0x0D, 0x0A, 0x0D, 0x0A, 0x0D, 0x0A, 0x0D, 0x07, 
	0x0D, 0x07, 0x0D, 0x07, 0x0D, 0x0A, 0x0D, 0x0A, 0x0D, 0x0A, 0x0D, 0x0A, 0x0D, 0x0A, 0x0D, 0x0A, 
	0x6E, 0x05, 0x71, 0x7F, 0x9B, 0xA9, 0x9B, 0xA9, 0x6C, 0x84, 0x67, 0x5B, 0x95, 0xAA, 0xA5, 0xA6, 
	0xA4, 0xA5, 0xBC, 0xA5, 0x78, 0xA9, 0xA7, 0xA9, 0xE6, 0xDC, 0x00, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 
	0x00, 0xD1, 0x00, 0xD1, 0x00, 0xD1, 0xE6, 0xDC, 0xB2, 0x9D, 0x81, 0xC0, 0xB3, 0xBE, 0x78, 0x5F, 
	0x78, 0x9D, 0x8F, 0xA8, 0x81, 0xA5, 0x9D, 0xA5, 0xBD, 0xA5, 0xB2, 0xA1, 0xBA, 0xAD, 0x95, 0xB7, 
	0x78, 0xAC, 0x67, 0x63, 0x6C, 0x5F, 0x4D, 0x5F, 0x35, 0x54, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x5C, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 
	0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 
	0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x59, 0x58, 0x59, 0x58, 0x62, 0x58, 0x00, 0x58, 
	0x76, 0x87, 0x83, 0x86, 0x26, 0x05, 0x26, 0x0D, 0x96, 0x05, 0xC3, 0x77, 0x26, 0x0D, 0x50, 0x0D, 
	0xDE, 0x83, 0xDB, 0x83, 0x56, 0x06, 0x56, 0x06, 0xF4, 0x73, 0xFA, 0x73, 0x26, 0x1E, 0x4F, 0x3F, 
	0x25, 0x87, 0x79, 0x7F, 0xB3, 0x9D, 0x6C, 0x85, 0x78, 0x64, 0x78, 0x54, 0xCB, 0xC0, 0xA4, 0xA9, 
	0x92, 0xA5, 0x8F, 0x64, 0x8F, 0x62, 0x8F, 0xAC, 0xE6, 0xCF, 0xEB, 0xD1, 0xEE, 0xD1, 0xD5, 0xD1, 
	0xDA, 0xD1, 0xD1, 0xCF, 0xD1, 0xCF, 0xD9, 0xCF, 0xB2, 0x9D, 0xA0, 0xA9, 0x8F, 0x62, 0x8F, 0x62, 
	0x8F, 0x57, 0x67, 0x5F, 0xB4, 0xBE, 0xC9, 0xC0, 0x9D, 0xA9, 0xCA, 0xAD, 0x81, 0xAD, 0x78, 0x63, 
	0x4D, 0x58, 0x59, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x62, 0x58, 0x62, 0x58, 0x62, 0x58, 0x62, 0x58, 0x62, 0x58, 0x62, 0x58, 0x62, 0x58, 
	0x62, 0x58, 0x62, 0x58, 0x59, 0x58, 0x59, 0x58, 0x59, 0x58, 0x59, 0x58, 0x62, 0x58, 0x62, 0x58, 
	0x62, 0x58, 0x62, 0x58, 0x62, 0x58, 0x62, 0x58, 0x62, 0x58, 0x62, 0x58, 0x62, 0x58, 0x62, 0x58, 
	0x67, 0x86, 0x3D, 0x5B, 0x3C, 0x62, 0x56, 0x62, 0x96, 0x5C, 0xB2, 0x46, 0x26, 0x59, 0x26, 0x64, 
	0xE9, 0x78, 0xE6, 0x78, 0x56, 0x4E, 0x3F, 0x5C, 0xA3, 0x81, 0xC2, 0x64, 0x50, 0x58, 0x50, 0x62, 
	0x47, 0x71, 0x5C, 0x7F, 0x6C, 0x8D, 0x6C, 0x58, 0x3E, 0x5F, 0x6C, 0x58, 0x67, 0x54, 0x49, 0x54, 
	0x34, 0x58, 0x5C, 0x54, 0x59, 0x58, 0x41, 0x54, 0x4D, 0x5F, 0x67, 0x54, 0x67, 0x54, 0x92, 0x58, 
	0x8F, 0x57, 0x78, 0x58, 0x78, 0x5F, 0x6C, 0x5F, 0x78, 0x57, 0x67, 0x58, 0x48, 0x58, 0x59, 0x58, 
	0x62, 0x58, 0x64, 0x58, 0x4D, 0x54, 0x67, 0x54, 0x78, 0x58, 0x6C, 0x54, 0x3A, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x59, 0x58, 0x5C, 0x58, 0x64, 0x62, 0x64, 0x62, 0x5C, 0x58, 0x64, 0x62, 0x64, 0x62, 0x5C, 0x58, 
	0x5D, 0x58, 0x5C, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x5C, 0x58, 0x5C, 0x58, 
	0x59, 0x58, 0x64, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x59, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 
	0x51, 0x58, 0x62, 0x58, 0x58, 0x5F, 0x58, 0x5F, 0x00, 0x58, 0x00, 0x58, 0x58, 0x5F, 0x58, 0x5F, 
	0x58, 0x5B, 0x58, 0x5B, 0x58, 0x5B, 0x62, 0x58, 0x58, 0x5F, 0x58, 0x5F, 0x58, 0x5F, 0x58, 0x5F, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x64, 0x58, 0x64, 0x58, 0x61, 0x58, 0x61, 0x58, 0x61, 0x58, 0x61, 0x58, 0x61, 0x58, 0x61, 0x58, 
	0x61, 0x58, 0x61, 0x58, 0x61, 0x58, 0x61, 0x58, 0x61, 0x58, 0x61, 0x58, 0x64, 0x58, 0x64, 0x58, 
	0x62, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x00, 0x58, 0x00, 0x58, 0x62, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
};

const u8 ImgAttr6[8320] __attribute__ ((aligned(4))) = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x00, 0xFF, 0xFF, 0xFC, 0xD3, 0x02, 0x03, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x98, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x07, 0xF8, 0x80, 0x00, 0x01, 0xFF, 0xFF, 0x11, 0x7B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0xAB, 0x73, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0xB9, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 
	0xFF, 0xE0, 0x00, 0xE0, 0x37, 0xF0, 0xFF, 0xFF, 0xCE, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0xB3, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xDC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xF8, 
	0x80, 0x20, 0x6F, 0x3B, 0xFF, 0x00, 0xFF, 0xFF, 0xEF, 0x73, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x12, 0x37, 0xEF, 0x73, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x9B, 0xCE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xF8, 0x0E, 
	0x07, 0x1F, 0xFF, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0x9C, 0xF7, 0xFF, 0x00, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x37, 0xEE, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xF8, 0x80, 0x00, 0x83, 
	0xFF, 0xFF, 0xFF, 0xCE, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0x42, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xCC, 0xBF, 0x39, 0xCE, 0x10, 0xF1, 0x0E, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0x7F, 0xEE, 0xB9, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xF0, 0x9E, 0x03, 0x77, 0xE8, 
	0xFF, 0xFF, 0xFF, 0xEF, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 
	0xB3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x93, 0x7F, 0x99, 0xEF, 0x28, 0x1F, 0x33, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xC9, 0xFF, 0xFF, 0xC8, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1E, 0xE0, 0x00, 0x04, 0x0F, 0xFF, 0x39, 0x00, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x02, 0x73, 0xFF, 0xFF, 0xFF, 0x11, 
	0x31, 0xF7, 0xFF, 0xFF, 0xFF, 0xFE, 0xEC, 0x7F, 0xFF, 0xFF, 0xFF, 0xCC, 0xE8, 0x7F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB3, 0xFC, 0xFF, 0x8D, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFE, 0xE0, 0x16, 0xC1, 0x78, 0xFF, 0xFF, 0xDC, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0xF7, 0x00, 0xFF, 0xFC, 0x83, 0xD0, 0x39, 0xFF, 0xFF, 0xFF, 0xEE, 
	0x54, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0x93, 0xBF, 0xFF, 0xFF, 0xFF, 0xCE, 0x77, 0xFF, 0x00, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x7F, 0x99, 0xFF, 0xCC, 0x31, 0x7B, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xE0, 0x00, 0xD1, 0x0B, 0x7F, 0x00, 0xFF, 0xFF, 0xEE, 0x77, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x73, 0x0F, 0xE8, 0x03, 0xFF, 0x00, 0x42, 0x73, 0xFF, 0xFF, 0xCC, 
	0xEE, 0x77, 0xFF, 0xFF, 0x03, 0xE8, 0x7F, 0x93, 0xFF, 0xFC, 0xFF, 0xFF, 0x98, 0xF0, 0x08, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xC9, 0x80, 0x9B, 0xFF, 0xCE, 0xC6, 0xF7, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x00, 0xFF, 0xFE, 0xE0, 0x30, 0x80, 0x37, 0xDC, 0xFF, 0xFF, 0xFF, 0xFF, 0x10, 0x01, 
	0x08, 0xFF, 0xFF, 0xFF, 0xFE, 0xB8, 0xC0, 0x1F, 0xC0, 0xFF, 0xFF, 0xFF, 0x39, 0x7B, 0xFF, 0xD9, 
	0xFB, 0x39, 0xFF, 0xEE, 0xE0, 0x30, 0xC0, 0x4C, 0x00, 0xC8, 0xFF, 0xFF, 0xFE, 0x13, 0xF7, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x93, 0x00, 0xBF, 0xF9, 0xEF, 0x7F, 0x31, 0xF7, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x03, 0xF8, 0x80, 0x2C, 0x7F, 0xFF, 0xFF, 0xEF, 0x73, 0xFF, 0xFF, 0xFE, 0x17, 0xFF, 
	0xCE, 0xF7, 0xFF, 0xFF, 0xFE, 0x97, 0x7B, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0x42, 0xF6, 0xFC, 0x37, 
	0xFF, 0xCA, 0x71, 0x7E, 0x8F, 0x0F, 0xD9, 0x80, 0x12, 0xB7, 0x3C, 0xF0, 0x80, 0x77, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xEC, 0x7F, 0xFF, 0xFF, 0x99, 0x11, 0x88, 0x9C, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF8, 0x84, 0x61, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0xFF, 0xFF, 0xCD, 0x7F, 0xFF, 
	0xFF, 0x08, 0xFF, 0xFE, 0x83, 0xFF, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x73, 0xD1, 0xB7, 
	0xFF, 0xCC, 0x1F, 0x80, 0xFE, 0xFE, 0x37, 0xFF, 0xE0, 0x7F, 0xCB, 0x0F, 0x6E, 0x31, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x81, 0xFF, 0xFF, 0xFF, 0x9F, 0x00, 0xCC, 0xEF, 0x73, 0xF7, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 
	0xBC, 0xC0, 0x00, 0x93, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0xFF, 0xFF, 0xCB, 0xF7, 0xC8, 
	0x31, 0xCC, 0xF0, 0x03, 0xFF, 0xFF, 0xEF, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x7E, 
	0xB0, 0xE0, 0x71, 0x08, 0xDE, 0x80, 0xF0, 0x80, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0x08, 0xF3, 0xFB, 
	0xFF, 0xFF, 0xFF, 0xFE, 0xEC, 0x7D, 0xFF, 0xFF, 0xFF, 0x99, 0xFF, 0xCE, 0xF7, 0x9C, 0xF7, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0xC2, 0x70, 0x81, 0x7E, 0xE3, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x73, 0x00, 0x33, 0x73, 0x88, 
	0x14, 0xEE, 0x07, 0xE0, 0xFF, 0xFF, 0xFF, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0xCC, 0x81, 
	0x6F, 0x0E, 0x1E, 0xF7, 0xEE, 0x07, 0x0F, 0x7C, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xCE, 0x9C, 0xF3, 
	0xFF, 0xFF, 0xFF, 0xB6, 0x92, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x7B, 0xEF, 0x31, 0x7D, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xF8, 0x00, 
	0xEC, 0x4F, 0x7F, 0xED, 0x9D, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0x11, 0x37, 0x3B, 0xCC, 
	0xCE, 0x7F, 0xB9, 0x00, 0xFF, 0xFC, 0xF1, 0xEE, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x13, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x31, 0xC8, 0xFF, 0xFF, 0x00, 0xFF, 0xCC, 0xFF, 0xFF, 0xFF, 0xFC, 0xF0, 0x13, 
	0xFF, 0xFF, 0xFF, 0xC9, 0xFE, 0x37, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xF9, 0x8C, 0xFF, 0xCE, 0xF3, 
	0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x92, 0xE0, 
	0x12, 0xF3, 0xFF, 0xD9, 0x88, 0xCE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xAC, 0x7F, 0x99, 0xCE, 
	0x01, 0xEF, 0xCC, 0x00, 0xFF, 0x93, 0x9C, 0x99, 0x39, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x33, 0xFF, 
	0xFF, 0xFF, 0x8C, 0xCE, 0x37, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x61, 0x1C, 0xB0, 
	0xFF, 0xDE, 0xC0, 0x78, 0x80, 0x7F, 0xEC, 0x37, 0xFF, 0xF9, 0xFF, 0xDE, 0xEF, 0x7B, 0xFF, 0x00, 
	0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEC, 0xBB, 0x73, 
	0xCB, 0x0E, 0xF7, 0xDC, 0x80, 0xEF, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x13, 0xFF, 0xCC, 0xFF, 
	0xFF, 0x6B, 0xC8, 0x9A, 0x87, 0x7F, 0xCC, 0x88, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0x12, 0x10, 0xF7, 
	0xFF, 0xFF, 0xCF, 0x93, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x38, 0xFB, 0xFC, 0xE8, 0x6F, 
	0xFF, 0xED, 0x0F, 0x0F, 0xDB, 0xFE, 0x80, 0x88, 0x00, 0x99, 0xFF, 0xEF, 0x78, 0xFE, 0xE0, 0x1F, 
	0xB7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9B, 0x11, 0x9D, 
	0x9C, 0xF7, 0x3A, 0xE1, 0x7F, 0xFF, 0x39, 0xFF, 0xFF, 0xFF, 0xFE, 0x81, 0x9C, 0xFF, 0xEE, 0xF7, 
	0xFF, 0xFC, 0x26, 0xE6, 0x77, 0xFF, 0xC9, 0xFF, 0xEE, 0x77, 0xFF, 0x00, 0xFF, 0xC9, 0x6F, 0x73, 
	0xBB, 0xFF, 0xE8, 0x7F, 0xFF, 0x93, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xCE, 0x03, 0x0F, 0x0E, 0x60, 
	0xFF, 0xFF, 0xFF, 0xE8, 0x60, 0x03, 0xDD, 0x80, 0x13, 0xB1, 0xFF, 0xFF, 0xCE, 0x01, 0x6F, 0x73, 
	0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x66, 0x46, 0xC6, 
	0xF5, 0x00, 0x4D, 0x8C, 0xFC, 0x30, 0xDC, 0xFF, 0xFF, 0xF8, 0x03, 0x7F, 0xEF, 0x73, 0xFF, 0x30, 
	0xE0, 0x16, 0xEF, 0x6B, 0x70, 0xF0, 0xB7, 0xFF, 0xFF, 0x3B, 0xFF, 0x07, 0xE8, 0x3F, 0x78, 0x19, 
	0x7E, 0xE0, 0x3C, 0xF0, 0x80, 0x7F, 0xFD, 0xFF, 0xFF, 0x38, 0xFF, 0xFF, 0xBE, 0xF3, 0xFF, 0x19, 
	0xFF, 0xFF, 0xFE, 0x0F, 0x37, 0xFF, 0x93, 0xFF, 0xEC, 0x10, 0xF1, 0xFF, 0xF0, 0x93, 0x88, 0xBD, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xCC, 0xC9, 0x27, 0x08, 
	0x73, 0x70, 0xEF, 0xD3, 0xDC, 0xEF, 0x6A, 0xF7, 0xC0, 0x07, 0xE0, 0xFF, 0xFF, 0x9C, 0xFF, 0xCD, 
	0x3F, 0xFF, 0x10, 0x88, 0xCF, 0x0F, 0x7F, 0xFF, 0x00, 0xB9, 0xFE, 0xC0, 0x3F, 0xFF, 0x06, 0xC6, 
	0xF7, 0x0F, 0x0F, 0x0F, 0x93, 0xFF, 0xB3, 0xFF, 0xFF, 0xCF, 0x00, 0x00, 0x03, 0x6D, 0xFF, 0xCE, 
	0xFF, 0xFF, 0xFF, 0xEE, 0x7F, 0xE8, 0x7F, 0xE0, 0x17, 0xEF, 0x0F, 0x0F, 0x0F, 0xFF, 0xCF, 0x42, 
	0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x80, 0x37, 0xFF, 0xEE, 
	0x95, 0x08, 0xEC, 0xF3, 0xEF, 0x10, 0xEC, 0x0F, 0x77, 0xFF, 0x00, 0xFF, 0xFF, 0xEF, 0x73, 0xCC, 
	0xFF, 0xFF, 0x00, 0xCC, 0x73, 0xFF, 0xFF, 0xFF, 0x16, 0x83, 0x09, 0x7F, 0xF0, 0xEE, 0x66, 0x77, 
	0x73, 0xFF, 0xFF, 0xE9, 0x7E, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0xCD, 0x98, 0x08, 0x03, 0x1F, 0xC0, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0x8C, 
	0x31, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0x1D, 0x37, 0xFF, 0xEE, 
	0x46, 0xF7, 0x13, 0xBB, 0xFF, 0xE0, 0x17, 0x90, 0x39, 0x00, 0xFF, 0xFF, 0xF1, 0xFF, 0x39, 0xCE, 
	0xFF, 0xFF, 0xFF, 0xCE, 0xF7, 0xF7, 0xFF, 0xFE, 0xC1, 0x7F, 0xCE, 0xEE, 0x07, 0x2B, 0x72, 0x77, 
	0xB9, 0xFF, 0xCE, 0x30, 0x03, 0x3F, 0xBF, 0xFE, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 
	0xFF, 0xFF, 0xFD, 0x93, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xEF, 
	0x0C, 0x73, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xC8, 0x9B, 0x7F, 0xFF, 0xEE, 
	0x3B, 0x33, 0x31, 0xB7, 0xC0, 0x3F, 0xFF, 0x00, 0xDE, 0x8C, 0xFF, 0xE0, 0x4E, 0x77, 0x40, 0xE6, 
	0xF7, 0xFF, 0xFF, 0xEF, 0x73, 0x31, 0xF8, 0x03, 0x7F, 0xFF, 0xEF, 0x63, 0x73, 0x99, 0x0E, 0xF7, 
	0xCE, 0xF7, 0xFF, 0xB7, 0xFF, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xCE, 0xF3, 0xFF, 0xFF, 0x8C, 0xF7, 
	0xFF, 0xFF, 0xFE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x39, 0xFF, 0xFF, 
	0xCE, 0x31, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xB6, 0x11, 0x88, 0xFF, 0x21, 
	0x8C, 0x90, 0xCF, 0xC1, 0x3F, 0xFF, 0xFF, 0xFF, 0xEF, 0x77, 0xEC, 0x0F, 0xEE, 0x77, 0xEF, 0x63, 
	0x77, 0x00, 0xFF, 0xFF, 0xBC, 0xC0, 0x17, 0xE0, 0xFF, 0xFF, 0xFF, 0x9D, 0x8E, 0x36, 0x04, 0xFF, 
	0xFF, 0x73, 0xEE, 0x5F, 0xFF, 0xFF, 0xEC, 0x3F, 0xFF, 0xFF, 0xFF, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xB3, 0xFF, 0xFF, 0xCE, 0xFF, 0xFF, 
	0xFF, 0x8D, 0x71, 0x7D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0x83, 0x7F, 0x00, 0xFF, 0x10, 
	0xFF, 0xCC, 0x0D, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x39, 0xDC, 0xFF, 0xEC, 0xFF, 0xFF, 0x31, 
	0x77, 0x03, 0xFC, 0xC0, 0x86, 0x77, 0x9D, 0x88, 0xFF, 0xFF, 0xFF, 0xCE, 0xF7, 0xEE, 0xEE, 0x76, 
	0xF3, 0x9C, 0xC9, 0xB7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x93, 0xFF, 0xFF, 0xFF, 0xFE, 0x93, 0xFF, 0xFE, 0x37, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 
	0xFF, 0xCE, 0x8E, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xCA, 0x73, 0xC8, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xCC, 0xEE, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xEB, 0x08, 0x13, 0xFF, 0xFF, 0xDD, 
	0x7F, 0xF8, 0x83, 0x3F, 0xFF, 0x39, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x73, 0xEF, 0x4B, 0xCD, 
	0x0C, 0xC6, 0x37, 0xFF, 0xFF, 0xFF, 0xFE, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEC, 0x7F, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xEC, 0x77, 0xFF, 0xFF, 0xFC, 0x0C, 0xFF, 
	0xFF, 0xFF, 0xED, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0x34, 0x33, 0x00, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xCE, 0x73, 0x39, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 
	0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0x9C, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0xFE, 0x16, 0xCE, 
	0xF7, 0x3B, 0x73, 0xFF, 0xFF, 0xFF, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xDB, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC8, 0x77, 0xFF, 0xFF, 0xCF, 0xFB, 0xFF, 
	0xFF, 0xE0, 0x17, 0xB7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEC, 0xEC, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEE, 0x08, 0xD0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x3B, 0xFF, 0x00, 0xFF, 0xFC, 0x81, 
	0x39, 0x0E, 0x08, 0x00, 0x00, 0x02, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xEE, 0x66, 0x77, 
	0x3C, 0x37, 0xB9, 0xFF, 0xFF, 0xFE, 0x37, 0xFF, 0xFF, 0xF3, 0xFF, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xEC, 0x7F, 0x12, 0x93, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0x06, 0x73, 0xFF, 0xFF, 0xFF, 0x8C, 0x00, 
	0x00, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x88, 0x13, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xEF, 0xCD, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x9D, 0xFF, 0x07, 0xF8, 0x03, 0xFF, 
	0xCE, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0x39, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x66, 0x64, 0x7F, 
	0xFF, 0xFC, 0x16, 0x38, 0xE0, 0x04, 0xFF, 0xFF, 0xEC, 0x7F, 0xFF, 0xEF, 0x30, 0xF0, 0xF0, 0xC0, 
	0x97, 0xFF, 0xE8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0xDE, 0x00, 0xB1, 0xFF, 0xFF, 0xFF, 0xFF, 0x0E, 
	0x20, 0xDC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x15, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x71, 0xCC, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xCE, 0xF7, 0xC0, 0x0F, 0xF8, 0xFF, 
	0xEF, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3B, 0x53, 0xFF, 
	0xF8, 0x03, 0xEF, 0x63, 0x0F, 0xD9, 0xFF, 0xFF, 0x93, 0xFF, 0xFC, 0xFF, 0x8F, 0x0F, 0x0F, 0x3F, 
	0xF0, 0x81, 0x1B, 0xF7, 0xFF, 0xFF, 0xF8, 0x80, 0x83, 0xFF, 0x8F, 0x10, 0x70, 0xF0, 0xE0, 0x07, 
	0xCE, 0xE7, 0x73, 0xF7, 0xFF, 0xFF, 0xFF, 0xFE, 0xC8, 0xD9, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x00, 0xCE, 0xC6, 0xF7, 0xFF, 0xFF, 0xFF, 0x03, 0xC9, 0x0D, 0x7F, 0xFF, 0xA3, 0x62, 
	0x1D, 0x39, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9C, 0xF4, 0xE0, 
	0x17, 0xFF, 0xFF, 0x31, 0xFE, 0x30, 0xF0, 0x81, 0x7F, 0xFF, 0xCE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0F, 0xFE, 0x37, 0xFF, 0xFF, 0xFE, 0xE0, 0x03, 0x68, 0xFF, 0xFF, 0xC3, 0x0F, 0x0F, 0x1F, 0xE0, 
	0x31, 0x08, 0x9C, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0x93, 0x13, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xCE, 0x08, 0x73, 0xFF, 0x00, 0xFF, 0xE0, 0x3F, 0xEE, 0xF7, 0xFF, 0x39, 0x89, 
	0xCC, 0xDC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x37, 0x0B, 0x3F, 
	0xFF, 0xFF, 0xFF, 0xCE, 0xE7, 0x0F, 0x0F, 0x7C, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x8C, 0xB0, 0xF0, 0x80, 0x03, 0x1F, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 
	0x00, 0xCF, 0xF7, 0x31, 0x7B, 0xFF, 0xFF, 0xEC, 0x41, 0x7F, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x39, 0xFF, 0x1E, 0xC0, 0x3F, 0xFF, 0xFF, 0x3B, 0xF8, 0x82, 0x4E, 
	0x80, 0xEF, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0x88, 0xFF, 0xFF, 0xFC, 0x03, 0xFF, 0xDC, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x73, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEC, 0xC9, 0x0F, 0x1F, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x08, 0xCE, 0xF7, 0xF7, 0xFF, 0xCC, 0x37, 0x68, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x00, 0xFF, 0xFF, 0xEE, 0x0A, 0xF0, 0x81, 0x3F, 0xFF, 0xFF, 0xFF, 0x9D, 0x37, 0x39, 0xD0, 
	0xFF, 0x00, 0x3B, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xF7, 0xFF, 0xE0, 0x07, 0xE0, 0xFF, 0xEE, 0xF7, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x9D, 0xFB, 0xFF, 0xFE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xED, 0x98, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x73, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xEF, 0x7B, 0x10, 0xD7, 0xD2, 0x80, 0x33, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0xF0, 0x8E, 0xFF, 0xFF, 0xEF, 0x9C, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0x30, 0x86, 0x66, 
	0x66, 0x4F, 0xD4, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0x28, 0x01, 0x3F, 0xFF, 0x00, 0xFF, 0xFF, 0x33, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x57, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD9, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x8C, 0x21, 0x38, 0xEE, 0x6E, 0x13, 0xFF, 0xFF, 0xFF, 0xFC, 0xF0, 0xFF, 0xC3, 
	0x0F, 0x73, 0x08, 0xFF, 0xFF, 0xCE, 0x00, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x77, 0xFF, 0x09, 
	0xFF, 0x38, 0x26, 0xF7, 0x00, 0xFF, 0xFC, 0x13, 0xCE, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9D, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x33, 0xEF, 0x3F, 0xFF, 0xFF, 0xFF, 0xEE, 0xF3, 0xFF, 0xFF, 0xFF, 
	0xC8, 0xFF, 0xFF, 0xFF, 0xFE, 0xF7, 0xFF, 0xFE, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x8E, 0xEE, 0x00, 0xC3, 0x37, 0xFF, 0xFF, 0xEC, 0x00, 0x00, 0x20, 0x7F, 
	0xFF, 0x10, 0x84, 0xFF, 0xFF, 0xFF, 0xCC, 0x3B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3B, 0xEC, 0x7B, 
	0x92, 0xF7, 0xFF, 0x73, 0x07, 0xE8, 0x07, 0xFE, 0x63, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 
	0xF7, 0xFF, 0xFF, 0xFF, 0x01, 0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8E, 0x30, 0xF0, 0xF7, 
	0xB7, 0xFF, 0xFF, 0xFF, 0xC9, 0x7F, 0xFF, 0xEC, 0xFF, 0xFF, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFC, 0xF0, 0xFF, 0xFF, 0xF8, 0x81, 0x01, 0x01, 0x48, 0xFF, 0x00, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xCC, 0x94, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9C, 0xDD, 0x99, 
	0x73, 0x7B, 0xFF, 0x98, 0xC0, 0x1F, 0xFF, 0xCD, 0x8C, 0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x31, 
	0x73, 0xFF, 0x00, 0xFF, 0xF8, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0x0F, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xEF, 0x0F, 0x00, 0x00, 0x07, 0x6C, 0x5D, 0x7F, 0x00, 0xFF, 0x11, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xEE, 0x63, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xC6, 0x80, 
	0x10, 0xB7, 0xE0, 0x6F, 0x39, 0xCB, 0x39, 0xDD, 0xCC, 0xCE, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
	0x9D, 0xFF, 0x03, 0xE8, 0x17, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0x00, 
	0x00, 0x10, 0x8E, 0x71, 0x79, 0xDB, 0x13, 0x77, 0xFF, 0xFF, 0xFF, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEC, 0x7F, 0xFF, 0xFF, 0xFF, 0xEF, 0x0C, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3B, 0xDF, 
	0xFF, 0xC0, 0x1F, 0xFF, 0xDC, 0x3B, 0xCE, 0xCE, 0x93, 0xEF, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xCE, 0x50, 0x80, 0x03, 0x1D, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x0F, 0xC9, 0xFF, 0xFF, 0xFF, 0xFE, 0x37, 0xD9, 0xFF, 0xCF, 0x38, 0xF1, 0x0F, 
	0x0F, 0x0F, 0xFC, 0x93, 0xB2, 0x34, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xDB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9C, 0xFC, 
	0xC1, 0x7F, 0xFF, 0xFF, 0xEF, 0x42, 0xE0, 0xFE, 0xFF, 0xFF, 0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xD9, 0x8F, 0x3F, 0xFF, 0x11, 0xBB, 0xFF, 0xEE, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF0, 0x37, 0xFF, 0xFF, 0xFF, 0xE9, 0x7F, 0x99, 0xFF, 0xFF, 0xCF, 0x00, 0xF0, 
	0xF0, 0xC0, 0x07, 0x68, 0xEC, 0x03, 0x13, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x08, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x2A, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xCD, 0x0E, 
	0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0xB0, 0xC9, 0x7B, 0x34, 0xC6, 0xF7, 0xFF, 0x00, 0xFF, 0xE8, 
	0x13, 0xF8, 0xE0, 0xFF, 0xFF, 0x99, 0xFF, 0xFF, 0x9C, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x01, 0x4D, 0xFF, 0xFF, 0xFF, 0xF8, 0x37, 0xFF, 0x99, 0xFF, 0xFF, 0xEF, 0xFF, 0xCF, 
	0x0F, 0xFF, 0xFF, 0x01, 0x8A, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0xF3, 0xFF, 0xFF, 
	0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x21, 0x9D, 0x3B, 0xFF, 0xFF, 0xFF, 0xFC, 0x17, 0xFF, 
	0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0x8C, 0x9C, 0x37, 0x9B, 0x3D, 0x73, 0xFF, 0x07, 0xC0, 0x1F, 
	0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x99, 0xFF, 0xFF, 0xEF, 0x38, 0xF1, 0x8F, 0x0F, 0x0F, 0x0F, 0x0F, 
	0xC0, 0xFF, 0xFE, 0xB7, 0xFF, 0xFF, 0xF8, 0x81, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x66, 0x13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x8C, 0x00, 0x00, 
	0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0x10, 0xFF, 0xFF, 0xFC, 0x03, 0xC8, 0xFF, 
	0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x73, 0x10, 0xFF, 0xBC, 0xCC, 0xB9, 0xFE, 0x80, 0x07, 0x3F, 
	0x00, 0xFF, 0xF9, 0xFF, 0xFF, 0x99, 0xFF, 0xFF, 0xFF, 0x81, 0x10, 0x90, 0xF7, 0xFF, 0xFF, 0xE0, 
	0x00, 0xFF, 0xCC, 0x40, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF9, 0xFF, 0xFE, 0xCC, 0xED, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0x8E, 0x17, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCD, 0x70, 0xE0, 0x07, 0xFF, 0x00, 0xFF, 
	0xCE, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0x39, 0x27, 0x73, 0xEF, 0x01, 0x83, 0x07, 0x7F, 0xFF, 0xFF, 
	0x3E, 0xC0, 0x00, 0x77, 0xFF, 0x9C, 0xF0, 0xF0, 0x80, 0x3F, 0xEF, 0x0F, 0x0F, 0x0F, 0x0F, 0x1F, 
	0xFF, 0xFF, 0x30, 0xF0, 0xF0, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8F, 0x33, 0xFF, 0x98, 0x13, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x71, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0x8D, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xEF, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0x77, 0x33, 0xFF, 0xC0, 0x33, 0x9F, 0xC0, 0xFF, 0xFE, 
	0xC1, 0x70, 0xE6, 0x77, 0xFF, 0xCD, 0x0F, 0x0F, 0x3F, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xF0, 0xFF, 
	0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xD9, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xFF, 0xFF, 0xF7, 0xFF, 
	0xFF, 0xFF, 0xEE, 0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0x42, 0xF7, 0xFF, 0xFF, 0xFC, 0xF3, 
	0xFF, 0x39, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x20, 0x7F, 0xE0, 0x3F, 0x7F, 0x00, 0x17, 0xE0, 0x00, 
	0xC1, 0x3F, 0x6B, 0x77, 0xFF, 0xDC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x37, 0xFF, 0xFF, 0xF9, 0xFF, 0xCF, 0xFF, 0xFF, 0x39, 0xFF, 
	0xFF, 0x00, 0xCD, 0xCC, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x8C, 0x73, 0xFF, 0xFF, 0x83, 0x1C, 
	0xFF, 0x9D, 0x08, 0xFF, 0xFF, 0xFF, 0xEF, 0x70, 0x00, 0x03, 0x3F, 0xFF, 0xFF, 0xE0, 0x3F, 0xC5, 
	0x3F, 0x11, 0xAB, 0x77, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0x73, 
	0xFF, 0x13, 0x93, 0x9B, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x99, 0xFE, 0x06, 0x77, 0xEE, 
	0x77, 0xCE, 0x8C, 0xFF, 0xFF, 0xFF, 0xEC, 0x4F, 0x7F, 0xFF, 0xFF, 0xFE, 0x80, 0x60, 0x1E, 0x99, 
	0xFF, 0x11, 0xBB, 0x33, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x93, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1C, 
	0xFF, 0xEE, 0x60, 0x01, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0xC6, 0xCD, 0x80, 0x80, 0xCC, 
	0xFF, 0xEE, 0x77, 0x00, 0xFF, 0xE8, 0x03, 0x7F, 0xE0, 0xFF, 0xFF, 0xCC, 0x49, 0x3F, 0xEE, 0x11, 
	0xFF, 0x11, 0xBB, 0x73, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xEF, 
	0x18, 0xC8, 0x33, 0x7F, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x6B, 0x46, 0x83, 0x0C, 0x9B, 
	0xFF, 0xFF, 0x33, 0x1E, 0xE0, 0x17, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xCC, 0x37, 0xFF, 0xEE, 0x11, 
	0xFF, 0x12, 0x37, 0x33, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEC, 0x7F, 0xFF, 0xFF, 0xFF, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0xF7, 0xFF, 0xFF, 
	0xCF, 0x33, 0x11, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x31, 0x8C, 0x33, 0x0C, 0x10, 0x37, 
	0xFF, 0xFF, 0x00, 0x00, 0x03, 0x7F, 0xFF, 0xF3, 0x08, 0xFF, 0xFF, 0xCC, 0x37, 0xFF, 0xEE, 0x99, 
	0xFF, 0xE8, 0x59, 0x33, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0x7F, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xEF, 0x73, 0xFF, 0xFF, 
	0xEE, 0x7E, 0x37, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0x95, 0xFF, 0xFF, 0x7F, 
	0xFF, 0xE8, 0x7F, 0xFF, 0xFF, 0xF8, 0x80, 0x00, 0x84, 0xFF, 0xFF, 0xCC, 0x33, 0xFF, 0xEC, 0xDC, 
	0x80, 0x3F, 0x19, 0x33, 0xFF, 0xEE, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x93, 0xFF, 0xFF, 0x00, 0xFD, 0xFF, 0xFF, 0xFF, 0x9D, 0xFF, 0x00, 
	0xCC, 0x81, 0x13, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xF7, 0xFF, 0xFF, 
	0x40, 0x03, 0x7F, 0xFF, 0xF8, 0x87, 0xF0, 0xEE, 0x77, 0xFF, 0xFF, 0xCC, 0x33, 0xFF, 0xC9, 0xB1, 
	0xE8, 0x03, 0xF7, 0x77, 0xFF, 0xCE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xC8, 0x7F, 0xFF, 0xFF, 0x13, 0x93, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 
	0xA2, 0x77, 0xFF, 0x07, 0x3E, 0xF0, 0xF0, 0xF0, 0xF0, 0x70, 0xCE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0xDC, 0x30, 0xF0, 0x01, 
	0x1F, 0xFF, 0xFC, 0xC0, 0x00, 0xE1, 0x0F, 0x66, 0x77, 0xFF, 0xFF, 0xCC, 0x73, 0xE0, 0x36, 0x02, 
	0x37, 0xFF, 0x33, 0x77, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0xFF, 0xFF, 0xFF, 0x13, 0xFF, 0xFF, 0xFF, 0xEC, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 
	0x7F, 0x33, 0xFE, 0xF0, 0xE1, 0x0F, 0x0F, 0x0F, 0x7F, 0x8F, 0x73, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x80, 0x00, 0x29, 0xE8, 0x00, 0x21, 0x39, 0x8D, 0x0F, 0x0F, 0x3F, 
	0xFF, 0xFC, 0xC3, 0x61, 0x49, 0x3F, 0xFE, 0x66, 0x77, 0xFF, 0xFF, 0xCC, 0x8F, 0x3C, 0x10, 0xEE, 
	0x44, 0x11, 0x32, 0x77, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0F, 0xFC, 0xC0, 0x80, 0x3F, 0xFF, 0xFF, 0xFE, 0x80, 0x70, 0xF7, 0xFF, 0xFF, 0xFF, 0xF3, 0xC8, 
	0xEC, 0x37, 0xC8, 0x10, 0xF0, 0xF3, 0xFE, 0x07, 0x01, 0xF3, 0x31, 0x8C, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0x77, 0xFF, 0xDD, 0x99, 0xFF, 0xCC, 0x11, 0xDD, 0xFF, 0xFF, 0xFF, 
	0xC8, 0x00, 0x83, 0x4E, 0x99, 0xFF, 0xEE, 0x66, 0x77, 0xFF, 0xFF, 0xCC, 0xEC, 0x1F, 0xEE, 0xEE, 
	0x44, 0x11, 0xA2, 0x77, 0xFF, 0xEE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF0, 0x80, 0x03, 0x49, 0x80, 0xFF, 0xFF, 0xE8, 0x03, 0x00, 0x30, 0xFF, 0xFF, 0xFF, 0xDE, 0x8F, 
	0x2F, 0x77, 0xC8, 0x07, 0x1F, 0xCC, 0xEE, 0x33, 0x30, 0x88, 0xB9, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0x33, 0xFF, 0xCC, 0x11, 0xFF, 0xCC, 0x99, 0xDD, 0x88, 0xFF, 0x11, 
	0x98, 0x03, 0x68, 0xEE, 0x11, 0xFF, 0xFF, 0x66, 0x77, 0xFF, 0xFF, 0xCC, 0x99, 0x80, 0xEE, 0xEE, 
	0x77, 0xFE, 0x26, 0x77, 0xFF, 0xEC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x1F, 0x7F, 0xE8, 0x3F, 0x0F, 0xF0, 0xE0, 0x07, 0xFF, 0xEF, 0x0F, 0x0C, 0xF0, 0xF0, 0xF0, 0x03, 
	0x0C, 0x77, 0x8C, 0x33, 0xFF, 0xCC, 0xEE, 0x77, 0x00, 0x88, 0x91, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0x33, 0xFF, 0xCC, 0x99, 0xFF, 0xCC, 0x99, 0xDD, 0x88, 0xFF, 0x11, 
	0x88, 0x77, 0x00, 0xEE, 0x11, 0xFF, 0xEE, 0x66, 0x77, 0xFF, 0xFF, 0xCC, 0x99, 0x00, 0xEE, 0xEF, 
	0x70, 0x80, 0xEE, 0x77, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x10, 0x0B, 0x00, 0x00, 0x03, 0x0F, 0x7C, 0x7F, 0xFF, 0xF3, 0xEF, 0x0F, 0x0F, 0x0F, 0x3F, 
	0xEE, 0x77, 0x8C, 0x33, 0x00, 0xEE, 0xEE, 0x77, 0xFF, 0x9D, 0xDD, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0x73, 0xFF, 0xDD, 0x99, 0xFF, 0xC9, 0x9D, 0xCC, 0x88, 0xFF, 0x11, 
	0x88, 0x77, 0xFF, 0xEE, 0x11, 0xFF, 0xC1, 0xEE, 0x77, 0xFF, 0xFF, 0xCC, 0x99, 0xFF, 0xEE, 0x18, 
	0x8F, 0x7C, 0x01, 0x88, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x01, 0xB3, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x33, 0x33, 0xCC, 0x33, 0x0F, 0xEC, 0xEE, 0x73, 0xF0, 0x90, 0xDD, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x38, 0x00, 0x16, 0x8E, 0x00, 0x0C, 0xDD, 0xDC, 0x88, 0xFF, 0x10, 
	0x88, 0x77, 0xFF, 0xEE, 0xDC, 0x80, 0x7C, 0xEE, 0x77, 0xFF, 0xFF, 0xCC, 0x99, 0xFC, 0xC1, 0x83, 
	0xF8, 0x07, 0x7F, 0x00, 0xFF, 0xCE, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x11, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x11, 0x3B, 0xCC, 0x38, 0xF0, 0x13, 0x90, 0x0F, 0x0F, 0x7F, 0xDD, 0x77, 0xFF, 0x00, 0xFF, 0xFF, 
	0xFF, 0x00, 0xFF, 0xFF, 0xCC, 0xF8, 0x00, 0xE1, 0xFC, 0x00, 0xE3, 0xDD, 0xCC, 0x88, 0xFF, 0xFF, 
	0x8C, 0x77, 0xFF, 0xC9, 0xFF, 0x40, 0x07, 0x66, 0x77, 0xFF, 0xFF, 0xCC, 0xCE, 0x87, 0x00, 0x01, 
	0x0F, 0xE8, 0xFF, 0xFF, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x11, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x0F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x11, 0xBB, 0xCC, 0xFF, 0xF0, 0xF3, 0x01, 0xF8, 0xE0, 0x73, 0xDD, 0x77, 0xFF, 0x03, 0xF8, 0xF0, 
	0xF0, 0xC7, 0xFF, 0xFF, 0xCC, 0x93, 0xFF, 0x9C, 0x99, 0x7F, 0x9C, 0xDD, 0xCC, 0x88, 0xFF, 0xFF, 
	0xCC, 0x73, 0xE0, 0x36, 0xEC, 0x3F, 0xFF, 0x62, 0x77, 0xFF, 0xFF, 0xEE, 0xF0, 0xC1, 0x1F, 0xFF, 
	0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xEE, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x77, 0xFF, 0xFF, 0x00, 0xFF, 0xFC, 0xF0, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x11, 0x99, 0xCC, 0xC9, 0x07, 0x0E, 0xF6, 0x07, 0x1F, 0x88, 0xDD, 0x77, 0xFF, 0xF8, 0x07, 0x0F, 
	0x0F, 0x38, 0xF7, 0x00, 0xCC, 0x33, 0xFF, 0xCC, 0x99, 0xFF, 0xCC, 0xDD, 0xCC, 0x88, 0xFF, 0xFF, 
	0xCC, 0x8E, 0x01, 0x1C, 0xCC, 0x88, 0x11, 0x66, 0x77, 0xFF, 0xFF, 0x21, 0x0F, 0x3F, 0xE0, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEE, 0x77, 0xFF, 0xFB, 0x1F, 0xC0, 0x00, 0x07, 0x08, 0x00, 0x30, 0xF0, 0xB6, 0xFF, 0xFF, 
	0x11, 0x99, 0xEE, 0x99, 0xFF, 0xEF, 0x77, 0x33, 0xFF, 0x89, 0xDD, 0x77, 0xE8, 0x14, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x31, 0x8C, 0xCC, 0x33, 0xFF, 0xCC, 0x99, 0xFF, 0xCC, 0xD9, 0xCC, 0x88, 0xFF, 0xFF, 
	0xCC, 0xCB, 0x7F, 0xCE, 0xCC, 0x88, 0x11, 0x66, 0x77, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEE, 0x77, 0x00, 0xFC, 0xE4, 0x3F, 0xDD, 0xF9, 0xCC, 0xFF, 0x01, 0x6F, 0x7B, 0x08, 0xFF, 
	0xFF, 0x99, 0xEE, 0x95, 0x00, 0x01, 0x33, 0x33, 0xFF, 0xDC, 0x99, 0x77, 0x93, 0xFE, 0xF0, 0x80, 
	0xF7, 0xFF, 0xCE, 0xF7, 0xCC, 0x33, 0xFF, 0xCC, 0x99, 0xFF, 0xCC, 0x99, 0xCC, 0x88, 0xFF, 0xFF, 
	0xCC, 0x33, 0xFF, 0xCC, 0xCC, 0xFF, 0xFE, 0x66, 0x44, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xCD, 0xFB, 0x11, 0x82, 0xCC, 0xFF, 0xCE, 0xF0, 0x80, 0xFF, 0x31, 0x30, 0x90, 0x8C, 0xFF, 
	0xFF, 0x99, 0xEE, 0x55, 0x09, 0x1F, 0xB3, 0x33, 0xF0, 0xD0, 0x99, 0x66, 0x77, 0xCC, 0xCF, 0x7F, 
	0x33, 0xFF, 0xFF, 0x33, 0xCE, 0x98, 0xF0, 0x90, 0x9C, 0xF0, 0xC1, 0x99, 0xCC, 0x88, 0xFF, 0xFF, 
	0xCC, 0x33, 0xFF, 0xCC, 0xCC, 0xF0, 0x02, 0xD1, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xF0, 0xF0, 0xF0, 0xF0, 
	0xFF, 0xDD, 0x88, 0xFF, 0xB8, 0x0E, 0xFF, 0xFF, 0xF7, 0xEC, 0xFF, 0xCD, 0x1F, 0x89, 0x73, 0xFF, 
	0xFF, 0xDD, 0xEE, 0x56, 0xF0, 0xC1, 0x7F, 0x8F, 0x0F, 0x7F, 0x13, 0xCC, 0x88, 0xCC, 0xFF, 0xFE, 
	0x77, 0xFF, 0xFF, 0x99, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x13, 0xCC, 0x88, 0xFF, 0xFF, 
	0xCC, 0x33, 0xFF, 0xC9, 0xEF, 0x1C, 0x01, 0x3F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x99, 0x89, 0xFA, 0xB1, 0xCC, 0xF0, 0xF0, 0x70, 0xE8, 0xF0, 0xD0, 0xF0, 0x90, 0x10, 0xF1, 
	0x7B, 0xCC, 0xEF, 0x7B, 0x10, 0xF8, 0xF0, 0xF0, 0xF0, 0x80, 0x3F, 0xCC, 0x88, 0xEF, 0x71, 0xCD, 
	0xFB, 0xFF, 0xFF, 0x9D, 0xFF, 0xCF, 0x2F, 0x0F, 0x1F, 0xFF, 0xFF, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 
	0xCC, 0x33, 0xC0, 0x3F, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEE, 0x77, 0x91, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x19, 0xFE, 0xE7, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xFC, 0x9C, 
	0xF7, 0xCC, 0x98, 0x8C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3F, 0xD9, 0x88, 0xFF, 0x8E, 0x13, 
	0x7F, 0xFF, 0xFF, 0xCC, 0x77, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0xCC, 0x88, 0xFF, 0xFF, 
	0xCC, 0x8F, 0x3E, 0x00, 0x17, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x01, 0xF7, 0xEC, 0xCC, 0x66, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xF0, 
	0xFF, 0x9B, 0xEE, 0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0xFF, 0x0F, 0x80, 0x40, 
	0x77, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB2, 0x11, 0x88, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xCC, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCC, 0x88, 0xFF, 0xFF, 
	0xCE, 0xF0, 0x07, 0x7F, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x88, 0xDE, 0xB7, 0x99, 
	0xFF, 0xFF, 0x10, 0x19, 0xCC, 0xEE, 0x66, 0xD4, 0xC0, 0x00, 0x11, 0xFF, 0xFF, 0xFF, 0x8F, 0x0F, 
	0x00, 0x33, 0xEE, 0xF7, 0xF0, 0xF0, 0xF0, 0xF0, 0x72, 0xEC, 0xF0, 0xF0, 0xF0, 0xF0, 0x98, 0x51, 
	0x7F, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x21, 0x5D, 0x88, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xCC, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 
	0xEF, 0x0F, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x99, 0xFF, 0xEF, 0x73, 0x9E, 
	0xEE, 0x77, 0x00, 0xCC, 0xD5, 0xCB, 0x42, 0x47, 0x3F, 0xF0, 0xE0, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x11, 0x33, 0xEE, 0x00, 0x11, 0xCC, 0x40, 0xEE, 0x77, 0xEE, 0x44, 0x44, 0xFF, 0x88, 0x87, 0x0F, 
	0x73, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0xF9, 0x88, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xEE, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8A, 0xF7, 0xEE, 0x33, 0x66, 
	0xCC, 0x77, 0x07, 0xCC, 0x33, 0x33, 0x7F, 0xFF, 0xFF, 0x00, 0x00, 0xCF, 0x00, 0x00, 0x00, 0x00, 
	0x11, 0x33, 0xEE, 0x77, 0x33, 0xCC, 0x77, 0xEE, 0x77, 0xEE, 0x77, 0xDD, 0x66, 0xCC, 0x77, 0x73, 
	0x33, 0xCE, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0x88, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x89, 0x77, 0xED, 0x32, 0x45, 
	0xA2, 0xFC, 0xC0, 0x03, 0x3D, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0xF0, 0xE0, 0x00, 
	0x10, 0x77, 0xEE, 0x77, 0x33, 0xCC, 0x77, 0xEE, 0x77, 0xEE, 0x77, 0xDD, 0x66, 0xDD, 0x30, 0xAE, 
	0x77, 0xEE, 0xC4, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0x88, 0xFF, 0xFF, 0xFF, 
	0xFE, 0xFE, 0xF3, 0xEE, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x99, 0x33, 0x93, 0x61, 0xCC, 
	0x6E, 0x07, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F, 
	0xEE, 0x77, 0xEE, 0x7F, 0x11, 0xCC, 0x77, 0xEE, 0x77, 0xCC, 0x77, 0xCC, 0x66, 0xCC, 0xCF, 0x11, 
	0x6C, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x83, 0x1E, 0xE6, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xF0, 0xD6, 0x9D, 0x37, 0x33, 0xCD, 
	0x9F, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xEE, 0x77, 0xCC, 0xFF, 0x11, 0xCC, 0x77, 0xEE, 0x77, 0xCC, 0x77, 0xCC, 0x66, 0xCC, 0xFF, 0x11, 
	0x8C, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 0xFF, 
	0xEE, 0x76, 0x07, 0x6E, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0x71, 0x0C, 0x46, 0x67, 0x7F, 0xFF, 
	0x7F, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xCD, 0xC8, 0xCC, 0xFF, 0x11, 0xCC, 0x77, 0xEE, 0x77, 0xCC, 0x77, 0xCC, 0xF7, 0x88, 0xFF, 0x11, 
	0xCC, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xEF, 0x60, 0x77, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xCC, 0x88, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xE7, 0x67, 0x7B, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xF0, 0xF0, 0xF0, 0xF6, 0xF0, 0xF0, 0xF2, 0xF3, 0x00, 0x00, 
	0xDD, 0x88, 0xCC, 0xFF, 0x13, 0xCC, 0x77, 0xEE, 0x77, 0xCC, 0x73, 0xCD, 0x77, 0xC8, 0xFF, 0x11, 
	0xCC, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xF7, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x9F, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0x03, 0x0F, 0xFF, 0xFF, 0xEE, 0xC4, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xF2, 0xF2, 0xE0, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0x0F, 0x0F, 0x0F, 0x4F, 0x0F, 0x0F, 0x2F, 0x3F, 0x0F, 0x0E, 
	0x11, 0x88, 0xCC, 0xFF, 0x13, 0xCC, 0x77, 0xEE, 0x77, 0xCC, 0x33, 0xCC, 0x77, 0x88, 0xFF, 0xDC, 
	0x77, 0xEE, 0x77, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xEC, 0x77, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xFF, 0xF8, 0x31, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFE, 0x94, 0x09, 0x03, 0x3F, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x00, 0x00, 
	0x99, 0x80, 0xCC, 0xFF, 0x33, 0xCC, 0x77, 0xEE, 0x77, 0xCC, 0x73, 0xCC, 0x77, 0x88, 0xFF, 0xCC, 
	0x77, 0xEE, 0x77, 0xFF, 0x13, 0xF1, 0xFC, 0x80, 0xF7, 0xFF, 0x11, 0x88, 0x77, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0xEC, 0x08, 0x37, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 
	0xFF, 0xFD, 0x0C, 0x0C, 0xFF, 0xFF, 0xCD, 0x9B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 
	0x00, 0x00, 0x11, 0x88, 0x00, 0x00, 0xCC, 0x00, 0x00, 0x64, 0x00, 0x00, 0x62, 0x77, 0xFF, 0xFF, 
	0x13, 0xFF, 0xCC, 0x00, 0x33, 0xCC, 0x00, 0x02, 0x77, 0xCC, 0x02, 0x04, 0x77, 0x88, 0x00, 0x06, 
	0x77, 0x23, 0x77, 0x00, 0xEC, 0x13, 0xD2, 0x03, 0x7F, 0xFF, 0x11, 0x88, 0x77, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0x01, 0x9B, 0x11, 0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x32, 0xF6, 0xF7, 0xF8, 0x93, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 
	0xF0, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x33, 0xFE, 0x88, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x3F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
	0x31, 0xBF, 0x73, 0x11, 0xA2, 0x6C, 0x4D, 0x7F, 0xFF, 0xFF, 0x00, 0x8C, 0x77, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0x11, 0x22, 0x77, 0xE8, 0xF3, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 
	0x99, 0xC8, 0xCA, 0x42, 0x40, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
	0x00, 0x00, 0xF8, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF7, 0xFF, 
	0x33, 0xCC, 0x7B, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF2, 
	0x62, 0x77, 0x33, 0xFE, 0x45, 0x9B, 0x93, 0x80, 0xFF, 0xFF, 0xFC, 0xCE, 0x77, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xFF, 0xFF, 0x44, 0x7C, 0x17, 0x7F, 0xFF, 0xEE, 0x77, 0x03, 0xF3, 
	0xD9, 0xAA, 0x26, 0x67, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xCF, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x7F, 0xFF, 
	0x37, 0xCC, 0x1B, 0x0F, 0x0E, 0x00, 0x04, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x2C, 
	0x60, 0x77, 0x33, 0xEC, 0x9B, 0x36, 0x37, 0x01, 0xF8, 0xF2, 0x81, 0xEC, 0x77, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xEE, 0x77, 0xC8, 0x70, 0x45, 0x8A, 0x76, 0x90, 0x77, 0xEE, 0x77, 0x10, 0x0C, 
	0xA2, 0x37, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 
	0xF0, 0xF0, 0xF0, 0xF8, 0xF0, 0xF0, 0xFC, 0xF0, 0xF1, 0xFC, 0xF0, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x74, 0xE7, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 
	0x17, 0x59, 0xAA, 0x67, 0xAA, 0xEE, 0x77, 0xFF, 0x8E, 0x30, 0xBA, 0x93, 0x77, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x00, 0x00, 0xEE, 0x77, 0xCF, 0xC6, 0xD4, 0x66, 0x92, 0x37, 0xFF, 0xEE, 0x77, 0xFF, 0xC8, 
	0x9B, 0x7B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0x0F, 0x0F, 0xCF, 0x0F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x44, 0x33, 0x88, 0x00, 0x01, 0x08, 0x00, 0x00, 0x11, 0xCC, 0x00, 0x00, 0x77, 0xCC, 0x88, 0xEF, 
	0x77, 0x11, 0xBB, 0x19, 0xB9, 0xCC, 0xFC, 0xF0, 0xF1, 0xC6, 0x9D, 0xB2, 0x70, 0xF0, 0xF0, 0xF0, 
	0xF0, 0x0F, 0x0F, 0xEE, 0x77, 0xF0, 0xB3, 0x46, 0xEE, 0x6E, 0x73, 0xF0, 0xE6, 0x76, 0xC0, 0x3F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF1, 
	0xFF, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xFE, 0xF0, 0xF0, 0xF0, 0xFE, 0xF0, 0xF0, 0xF1, 
	0xCE, 0x9D, 0x82, 0x04, 0x10, 0x00, 0x11, 0x3A, 0x33, 0xCC, 0x03, 0x40, 0x33, 0x80, 0x00, 0x00, 
	0x77, 0xFF, 0xBA, 0x04, 0x99, 0xCC, 0x07, 0x0F, 0x0F, 0x2D, 0x7E, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0C, 0x00, 0x00, 0x07, 0x0F, 0x7E, 0xBD, 0x4B, 0xED, 0x0F, 0x0F, 0x0C, 0x03, 0x3F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x2F, 0x0F, 0x0F, 0x1F, 
	0xFF, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x4F, 0x0F, 0xEF, 0x0F, 0x0F, 0x0F, 0xEF, 0x0F, 0x0F, 0x1F, 
	0xC0, 0xCE, 0x6F, 0xCF, 0x1F, 0x0F, 0x0F, 0xEF, 0x0F, 0x0F, 0x1F, 0xCF, 0x0F, 0x0F, 0x0F, 0x0F, 
	0x28, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xF0, 
	0xF0, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xF7, 0xFF, 0xF0, 0xF0, 0xF1, 0xFF, 0xFF, 0xFF, 
	0x3F, 0x5F, 0x90, 0x30, 0xFF, 0xFF, 0x70, 0x50, 0xF0, 0xF0, 0xE0, 0x3F, 0xF0, 0xB0, 0xD0, 0xF0, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x7F, 0xEF, 0x0F, 0x0F, 0x1F, 0xFF, 0xFF, 0xEF, 
	0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
};
