#include "../include.h"

// format: 8-bit paletted pixel graphics
// image width: 54 pixels
// image height: 54 lines
// image pitch: 56 bytes
const u16 ImgPattern_Pal[256] __attribute__ ((aligned(4))) = {
	0x01CC, 0x01CC, 0x01AB, 0x01AB, 0x01AB, 0x018B, 0x018A, 0x041B, 0x03FB, 0x03FA, 0x03DA, 0x03B9, 0x03B9, 0x03B8, 0x0398, 0x0398, 
	0x0314, 0x02F4, 0x02F3, 0x02D3, 0x02D3, 0x02D3, 0x02D2, 0x02B2, 0x02B2, 0x02B2, 0x0291, 0x0291, 0x0291, 0x0271, 0x0270, 0x0270, 
	0x0250, 0x016A, 0x0169, 0x0169, 0x0149, 0x0149, 0x0128, 0x0128, 0x0377, 0x0377, 0x0377, 0x0357, 0x0356, 0x0356, 0x0336, 0x0335, 
	0x0335, 0x0315, 0x0314, 0x02F4, 0x024F, 0x024F, 0x022F, 0x022F, 0x022E, 0x022E, 0x020E, 0x020E, 0x020E, 0x020D, 0x01ED, 0x01ED, 
	0x01EC, 0x0128, 0x0127, 0x0107, 0x01CC, 0x01CC, 0x01CC, 0x01CC, 0x01CC, 0x01AB, 0x01AB, 0x00E6, 0x01CC, 0x01CC, 0x01AB, 0x01AB, 
	0x045C, 0x043C, 0x043B, 0x041B, 0x041B, 0x041B, 0x041B, 0x041B, 0x041A, 0x041A, 0x03FA, 0x041A, 0x03FA, 0x03FA, 0x03FA, 0x03FA, 
	0x03FA, 0x03D9, 0x03F9, 0x03D9, 0x03D9, 0x03D9, 0x03B9, 0x03D9, 0x03D9, 0x03B9, 0x03D9, 0x03B8, 0x03B8, 0x03B8, 0x0398, 0x03B8, 
	0x0398, 0x0314, 0x02F4, 0x02F4, 0x02F3, 0x02D3, 0x02D3, 0x02B2, 0x02B2, 0x02B1, 0x0291, 0x0291, 0x0270, 0x0270, 0x0270, 0x018A, 
	0x018A, 0x018A, 0x016A, 0x0169, 0x0169, 0x0148, 0x0148, 0x0148, 0x0128, 0x047D, 0x045C, 0x043C, 0x041B, 0x0398, 0x0397, 0x0397, 
	0x0397, 0x0377, 0x0377, 0x0397, 0x0377, 0x0377, 0x0376, 0x0356, 0x0356, 0x0356, 0x0356, 0x0356, 0x0355, 0x0335, 0x0335, 0x0335, 
	0x0335, 0x0315, 0x0334, 0x0314, 0x0314, 0x024F, 0x024F, 0x022E, 0x020E, 0x020D, 0x01ED, 0x0127, 0x0107, 0x0106, 0x01CB, 0x01AB, 
	0x043B, 0x043A, 0x041A, 0x043A, 0x041A, 0x041A, 0x041A, 0x041A, 0x03FA, 0x0419, 0x03F9, 0x03F9, 0x03F9, 0x03D9, 0x03D8, 0x03D8, 
	0x04BE, 0x04BE, 0x049D, 0x049D, 0x047C, 0x045C, 0x047C, 0x045C, 0x045B, 0x045B, 0x043B, 0x045B, 0x045B, 0x043B, 0x041A, 0x043A, 
	0x03B7, 0x0397, 0x03B7, 0x0396, 0x0376, 0x03F9, 0x0419, 0x0419, 0x03F8, 0x03D8, 0x04FF, 0x04FE, 0x04DE, 0x04BD, 0x049C, 0x049C, 
	0x047B, 0x049B, 0x047B, 0x045A, 0x043A, 0x043A, 0x0419, 0x053F, 0x051E, 0x04FD, 0x04DC, 0x04BC, 0x04BC, 0x049B, 0x049B, 0x047A, 
	0x045A, 0x0459, 0x053D, 0x04FC, 0x04BB, 0x049A, 0x055F, 0x055E, 0x055E, 0x0459, 0x057E, 0x057E, 0x051C, 0x05BF, 0x059E, 0x063F, 
};

const u8 ImgPattern[3024] __attribute__ ((aligned(4))) = {
	0x38, 0x3F, 0x47, 0x37, 0x92, 0xF7, 0xDB, 0xFB, 0xEA, 0x2E, 0x3B, 0x4C, 0x34, 0xBF, 0xF7, 0x08, 
	0x52, 0xFF, 0xF7, 0xDE, 0x16, 0x34, 0x1A, 0x6F, 0xE2, 0x16, 0x70, 0xC6, 0x18, 0x3A, 0x1E, 0x11, 
	0x33, 0x2B, 0xC9, 0x53, 0x90, 0xA5, 0x00, 0x4D, 0x3B, 0xA9, 0x00, 0x4E, 0x3F, 0x3F, 0x71, 0xF2, 
	0x11, 0x3B, 0x37, 0x30, 0x6B, 0x39, 0x00, 0x00, 0x45, 0x23, 0x87, 0x4F, 0x34, 0x2C, 0xC4, 0xE7, 
	0x07, 0x32, 0x1C, 0x7A, 0x2A, 0xE7, 0x0C, 0x0E, 0xDB, 0x63, 0xA0, 0x9D, 0xB8, 0x94, 0xE2, 0x5F, 
	0x98, 0x15, 0x6C, 0x8D, 0x1D, 0x34, 0x78, 0x2C, 0xE8, 0xF7, 0xF2, 0x70, 0x18, 0x3C, 0x06, 0x21, 
	0x40, 0xA9, 0x06, 0x4D, 0x06, 0x80, 0x3D, 0x2A, 0xE0, 0x6A, 0x6E, 0xE9, 0x13, 0x4E, 0x00, 0x00, 
	0x3F, 0x82, 0x25, 0x48, 0x7D, 0x2E, 0x0A, 0x50, 0xFA, 0x58, 0x65, 0x0A, 0x08, 0xF2, 0xFB, 0xC2, 
	0x55, 0x30, 0x1C, 0x39, 0x7B, 0x14, 0xA1, 0x1F, 0x34, 0x33, 0x56, 0xA1, 0x35, 0x1C, 0x34, 0xA1, 
	0x51, 0x28, 0x2A, 0x30, 0x1A, 0x45, 0xAE, 0x47, 0xA9, 0x45, 0x06, 0x4D, 0x21, 0x83, 0x03, 0x1F, 
	0x74, 0x6C, 0xBA, 0x2B, 0x7B, 0x46, 0x00, 0x00, 0x39, 0x45, 0x01, 0xA8, 0x1F, 0x70, 0xC3, 0x91, 
	0x97, 0x28, 0xF0, 0xF7, 0x0B, 0x2E, 0x9B, 0x0D, 0x2F, 0x34, 0x20, 0x35, 0x3D, 0xAA, 0x45, 0x39, 
	0x3A, 0x2D, 0x89, 0x11, 0x35, 0x1D, 0x38, 0x32, 0x07, 0x70, 0x29, 0x30, 0x7D, 0xA9, 0x02, 0x04, 
	0x02, 0x4D, 0x37, 0x34, 0xA9, 0x02, 0x49, 0x38, 0x34, 0x38, 0x18, 0x73, 0x1D, 0x3D, 0x00, 0x00, 
	0x37, 0x7D, 0x7C, 0x7D, 0x2D, 0xF8, 0x97, 0x3B, 0x01, 0x3E, 0x3D, 0xD3, 0x5E, 0x7B, 0xA5, 0x1F, 
	0x1F, 0x38, 0xA7, 0x38, 0x3F, 0x45, 0x24, 0x84, 0x3D, 0x98, 0xDD, 0x11, 0x36, 0x3B, 0x37, 0x9D, 
	0xC2, 0x5A, 0x0F, 0x13, 0x3D, 0x02, 0x05, 0x04, 0x45, 0x7D, 0x8D, 0xCD, 0xD1, 0x30, 0x18, 0xA6, 
	0x3D, 0x3D, 0x3C, 0x34, 0x39, 0x3A, 0x00, 0x00, 0x36, 0x34, 0x18, 0x12, 0x67, 0xA1, 0x7D, 0x40, 
	0x23, 0x84, 0x82, 0x79, 0xE9, 0x2F, 0x1F, 0x1B, 0x1B, 0x7D, 0x7D, 0x3E, 0x80, 0x25, 0x84, 0x88, 
	0x04, 0x30, 0x62, 0x36, 0x45, 0x3D, 0x1B, 0xF3, 0x8D, 0x18, 0x18, 0x19, 0x49, 0x04, 0x40, 0xA5, 
	0x19, 0x69, 0x77, 0x34, 0x36, 0x14, 0xC8, 0xA1, 0x3B, 0x3F, 0x38, 0x3C, 0xA9, 0x38, 0x00, 0x00, 
	0x39, 0x39, 0x34, 0x1F, 0x6A, 0x7A, 0xA9, 0x46, 0x02, 0x82, 0x4F, 0x37, 0x30, 0x5A, 0x13, 0x7B, 
	0x77, 0x7B, 0x19, 0x20, 0x06, 0x86, 0x80, 0x22, 0x46, 0x99, 0xEE, 0x34, 0xA9, 0x1E, 0x9B, 0xCB, 
	0x1E, 0x3E, 0xA8, 0xA7, 0x47, 0xAA, 0x4F, 0xA9, 0x2C, 0xCC, 0x3B, 0x46, 0x4D, 0x45, 0x15, 0x63, 
	0x72, 0x37, 0xA9, 0x03, 0x02, 0x3B, 0x00, 0x00, 0x05, 0xAA, 0xA9, 0x3A, 0x6D, 0x1C, 0x40, 0x04, 
	0x7F, 0x42, 0x41, 0x48, 0x3E, 0x11, 0x60, 0xB9, 0x72, 0x12, 0x79, 0x18, 0x3E, 0x25, 0x87, 0x21, 
	0xAA, 0x9B, 0xFC, 0x1C, 0x34, 0x34, 0x2B, 0x13, 0x40, 0x4D, 0x40, 0x40, 0x45, 0x22, 0x84, 0xAA, 
	0x73, 0xF3, 0x20, 0x40, 0x86, 0x85, 0x3E, 0x11, 0x5B, 0x71, 0x47, 0x83, 0x06, 0xAE, 0xCD, 0x3F, 
	0xAB, 0x24, 0xAA, 0x7A, 0xB4, 0x37, 0x06, 0x24, 0x86, 0x85, 0x85, 0xAB, 0x86, 0x05, 0x7E, 0xE6, 
	0xC7, 0x92, 0x17, 0x3A, 0x7F, 0x81, 0x87, 0xAD, 0x86, 0x7D, 0xCB, 0x74, 0x7B, 0x38, 0x2A, 0x18, 
	0x40, 0x03, 0x45, 0x06, 0x48, 0x05, 0x4F, 0x20, 0xB9, 0xF4, 0x1F, 0x05, 0x42, 0xAD, 0x81, 0x35, 
	0x9E, 0xD7, 0x46, 0x85, 0x24, 0x84, 0x00, 0x00, 0xAD, 0xAD, 0x49, 0x9C, 0xD9, 0xA9, 0x7F, 0x88, 
	0x25, 0x22, 0x87, 0xAD, 0xAD, 0x88, 0x44, 0xA5, 0xA1, 0x5E, 0x79, 0xAA, 0x42, 0x4B, 0x88, 0xAD, 
	0x42, 0x3F, 0x68, 0x98, 0x16, 0x38, 0x11, 0xB4, 0x1F, 0x3A, 0xA7, 0x80, 0x05, 0x38, 0x35, 0x9D, 
	0xFF, 0xB9, 0x38, 0x04, 0x22, 0xAB, 0x49, 0x4D, 0x39, 0x5F, 0x19, 0x22, 0x41, 0x24, 0x00, 0x00, 
	0x42, 0xAC, 0x05, 0x9D, 0xA7, 0x83, 0x24, 0x21, 0x87, 0x81, 0x81, 0x26, 0xAB, 0x82, 0x81, 0x82, 
	0x36, 0x0D, 0x37, 0x47, 0xAC, 0x4B, 0xAD, 0x42, 0x41, 0x3E, 0x65, 0x0D, 0x78, 0x3F, 0x34, 0x32, 
	0xB1, 0xED, 0x12, 0x3A, 0x3E, 0x20, 0x7B, 0xA1, 0xB2, 0xF8, 0x17, 0x3F, 0x40, 0xAA, 0xA7, 0x3F, 
	0x36, 0xB4, 0xD7, 0x38, 0x06, 0x06, 0x00, 0x00, 0x80, 0x85, 0xAA, 0x71, 0x81, 0x24, 0x27, 0x82, 
	0x4D, 0x40, 0x49, 0x21, 0x83, 0x4F, 0x7F, 0x83, 0x3E, 0x69, 0x35, 0x45, 0x85, 0x4B, 0x4B, 0x83, 
	0x22, 0xA5, 0x63, 0x31, 0x3B, 0x83, 0x04, 0xAE, 0x7D, 0x2F, 0x57, 0xE5, 0x17, 0x7B, 0x13, 0x77, 
	0x72, 0xD0, 0xC5, 0xBC, 0xD2, 0xD2, 0x9B, 0x68, 0xF1, 0xC4, 0xFF, 0x65, 0x35, 0xA9, 0x00, 0x00, 
	0x1E, 0x40, 0x16, 0x7B, 0x23, 0x87, 0x05, 0x4A, 0xA6, 0x7B, 0x37, 0xAA, 0x3E, 0x4D, 0x45, 0x3C, 
	0x39, 0xB9, 0x93, 0x34, 0x81, 0xAC, 0xAC, 0x81, 0x04, 0x30, 0x14, 0xA5, 0x7F, 0xAD, 0x43, 0x22, 
	0x49, 0x4E, 0x38, 0xD5, 0x90, 0x34, 0x3A, 0x1E, 0x1A, 0x20, 0x20, 0x12, 0x0F, 0xBD, 0x2F, 0x30, 
	0xD5, 0xF7, 0xF2, 0xF8, 0x61, 0x79, 0x00, 0x00, 0x28, 0x14, 0xB5, 0x13, 0x02, 0x85, 0x48, 0x1F, 
	0x98, 0x57, 0xD9, 0x32, 0x11, 0x78, 0x1E, 0x1B, 0x17, 0x30, 0xB0, 0x18, 0x49, 0x88, 0x41, 0x03, 
	0x7B, 0x29, 0x3D, 0x44, 0x41, 0x4B, 0x27, 0x27, 0x84, 0x44, 0x3A, 0xBF, 0x28, 0x3E, 0x7F, 0x02, 
	0xAA, 0x3E, 0x02, 0x4D, 0x39, 0x7B, 0x1C, 0x7D, 0x7A, 0x9E, 0x52, 0x2E, 0x6A, 0xC8, 0x00, 0x00, 
	0xFE, 0x5F, 0xE7, 0x91, 0x3D, 0x4F, 0x3E, 0x10, 0x54, 0xE0, 0xF8, 0xE8, 0x5C, 0x60, 0xE2, 0x30, 
	0x1A, 0x1D, 0x99, 0x0E, 0x35, 0x04, 0x22, 0x04, 0xD3, 0x32, 0xA9, 0x04, 0x41, 0x27, 0xAC, 0xAD, 
	0xAC, 0x04, 0x1E, 0xB4, 0x32, 0x05, 0x27, 0x26, 0x21, 0x03, 0x83, 0x22, 0x45, 0x4D, 0x40, 0x3F, 
	0x00, 0x1D, 0x5E, 0x77, 0x17, 0x96, 0x00, 0x00, 0xC3, 0xE7, 0x89, 0xA1, 0x38, 0x49, 0x3C, 0x77, 
	0x50, 0x2E, 0x91, 0x92, 0x97, 0x66, 0xF8, 0xFD, 0x28, 0x20, 0x17, 0x69, 0x5E, 0x32, 0x38, 0x38, 
	0x93, 0xBE, 0x7D, 0x46, 0x04, 0x43, 0xAC, 0x42, 0x25, 0x01, 0x1B, 0xC9, 0x7A, 0x25, 0x27, 0x86, 
	0x84, 0x82, 0x26, 0x22, 0xAE, 0x7F, 0x05, 0x7F, 0x82, 0xAA, 0x6A, 0x10, 0x3B, 0x1D, 0x00, 0x00, 
	0xED, 0xF6, 0xF6, 0xBE, 0x7C, 0x3E, 0x3A, 0x1A, 0x65, 0x52, 0x32, 0x72, 0x16, 0x13, 0x2F, 0xC7, 
	0x62, 0x73, 0x1C, 0x16, 0x18, 0x28, 0x2A, 0x78, 0x13, 0x68, 0x6F, 0x1C, 0x3B, 0x80, 0x25, 0xAD, 
	0x88, 0x02, 0x34, 0x5E, 0x34, 0x42, 0x27, 0xAC, 0xAC, 0x83, 0x84, 0x4D, 0x40, 0x7F, 0x22, 0x22, 
	0x26, 0x04, 0xD3, 0x92, 0x3D, 0x20, 0x00, 0x00, 0x58, 0x28, 0xB8, 0xDD, 0x2F, 0x1B, 0x34, 0x19, 
	0x72, 0xF3, 0xE1, 0x6E, 0x11, 0x98, 0x0D, 0x5C, 0x5F, 0x2F, 0x1C, 0x20, 0x34, 0x10, 0x59, 0x7B, 
	0x20, 0x3F, 0x1F, 0x96, 0xA0, 0x48, 0xAC, 0xAC, 0x27, 0x02, 0x18, 0x96, 0x39, 0x27, 0x42, 0x21, 
	0x02, 0x40, 0x37, 0x1D, 0x11, 0x3D, 0x06, 0x25, 0x41, 0x83, 0x1C, 0x50, 0x1B, 0x72, 0x00, 0x00, 
	0x9F, 0x16, 0x18, 0x92, 0x95, 0xA7, 0x3B, 0x7D, 0x17, 0x13, 0xDD, 0xEA, 0x63, 0x60, 0xC5, 0xCA, 
	0x6E, 0x0B, 0x10, 0x72, 0x10, 0xCC, 0x9B, 0x45, 0x49, 0x80, 0x81, 0x40, 0x92, 0x20, 0x83, 0x24, 
	0x4E, 0xA2, 0xB4, 0x1E, 0x04, 0x23, 0x80, 0xAA, 0x3B, 0x19, 0xD6, 0x0F, 0xCD, 0x6C, 0x1E, 0xAA, 
	0x21, 0x82, 0x36, 0xEA, 0xB2, 0x51, 0x00, 0x00, 0x7C, 0x40, 0xA5, 0x1B, 0x60, 0x76, 0x1F, 0x16, 
	0x73, 0x15, 0x10, 0x14, 0x7D, 0x20, 0x7B, 0x72, 0x63, 0x8A, 0x50, 0xDD, 0x89, 0x6F, 0x38, 0x81, 
	0x04, 0x81, 0x22, 0x47, 0x9D, 0x72, 0x3F, 0x40, 0x99, 0xE9, 0x96, 0x39, 0x86, 0x27, 0x22, 0x35, 
	0x2A, 0xB0, 0x9B, 0x38, 0x1B, 0x5E, 0x19, 0xAA, 0xA9, 0x4D, 0x1B, 0x0D, 0x89, 0x60, 0x00, 0x00, 
	0x38, 0x04, 0xA8, 0x3B, 0x71, 0xC6, 0xF3, 0xE9, 0x63, 0x30, 0x34, 0xA5, 0x00, 0x00, 0x38, 0x19, 
	0x32, 0x5D, 0x12, 0x18, 0x1B, 0x37, 0x02, 0x05, 0x3E, 0x3F, 0xA9, 0x1E, 0x59, 0xA1, 0x1C, 0x79, 
	0xC9, 0x95, 0x1E, 0x00, 0x21, 0x82, 0x40, 0x9C, 0xF3, 0x18, 0xA5, 0xA9, 0x1C, 0xC9, 0x2F, 0x1F, 
	0x40, 0x40, 0x76, 0x2E, 0x63, 0x70, 0x00, 0x00, 0x12, 0x37, 0x35, 0xA9, 0x1C, 0x5E, 0xF6, 0xF6, 
	0xF2, 0x75, 0x3E, 0x05, 0x03, 0x4E, 0x4D, 0x7D, 0x6D, 0x2C, 0x1E, 0x3F, 0x46, 0x4F, 0x01, 0x45, 
	0x3F, 0x1B, 0x30, 0xED, 0x6E, 0x37, 0x38, 0x8E, 0x70, 0x39, 0xAE, 0x4E, 0x44, 0x3C, 0x32, 0xEF, 
	0x1C, 0x04, 0x04, 0x3E, 0x36, 0x90, 0x10, 0x36, 0x01, 0x01, 0x1B, 0x67, 0x89, 0x55, 0x00, 0x00, 
	0x65, 0x97, 0x99, 0xA1, 0x94, 0x56, 0xFB, 0xF6, 0x95, 0x20, 0x00, 0x7F, 0x06, 0x05, 0x37, 0x9B, 
	0xBA, 0x77, 0x3B, 0x45, 0x4D, 0x3F, 0x00, 0x02, 0x38, 0x72, 0x0A, 0x30, 0x3C, 0x03, 0x3E, 0xB8, 
	0x2E, 0x20, 0x3E, 0x4E, 0x3F, 0x1C, 0x68, 0x36, 0x05, 0x27, 0x21, 0x01, 0x02, 0x1F, 0x69, 0x32, 
	0x1E, 0xA6, 0x13, 0xF2, 0x50, 0x53, 0x00, 0x00, 0x2A, 0xB9, 0xF9, 0x8E, 0x7A, 0x1F, 0x76, 0x97, 
	0x35, 0x40, 0xA8, 0xA6, 0x7D, 0x71, 0xE4, 0x9D, 0xA6, 0x3F, 0x22, 0x21, 0x45, 0x3E, 0x3F, 0x35, 
	0x2F, 0xC8, 0x10, 0x1E, 0xAA, 0x05, 0x38, 0x6B, 0x0E, 0x7D, 0x02, 0x02, 0x38, 0x28, 0x13, 0x02, 
	0x83, 0x83, 0x05, 0x4A, 0x03, 0xAA, 0x19, 0x64, 0xE0, 0xB5, 0xE1, 0xFD, 0x2B, 0x2F, 0x00, 0x00, 
	0x13, 0x1C, 0x40, 0x40, 0x45, 0x03, 0x40, 0x38, 0xA8, 0x3E, 0x1C, 0x2C, 0xCA, 0x69, 0x73, 0xAA, 
	0x45, 0x84, 0x25, 0x80, 0x3F, 0x1E, 0x9E, 0x5D, 0xE8, 0x52, 0x13, 0x3E, 0x44, 0x02, 0x35, 0xD1, 
	0x59, 0x1F, 0x3C, 0xA6, 0x14, 0x69, 0x1F, 0x3E, 0x40, 0x45, 0x03, 0x40, 0x47, 0x40, 0xA5, 0x16, 
	0x70, 0xE7, 0xFF, 0xDB, 0x54, 0x2C, 0x00, 0x00, 0x16, 0xA6, 0x3E, 0x05, 0x04, 0x47, 0x45, 0x80, 
	0x81, 0x40, 0x18, 0x56, 0xEC, 0x14, 0x3B, 0x05, 0x22, 0x80, 0x22, 0x3E, 0x76, 0xCC, 0xFF, 0xFF, 
	0xE7, 0x90, 0x38, 0x02, 0x46, 0x4E, 0x7A, 0x56, 0x6E, 0x1F, 0xA8, 0x7D, 0x32, 0xC5, 0x2B, 0x19, 
	0x12, 0x12, 0x7B, 0x77, 0x7C, 0x1E, 0x72, 0x30, 0x66, 0xC2, 0x6C, 0x92, 0x57, 0xC5, 0x00, 0x00, 
	0x65, 0x7D, 0xAA, 0x3F, 0x48, 0x3D, 0x01, 0x21, 0x83, 0xAE, 0x7D, 0x30, 0xE9, 0x77, 0x04, 0xAB, 
	0x42, 0x02, 0x3B, 0x78, 0x73, 0xF2, 0xFA, 0xC0, 0xC2, 0x9B, 0x34, 0x3E, 0x4D, 0x02, 0x12, 0xC9, 
	0x18, 0x37, 0xAA, 0x3B, 0x79, 0xB1, 0x5C, 0x5B, 0x58, 0xDC, 0xEB, 0xFC, 0xD6, 0xC9, 0xDC, 0x5B, 
	0xC4, 0xD6, 0x77, 0x34, 0x72, 0x0E, 0x00, 0x00, 0xCE, 0xBB, 0x7C, 0x20, 0x3A, 0x1E, 0x34, 0x44, 
	0x4F, 0x3F, 0x38, 0x1E, 0xBD, 0xCD, 0x7C, 0x21, 0x88, 0x85, 0x48, 0x18, 0x32, 0xC1, 0xE7, 0xDA, 
	0x8A, 0x63, 0x17, 0x36, 0x04, 0x3C, 0x2A, 0x71, 0x40, 0x48, 0x81, 0x81, 0x40, 0x13, 0x19, 0x31, 
	0x2C, 0x28, 0x60, 0xCD, 0x6D, 0x63, 0xBB, 0x6D, 0x73, 0x1F, 0x3F, 0x05, 0x45, 0x15, 0x00, 0x00, 
	0x11, 0xC2, 0x32, 0x17, 0x19, 0x77, 0x14, 0x7B, 0x36, 0x3A, 0x4E, 0x40, 0x16, 0x94, 0x6E, 0x7D, 
	0x7F, 0x05, 0x3B, 0x74, 0x52, 0xE9, 0x61, 0x0D, 0x0F, 0x98, 0x1C, 0x47, 0x46, 0x20, 0x6F, 0xA9, 
	0x84, 0x82, 0x81, 0x27, 0x7F, 0x35, 0x10, 0x11, 0x30, 0x2F, 0x32, 0x16, 0x79, 0x19, 0x19, 0x1B, 
	0x34, 0x34, 0x3D, 0x01, 0x05, 0x3B, 0x00, 0x00, 0xCA, 0xC5, 0xA1, 0xA3, 0x97, 0x11, 0x14, 0x10, 
	0x35, 0x4E, 0x03, 0x48, 0x3C, 0x20, 0x18, 0x2A, 0x72, 0x12, 0xBA, 0xE0, 0x9D, 0x18, 0x12, 0x32, 
	0x29, 0x2D, 0x35, 0x40, 0x36, 0xA1, 0x13, 0x4E, 0x87, 0xAB, 0x83, 0x84, 0x04, 0x79, 0xE0, 0xC4, 
	0xCA, 0x6E, 0xA1, 0x78, 0x77, 0x17, 0x12, 0x11, 0x16, 0x7C, 0xAA, 0x3F, 0x1B, 0x76, 0x00, 0x00, 
	0xB9, 0x32, 0x16, 0x31, 0x0E, 0x72, 0x17, 0x7B, 0x3D, 0x04, 0x05, 0x46, 0x04, 0x48, 0x40, 0x34, 
	0x9E, 0xE2, 0xD0, 0xA3, 0x7C, 0x3D, 0x19, 0x15, 0x15, 0x2A, 0xA1, 0x16, 0xA3, 0x90, 0xAA, 0x4F, 
	0x84, 0x84, 0x23, 0x04, 0x18, 0x8D, 0x17, 0x7A, 0x18, 0x11, 0xCA, 0xB8, 0x0E, 0x28, 0x70, 0x72, 
	0x10, 0x30, 0x10, 0xA3, 0x60, 0xEA, 0x00, 0x00, 0x38, 0x35, 0x14, 0x70, 0xC3, 0x60, 0x12, 0x39, 
	0xAA, 0x24, 0x24, 0x4F, 0x3A, 0x39, 0xA7, 0x3B, 0x37, 0x1F, 0x1F, 0x3A, 0x35, 0x3C, 0x37, 0x1D, 
	0x96, 0x8B, 0xF8, 0xF8, 0xB8, 0x35, 0x83, 0x84, 0x26, 0x88, 0x86, 0x37, 0x6A, 0x36, 0x45, 0x83, 
	0x3F, 0x7D, 0x2C, 0xF7, 0xDA, 0x8A, 0x50, 0x0C, 0x0B, 0xFB, 0xFF, 0xE3, 0x10, 0x1E, 0x00, 0x00, 
	0x38, 0x16, 0xD6, 0xDC, 0xB0, 0x52, 0x13, 0x3F, 0x46, 0x4E, 0x02, 0x3B, 0x17, 0x9F, 0x29, 0x33, 
	0x7B, 0x1D, 0x1C, 0x3A, 0x1F, 0x1C, 0x19, 0x6D, 0x0E, 0x32, 0x9F, 0x2D, 0x1B, 0x46, 0x25, 0x27, 
	0x06, 0x4F, 0x4D, 0xD0, 0x18, 0x22, 0x82, 0x85, 0x23, 0x3F, 0x18, 0xDC, 0x51, 0x2F, 0x9E, 0x0F, 
	0x07, 0xFF, 0xE8, 0x2C, 0x34, 0x3A, 0xDB, 0x01, 0x9B, 0x2B, 0xB0, 0x92, 0x14, 0x2D, 0xCA, 0x77, 
	0x3D, 0x38, 0x12, 0xD3, 0xC5, 0x51, 0xE8, 0xF7, 0xEE, 0xB8, 0x2B, 0x12, 0x2C, 0x91, 0x58, 0x57, 
	0x76, 0xA6, 0x3B, 0x3F, 0x3E, 0x3E, 0x04, 0x22, 0x21, 0x3A, 0x96, 0xF0, 0xA8, 0x80, 0x87, 0x05, 
	0x3C, 0x16, 0xE3, 0xB7, 0x7B, 0xA6, 0x7D, 0x19, 0x2A, 0x0F, 0xDF, 0xC3, 0xA0, 0x16, 0x00, 0x00, 
	0xDB, 0x0E, 0x1D, 0x3D, 0x1F, 0x77, 0xBC, 0xFC, 0xA0, 0x14, 0xEB, 0xDD, 0x0F, 0x2A, 0x6E, 0x0C, 
	0x68, 0xE3, 0xC7, 0x53, 0xDD, 0xC9, 0x0E, 0x30, 0x7B, 0x4F, 0x84, 0x84, 0x06, 0xAE, 0x21, 0x45, 
	0x45, 0x1C, 0xCD, 0x75, 0x4E, 0x04, 0x24, 0x4E, 0x20, 0xB9, 0xF1, 0x34, 0x4E, 0x06, 0x40, 0x36, 
	0x34, 0x37, 0x7A, 0xD2, 0xFE, 0xFD, 0x00, 0x00, 0x66, 0x72, 0x3F, 0x05, 0x03, 0x3E, 0x1A, 0x9F, 
	0xEE, 0xF3, 0xEF, 0xA3, 0xA3, 0x79, 0x77, 0x11, 0x18, 0x1C, 0x1B, 0x72, 0x1D, 0x37, 0x3B, 0x3E, 
	0x00, 0x7F, 0x21, 0x24, 0x7F, 0xA8, 0xA9, 0x77, 0x30, 0xB1, 0x96, 0x37, 0x3E, 0x06, 0x49, 0x78, 
	0xEE, 0x6C, 0x36, 0x04, 0x85, 0x24, 0x02, 0x3E, 0x3F, 0x3C, 0x39, 0x77, 0x96, 0xC4, 0xFF, 0xFF, 
	0xA1, 0x7B, 0x20, 0x40, 0x4D, 0x38, 0xA5, 0x37, 0x1F, 0x18, 0x1A, 0x19, 0x16, 0x1F, 0x20, 0x34, 
	0x7A, 0x1F, 0x3B, 0x39, 0x4E, 0x80, 0x82, 0x7F, 0x01, 0x38, 0x1A, 0x7A, 0x16, 0x9D, 0x8D, 0x5F, 
	0xE3, 0x6E, 0x77, 0x34, 0x3B, 0x45, 0x36, 0xB4, 0x6F, 0x35, 0x22, 0x25, 0x83, 0x7F, 0x40, 0x4E, 
	0x4E, 0x7D, 0x10, 0x0B, 0x54, 0xC5, 0x00, 0x00, 0xC7, 0x72, 0x19, 0x11, 0x79, 0x72, 0x1A, 0xA9, 
	0x3B, 0x1E, 0x79, 0x16, 0x1D, 0x1D, 0x1F, 0x1F, 0x1D, 0x1C, 0xA7, 0x3E, 0x01, 0x04, 0x4E, 0x45, 
	0x16, 0xDE, 0x58, 0x5E, 0x68, 0x99, 0x13, 0x7D, 0x7D, 0x72, 0x78, 0x7C, 0x78, 0x1B, 0x33, 0x52, 
	0x18, 0x00, 0x86, 0xAC, 0x88, 0x4F, 0x02, 0x04, 0x3B, 0x2A, 0xE5, 0x19, 0x72, 0xC8, 0x00, 0x00, 
	0x0E, 0x51, 0xCA, 0x8B, 0xFE, 0xC7, 0x74, 0x3A, 0x36, 0x38, 0x3B, 0x36, 0x35, 0x1B, 0x17, 0x32, 
	0x2D, 0x2B, 0x1D, 0x49, 0x86, 0x26, 0x02, 0x34, 0xD6, 0x93, 0xA7, 0x3D, 0xAA, 0x46, 0x40, 0x46, 
	0x00, 0x79, 0x2D, 0x9D, 0x11, 0x2C, 0x14, 0x92, 0x91, 0x36, 0x24, 0xAD, 0x42, 0x04, 0x00, 0x3C, 
	0x9A, 0x12, 0x34, 0x01, 0x01, 0x78, 0x00, 0x00, 0x12, 0x2A, 0x5D, 0x09, 0x55, 0xC3, 0xB2, 0x7B, 
	0x36, 0x3C, 0x3F, 0x38, 0x7C, 0x7A, 0x1B, 0xA3, 0x8A, 0xDC, 0xBF, 0x7E, 0x02, 0x84, 0x05, 0x1D, 
	0x67, 0x76, 0x3A, 0x4D, 0x03, 0x3F, 0x3F, 0x3E, 0x00, 0x77, 0x09, 0x51, 0x6E, 0x10, 0x3A, 0x35, 
	0x8E, 0xF0, 0xA9, 0x85, 0x82, 0x01, 0x1D, 0x30, 0x6A, 0x3D, 0x7F, 0x4F, 0x23, 0x00, 0x00, 0x00, 
	0x14, 0x28, 0x6E, 0x10, 0xA3, 0xCC, 0xFB, 0xA3, 0x37, 0x4D, 0x01, 0x3A, 0x39, 0x00, 0x48, 0x7D, 
	0xE1, 0xFB, 0xFC, 0xF3, 0x7A, 0x45, 0x4D, 0x18, 0x5F, 0xA1, 0x14, 0x1F, 0x39, 0x3B, 0x3B, 0x3E, 
	0x3D, 0x31, 0x09, 0xC0, 0x8F, 0x3A, 0x82, 0x3F, 0x36, 0x93, 0xD4, 0x02, 0x4D, 0x4D, 0x3A, 0x97, 
	0xF5, 0x4C, 0x25, 0x86, 0x4F, 0x3E, 0x00, 0x00, 0x78, 0x66, 0x65, 0x30, 0x30, 0xE9, 0x5B, 0x17, 
	0x37, 0x4F, 0x84, 0x82, 0x7F, 0x84, 0x84, 0x3A, 0x6C, 0x0F, 0x78, 0xD8, 0xEC, 0x79, 0x3B, 0x1E, 
	0x70, 0x8A, 0x09, 0xCA, 0x11, 0xA7, 0x3F, 0x47, 0x39, 0xA3, 0x0B, 0x8B, 0x15, 0x02, 0x88, 0x4F, 
	0xAA, 0x7B, 0xD9, 0x3C, 0x48, 0x4E, 0x38, 0x30, 0xB2, 0xAA, 0x26, 0x27, 0x44, 0x20, 0x00, 0x00, 
	0xE1, 0x89, 0xFA, 0xFA, 0xF8, 0xB3, 0x9F, 0x1F, 0x04, 0x05, 0x82, 0x85, 0x27, 0x27, 0x27, 0x4D, 
	0x94, 0x95, 0x36, 0x1B, 0xE5, 0xD7, 0x1B, 0x7C, 0x2C, 0xFD, 0xFF, 0xF6, 0x5C, 0x1D, 0x3E, 0x47, 
	0x01, 0x35, 0x0F, 0x0A, 0x11, 0x4D, 0x22, 0x4F, 0xA6, 0x72, 0x69, 0xA6, 0xA9, 0x7A, 0x2E, 0xDF, 
	0xC9, 0x34, 0x4E, 0x4D, 0x7B, 0xD3, 0xF0, 0x3F, 0x9C, 0x11, 0x0F, 0x8B, 0x60, 0x1D, 0x01, 0x02, 
	0x25, 0x85, 0x82, 0x84, 0x06, 0x05, 0x4F, 0x3E, 0x12, 0x99, 0x39, 0x16, 0x70, 0xC7, 0x14, 0x77, 
	0x2A, 0xDB, 0xFF, 0xFD, 0x8A, 0x13, 0x7A, 0x20, 0x46, 0x39, 0x33, 0x32, 0x31, 0x10, 0x7A, 0x76, 
	0x96, 0x60, 0x9B, 0x13, 0x93, 0x62, 0x53, 0xF2, 0xE8, 0xF0, 0x6C, 0xBB, 0xCD, 0xEF, 0x00, 0x00, 
	0x3B, 0x7C, 0x0E, 0x08, 0x13, 0x40, 0x81, 0x05, 0x24, 0x05, 0x80, 0x45, 0xA7, 0x02, 0x02, 0x44, 
	0x7A, 0x98, 0x20, 0x18, 0x96, 0x59, 0x18, 0x1B, 0x2E, 0xC1, 0xC0, 0xDA, 0x8A, 0x0F, 0x32, 0x13, 
	0x19, 0x33, 0x29, 0x0F, 0x08, 0xC8, 0xDD, 0x6B, 0x92, 0x74, 0x15, 0xB3, 0xF5, 0x16, 0x1B, 0x2D, 
	0xE8, 0xEB, 0xA3, 0x1E, 0x34, 0x39, 0x00, 0x00, 0x3F, 0x7A, 0x8B, 0x8A, 0x11, 0x3E, 0x81, 0x80, 
	0x24, 0x00, 0x7E, 0xD9, 0xBC, 0x74, 0x7A, 0x15, 0xBC, 0x6C, 0x12, 0x91, 0xE9, 0x2E, 0x1F, 0x7D, 
	0xA3, 0xC4, 0xC0, 0xFD, 0xC1, 0x89, 0xC9, 0xCF, 0x52, 0x52, 0x08, 0x8B, 0x29, 0xA3, 0x7A, 0x00, 
	0x01, 0x3F, 0x1B, 0x60, 0x1F, 0x00, 0x38, 0x12, 0xC6, 0x30, 0x40, 0x4D, 0x04, 0xAA, 0x00, 0x00, 
	0x34, 0x6D, 0xB5, 0x2F, 0x69, 0x1C, 0x01, 0x4E, 0x21, 0x3A, 0xE3, 0x6C, 0x77, 0xD6, 0xDE, 0xCA, 
	0xE8, 0x67, 0x0D, 0x0E, 0x62, 0x7A, 0x35, 0xA6, 0x32, 0x99, 0x68, 0xDE, 0x64, 0x61, 0x51, 0x5A, 
	0x2C, 0xA3, 0x10, 0x11, 0x20, 0x36, 0x20, 0x4E, 0x05, 0x4D, 0x77, 0x2C, 0x38, 0xA8, 0x3E, 0xA6, 
	0x5F, 0x1E, 0x21, 0x04, 0x7F, 0x3B, 0x00, 0x00, 0xA0, 0x92, 0xA6, 0x19, 0x11, 0x70, 0x79, 0x34, 
	0x4D, 0x77, 0xB8, 0x1E, 0x3F, 0x7A, 0x2D, 0x52, 0x5D, 0x70, 0x91, 0xC4, 0xB3, 0x19, 0x7C, 0x39, 
	0x7D, 0x1B, 0x1D, 0xA3, 0x77, 0x13, 0x7A, 0x36, 0x1A, 0x1C, 0x1B, 0x36, 0x3A, 0x1D, 0x19, 0x7C, 
	0x1C, 0x79, 0xB8, 0x30, 0xA8, 0x01, 0xAA, 0x38, 0xB7, 0x16, 0x01, 0x02, 0x40, 0x1E, 0x00, 0x00, 
	0x94, 0x39, 0x06, 0x05, 0xA6, 0x9B, 0xE1, 0x8E, 0x9B, 0xCB, 0x16, 0x3A, 0x40, 0x39, 0x7C, 0x31, 
	0x18, 0x1B, 0x72, 0x6D, 0xF2, 0x6F, 0x37, 0x4F, 0x4D, 0x3C, 0xAA, 0x3D, 0x36, 0x3B, 0x4C, 0x49, 
	0xAA, 0x3A, 0x3E, 0x3E, 0x20, 0x9D, 0x92, 0xB6, 0xB0, 0xDE, 0x53, 0x1E, 0x00, 0x44, 0x38, 0xA6, 
	0xBE, 0xE5, 0x79, 0xA8, 0x76, 0x70, 0x00, 0x00, 0x36, 0x02, 0x84, 0x22, 0x81, 0x44, 0x1E, 0xD8, 
	0xD6, 0x10, 0x34, 0x3E, 0x3F, 0x38, 0x7D, 0x15, 0x77, 0xA7, 0x3B, 0x78, 0x30, 0xDF, 0xA4, 0x3D, 
	0x3B, 0x4E, 0x05, 0x03, 0x4D, 0x40, 0xAA, 0xA8, 0x34, 0x1B, 0x1F, 0x34, 0x15, 0xC6, 0xDE, 0x70, 
	0x0E, 0x0B, 0x13, 0x39, 0xAA, 0x04, 0x3B, 0x39, 0x74, 0x93, 0xEB, 0x62, 0xCC, 0xA1, 0x00, 0x00, 
	0xA6, 0x3D, 0x3D, 0x40, 0x80, 0x24, 0x81, 0x38, 0x7E, 0x16, 0x9D, 0x6B, 0xE3, 0x68, 0x66, 0x28, 
	0x30, 0x38, 0x4D, 0x01, 0xA6, 0x7B, 0x90, 0x6F, 0x1B, 0x47, 0x40, 0x3A, 0xA6, 0x17, 0x6F, 0xE0, 
	0x59, 0x5B, 0xCB, 0x64, 0x54, 0x0D, 0x0E, 0x9D, 0x9D, 0x73, 0x1C, 0x1E, 0x3E, 0x40, 0xAA, 0x02, 
	0x3A, 0x40, 0x7E, 0x20, 0x36, 0x7A, 0x00, 0x00, 0x6D, 0xF9, 0xA2, 0x37, 0x3E, 0x84, 0x25, 0x4E, 
	0x20, 0x6A, 0x8D, 0x15, 0x10, 0x15, 0x31, 0x50, 0x0A, 0x1C, 0x44, 0x05, 0x05, 0x00, 0x1C, 0xE3, 
	0x71, 0x20, 0x18, 0x28, 0xB6, 0x66, 0x2C, 0x77, 0x19, 0x18, 0x11, 0x32, 0x12, 0x9E, 0x63, 0x0A, 
	0x6A, 0x8D, 0x92, 0x8D, 0x9B, 0x18, 0x3E, 0x05, 0x05, 0x04, 0x01, 0x05, 0x01, 0x79, 0x00, 0x00, 
	0xDD, 0xF0, 0xF9, 0xB0, 0x75, 0x00, 0x04, 0x44, 0x31, 0x65, 0x3B, 0x04, 0x4E, 0xA8, 0x18, 0x0D, 
	0x50, 0x2B, 0x15, 0xA7, 0x40, 0x00, 0x00, 0x77, 0xCA, 0x14, 0x13, 0xC6, 0x6A, 0x79, 0x3B, 0x3F, 
	0x46, 0x40, 0x3A, 0x17, 0x14, 0xE0, 0xF8, 0xEB, 0xF5, 0xF4, 0x9B, 0x9C, 0xEF, 0xDE, 0xA3, 0xAA, 
	0x22, 0x83, 0x24, 0x82, 0x7B, 0xEC, 0x00, 0x00, 0x15, 0x20, 0x3E, 0x77, 0x64, 0x11, 0x1C, 0x16, 
	0xF5, 0x95, 0x01, 0x22, 0x02, 0xA6, 0xA3, 0x54, 0x8B, 0x07, 0x97, 0x19, 0x1E, 0xA9, 0x40, 0x11, 
	0xF3, 0x14, 0x2A, 0x50, 0x12, 0x3A, 0x3E, 0x37, 0x38, 0x37, 0x18, 0x14, 0x68, 0x64, 0x19, 0x1C, 
	0x7D, 0x34, 0xA6, 0xAA, 0x7A, 0x2F, 0x54, 0x2D, 0x3F, 0x80, 0x81, 0xA8, 0x28, 0x9A, 0x00, 0x00, 
};
