; ****************************************************************************
;
;                                 Data
;
; ****************************************************************************

#include "include.inc"

	.data

; Data area pointed by Y registers (to reduce program size; max. 63 bytes)

.global DataStart
	.lcomm	DataStart,0

; ----- video

.global VLine
	.lcomm VLine,2		; 0: (s16) DATA_VLINE current vertical line (= next processed video line)

.global Frame
	.lcomm Frame,2		; 2: (u16) DATA_FRAME current frame

.global DispMode
	.lcomm DispMode,1 	; 4: (u8) DATA_DISPMODE current display mode (DISP_VGA, DISP_PAL, DISP_NTSC)

.global DispRows
	.lcomm DispRows,1	; 5: (u8) DATA_DISPROWS number of displayed rows (only to speed up computations)

.global VLines
	.lcomm VLines,2		; 6: (s16) DATA_VLINES total number of vertical lines

.global VVisible
	.lcomm VVisible,2	; 8: (s16) DATA_VVISIBLE number of visible lines

.global VSyncBeg
	.lcomm VSyncBeg,2	; 10: (s16) DATA_VSYNCBEG begin of vertical synchronization pulse

.global VSyncEnd
	.lcomm VSyncEnd,2	; 12: (s16) DATA_VSYNCEND end of vertical synchronization pulse

; ----- sound

.global SndInc
	.lcomm SndInc,2		; 14: (u16) DATA_SNDINC sound pulse increment

.global SndLen
	.lcomm SndLen,1		; 16: (u8) DATA_SNDLEN sound length counter

; ----- key

.global KeyWrite
	.lcomm KeyWrite,1	; 17: (u8) DATA_KEYWRITE write offset into keyboard buffer

.global KeyRead
	.lcomm KeyRead,1	; 18: (u8) DATA_KEYREAD read offset from keyboard buffer

.global KeyRelPref
	.lcomm KeyRelPref,1	; 19: (u8) DATA_KEYRELPREF 0xf0=release prefix

.global KeyShift
	.lcomm KeyShift,1	; 20: (u8) DATA_KEYSHIFT SHIFT is pressed (scan code 0x12 or 0x59)

.global KeyAlt
	.lcomm KeyAlt,1		; 21: (u8) DATA_KEYALT ALT is pressed (scan code 0x11)

; ----- disp

.global ParEnd
	.lcomm ParEnd,1		; 22: (u8) DATA_PAREND low of end address of parameters address

.global	CurX
	.lcomm CurX,1		; 23: (u8) DATA_CURX cursor X coordinate

.global	CurY
	.lcomm CurY,1		; 24: (u8) DATA_CURY cursor Y coordinate

.global CurVis
	.lcomm CurVis,1		; 25: (u8) DATA_CURVIS 0xff=cursor is visible

; ----- pointers to allocable memory (may be moved on RAM relocations)

.global PointBeg	; start of pointers
	.lcomm PointBeg,0

.global CurLine		; OFF_CURLINE = 0
	.lcomm CurLine,2	; 26: (u16) DATA_CURLINE address of current row with cursor

.global CurAddr		; OFF_CURADDR = 2
	.lcomm CurAddr,2	; 28: (u16) DATA_CURADDR cursor address

;	Board:			; (u8[]) start of board
.global BoardEnd		; 30: (u16) DATA_BOARDEND end of board = VarAddr
	.lcomm BoardEnd,0	

.global VarAddr		; OFF_VARADDR = 4
	.lcomm VarAddr,2	; 30: (u16) DATA_VARADDR variables
.global VarEnd			; 32: (u16) DATA_VAREND end of variables
	.lcomm VarEnd,0

.global EditAddr	; OFF_EDITADDR = 6
	.lcomm EditAddr,2	; 32: (u16) DATA_EDITADDR edit line, workspace
.global EditEnd			; 34: (u16) DATA_EDITEND end of edit line
	.lcomm EditEnd,0

.global StkAddr		; OFF_STKADDR = 8
	.lcomm StkAddr,2	; 34: (u16) DATA_STKADDR calculator stack
.global StkEnd			; 36: (u16) DATA_STKEND end of calculator stack
	.lcomm StkEnd,0

.global PointEnd	; end of pointers
	.lcomm PointEnd,0	; 36:

.global MemTop		; OFF_MEMTOP = 10
	.lcomm MemTop,2		; 36: (u16) DATA_MEMTOP top of allocated memory

; ----- program

.global	ErrCode
	.lcomm ErrCode,1	; 38: (u8) DATA_ERRCODE error code

.global Flags
	.lcomm Flags,1		; 39: (u8) DATA_FLAGS flags
				;	bit 0: suppression of leading space
				;	bit 6: floating point number or string parameters
				;	bit 7: reset during syntax checking

.global ExecLine
	.lcomm ExecLine,2	; 40: (u16) DATA_EXECLINE line number of the current statement

.global ParAddr
	.lcomm ParAddr,2	; 42: (u16) DATA_PARADDR scanning parameters address

.global MemAddr
	.lcomm MemAddr,2	; 44: (u16) DATA_MEMADDR pointer to calculator numbers (stack or variables)

.global CalcPar
	.lcomm CalcPar,1	; 46: (u8) DATA_CALCPAR calculator parameter

.global OutBufNum
	.lcomm OutBufNum,1	; 47: (u8) DATA_OUTBUFNUM number of bytes in output buffer

; ----- static buffers

.global KeyBuf
	.lcomm KeyBuf,KEYBUF_SIZE ; (u8[]) keyboard buffer

.global NumBuf
	.lcomm NumBuf,5*6	; numeric buffer, holds 6 float numbers

.global OutBuf
	.lcomm OutBuf,NUMMAXLEN ; output buffer to print float number

; ----- allocable memory

.global MemBeg			; start of allocable memory
	.lcomm MemBeg,0

; start of video buffer (every row of the screen starts with 1 byte with length)
.global Board
	.lcomm Board,0
