
// ----------- Surfaces
#declare DarkSurface = finish {
    phong 0.8
    phong_size 10
    ambient 0.1
    diffuse 0.9
}

#declare LightSurface = finish {
    phong 0.4
    phong_size 4
    ambient 0.4
    diffuse 0.3
}

// ----------- Window
#declare Cylin = intersection {
    cylinder { <0, -9, 0>, <0, 9, 0>, 1.6 }
    torus { 7.1, 1.8 rotate -90*x }
}

// ************ Model declaration
#declare Model = union {

    torus { 6.7, 1.8
        texture {
            pigment { MainColor }
            finish { DarkSurface }
        }
        rotate -90*x
    }

    sphere { <0, 0, 0>, 6
        texture {
            pigment { rgb <0.6, 0.8, 0.8> }
            finish { DarkSurface }
        }
    }

    object { Cylin
        texture {
            pigment { rgb <1, 1, 0.3> }
            finish { LightSurface }
        }
    }

    object { Cylin rotate 45*z
        texture {
            pigment { rgb <0.3, 1, 0.3> }
            finish { LightSurface }
        }
    }

    object { Cylin rotate 90*z
        texture {
            pigment { rgb <1, 0.3, 0.3> }
            finish { LightSurface }
        }
    }

    object { Cylin rotate 135*z
        texture {
            pigment { rgb <0.3, 0.3, 1> }
            finish { LightSurface }
        }
    }

    scale <1, 1, 0.6>
}
