
// ----------- Surfaces
#declare DarkSurface = finish {
    phong 0.3
    phong_size 2
    ambient 0.2
    diffuse 0.8
}

#declare LightSurface = finish {
    phong 0.4
    phong_size 2
    ambient 1
    diffuse 0
}

// ----------- Wheel declaration

#declare Wheel = difference {
    cylinder { <0, -0.5, 0>, <0, 0.5, 0>, 1.2 }
    cylinder { <0, -0.6, 0>, <0, -0.2, 0>, 0.8 }
    texture {
        pigment { rgb <0.2, 0.1, 0> }
        finish { DarkSurface }
    }
    translate <0, 0, 2>
}

// ----------- Model declaration

#declare Model = union {

// ----------- Truck
    difference {
        box { <-8, -2.5, -3.5>, <4, 2.5, 1.2> }

        cylinder { < 5, 2.1, 2>, < 5,    3, 2>, 1.5 }
        cylinder { <-3, 2.1, 2>, <-3,    3, 2>, 1.5 }
        cylinder { <-6, 2.1, 2>, <-6,    3, 2>, 1.5 }
        cylinder { < 5,  -3, 2>, < 5, -2.1, 2>, 1.5 }
        cylinder { <-3,  -3, 2>, <-3, -2.1, 2>, 1.5 }
        cylinder { <-6,  -3, 2>, <-6, -2.1, 2>, 1.5 }

        plane { <0, 4, 3>, -3.5 }
        plane { <0, -4, 3>, -3.5 }
        plane { <4, 0, 3>, -7.9 }
        plane { <-4, 0, 3>, -5 }

        texture {
            pigment { rgb <0.1, 0.3, 0.5> }
            finish { DarkSurface }
        }
    }

    box { <-8.01, -2.51, -1>, <4.01, 2.51, 0>
        texture {
            pigment { rgb <0.6, 0.5, 0.2> }
            finish { DarkSurface }
        }
    }

// ----------- Body
    difference {
        intersection {
            union {
                box { <4, -2.3, -1>, <8, 2.3, 1.2> }
                box { <4, -2.2, -3>, <6, 2.2, -2.4> }
            }
        }

        cylinder { < 5, 2.1, 2>, < 5,    3, 2>, 1.5 }
        cylinder { < 5,  -3, 2>, < 5, -2.1, 2>, 1.5 }
        plane { <-2, 0, -1>, -7.2 }
        plane { <-1, 0, 1>, -6.2 }

        texture {
            pigment { MainColor }
            finish { DarkSurface }
        }
    }

    box { <8, -0.9, -0.7> <8.05, 0.9, 0>
        texture {
            pigment { rgb <0.2, 0.2, 0.2> }
            finish { DarkSurface }
        }
    }

    union {
        cylinder { <8, -1.6, -0.35>, <8.02, -1.6, -0.35>, 0.3 }
        cylinder { <8,  1.6, -0.35>, <8.02,  1.6, -0.35>, 0.3 }

        texture {
            pigment { rgb <1, 1, 1> }
            finish { LightSurface }
        }
    }

// ------------ Window
    difference {
        box { <4, -2.1, -2.4>, <7, 2.1, -1> }
        plane { <-3, 0, 1>,-6.34 }
        texture {
            pigment { rgb <0, 0, 0.6> }
            finish { DarkSurface }
        }
    }

// ---------- Wheels
    object { Wheel rotate 180*z translate <5, 2.5, 0> }
    object { Wheel rotate 180*z translate <-3, 2.5, 0> }
    object { Wheel rotate 180*z translate <-6, 2.5, 0> }
    object { Wheel translate <5, -2.5, 0> }
    object { Wheel translate <-3, -2.5, 0> }
    object { Wheel translate <-6, -2.5, 0> }

//---------- Bogie
    box { <-7, -2, 1.2>, <6, 2, 2.2>
        texture {
            pigment { rgb <0, 0, 0> }
            finish {
                phong 0.1
                phong_size 2
                ambient 0
                diffuse 0.05
            }
        }
    }

//    rotate -z*90
}
