
// ----------- Surfaces
#declare DarkSurface = finish {
    phong 0.3
    phong_size 2
    ambient 0.2
    diffuse 0.8
}

#declare LightSurface = finish {
    phong 0.4
    phong_size 2
    ambient 1
    diffuse 0
}

// ----------- Wheel declaration

#declare Wheel = difference {
    cylinder { <0, -0.5, 0>, <0, 0.5, 0>, 1.2 }
    cylinder { <0, -0.6, 0>, <0, -0.2, 0>, 0.8 }
    texture {
        pigment { rgb <0.8, 0.5, 0.1> }
        finish { DarkSurface }
    }
    translate <0, 0, 2>
}

// ----------- Model declaration

#declare Model = union {

// ----------- Tank
    intersection {
        cylinder { <-8, 0, 0>, <4, 0, 0> 2.5 scale <1,1,0.8> }
        plane { <0.7, 0, -1>, 3.2 }
        plane { <-0.7, 0, -1>, 5.5 }
        texture {
            pigment { rgb <0.5,0.5,0.5> }
            finish { DarkSurface }
        }
        pigment {
            image_map { gif "..\Logo.gif" map_type 2 interpolate 4 }
            rotate <0, 0, 90>
            scale <12.5, 1, 1>
            translate <4.2, 0, 0>
            rotate <-135, 0, 0>
        }
    }

// ----------- Body
    union {
        intersection {
            union {
                cylinder { <4, 0, 0>, <8, 0, 0> 2.5 scale <1,1,0.5> }
                cylinder { <4, 0, -2>, <6, 0, -2> 2.2 scale <1,1,0.5> }
            }
            plane { <2, 0, 1>, 6.8 }
        }
        texture {
            pigment { MainColor }
            finish { DarkSurface }
        }
    }

// ------------ Window
    cylinder { <4, 0, -2.1>, <6, 0, -2.1> 2.1
        texture {
            pigment { rgb <0, 0, 0.6> }
            finish { DarkSurface }
        }
        scale <1,1,0.3>
        rotate -45*y
        translate <2.5,0,-3.6>
    }

// ---------- Wheels
    object { Wheel rotate 180*z translate <5, 2.5, 0> }
    object { Wheel rotate 180*z translate <-3, 2.5, 0> }
    object { Wheel rotate 180*z translate <-6, 2.5, 0> }
    object { Wheel translate <5, -2.5, 0> }
    object { Wheel translate <-3, -2.5, 0> }
    object { Wheel translate <-6, -2.5, 0> }

//---------- Bogie
    box { <-7, -1.5, 1.2>, <6, 1.5, 2.2>
        texture {
            pigment { rgb <0, 0, 0> }
            finish {
                phong 0.1
                phong_size 2
                ambient 0
                diffuse 0.05
            }
        }
    }
}
