
#include "colors.inc"

#include "..\Model.inc"

object { Model
    rotate -30*z
    rotate 75*x
}

camera {
   location  <0.0, 0, -100.0>
   up        <0.0, 0.18,   0.0>
   right     <0.18, 0,   0.0>
   look_at   <0.0, 0.0, 0>
}

intersection {
    plane { <0,1,-0.27>, -3.3 }
    plane { z, 20 }

    pigment { green 0.65 }
    finish { ambient 0.25 diffuse 0.5 }
}

sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.000 0.002 color rgb <1.0, 0.2, 0.0>
                     color rgb <1.0, 0.2, 0.0>]
        [0.002 0.200 color rgb <0.8, 0.1, 0.0>
                     color rgb <0.2, 0.26, 0.63>]
      }
      scale 2
      translate -1
    }
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.02, 0.2>
    }
  }

light_source { <50, 100, -60> colour rgb<0.6, 0.6, 0.6> }
light_source { <-200, 50, -100> colour rgb<0.6, 0.6, 0.6> }
light_source { <0, -20, -100> colour rgb<0.2, 0.2, 0.2> }
light_source { <0, 50, -100> colour rgb<0.2, 0.2, 0.2> }
light_source { <-30, 20, -100> colour rgb<0.2, 0.2, 0.2> }
light_source { <20, 20, -100> colour rgb<0.2, 0.2, 0.2> }
light_source { <-30, -30, 0> colour rgb<0.2, 0.2, 0.2> }
light_source { <20, -40, 0> colour rgb<0.2, 0.2, 0.2> }
