
// ----- garden with flowers

#declare Flower = cylinder { <0, 0.1, 0> <0, 0.11, 0> 0.1 }

#declare Garden = union {
    prism {
        conic_sweep
        linear_spline
        0.85,
        1,
        14,
        <-1.3, -1.8>, <1.3, -1.8>,
        <1.3, -1.08>, <1.1, -0.8>, <1.0, -0.6>, <0.9, -0.3>,
        <0.86, 0>,
        <0.9, 0.3>, <1.0, 0.6>, <1.1, 0.8>, <1.3, 1.08>,
        <1.3, 1.8>, <-1.3, 1.8>, <-1.3, -1.8>

        scale <1, 0.5, 1>
        rotate 180*z
        translate 0.5*y

        pigment {
            marble
            turbulence 10
            color_map {
                [0.0, 0.8 color rgb <0.1, 0.7, 0.1> color rgb <0.0, 0.5, 0.0>]
                [0.8, 1.0 color rgb <0.1, 0.7, 0.1> color rgb <0.0, 0.4, 0.0>]
            }
        }
    }

    union {
        object { Flower translate <-0.8, 0,  1.2> }
        object { Flower translate <-0.4, 0,  1.2> }
        object { Flower translate <   0, 0,  1.2> }
        object { Flower translate < 0.4, 0,  1.2> }
        object { Flower translate < 0.8, 0,  1.2> }

        object { Flower translate < 0.8, 0,  0.8> }
        object { Flower translate < 0.8, 0,  0.4> }
        object { Flower translate < 0.8, 0,    0> }
        object { Flower translate < 0.8, 0, -0.4> }
        object { Flower translate < 0.8, 0, -0.8> }

        object { Flower translate <-0.8, 0, -1.2> }
        object { Flower translate <-0.4, 0, -1.2> }
        object { Flower translate <   0, 0, -1.2> }
        object { Flower translate < 0.4, 0, -1.2> }
        object { Flower translate < 0.8, 0, -1.2> }

        pigment { Yellow }
    }

    union {
        object { Flower translate <-0.4, 0,  0.8> }
        object { Flower translate <   0, 0,  0.8> }
        object { Flower translate < 0.4, 0,  0.8> }

        object { Flower translate < 0.4, 0, -0.4> }
        object { Flower translate < 0.4, 0,    0> }
        object { Flower translate < 0.4, 0,  0.4> }

        object { Flower translate <-0.4, 0, -0.8> }
        object { Flower translate <   0, 0, -0.8> }
        object { Flower translate < 0.4, 0, -0.8> }

        pigment { Red }
    }

    union {
        object { Flower translate <   0, 0, -0.4> }
        object { Flower translate <   0, 0,    0> }
        object { Flower translate <   0, 0,  0.4> }

        object { Flower translate <-0.4, 0, -0.4> }
        object { Flower translate <-0.4, 0,    0> }
        object { Flower translate <-0.4, 0,  0.4> }

        pigment { rgb <1, 0, 1> }
    }
}

// ---- window
#declare Window = difference {
    box { <-0.45, -0.35, -0.06> <0.45, 0.35, 0.1>
        pigment { color rgb <0.6, 0.3, 0.05> }
    }

    box { <-0.4, -0.3, -0.1> <-0.02, 0.3, -0.04>
        pigment { color rgb <0.2, 0.3, 0.9> }
    }

    box { <0.02, -0.3, -0.1> <0.4, 0.3, -0.04>
        pigment { color rgb <0.2, 0.3, 0.9> }
    }
}

// ---- model declaration
#declare Model = union {

// ----- fence
    union {
        box { <-4.6, 0, 5.6> <4.6, 1, 6.4> }
        box { <-4.6, 0, -5.2> <-3.8, 1, 6.4> }
        box { <4.6, 0, -5.2> <3.8, 1, 6.4> }
        box { <-4.6, 0, -4.4> <-2, 1, -5.2> }
        box { <2, 0, -4.4> <4.6, 1, -5.2> }

        pigment { Jade }
    }

// ----- garden
    object { Garden rotate 180*y translate <-2, 0, -2.1> }
    object { Garden translate < 2, 0, -2.1> }

// ----- fountain
    union {
        torus { 0.7, 0.2 translate <0, 0, -2.1> }
        cylinder { <0, 0, -2.1> <0, 0.5, -2.1> 0.1 }
        torus { 0.2, 0.06 translate <0, 0.6, -2.1> }

        pigment { Gray }
    }

    union {
        cylinder { <0, 0, -2.1> <0, 0.1, -2.1> 0.7 }
        cylinder { <0, 0.6, -2.1> <0, 0.61, -2.1> 0.2 }

        pigment { color rgb <0, 0.5, 1> }
    }

// ----- pillars
    union {
        cylinder { <2, 0, -4.8> <2, 1.5, -4.8> 0.5 }
        cylinder { <-2, 0, -4.8> <-2, 1.5, -4.8> 0.5 }
        pigment { White_Marble scale 0.3 }
        finish { phong 1 phong_size 50 reflection .35 }
    }

    union {
        sphere { <2, 2.0, -4.8> 0.6 }
        sphere { <-2, 2.0, -4.8> 0.6 }
        texture { T_Gold_1B }
    }

// ---- gate
    union {
        intersection {
            torus { 0.5, 0.12 }
            box { <-0.7, -0.5, 0> <0, 0.5, 1.6> }
            rotate -90*x
            translate <-0.85, 1.2, -4.8>
        }

        cylinder { <-0.85, 1.7, -4.8> <0.85, 1.7, -4.8> 0.12 }

        intersection {
            torus { 0.5, 0.12 }
            box { <0, -0.5, 0> <0.7, 0.5, 1.6> }
            rotate -90*x
            translate <0.85, 1.2, -4.8>
        }

        cylinder { <-1.35, 1.2, -4.8> <1.35, 1.2, -4.8> 0.12 }

        cylinder { <-1.35, 0, -4.8> <-1.35, 1.2, -4.8> 0.12 }
        cylinder { <-0.90, 0, -4.8> <-0.90, 1.2, -4.8> 0.12 }
        cylinder { <-0.45, 0, -4.8> <-0.45, 1.2, -4.8> 0.12 }
        cylinder { <    0, 0, -4.8> <    0, 1.2, -4.8> 0.12 }
        cylinder { < 0.45, 0, -4.8> < 0.45, 1.2, -4.8> 0.12 }
        cylinder { < 0.90, 0, -4.8> < 0.90, 1.2, -4.8> 0.12 }
        cylinder { <1.35, 0, -4.8> <1.35, 1.2, -4.8> 0.12 }

        box { <-1.35, 0, -4.92> <1.35, 0.1, -4.68> }

        pigment { MainColor }
    }

// ----- building
    box { <-3.5, 0, 0> <3.5, 3.0, 4.4>
        texture { T_Grnt20 scale 0.4 }
    }

    box { <-3.55, 2.85, -0.05> <3.55, 3.0, 4.45>
        pigment { color White }
    }

// ----- cover
    intersection {
        box { <-3.5, 3.0, 0> <3.5, 5.0, 4.4> }
        cylinder { <-3.6, 1, 2.55> <3.6, 1, 2.55> 3.3 }
        cylinder { <-3.6, 1, 1.85> <3.6, 1, 1.85> 3.3 }
        cylinder { <0, 1, -5.5> <0, 1, 5.5> 4.1 }
        pigment { MainColor }
    }

    union {
        sphere { <-1.6, 4.35, 2.2> 0.16 }
        sphere { < 1.6, 4.35, 2.2> 0.16 }
        cone { <-1.6, 4.35, 2.2>, 0.12, <-1.6, 4.9, 2.2> 0 }
        cone { < 1.6, 4.35, 2.2>, 0.12, < 1.6, 4.9, 2.2> 0 }
        texture { T_Gold_1B }
    }

// ---- windows
    object { Window translate <-2.4, 2.2, 0> }
    object { Window translate <-0.8, 2.2, 0> }
    object { Window translate < 0.8, 2.2, 0> }
    object { Window translate < 2.4, 2.2, 0> }

    object { Window translate <-2.4, 0.9, 0> }
    object { Window translate < 2.4, 0.9, 0> }

// ---- door
    difference {
        box { <-0.6, 0, -0.15> <0.6, 1.3, 0.1> }
        box { <-0.5, 0.1, -0.2> <-0.1, 1.2, -0.1> }
        box { < 0.1, 0.1, -0.2> < 0.5, 1.2, -0.1> }

        texture { T_Wood4 scale 2 }
    }

// ---- sand
    box { <-4.5, -0.1, 6.0> <4.5, 0, -5.1>  pigment { color rgb<1, 0.65, 0.3> } }
}
