
// ---- model declaration
#declare Model = union {

// ---- deck
    union {
        box { <-4.5, 0, -2.5> <4.5, 0.5, 4> }
        box { <-2, 0, -5> <2, 0.5, -2.5> }
        cylinder { <-2, 0, -2.5> <-2, 0.5, -2.5> 2.5 }
        cylinder { < 2, 0, -2.5> < 2, 0.5, -2.5> 2.5 }
        texture { T_Chrome_4A }      
    }

// ---- building   
    difference {
        union {
            box { <-4.5, 0.5, 1> <3, 2.5, 4> }
            cylinder { <-3.5, 2.5, 1> <-3.5, 2.5, 4> 1 }
            cylinder { <0.5, 2.5, 1> <0.5, 2.5, 4> 1 }
            box { <-3.5, 2.5, 1> <0.5, 3.5, 4> }
        
            cylinder { <3, 0.5, 2.5> <3, 3, 2.5> 1.5 }
    
            pigment { MainColor }
        }

        cylinder { <3, 1, 2.5> <3, 3.1, 2.5> 1.1
            texture { T_Copper_3A }      
        }
    }

// ---- container
    cylinder { <3, 1, 2.5> <3, 2.5, 2.5> 1.3
        texture { T_Gold_5A }
    }
    
    torus { 1.3 0.2
        translate <3, 3, 2.5>
        texture { T_Chrome_4A }      
    }   

// ---- cooler
    union {
        box { <-3.2, 3.5, 1.5> <0.2, 3.8, 2> }
        box { <-3.2, 3.5, 3> <0.2, 3.8, 3.5> }
        cylinder { <-3.2, 3.5, 1.5> <-3.2, 3.5, 2> 0.3 }
        cylinder { <-3.2, 3.5, 3> <-3.2, 3.5, 3.5> 0.3 }
        cylinder { <0.2, 3.5, 1.5> <0.2, 3.5, 2> 0.3 }
        cylinder { <0.2, 3.5, 3> <0.2, 3.5, 3.5> 0.3 }
    
        box { <-3, 3.5, 1.3> <-3.1, 3.8, 3.7> }
        box { <-2.5, 3.5, 1.3> <-2.6, 3.8, 3.7> }
        box { <-2, 3.5, 1.3> <-2.1, 3.8, 3.7> }
        box { <-1.5, 3.5, 1.3> <-1.6, 3.8, 3.7> }
        box { <-1, 3.5, 1.3> <-1.1, 3.8, 3.7> }
        box { <-0.5, 3.5, 1.3> <-0.6, 3.8, 3.7> }
        box { < 0, 3.5, 1.3> <-0.1, 3.8, 3.7> }
        
        texture { T_Chrome_4A }
    }

    box { <-3.5, 3.5, 2> <0.5, 3.51, 3> texture { T_Chrome_3A } }
      
// ---- props
    intersection {
        union {
            box { <-4.4, 0.5, -2> <-3.7, 2, 1> }
            box { <4.4, 0.5, -2> <3.7, 2, 1> }
        }
        plane { <0, 1, -1> 2.3 }
    
        texture { T_Stone2 }
    }

// ---- arrows
    prism {
        linear_sweep
        linear_spline
        0.5,
        0.51,
        8,
        <0, -2.5>, <-2, -4.5>, <2, -4.5>, <0, -2.5>,
        <-2, -2.5>, <0, -0.5>, <2, -2.5>, <0, -2.5>
    
        pigment { Blue } 
    }

// ---- entry
    union {
        difference {
            intersection {
                box { <-1.3, 0.5, 0.6> <1.3, 2.8, 1> }
                plane { <1, 1, 0> 2.7 }
                plane { <-1, 1, 0> 2.7 }
            }
        
            intersection {
                box { <-1, 0.8, 0.5> <1, 2.5, 0.95> }
                plane { <1, 1, 0> 2.3 }
                plane { <-1, 1, 0> 2.3 }
                texture { T_Chrome_4A }
            }
        }
        cylinder { <0, 1.6, 0.8> <0, 1.6, 1> 0.3 }
        torus { 0.3, 0.06 rotate 90*x translate <0, 1.6, 0.8> }
        cylinder { <-1.2, 0.9, 0.96> <1.2, 0.9, 0.96> 0.1 }
        cylinder { <-1.2, 2.1, 0.96> <1.2, 2.1, 0.96> 0.1 }
        
        cylinder { <-2, 0.7, 0.7> <-2, 2.8, 0.7> 0.3 }
        sphere { <-2, 2.8, 0.7> 0.3 }
        
        box { <-3, 0.5, 0.95> <-1.2, 2.2, 1> }
        box { <-3.2, 0.8, 0.7> <-2.8, 0.9, 1> }
        box { <-3.2, 1.4, 0.7> <-2.8, 1.5, 1> }
        box { <-3.2, 2.0, 0.7> <-2.8, 2.1, 1> }
        
        torus { 0.3, 0.1 translate <1.4, 1, 1> }
        torus { 0.3, 0.1 translate <1.4, 1.6, 1> }
        torus { 0.3, 0.1 translate <1.4, 2.2, 1> }
        
        texture { T_Chrome_5A }
    }
}
