
// ---- model declaration
#declare Model = union {

    union {
        box { <-4, 0.3, -4.5> <4, 1.9, 1> }
        cylinder { <0, 0, 1> <0, 1.9, 1> 4 }
        pigment { MainColor }
    }
    
    box { <-4.2, 0, -4.7> <4.2, 0.3, 5.2>
        pigment { color rgb<1, 0.9, 0.8> }
    }
    

    union {
        difference {
            intersection {
                cylinder { <0, -4, 0> <0, 4, 0> 4 }
                plane { <0, 4, -1> 2.5 }
                plane { <0, -4, -1> 2.5 }
                sphere { <0, 0, -9> 8 }
            
                texture { T_Chrome_5B }
            }
    
            intersection {
                cylinder { <0, -4, 0> <0, 4, 0> 3.8 }
                plane { <0, 3, -1> 2.4 }
                plane { <0, -3, -1> 2.4 }
                sphere { <0, 0, -9> 8.1 }
            
                texture { T_Chrome_3B }
            }
        }
        
        cone { <0, 0, -3.9> 0.6 <0, 0, -1> 0.2
            texture { T_Chrome_2C }
        }

        translate <0, 5, 2>

        rotate -(clock*360 + 180)*y

        translate -2.5*z
           
    }
  
    cone { <0, 1.9, -2.5> 0.8 <0, 2.8, -2.5> 0.6
        texture { T_Chrome_5A }
    }
    
    torus { 1, 0.25
        translate <0, 1.9, -2.5>
        texture { T_Chrome_5A }
    }

    union {
        box { <-3.5, 0, -4.8> <-2, 1.2, -4.2> }
        box { < 3.5, 0, -4.8> < 2, 1.2, -4.2> }
        texture { T_Chrome_5A }
    }
}
