
// ---- window
#declare Window = difference {
    box { <-0.3, -0.25, -0.04> <0.3, 0.25, 0.04>
        pigment { color rgb <0.6, 0.3, 0.05> }
    }

    box { <-0.28, -0.23, -0.1> <-0.01, 0.23, -0.02>
        pigment { color rgb <0.2, 0.3, 0.9> }
    }

    box { <0.01, -0.23, -0.1> <0.28, 0.23, -0.02>
        pigment { color rgb <0.2, 0.3, 0.9> }
    }
    
    scale 2
    translate -3.85*z
}

#declare WindowDelta = 360/8

// ---- model declaration
#declare Model = union {

// ---- cover
    union {
        cylinder { <0, 3, -1> <0, 3.5, -1> 4 }
        intersection {
            sphere {<0, 0, -1> 4 scale <1, 0.8, 1> translate 3.5*y }
            union {
                box { <-4.1, 3.4, -1.2> <4.1, 8, -0.8> }
                box { <-0.2, 3.4, -5.1> <0.2, 8, 3.1> }
            }
        }
        cylinder { <0, 6.4, -1> <0, 6.7, -1> 1 }
        
        pigment { MainColor }
    }

    sphere { <0, 0, -1> 3.7
        scale <1, 0.8, 1>
        translate 3.5*y
        texture { T_Chrome_5A }
        pigment { color rgb <0.7, 1, 1> }
    }
    
    sphere { <0, 6.2, -1> 0.8
        texture { T_Chrome_5A }
        pigment { color rgb <0.5, 0.8, 1> }
    }
    
// ---- building
    cylinder { <0, 0.5, -1> <0, 3.4, -1> 3.8
        texture { T_Stone17 scale 0.6 }
    }

    cylinder { <0, 0, -1> <0, 0.5, -1> 4
        texture { T_Stone16 scale 0.6 }
    }

// ---- windows   
    object { Window rotate  0*WindowDelta*y translate <0, 1.8, -1> }
    object { Window rotate  1*WindowDelta*y translate <0, 1.8, -1> }
    object { Window rotate  2*WindowDelta*y translate <0, 1.8, -1> }
    object { Window rotate  3*WindowDelta*y translate <0, 1.8, -1> }
    object { Window rotate  4*WindowDelta*y translate <0, 1.8, -1> }
    object { Window rotate  5*WindowDelta*y translate <0, 1.8, -1> }
    object { Window rotate  6*WindowDelta*y translate <0, 1.8, -1> }
    object { Window rotate  7*WindowDelta*y translate <0, 1.8, -1> }
    
// ---- lawn
    intersection {
        torus { 4.3, 0.3 translate <0, 0, -1> }
        plane { <0, -1, 0> 0 }
        pigment {
            marble
            turbulence 10
            color_map {
                [0.0, 0.8 color rgb <0.1, 0.7, 0.1> color rgb <0.0, 0.5, 0.0>]
                [0.8, 1.0 color rgb <0.1, 0.7, 0.1> color rgb <0.0, 0.4, 0.0>]
            }
        }
    }
}
