
// ---- model declaration
#declare Model = union {

    union {
        cylinder { <-3.5, 2, -2> <1, 2, -2> 1.5 }
        sphere { <0, 0, 0> 1.5 scale <0.3, 1, 1> translate <-3.5, 2, -2> }
        sphere { <0, 0, 0> 1.5 scale <0.3, 1, 1> translate < 1, 2, -2> }
        box { <2.5, 0, -4> <4.5, 2.5, 0> }
        
        intersection {
            box { <-4.5, 1.5, 2> <4.5, 2, 6> }
            box { <4, -0.1, 4> <-4, 6, -4> rotate 45*y translate 4*z }
        }
        
        intersection {
            cylinder { <2.5, 2.5, -2> <4.5, 2.5, -2> 2 }
            box { <2, 2, -4> <5, 5, 0> }
        }
            
        finish {
            phong 0.2
            phong_size 0.7
        }
        pigment { MainColor }
    }

    union {
        cylinder { <-3.2, 2, -2> <-2.7, 2, -2> 1.6 }
        cylinder { < 0.2, 2, -2> < 0.7, 2, -2> 1.6 }
        texture { T_Chrome_4A }
    }

    union {
        box { <-4.5, 0, -4> <2.5, 1.5, 0> }
        intersection {
            box { <-4.5, 0, 2> <4.5, 1.5, 6> }
            box { <4, -0.1, 4> <-4, 6, -4> rotate 45*y translate 4*z }
        }
        pigment { rgb <1, 0.9, 0.7> }
    }

    union {   
        cylinder { <0, 2, -2> <3, 2, -2> 0.25 }
        sphere { <2, 2, -2> 0.4 }
        texture { T_Chrome_4A }
    }
  
    sphere { <0, 0, 0> 1
        scale <3.2, 1, 1.7>
        translate <0, 2, 4>
        pigment { color rgb<0.5, 0.7, 0.8> }
        finish { phong 1 phong_size 20 }
    }    
}
