
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "finish.inc"
#include "glass.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"

#include "..\Model.inc"

object { Model
    translate -1.3*z
    rotate -45*x
    translate <-0.2, -0.1, 0>
}

// ------ Shadow
union {
    box { <-3, -0.2, 0> <4.7, -0.1, -6.0> }
    box { <-1.8, -0.2, -1.8> <1.8, -0.1, 1.8> rotate 65*y translate <-2.2, 0, -3.5> }
    cylinder { <3.7, -0.2, 3.9> <3.7, -0.1, 3.9> 0.8 }
    cylinder { <3.9, -0.2, 3.8> <3.9, -0.1, 3.8> 0.8 }
    box { <-3.7, -0.2, 3.2> <0.3, -0.1, 5.2> }

    texture { pigment { color rgb <97/255, 30/255, 111/255> } }
    finish {
        phong 0
        ambient 1
        diffuse 0
    }
    rotate -45*x
}

camera {
    location <0, 0, -100>
    up <0, 1, 0>
    right <1, 0, 0>
    angle 5.4
    orthographic
    look_at  0
}

background { color rgb <149/255, 34/255, 140/255> }

difference {
    sphere { <0, 0, 0> 200 }
    sphere { <0, 0, 0> 190 }
    plane { -z, -140 }
    pigment { color Gray }
}

light_source { <-40, 160, -80> color White }
light_source { <0, 0, -100> color <0.9, 0.9, 0.9> shadowless }
