
#declare Angle = (2*pi*clock)
#declare AngleDelta = (2*pi/16)

// ---- window item
#declare WindowItem = box {
    <-0.17, -0.17, -0.1> <0.17, 0.17, -0.05>
    pigment { color rgb <0.2, 0.3, 0.9> }
}

// ---- fan leaf
#declare FanLeaf = sphere { <0, 0, 0> 1
    scale <0.2, 0.02, 0.6>
    rotate 15*z
    translate 0.6*z
    rotate -45*y*clock
}


// ---- model declaration
#declare Model = union {

// ---- building
    difference {
        box { <-3.5, 0, -3> <4.5, 2.5, 2> pigment { Yellow } }
        box { <-1.5, 0.2, -5> <1.5, 1.7, 1> pigment { color rgb<0.6, 0.5, 0> } }
        cylinder { <-3, 0.1, -0.5> <-3, 4.1, -0.5> 1.3 pigment { White } }
    }
    
// ---- entry
    difference {
        box { <-1.7, 0.01, -3.1> <1.7, 1.9, -2.8> pigment { rgb<0.5, 0.4, 0.4> } }
        box { <-1.49, 0.19, -5> <1.49, 1.69, 1> pigment { color rgb<0.6, 0.5, 0> } }
    }
    box { <-1.5, 0.02, -5> <1.5, 0.21, -3> texture { T_Stone17 scale 0.2 } }
    box { <-1.5, 0.02, -3.01> <1.5, 0.21, 1> texture { T_Stone16 scale 0.2 } }
    box { <-1.6, 0.01, -5.1> <1.6, 0.2, 1> pigment { color rgb<0.4, 0.3, 0.1> } }
    
// ---- cover
    union {
        difference {
            intersection {
                box { <-3.6, 2.5, -3.1> <4.6, 3.5, 2.1> }
                plane { <0, 2, -1> 3.65 }
                plane { <0, 2, 1> 3.2 }
            }
            cylinder { <-3, 0.1, -0.5> <-3, 4.1, -0.5> 1.3 }
        }
        
        pigment { MainColor }
    }

// ---- window
    difference {
        box { <-0.9, -0.6, -0.08> <0.9, 0.6, 0.04>
            pigment { color rgb <0.6, 0.3, 0.05> }
        }
        
        object { WindowItem translate <-0.6, 0.25, 0> }
        object { WindowItem translate <-0.2, 0.25, 0> }
        object { WindowItem translate < 0.2, 0.25, 0> }
        object { WindowItem translate < 0.6, 0.25, 0> }

        object { WindowItem translate <-0.6, -0.25, 0> }
        object { WindowItem translate <-0.2, -0.25, 0> }
        object { WindowItem translate < 0.2, -0.25, 0> }
        object { WindowItem translate < 0.6, -0.25, 0> }

        translate <3, 1.2, -3>
    }
    
// ---- fan
    difference {
        cylinder { <-3, 0, -0.5> <-3, 4, -0.5> 1.6 texture { T_Chrome_5C } }
        cylinder { <-3, 0.1, -0.5> <-3, 4.1, -0.5> 1.2 texture { T_Chrome_4A } }
    }
    torus { 1.4, 0.2 translate <-3, 4, -0.5> texture { T_Chrome_5C } }

    union {
        object { FanLeaf rotate   0*y translate <-3, 3.8, -0.5> }
        object { FanLeaf rotate  45*y translate <-3, 3.8, -0.5> }
        object { FanLeaf rotate  90*y translate <-3, 3.8, -0.5> }
        object { FanLeaf rotate 135*y translate <-3, 3.8, -0.5> }
        object { FanLeaf rotate 180*y translate <-3, 3.8, -0.5> }
        object { FanLeaf rotate 225*y translate <-3, 3.8, -0.5> }
        object { FanLeaf rotate 270*y translate <-3, 3.8, -0.5> }
        object { FanLeaf rotate 315*y translate <-3, 3.8, -0.5> }
        texture { T_Chrome_3D }
    }    

    sphere { <-3, 3.8, -0.5> 0.2 texture { T_Chrome_3A } }

// ---- cooler box
    box { <-3.6, 0.1, -3.1> <-2.5, 2.2, -2.7> texture { T_Chrome_3A } }
    
    union {
        box { <-3.7, 0.5, -3.2> <-2.6, 0.6, -2.8> }
        box { <-3.7, 1.0, -3.2> <-2.6, 1.1, -2.8> }
        box { <-3.7, 1.5, -3.2> <-2.6, 1.6, -2.8> }
        box { <-3.7, 2.0, -3.2> <-2.6, 2.1, -2.8> }
    
        texture { T_Chrome_5A }
    }

// ---- machine
    union {
        intersection {
            box { <-4, 0, 5> <0, 1, 7> }
            plane { <-1, 1, 0>, 3.2 }
            plane { <1, 1, 0>, 0.4 }
            texture { T_Chrome_5B }
        }

        box { <-3.1, 1, 5.2> <-2.9, 1.02, 6.0> pigment { Black} }
        cylinder { <-3, 0.9, 5.2> <-3, 0.9, 5.4> 0.2 pigment { Red } translate 0.6*abs(sin(Angle))*z }

        cylinder { <-1.5, 1, 5.55> <-1.5, 1.04, 5.55> 0.4 pigment { Grey } }
        box { <-0.05, -0.05, -0.3> <0.05, 0.1, 0.3>
            rotate (clock*180)*y
            pigment { Blue }
            translate <-1.5, 1, 5.55>
        }
        
        box { <-3, 0.5, 4.6> <-1, 0.6, 6> texture { T_Chrome_2B } translate (0.2*sin(Angle))*z }
                     
        sphere { <-3.45, 1, 6.5> 0.2 pigment { color rgb<0, (sin(Angle +  0*AngleDelta)+1)/2, 0> } }
        sphere { < -3.3, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle +  1*AngleDelta)+1)/2, 0> } }
        sphere { < -3.1, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle +  2*AngleDelta)+1)/2, 0> } }
        sphere { < -2.9, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle +  3*AngleDelta)+1)/2, 0> } }
        sphere { < -2.7, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle +  4*AngleDelta)+1)/2, 0> } }
        sphere { < -2.5, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle +  5*AngleDelta)+1)/2, 0> } }
        sphere { < -2.3, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle +  6*AngleDelta)+1)/2, 0> } }
        sphere { < -2.1, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle +  7*AngleDelta)+1)/2, 0> } }
        sphere { < -1.9, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle +  8*AngleDelta)+1)/2, 0> } }
        sphere { < -1.7, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle +  9*AngleDelta)+1)/2, 0> } }
        sphere { < -1.5, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle + 10*AngleDelta)+1)/2, 0> } }
        sphere { < -1.3, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle + 11*AngleDelta)+1)/2, 0> } }
        sphere { < -1.1, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle + 12*AngleDelta)+1)/2, 0> } }
        sphere { < -0.9, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle + 13*AngleDelta)+1)/2, 0> } }
        sphere { < -0.7, 1, 6.5> 0.3 pigment { color rgb<0, (sin(Angle + 14*AngleDelta)+1)/2, 0> } }
        sphere { <-0.55, 1, 6.5> 0.2 pigment { color rgb<0, (sin(Angle + 15*AngleDelta)+1)/2, 0> } }
    }
    
    union {
        intersection {
            difference {
                cylinder { <0, -0.2, 0> <0, 0.1, 0> 3 }
                cylinder { <0, -0.3, 0> <0, 0.2, 0> 1.5 }
            }
            box { <0, -0.3, 0> <4, 0.2, 4> }
            texture { T_Chrome_4B }
        }        
        
        box { <0, 0.1, 1.5> <0.05, 0.15, 3> rotate (22.5 - clock*22.5)*y texture { T_Chrome_2B } }
        box { <0, 0.1, 1.5> <0.05, 0.15, 3> rotate (45   - clock*22.5)*y texture { T_Chrome_2B } }
        box { <0, 0.1, 1.5> <0.05, 0.15, 3> rotate (67.5 - clock*22.5)*y texture { T_Chrome_2B } }
        box { <0, 0.1, 1.5> <0.05, 0.15, 3> rotate (90   - clock*22.5)*y texture { T_Chrome_2B } }
        
        translate <0, 1, 2.7>
    }

// ---- generator
    union {
        cylinder { <3.8, 0, 5.5> <3.8, 0.4, 5.5> 0.8 }
        cylinder { <3.8, 1.4, 5.5> <3.8, 1.75, 5.5> 0.8 }
        sphere { <0, 0, 0> 0.8 scale <1, 0.3, 1> translate <3.8, 1.75, 5.5> }
        
        texture { T_Copper_4A }
    }
    
    cylinder { <3.8, 0.2, 5.5> <3.8, 1.5, 5.5> 0.6
        pigment { color rgb<0, (sin(Angle)+1)/4 + 0.5, 0> }
        finish { ambient 1 }
    }

    cylinder { <-1, 0.7, 6.5> <4.45, 0.7, 6.5> 0.1 pigment { Red } }
    cylinder { <4.4, 0.7, 1> <4.4, 0.7, 6.55> 0.1 pigment { Red } }
     
//rotate 90*y
//rotate 45*x
//translate -2*x
}
