
// ----------- Foot
#declare Foot = intersection {
    union {
        intersection {
            sphere { <0, -0.25, 0> 0.5 scale <2,1,1> }
            plane { <1, 0, 0> 0.1 }
        }

        intersection {
            sphere { <0, -0.25, 0> 0.5 scale <1.8,1,1> }
            plane { <0, -1, 0> 0.35 }
            plane { <-1, 0, 0> 0 }
        }

        intersection {
            sphere { <-0.2, -0.15, 0> 0.5 scale <1.5,1,1> }
            plane { <1, 0, 0> 0.2 }
        }
    }
    plane { <0, -1, 0> 0.35 }
    translate 0.5*x
}

// ----------- Leg
#declare Leg = union {
    sphere { <0, 0, 0> 0.5 }
    cylinder { <0, 0, 0> <0, -1.4, 0> 0.5 }
    object { Foot translate <0, -1.4, 0> }
    cone { <0, 0, 0> 0.5 <0, 1.4, 0> 0.68 }

    translate -1.4*y
}

// ---------- Arms
#declare RightArm = union {
    sphere { <0, 0, 0> 0.5 }
    cone { <0, 0, 0> 0.5 <-0.5, -1.1, -0.4> 0.4 }
    sphere { <-0.5, -1.1, -0.4> 0.4 }
    cone { <-0.5, -1.1, -0.4> 0.4 <1, -1.3, -0.4> 0.3 }
    sphere { <0, 0, 0> 0.3
        scale <1.3, 1, 0.8>
        translate <1.2, -1.3, -0.4>
    }
}

#declare LeftArm = union {
    sphere { <0, 0, 0> 0.5 }
    cone { <0, 0, 0> 0.5 <-0.7, -1.1, 0.1> 0.4 }
    sphere { <-0.7, -1.1, 0.1> 0.4 }
    cone { <-0.7, -1.1, 0.1> 0.4 <-1.8, -1.2, 1.6> 0.3 }
    sphere { <0, 0, 0> 0.3
        scale <1, 1.3, 0.8>
        translate <-2.0, -1.2, 1.7>
    }
}

// *********** Statue declaration
#declare Statue = union {

// -------- trousers
    object { Leg
        translate 0.5*z
    }

    object { Leg
        translate -0.5*z
    }

    sphere { <0, 0, 0> 0.82
        scale <1,1,1.5>
    }

// ------- body
    union {
        cylinder { <0, 0, 0> <0, 2, 0> 0.8 scale <1,1,1.5> }
        sphere { <0, 2, 0> 0.8 scale <1,1,1.5> }
    }

    object { RightArm
        translate <0, 2.1, -0.9>
    }

    object { LeftArm
        rotate 180*y
        translate <0, 2.1, 0.9>
    }

// ------- head
    union {
        cylinder { <0, 2, 0> <0, 3.6, 0> 0.4 }
        sphere { <0, 3.6, 0> 0.8 }
        sphere { <0.79, 3.5, 0> 0.12 }
        cylinder { <0, 3.57, -0.82> <0, 3.57, 0.82> 0.14 }
    }

// ------ face
    intersection {
        union {
            cylinder { <0.2, 3.7, -0.27> <0.9, 3.7, -0.27> 0.1 }
            cylinder { <0.2, 3.7,  0.27> <0.9, 3.7,  0.27> 0.1 }
        }

        sphere { <0, 3.6, 0> 0.81 }
    }

    intersection {
        box { <0.2, 3.15, -0.22> <0.78, 3.25, 0.22> }
        sphere { <0, 3.6, 0> 0.81 }
    }

// ------ hear
    difference {
        union {
            sphere { <0, 3.6, 0> 0.9 }
            cylinder { <0, 3.6, 0> <0, 3, 0> 0.9 }
        }
        box { <0.5, 3.9, -4> <4, 0, 5> }
        plane { <0, 1, 0> 3.1 }
        cylinder { <0, 3.5, -4> <0, 3.5, 4> 0.3 }
        box { <0, 3.5, -4> <4, 0, 4> }
        box { <-0.3, 3.5, -4> <4, 0, 4> }
    }

    intersection {
        sphere { <0, 3.6, 0> 1.1 }
        plane { <0.8, -1, 0>, -2.5 }
    }

// ------- machine gun
    union {
        cylinder { <1.3, 0.8, -1.1> <3.4, 0.8, -1.1> 0.13 }

        intersection {
            difference {
                cylinder { <1.3, 0.52, -1.1> <3, 0.52, -1.1> 0.25 scale <1, 2, 1> }
                cylinder { <2.8, 1.0, -1.5> <2.8, 1.0, -0.5> 0.12 }
                cylinder { <2.4, 1.0, -1.5> <2.4, 1.0, -0.5> 0.12 }
                cylinder { <2.0, 1.0, -1.5> <2.0, 1.0, -0.5> 0.12 }
            }
            plane { <-1, -1, 0>, -1.9 }
        }

        difference {
            cylinder { <-0.4, 1.2, -1.1> <3.8, 1.2, -1.1> 0.2 }
            cylinder { <-0.5, 1.2, -1.1> <3.9, 1.2, -1.1> 0.14 }
        }
    }

    union {
        cone { <-1.3, 0.43, -1.1> 0.32 <1.3, 0.6, -1.1> 0.1 scale <1, 2, 1> }

        intersection {
            cylinder { <0.6, 0.9, -1.22> <0.6, 0.9, -0.98> 0.8 }
            plane { <0, 1, 0> 1.2 }
        }
        box { <1.5, 1.1, -1.3> <1.8, 0.2, -0.9> }
    }
    translate -1.1*y
}
