
#include "..\Statue.inc"

// ---- window
#declare Window = difference {
    box { <-0.3, -0.25, -0.04> <0.3, 0.25, 0.04>
        pigment { color rgb <0.6, 0.3, 0.05> }
    }

    box { <-0.28, -0.23, -0.1> <-0.01, 0.23, -0.02>
        pigment { color rgb <0.2, 0.3, 0.9> }
    }

    box { <0.01, -0.23, -0.1> <0.28, 0.23, -0.02>
        pigment { color rgb <0.2, 0.3, 0.9> }
    }
}

#declare WindowCol = union {
    object { Window translate y*3.8 }
    object { Window translate y*2.8 }
    object { Window translate y*1.8 }
    object { Window translate y*0.8 }
}


// ---- model declaration
#declare Model = union {

// ---- building
    union {
        difference {
            cylinder { <0, 0, -1.5> <0, 4.5, -1.5> 4.5 }
            cylinder { <0, -1, -1.5> <0, 5, -1.5> 2 }
            box { <-6, -1, -1.5> <6, 5, -7> }
        }
        box { <-4.5, 0, -1.5> <-2, 4.5, -4.5> }
        box { < 4.5, 0, -1.5> < 2, 4.5, -4.5> }
            
        pigment { White }
    }

// ---- cover
    union {
        difference {
            cone { <0, 4.5, -1.5> 4.51 <0, 5.5, -1.5> 3.25 }
            cone { <0, 4.49, -1.5> 1.98 <0, 5.51, -1.5> 3.25 }
            box { <-6, -1, -1.5> <6, 6, -7> }
        }
        
        intersection {
            box { <-4.51, 4.5, -1.49> <-1.99, 5.5, -4.51> }
            plane { <1, 1.252, 0> 2.277 }
            plane { <-1, 1.256, 0> 6.329 }
            plane { <0, 1.25, -1> 6.33 }
        }

        intersection {
            box { < 4.51, 4.5, -1.49> < 1.99, 5.5, -4.51> }
            plane { <-1, 1.252, 0> 2.277 }
            plane { <1, 1.256, 0> 6.329 }
            plane { <0, 1.25, -1> 6.33 }
        }
       
        pigment { MainColor }
    }

// ---- windows   
    object { WindowCol translate <-3.8, 0, -4.5> }
    object { WindowCol translate <-2.8, 0, -4.5> }
    object { WindowCol translate < 2.8, 0, -4.5> }
    object { WindowCol translate < 3.8, 0, -4.5> }

    object { WindowCol translate 2*z rotate   -90*y translate -3.5*z}
    object { WindowCol translate 2*z rotate   -90*y translate -2.5*z}
    object { WindowCol translate 2*z rotate   -90*y translate -1.5*z}
    
    object { WindowCol translate 2*z rotate -67.5*y translate -1.5*z}
    object { WindowCol translate 2*z rotate   -45*y translate -1.5*z}
    object { WindowCol translate 2*z rotate -22.5*y translate -1.5*z}
    object { WindowCol translate 2*z rotate     0*y translate -1.5*z}
    object { WindowCol translate 2*z rotate  22.5*y translate -1.5*z}
    object { WindowCol translate 2*z rotate    45*y translate -1.5*z}
    object { WindowCol translate 2*z rotate  67.5*y translate -1.5*z}

    object { WindowCol translate 2*z rotate    90*y translate -1.5*z}
    object { WindowCol translate 2*z rotate    90*y translate -2.5*z}
    object { WindowCol translate 2*z rotate    90*y translate -3.5*z}

// ---- sand
    box { <-2.5, -0.1, 1> <2.5, 0, -4.5>  pigment { color rgb<1, 0.65, 0.3> } }

// ---- statue
    union {
        object { Statue rotate 20*y scale 0.6 translate <-0.2, 3, -1.7> }
        cylinder { <0, 0, -1.9> <0, 0.5, -1.9> 1.2 }
        pigment { White } 
    }

// ---- lawn
    torus { 1.5, 0.3
        translate <0, 0, -1.9>
        pigment {
            marble
            turbulence 10
            color_map {
                [0.0, 0.8 color rgb <0.1, 0.7, 0.1> color rgb <0.0, 0.5, 0.0>]
                [0.8, 1.0 color rgb <0.1, 0.7, 0.1> color rgb <0.0, 0.4, 0.0>]
            }
        }
    }
}
