
#include "colors.inc"

#if (clock < (1/17 - 0.0005))
#declare PhaseLeft = 0
#declare PhaseRight = 0
#else
#declare PhaseLeft = int(clock*17 + 0.0005)/16*360
#declare PhaseRight = PhaseLeft + 180
#end

#include "..\Model.inc"

object { Model
    rotate -17*360*clock*y
    rotate -45*x
    translate 0.3*y
}

// ------ Shadow
union {
    cylinder { <0, -4.2, 0> <0, -4.3, 0> 1
        scale <1.4, 1, 1>
        rotate 45*y
        translate <0.5, 0, 0>
    }

    texture { pigment { color rgb <97/255, 30/255, 111/255> } }
    finish {
        phong 0
        ambient 1
        diffuse 0
    }

    rotate -45*x
    translate 0.2*y
}

camera {
   location  <0.0, 0, -100.0>
   up        <0.0, 0.077,   0.0>
   right     <0.077, 0,   0.0>
   look_at   <0.0, 0.0, 0>
}

background { color rgb <149/255, 34/255, 140/255> }

light_source { <50, 100, -60> colour rgb<0.6, 0.6, 0.6> }
light_source { <-200, 50, -100> colour rgb<0.6, 0.6, 0.6> }
light_source { <0, -20, -100> colour rgb<0.2, 0.2, 0.2> }
light_source { <0, 50, -100> colour rgb<0.2, 0.2, 0.2> }
light_source { <-30, 20, -100> colour rgb<0.2, 0.2, 0.2> }
light_source { <20, 20, -100> colour rgb<0.2, 0.2, 0.2> }
light_source { <-30, -30, 0> colour rgb<0.2, 0.2, 0.2> }
light_source { <20, -40, 0> colour rgb<0.2, 0.2, 0.2> }
