
// ----------- Surfaces
#declare DarkSurface = finish {
    phong 0.3
    phong_size 2
    ambient 0.2
    diffuse 0.8
}

// *********** Model declaration
#declare Model = union {

    cone { <-6, 0, 0> 5 <5.6, 0, 0> 0.7
        texture {
            pigment { MainColor }
            finish { DarkSurface }
        }
    }

    torus { 4.8 1
        rotate 90*z
        translate -6*x
        texture {
            pigment { rgb <1, 0.2, 0.2> }
            finish { DarkSurface }
        }
    }

    torus { 3 1
        rotate 90*z
        texture {
            pigment { rgb <0.2, 0.2, 1> }
            finish { DarkSurface }
        }
    }

    union {
        cylinder { <5.6, 0, 0> <7.8, 0, 0> 0.3 }
        sphere { <7.8, 0, 0> 1 }
        texture {
            pigment { rgb <0.2, 0.8, 0.2> }
            finish { DarkSurface }
        }
    }
}
