
#include "textures.inc"

#declare MaxAngle = 25

#declare Pi180 = pi/180
#declare SinPhaseLeft = sin(PhaseLeft*Pi180)
#declare SinPhaseRight = sin(PhaseRight*Pi180)
#declare CosPhaseLeft = cos(PhaseLeft*Pi180)
#declare CosPhaseRight = cos(PhaseRight*Pi180)

#declare TrousersColor = pigment { MainColor }

// ----------- Surfaces
#declare DarkSurface = finish {
    phong 0.3
    phong_size 2
    ambient 0.2
    diffuse 0.8
}

#declare LightSurface = finish {
    phong 0.4
    phong_size 2
    ambient 1
    diffuse 0
}

// ----------- Foots
#declare LeftFoot = intersection {
    union {
        intersection {
            sphere { <0, -0.25, 0> 0.5 scale <2,1,1> }
            plane { <1, 0, 0> 0.1 }
        }

        intersection {
            intersection {
                sphere { <0, -0.25, 0> 0.5 scale <1.8,1,1> }
                plane { <0, -1, 0> 0.35 }
#if (SinPhaseLeft > 0)
                rotate MaxAngle*SinPhaseLeft*z
#end
            }
            plane { <-1, 0, 0> 0 }
        }

        intersection {
            sphere { <-0.2, -0.15, 0> 0.5 scale <1.5,1,1> }
            plane { <1, 0, 0> 0.2 }
        }
    }
    plane { <0, -1, 0> 0.35 }
    translate 0.5*x
    texture { pigment { color Black } }
    finish { DarkSurface }
}

#declare RightFoot = intersection {
    union {
        intersection {
            sphere { <0, -0.25, 0> 0.5 scale <2,1,1> }
            plane { <1, 0, 0> 0.1 }
        }

        intersection {
            intersection {
                sphere { <0, -0.25, 0> 0.5 scale <1.8,1,1> }
                plane { <0, -1, 0> 0.35 }
#if (SinPhaseRight > 0)
                rotate MaxAngle*SinPhaseRight*z
#end
            }
            plane { <-1, 0, 0> 0 }
        }

        intersection {
            sphere { <-0.2, -0.15, 0> 0.5 scale <1.5,1,1> }
            plane { <1, 0, 0> 0.2 }
        }
    }
    plane { <0, -1, 0> 0.35 }
    translate 0.5*x
    texture { pigment { color Black } }
    finish { DarkSurface }
}

// ----------- Legs
#declare LeftLeg = union {
    union {
        sphere { <0, 0, 0> 0.5
            texture { pigment { TrousersColor } }
            finish { DarkSurface }
        }

        cylinder { <0, 0, 0> <0, -1.4, 0> 0.5
            texture { pigment { TrousersColor } }
            finish { DarkSurface }
        }

        object { LeftFoot
            rotate MaxAngle*(1 - CosPhaseLeft)*z
            translate <0, -1.4, 0>
        }

        rotate -MaxAngle*(1 - CosPhaseLeft)*z
    }

    cone { <0, 0, 0> 0.5 <0, 1.4, 0> 0.68
        texture { pigment { TrousersColor } }
        finish { DarkSurface }
    }

    translate -1.4*y
}

#declare RightLeg = union {
    union {
        sphere { <0, 0, 0> 0.5
            texture { pigment { TrousersColor } }
            finish { DarkSurface }
        }

        cylinder { <0, 0, 0> <0, -1.4, 0> 0.5
            texture { pigment { TrousersColor } }
            finish { DarkSurface }
        }

        object { RightFoot
            rotate MaxAngle*(1 - CosPhaseRight)*z
            translate <0, -1.4, 0>
        }

        rotate -MaxAngle*(1 - CosPhaseRight)*z
    }

    cone { <0, 0, 0> 0.5 <0, 1.4, 0> 0.68
        texture { pigment { TrousersColor } }
        finish { DarkSurface }
    }

    translate -1.4*y
}

// ---------- Arms
#declare RightArm = union {
    sphere { <0, 0, 0> 0.5
        texture { pigment { MainColor } }
        finish { DarkSurface }
    }

    cone { <0, 0, 0> 0.5 <-0.5, -1.1, -0.4> 0.4
        texture { pigment { MainColor } }
        finish { DarkSurface }
    }

    sphere { <-0.5, -1.1, -0.4> 0.4
        texture { pigment { MainColor } }
        finish { DarkSurface }
    }

    cone { <-0.5, -1.1, -0.4> 0.4 <1, -1.3, -0.4> 0.3
        texture { pigment { MainColor } }
        finish { DarkSurface }
    }

    sphere { <0, 0, 0> 0.3
        scale <1.3, 1, 0.8>
        translate <1.2, -1.3, -0.4>

        texture { pigment { rgb <0.8, 0.6, 0.4> } }
        finish { DarkSurface }
    }
}

#declare LeftArm = union {
    sphere { <0, 0, 0> 0.5
        texture { pigment { MainColor } }
        finish { DarkSurface }
    }

    cone { <0, 0, 0> 0.5 <-0.7, -1.1, 0.1> 0.4
        texture { pigment { MainColor } }
        finish { DarkSurface }
    }

    sphere { <-0.7, -1.1, 0.1> 0.4
        texture { pigment { MainColor } }
        finish { DarkSurface }
    }

    cone { <-0.7, -1.1, 0.1> 0.4 <-1.4, -1.2, 1.6> 0.3
        texture { pigment { MainColor } }
        finish { DarkSurface }
    }

    sphere { <0, 0, 0> 0.3
        scale <1, 1.3, 0.8>
        translate <-1.6, -1.2, 1.7>

        texture { pigment { rgb <0.8, 0.6, 0.4> } }
        finish { DarkSurface }
    }
}

// *********** Model declaration
#declare Model = union {

// -------- trousers
    object { LeftLeg
        translate 0.5*z
        rotate -MaxAngle*SinPhaseLeft*z
    }

    object { RightLeg
        translate -0.5*z
        rotate -MaxAngle*SinPhaseRight*z
    }

    sphere { <0, 0, 0> 0.82
        texture { pigment { TrousersColor } }
        finish { DarkSurface }
        scale <1,1,1.5>
    }

// ------- body
    union {
        cylinder { <0, 0, 0> <0, 2, 0> 0.8 scale <1,1,1.5> }
        sphere { <0, 2, 0> 0.8 scale <1,1,1.5> }

        texture { pigment { MainColor } }
        finish { DarkSurface }
    }

    object { RightArm
        translate <0, 2.1, -0.9>
    }

    object { LeftArm
        rotate 180*y
        translate <0, 2.1, 0.9>
    }

// ------- head
    union {
        cylinder { <0, 2, 0> <0, 3.6, 0> 0.4 }
        sphere { <0, 3.6, 0> 0.8 }
        sphere { <0.79, 3.5, 0> 0.12 }
        cylinder { <0, 3.57, -0.82> <0, 3.57, 0.82> 0.14 }

        texture { pigment { rgb <0.8, 0.6, 0.4> } }
        finish { DarkSurface }
    }

// ------ face
    intersection {
        union {
            cylinder { <0.2, 3.7, -0.27> <0.9, 3.7, -0.27> 0.1 }
            cylinder { <0.2, 3.7,  0.27> <0.9, 3.7,  0.27> 0.1 }
        }

        sphere { <0, 3.6, 0> 0.81 }

        texture { pigment { color Blue } }
        finish { DarkSurface }
    }

    intersection {
        box { <0.2, 3.15, -0.22> <0.78, 3.25, 0.22> }
        sphere { <0, 3.6, 0> 0.81 }

        texture { pigment { color Red } }
        finish { DarkSurface }
    }

// ------ hear
    difference {
        union {
            sphere { <0, 3.6, 0> 0.9 }
            cylinder { <0, 3.6, 0> <0, 3, 0> 0.9 }
        }
        box { <0.5, 3.9, -4> <4, 0, 5> }
        plane { <0, 1, 0> 3.1 }
        cylinder { <0, 3.5, -4> <0, 3.5, 4> 0.3 }
        box { <0, 3.5, -4> <4, 0, 4> }
        box { <-0.3, 3.5, -4> <4, 0, 4> }

        texture { pigment { color rgb <0.2, 0.1, 0> } }
        finish { DarkSurface }
    }

    intersection {
        sphere { <0, 3.6, 0> 1.1 }
        plane { <0.8, -1, 0>, -2.5 }

        texture { pigment { color Black } }
        finish { DarkSurface }
    }

    intersection {
        sphere { <0, 3.6, 0> 1.11 }
        plane { <0.8, -1, 0>, -2.51 }
        plane { <0, 0, 1> 0.25 }
        plane { <0, 0, -1> 0.25 }

        texture { pigment { color Orange } }
        finish { DarkSurface }
    }

// ------- flame gun
    intersection {
        difference {
            cone { <-0.4, 1.2, -1.1> 0.2 <3.0, 1.2, -1.1> 0.4 }

            intersection {
                cone { <2, 1.2, -1.1> 0.1 <4, 1.2, -1.1> 0.3 }
                box { <-1, 1.1, -2> <4, 1.3, 0> }
            }
        }
        box { <-1, 0.9, -2> <4, 1.5, 0> }

        plane { <1, -1, 0>, 1.84 }

        texture { Chrome_Texture }
    }

    cylinder { <0, 0.75, -1.1> <2.8, 0.75, -1.1> 0.1
        texture { Chrome_Texture }
    }

    union {
        cylinder { <-1.1, 0.5, -0.6> <-1.1, 2.5, -0.6> 0.5 }
        cylinder { <-1.1, 0.5,  0.6> <-1.1, 2.5,  0.6> 0.5 }
        sphere { <-1.1, 0.5, -0.6> 0.5 }
        sphere { <-1.1, 2.5, -0.6> 0.5 }
        sphere { <-1.1, 0.5,  0.6> 0.5 }
        sphere { <-1.1, 2.5,  0.6> 0.5 }

        texture { pigment { color Orange } }
        finish { DarkSurface }
    }

    intersection {
        cylinder { <-0.4, 0, -1.1> <1.0, 0, -1.1> 0.34 scale <1, 2.0, 1> translate <0, 1.0, 0> }

        texture { pigment { color Black } }
        finish { DarkSurface }
    }

#if (cos(PhaseFlame*Pi180) > 0)
    sphere { <0, 0, 0> 0.18
        scale <2, 1, 1>
        rotate 50*z
        translate <3.2, 1.0, -1.1>

        texture { pigment { color rgb <0.8, 0.7, 0.5> } }
        finish { LightSurface }
    }

    sphere { <0, 0, 0> 0.2
        scale <2, 1, 1>
        rotate 60*z
        translate <3.3, 1.1, -1.1>

        texture { pigment { color rgb <0.9, 0.7, 0.2> } }
        finish { LightSurface }
    }

    sphere { <0, 0, 0> 0.19
        scale <2, 1, 1>
        rotate 70*z
        translate <3.4, 1.2, -1.1>

        texture { pigment { color rgb <1, 0.5, 0.1> } }
        finish { LightSurface }
    }

    sphere { <0, 0, 0> 0.17
        scale <2, 1, 1>
        rotate 80*z
        translate <3.5, 1.3, -1.1>

        texture { pigment { color rgb <1, 0.35, 0> } }
        finish { LightSurface }
    }
#else
    sphere { <0, 0, 0> 0.17
        scale <2, 1, 1>
        rotate 50*z
        translate <3.2, 1.0, -1.1>

        texture { pigment { color rgb <0.9, 0.7, 0.2> } }
        finish { LightSurface }
    }

    sphere { <0, 0, 0> 0.15
        scale <2, 1, 1>
        rotate 65*z
        translate <3.35, 1.15, -1.1>

        texture { pigment { color rgb <1, 0.35, 0> } }
        finish { LightSurface }
    }
#end

    translate 0.3*(abs(CosPhaseLeft))*y
    translate -1.1*y
}
