
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                           Long Integer - test                             //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
// (c) 2021 Miroslav Nemecek, Panda38@seznam.cz, panda38.sweb.cz
// This source code may be used freely without restrictions for any purpose,
// including commercial.

// temporary text buffer
#define TEXTBUF_SIZE 500
extern char TextBuf[TEXTBUF_SIZE];
extern char TextBuf2[TEXTBUF_SIZE];

// --- double integer

// uint32, sint32, fix32
#define DBLUINT uint32	// double integer class unsigned
#define BASEUINT u16	// base integer unsigned
#define HALFUINT u8		// half integer unsigned
#define BASEBITS 16		// number of bits of base integer
#define DBLSINT sint32	// double integer class signed
#define BASESINT s16	// base integer signed
#define HALFSINT s8		// half integer signed
#define DBLFIX fix32	// double fixed point class
#include "dblint_h.h"

// uint64, sint64, fix64
#define DBLUINT uint64	// double integer class unsigned
#define BASEUINT u32	// base integer unsigned
#define HALFUINT u16	// half integer unsigned
#define BASEBITS 32		// number of bits of base integer
#define DBLSINT sint64	// double integer class signed
#define BASESINT s32	// base integer signed
#define HALFSINT s16	// half integer signed
#define DBLFIX fix64	// double fixed point class
#include "dblint_h.h"

// uint128, sint128, fix128
#define DBLUINT uint128	// double integer class unsigned
#define BASEUINT u64	// base integer unsigned
#define HALFUINT u32	// half integer unsigned
#define BASEBITS 64		// number of bits of base integer
#define DBLSINT sint128	// double integer class signed
#define BASESINT s64	// base integer signed
#define HALFSINT s32	// half integer signed
#define DBLFIX fix128	// double fixed point class
#include "dblint_h.h"

// --- quadruple integer

// uint64B, sint64B, fix64B
#define QUADUINT uint64B // quadruple integer class
#define DBLUINT uint32	// double integer class unsigned
#define BASEUINT u16	// base integer unsigned
#define HALFUINT u8		// half integer unsigned
#define BASEBITS 16		// number of bits of base integer
#define QUADSINT sint64B // double integer class signed
#define DBLSINT sint32	// double integer class signed
#define BASESINT s16	// base integer signed
#define HALFSINT s8		// half integer signed
#define DBLFIX fix32	// double fixed point class
#define QUADFIX fix64B	// quadruple fixed point class
#include "quadint_h.h"

// uint128B, sint128B, fix128B
#define QUADUINT uint128B // quadruple integer class
#define DBLUINT uint64	// double integer class unsigned
#define BASEUINT u32	// base integer unsigned
#define HALFUINT u16	// half integer unsigned
#define BASEBITS 32		// number of bits of base integer
#define QUADSINT sint128B // double integer class signed
#define DBLSINT sint64	// double integer class signed
#define BASESINT s32	// base integer signed
#define HALFSINT s16	// half integer signed
#define DBLFIX fix64	// double fixed point class
#define QUADFIX fix128B	// quadruple fixed point class
#include "quadint_h.h"

// uint256, sint256, fix256
#define QUADUINT uint256 // quadruple integer class
#define DBLUINT uint128	// double integer class unsigned
#define BASEUINT u64	// base integer unsigned
#define HALFUINT u32	// half integer unsigned
#define BASEBITS 64		// number of bits of base integer
#define QUADSINT sint256 // double integer class signed
#define DBLSINT sint128	// double integer class signed
#define BASESINT s64	// base integer signed
#define HALFSINT s32	// half integer signed
#define DBLFIX fix128	// double fixed point class
#define QUADFIX fix256	// quadruple fixed point class
#include "quadint_h.h"

// check double integer + u32
void Check_dbluint32(int max);

// check double integer + s32
void Check_dblsint32(int max);

// check double fix + s32
void Check_dblfix32(int max);

// check double integer + u64
void Check_dbluint64(int max);

// check double integer + s64
void Check_dblsint64(int max);

// check double fix + s64
void Check_dblfix64(int max);

// check quadruple integer + u64
void Check_quaduint64B(int max);

// check quadruple integer + s64
void Check_quadsint64B(int max);

// check quadruple fix + s64
void Check_quadfix64B(int max);

// check quadruple integer + double integer unsigned
void Check_quadudbl128(int max);

// check quadruple integer + double integer signed
void Check_quadsdbl128(int max);
