
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                               CPU Control                                 //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
// (c) 2021 Miroslav Nemecek, Panda38@seznam.cz, panda38.sweb.cz
// This source code may be used freely without restrictions for any purpose,
// including commercial.

// create or verify bit tables (returns FALSE on table error)
bool InitBitTab();

// reverse bits
u8 Reverse8(u8 val);
u16 Reverse16(u16 val);
u32 Reverse32(u32 val);
u64 Reverse64(u64 val);

// get numer of bits of value (logarithm, returns position of highest bit + 1: 0..64)
u8 Bits8(u8 val);
u8 Bits16(u16 val);
u8 Bits32(u32 val);
u8 Bits64(u64 val);

// get number of high bits of value (returns top offset of lowest bit + 1: 0..64)
u8 HighBits8(u8 val);
u8 HighBits16(u16 val);
u8 HighBits32(u32 val);
u8 HighBits64(u64 val);
