
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                 Includes                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
// (c) 2021 Miroslav Nemecek, Panda38@seznam.cz, panda38.sweb.cz
// This source code may be used freely without restrictions for any purpose,
// including commercial.

#ifdef _MSC_VER

///////////////////////////////////////////////////////////////////////////////
// base types

typedef signed char s8;
typedef unsigned char u8;
typedef signed short s16;
typedef unsigned short u16;
typedef signed long int s32;
typedef unsigned long int u32;
typedef signed long long int s64;
typedef unsigned long long int u64;

// MS VC++ disable warnings
#pragma warning ( disable: 4100)		// warning - unreferenced parameter
#pragma warning ( disable: 4996)		// warning - unsafe function
#pragma warning ( disable: 4201)		// warning - nameless struct/union
#pragma warning ( disable: 4127)		// warning - condition is constant
#pragma warning ( disable: 4146)		// warning - unsigned minus

///////////////////////////////////////////////////////////////////////////////
// system includes

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h>
#include <time.h>
#include <Windows.h> // required only for time measures

///////////////////////////////////////////////////////////////////////////////
// constants

#define	B0 (1<<0)
#define	B1 (1<<1)
#define	B2 (1<<2)
#define	B3 (1<<3)
#define	B4 (1<<4)
#define	B5 (1<<5)
#define	B6 (1<<6)
#define	B7 (1<<7)
#define	B8 (1<<8)
#define	B9 (1<<9)
#define	B10 (1<<10)
#define	B11 (1<<11)
#define	B12 (1<<12)
#define	B13 (1<<13)
#define	B14 (1<<14)
#define	B15 (1<<15)

#define B16 (1<<16)
#define B17 (1<<17)
#define B18 (1<<18)
#define	B19 (1<<19)
#define B20 (1<<20)
#define B21 (1<<21)
#define B22 (1<<22)
#define B23 (1<<23)
#define B24 (1<<24)
#define B25 (1<<25)
#define B26 (1<<26)
#define B27 (1<<27)
#define B28 (1<<28)
#define B29 (1<<29)
#define B30 (1<<30)
#define B31 (1UL<<31)

#define	BIGINT	0x40000000

#else

#define PI 3.14159265358979324

// Raspberry Pico SDK
#include "..\..\global.h"	// global common definitions

#endif


// fast division flags (LOW part in 3 bits = mode, 1 bit neg flag, HIGH part = number of shifts):
enum { // mode in LOW part (max. 8 modes!)
	FASTDIV_0 = 0,	// divide by zero
	FASTDIV_1,		// divide by 1
	FASTDIV_2,		// divide by 2
	FASTDIV_SHIFT,	// divide by shift, HIGH = number of shifts 0...
	FASTDIV_HIGH,	// divide by number with highest bit set, mul=divider, result 0 or 1
	FASTDIV_MUL,	// divide, simple multiplier, HIGH = number of shifts 0...
	FASTDIV_FULL,	// divide, multiplier in full range with hidden highest bit "1"
					//   HIGH = number of shifts 0...
};

#define FASTDIV_NEG B3	// flag - divisor is negative

#define FASTDIV_BIT 4	// number of bits of mode (=LOW part), 3 bits mode + 1 bit negative flag
#define FASTDIV_BASE (1 << FASTDIV_BIT) // base of number of shifts (=HIGH part)
#define FASTDIV_MASK (FASTDIV_BASE - 1) // mask of flags (=LOW part)
#define FASTDIV_MASK2 (FASTDIV_MASK & ~FASTDIV_NEG) // mask of flags without negative flag

///////////////////////////////////////////////////////////////////////////////
// inplace "new" operator
//		example:	new (&m_List[inx]) cText;
//					m_List[i].~cText()

inline void* operator new (size_t size, void* p)
{
	size;
	return p;
}

inline void operator delete (void* adr, void* p)
{
	adr; p;
	return;
}

///////////////////////////////////////////////////////////////////////////////
// program includes

#include "cpu.h"			// CPU control
#include "test.h"			// double integer test
#include "main.h"			// main module
