; ============================================================================
;
;                            VEGASLOT - Macros
;
; ============================================================================

; ------------- Macro - clear debug window (params: row, column, length)

%macro DebugClear 3
%ifdef DEBUG
		push	ax		; push AX
		push	cx		; push CX
		push	dx		; push DX
		mov	dh,%1		; DH <- row
		mov	dl,%2		; DL <- column
		call	SetCursor	; set cursor position
		mov	cx,%3		; CX <- length of window
		mov	al," "		; AL <- blank character
%%disp:		call	DispChar	; display one character
		loop	%%disp		; next character
		mov	dh,%1		; DH <- row
		mov	dl,%2		; DL <- column
		call	SetCursor	; set cursor position
		pop	dx		; pop DX
		pop	cx		; pop CX
		pop	ax		; pop AX
%endif
%endmacro

; ------------- Macro - display debug text (param: "text")

%macro DebugText 1
%ifdef DEBUG
		push	si		; push SI
		mov	si,%%text	; SI <- text to display
		call	DispText	; display text
		jmp	short %%next	; skip text
%%text:		db	%1,0		; text to display
%%next:		pop	si		; pop SI
%endif
%endmacro

; ------------- Macro - display number (param: number)

%macro DebugNum 1
%ifdef DEBUG
		push	ax		; push AX
		mov	ax,%1		; AX <- number to display
		call	DispNum		; display number
		pop	ax		; pop AX
%endif
%endmacro

; ------------- Macro - display bonus

%macro DebugBonus 0
		DebugClear 0, 0, 12
		DebugText " Bonus:"
		DebugNum [Bonus]
%endmacro

; ------------- Macro - display reel position (param: reel position)

%macro DebugPosition 1
%ifdef DEBUG
		DebugClear 0, 12, 14
		DebugText "Reels:"
		push	ax		; push AX
		push	bx		; push BX
		push	cx		; push CX
		mov	bx,%1		; BX <- reel position
		mov	ax,bx		; AX <- position
		and	ax,POSMASK	; AX <- masked position
		call	DispNum		; display position of reel 0
		mov	al,","		; comma
		call	DispChar	; display comma
		mov	cl,5		; CL <- number of rotation
		shr	bx,cl		; rotate to next reel
		mov	ax,bx		; AX <- position
		and	ax,POSMASK	; AX <- masked position
		call	DispNum		; display position of reel 1
		mov	al,","		; comma
		call	DispChar	; display comma
		shr	bx,cl		; rotate to next reel
		mov	ax,bx		; AX <- position
		call	DispNum		; display position of reel 1
		pop	cx		; pop CX
		pop	bx		; pop BX
		pop	ax		; pop AX
%endif
%endmacro	

; ------------- Macro - set winning mode (param: winning mode number)

%macro DebugSetMode 1
%ifdef DEBUG
		mov	byte [WinMode],%1
%endif
%endmacro

; ------------- Macro - display winning mode

%macro DebugMode 0
%ifdef DEBUG
		DebugClear 0, 26, 14
		DebugText "Mode:"
		cmp	byte [WinMode],WINMODE_LOST
		jne	%%lost
		DebugText "Lost"
%%lost:		cmp	byte [WinMode],WINMODE_WIN
		jne	%%win
		DebugText "Win"
%%win:		cmp	byte [WinMode],WINMODE_BLUFF
		jne	%%bluff
		DebugText "Bluff"
%%bluff:	cmp	byte [WinMode],WINMODE_BLOST
		jne	%%blost
		DebugText "BonusLost"
%%blost:	cmp	byte [WinMode],WINMODE_BWIN
		jne	%%bwin
		DebugText "BonusWin"
%%bwin:
%endif
%endmacro

; ------------- Macro - display Game-In

%macro DebugGameIn 0
		DebugClear 1, 0, 12
		DebugText "GameIn:"
		DebugNum word [GameIn]
%endmacro

; ------------- Macro - display Game-Out

%macro DebugGameOut 0
		DebugClear 1, 12, 13
		DebugText "GameOut:"
		DebugNum word [GameOut]
%endmacro

; ------------- Macro - display Profit

%macro DebugGameProfit 0
%ifdef DEBUG
		DebugClear 1, 25, 15
		DebugText " Profit:"
		push	ax		; push AX
		push	bx		; push BX
		push	dx		; push DX
		xor	ax,ax		; AX <- 0 prepare zero Profit LOW
		cmp	word [GameIn],0	; is there no GameIn?
		je	%%zero		; there is no GameIn
		mov	ax,1000		; AX <- 1000 multiplier
		mul	word [GameOut]	; * GameOut
		div	word [GameIn]	; / GameIn
%%zero:		mov	bx,10		; BX <- 10 divider
		xor	dx,dx		; DX <- 0 prepare zero Profit HIGH
		div	bx		; AX <- percent, DX <- decimal
		DebugNum ax		; display Profit in percents
		DebugText "."		; display decimal character
		DebugNum dx		; display decimal
		DebugText "%"		; display percent character
		pop	dx		; pop DX
		pop	bx		; pop BX
		pop	ax		; pop AX
%endif
%endmacro
