StackSize	equ	0x2000		; stack size (paragraph aligned)
SECTION		.text
		org	0
%ifdef DOS
EXEStart:	db	4Dh,5Ah		; EXE file signature
		dw	AllocSize % 512
		dw	(AllocSize + 511) / 512
		dw	0		; number of relocation entries
		dw	EXEHead/16	; header size in paragraphs
		dw	StackSize/16+4	; min extra memory
		dw	StackSize/16+4	; max extra memory
		dw	AllocSize/16	; initial SS
		dw	StackSize	; initial SP
		dw	0		; checksum
		dw	Start		; initial IP
		dw	-EXEHead/16	; initial CS
		dw	0		; file offset of the relocation table
		dw	0		; overlay number
		align	16,db 0
EXEEnd:
EXEHead		equ	(EXEEnd - EXEStart) ; EXE head size
%else
EXEHead		equ	0
%endif
; ----------------------------------------------------------------------------
;             Start of program at 0080:0000 (or CS:0020 in case of EXE program)
; ----------------------------------------------------------------------------

; ------------- Identification

Start:		jmp	Init

Ident		dw	8A25h		; identification word

; ------------- Init segments

Init:		cli			; disable interrupts
		mov	ax,cs		; AX <- program segment
		mov	ds,ax		; DS <- program segment
		add	ax,(Graphics - Start + EXEHead)/16 ; add code size
		mov	[GraphSeg],ax	; segment with VGA graphics
		mov	word [GraphOff],BMPData ; offset with VGA graphics
		add	ax,DataSize/16	; add graphics size
		mov	ss,ax		; SS <- stack segment
		mov	sp,StackSize	; SP <- end of stack
		sti			; enable interrupts

; ------------- Push old videomode

		mov	ah,0fh		; AH <- function code
		call	Int10		; call Int 10h interrupt
		mov	[OldVMode],al	; store old video mode

; ------------- Init Graphics

		call	InitGraph	; init graphics
		jnc	GameStart	; game start

; ------------- Error, quit program

		mov	ah,0		; AH <- function code
		mov	al,[OldVMode]	; AL <- old video mode
		call	Int10		; call Int 10h interrupt

; ------------- No VGA, display error message

		mov	si,ErrorNoVGA	; error text - cannot find VGA card
		call	DispText	; display error message

; ------------- Wait for a key press

		mov	ah,10h		; AH <- function code
		int	16h		; input character

; ------------- End program/Repeat booting

Quit:
%ifdef	DOS
		mov	ax,4C00h
		int	21h
%else
		int	19h		; repeat booting
%endif
; ------------- Display background

GameStart:	call	SetPalettes	; set palettes

		call	DispGraph	; display background image

		mov	bx,[WindowL]	; BX <- left coordinate of reels
		mov	cx,[WindowT]	; CX <- top coordinate of reels
		call	CalcSrc		; calc source offset -> AX:SI
		call	CalcDest	; calc destination offset -> DX:DI
		mov	bx,[WindowW]	; BX <- width of reels
		mov	cx,[WindowH]	; CX <- height of reels
		mov	bp,DarkTab+5*256 ; BP <- dark table
GameStart2:	call	DrawDark	; draw dark line
		loop	GameStart2	; next line

		mov	ah,10h		; AH <- function code
		int	16h		; input character

		mov	ah,0		; AH <- function code
		mov	al,[OldVMode]	; AL <- old video mode
		call	Int10		; call Int 10h interrupt

		jmp	short Quit	; quit the program

; ----------------------------------------------------------------------------
;                           Display text with BIOS
; ----------------------------------------------------------------------------
; INPUT:	DS:SI = error message ASCIIZ (ends with zero)
; ----------------------------------------------------------------------------

DispText:	push	ax		; push AX
		push	si		; push SI
		cld			; set direction up
DispText2:	lodsb			; AL <- load next character from DS:SI
		or	al,al		; AL == 0? is it end of text?
		jz	DispText3	; it is end of text
		call	DispChar	; display character in AL
		jmp	short DispText2	; next character
DispText3:	pop	si		; pop SI
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                        Display one character with BIOS
; ----------------------------------------------------------------------------
; INPUT:	AL = character to display
; ----------------------------------------------------------------------------

DispChar:	push	ax		; push AX
		push	bx		; push BX
		push	cx		; push CX
		push	dx		; push DX
		mov	ah,0eh		; AH <- 0Eh function code
		mov	bx,7		; BL <- color of text, BH <- page 0
		call	Int10		; call Int 10h
		pop	dx		; pop DX
		pop	cx		; pop CX
		pop	bx		; pop BX
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                                 Includes
; ----------------------------------------------------------------------------

InitSymbOff:	ret
InitDigOff:	ret

; ------------- Symbols

SymbolW:	dw	64		; width of one symbol
SymbolH:	dw	40		; height of one symbol
WindowW:	dw	192		; width of reel window
WindowH:	dw	120		; height of reel window
WindowL:	dw	64		; left coordinate of reel window
WindowT:	dw	40		; top coordinate of reel window
WindowB:	dw	160		; bottom coordinate of reel window

Border:		dw	5		; height of dark border
BorderT:	dw	0		; line of top border
BorderB:	dw	0		; line of bottom border

; ------------- Digits

DigitW:		dw	0		; width of one digit
DigitH:		dw	0		; height of one digit
DigitL:		dw	0		; left coordinate of first digit
DigitT:		dw	0		; top coordinate od digits
BankL:		dw	0		; left coordinate of BANK
WinL:		dw	0		; left coordinate of WIN
BetL:		dw	0		; left coordinate of BET
CredL:		dw	0		; left coordinate of CREDIT

%include	"GRAPHIC.ASM"		; graphic

; ------------- Added graphics

SECTION		.text

		align	16
Graphics:

AllocSize	equ	(Graphics - Start) + DataSize
