SYMBOLS		equ	6		; number of types of symbols
C		equ	0		; shortcut of symbol "cherry"
A		equ	1		; shortcut of symbol "apple"
P		equ	2		; shortcut of symbol "plum"
E		equ	3		; shortcut of symbol "pear"
G		equ	4		; shortcut of symbol "grape"
B		equ	5		; shortcut of symbol "bell"
POS		equ	32		; number of positions on one reel

SECTION		.text
		org	100h		; start of COM program

; ------------- Print help 1

Start:		mov	ax,TextHelp1	; AX <- help 1
		call	PrintText	; print help 1

; ------------- Print symbols on reels

		mov	al,0		; AL <- 0 first reel
		call	PrintReel	; print symbols on reel 0
		mov	ax,TextHelp2	; AX <- help 2
		call	PrintText	; print help 2
		mov	al,1		; AL <- 1 second reel
		call	PrintReel	; print symbols on reel 1
		mov	ax,TextHelp2	; AX <- help 2
		call	PrintText	; print help 2
		mov	al,2		; AL <- 2 third reel
		call	PrintReel	; print symbols on reel 2

; ------------- Print help 3

		mov	ax,TextHelp3	; AX <- help 3
		call	PrintText	; print help 3

; ------------- Print winning values

		cld			; direction up
		mov	cx,SYMBOLS-1	; number of symbols - 1
		mov	si,WinVal	; table of winning values
Start1:		lodsw			; AX <- value of one symbol
		call	PrintNum	; print value of one symbol
		mov	al,","		; AL <- comma character
		call	PrintChar	; print comma character
		loop	Start1		; print next value
		lodsw			; AX <- value of last symbol
		call	PrintNum	; print value of last symbol
		int	20h		; end of program

; ----------------------------------------------------------------------------
;                            Print symbols on one reel
; ----------------------------------------------------------------------------
; INPUT:	AL = reel (0 to 2)
; ----------------------------------------------------------------------------

; ------------- Push registers

PrintReel:	push	ax		; push AX
		push	bx		; push BX
		push	cx		; push CX
		push	si		; push SI
		
; ------------- Prepare registers

		cld			; direction up
		mov	cx,POS		; CX <- positions on one reel
		mul	cl		; AX <- offset of reel tab
		add	ax,ReelTab	; AX <- addres of reel tab
		xchg	ax,si		; SI <- addres of reel tab

; ------------- Display one symbol

PrintReel2:	xor	ax,ax		; AX <- 0
		lodsb			; AL <- one symbol
		xchg	ax,bx		; BX <- symbol
		mov	al,[bx+TextSymb]; AL <- character of symbol
		call	PrintChar	; print symbol

; ------------- Print comma

		cmp	cl,1		; is it last symbol?
		je	PrintReel3	; it is last symbol
		mov	al,","		; comma character
		call	PrintChar	; print comma character
PrintReel3:	loop	PrintReel2	; print next symbol

; ------------- Pop registers

		pop	si		; pop SI
		pop	cx		; pop CX
		pop	bx		; pop BX
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                         Print number with comma
; ----------------------------------------------------------------------------
; INPUPT:	AX = number to print
; ----------------------------------------------------------------------------

PrintNumCom:	call	PrintNum	; print number
                push	ax		; push AX
		mov	ax,TextComma	; AX <- text ", "
		call	PrintText	; print text ", "
		pop	ax		; pop AX
		ret
		
; ----------------------------------------------------------------------------
;                             Print number
; ----------------------------------------------------------------------------
; INPUPT:	AX = number to print
; ----------------------------------------------------------------------------

; ------------- Push registers

PrintNum:	push	ax		; push AX
		push	bx		; push BX
		push	cx		; push CX
		push	dx		; push DX

; ------------- Convert number do digits

		xor	cx,cx		; CX <- 0 character counter
		mov	bx,10		; BX <- 10 divisor
PrintNum2:	xor	dx,dx		; DX <- 0
		div	bx		; divide DX:AX with 10
		xchg	ax,dx		; AX <- remainder
		add	al,'0'		; convert to printable character
		push	ax		; push character to stack
		inc	cx		; increase character counter
		xchg	ax,dx		; AX <- quotient
		or	ax,ax		; is it zero?
		jnz	PrintNum2	; it is not zero yet

; ------------- Display digits

PrintNum3:	pop	ax		; pop character from stack
		call	PrintChar	; print character
		loop	PrintNum3	; print next character

; ------------- Pop registers

		pop	dx		; pop DX
		pop	cx		; pop CX
		pop	bx		; pop BX
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                             Print ASCIIZ text
; ----------------------------------------------------------------------------
; INPUPT:	AX = text to print
; ----------------------------------------------------------------------------

; ------------- Push registers

PrintText:	push	ax		; push AX 
		push	si		; push SI

; ------------- Print text

		cld			; direction up
		xchg	ax,si		; SI <- text to print
PrintText2:	lodsb			; AL <- character to print
		or	al,al		; is it end of text?
		jz	PrintText4	; it is end of text
		call	PrintChar	; print character
		jmp	short PrintText2 ; next character

; ------------- Pop registers

PrintText4:	pop	si		; pop SI
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                        Print tabulator to position
; ----------------------------------------------------------------------------
; INPUT:	AL = required position
; ----------------------------------------------------------------------------

PrintTabPos:	call	PrintTab	; print tabulator
		cmp	al,[CharPos]	; is it required position?
		ja	PrintTabPos	; print next tabulator
		ret
		
; ----------------------------------------------------------------------------
;                             Print tabulator
; ----------------------------------------------------------------------------

PrintTab:	push	ax		; push AX
		mov	al,9		; AL <- TAB character
		call	PrintChar	; print TAB character
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                            Print end of line
; ----------------------------------------------------------------------------

PrintCRLF:	push	ax		; push AX
		mov	al,13		; AL <- CR character
		call	PrintChar	; print CR character
		mov	al,10		; AL <- LF character
		call	PrintChar	; print LD character
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                             Print character
; ----------------------------------------------------------------------------
; INPUPT:	AL = character to print
; ----------------------------------------------------------------------------

; ------------- Push registers

PrintChar:	push	ax		; push AX
		push	dx		; push DX

; ------------- End of line (CR character)

		cmp	al,13		; is it CR character?
		jne	PrintChar2	; it is not CR character
		mov	byte [CharPos],0 ; reset character position
		jmp	short PrintChar6 ; print character

; ------------- Tabulator (TAB character)

PrintChar2:	cmp	al,9		; is it TAB character?
		jne	PrintChar4	; it is not TAB character
		add	byte [CharPos],8 ; round position up
		and	byte [CharPos],~7 ; tab position
		jmp	short PrintChar6 ; print character

; ------------- Other characters

PrintChar4:	inc	byte [CharPos]	; increase character position

; ------------- Print character

PrintChar6:	mov	dl,al		; DL <- character to print
		mov	ah,2		; AH <- function code
		int	21h		; print character

; ------------- Pop registers

		pop	dx		; pop DX
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                                Data
; ----------------------------------------------------------------------------

CharPos:	db	0
TextHelp1:	db	"SECTION",9,9,".text",13,10
		db	"ReelTab: db ",0
TextHelp2:	db	13,10,9," db ",0

TextHelp3:	db	13,10
		db	"WinVal:",9,9,"dw",9,0

TextDW:		db	9,9,"dw",9,0
TextDW2:	db	":",9,"dw",9,0
TextComma:	db	",",9,0
TextSymb:	db	"CAPEGB"

ReelTab:
Reel0:	db  C,C,C,C,C,A,A,P,P,E,P,A,C,P,A,C,G,E,A,E,G,C,A,G,E,G,A,P,P,B,C,A
Reel1:	db  C,C,C,A,C,A,A,P,E,P,A,E,P,A,C,G,E,G,E,P,C,P,A,G,E,G,C,A,E,B,A,C
Reel2:	db  C,C,C,G,C,A,A,A,P,C,G,P,E,P,C,E,G,E,C,E,B,G,P,G,E,G,C,E,G,B,P,A

WinVal:		dw	10,20,50,100,200,750	; C,A,P,E,G,B
