; ============================================================================
;
;                         MicroDOS - Printer device
;
; ============================================================================

; ----------------------------------------------------------------------------
;                        Output character to printer
; ----------------------------------------------------------------------------
; INPUT:	AL = character to print
; ----------------------------------------------------------------------------
; NOTES:	use CALL FAR
; ----------------------------------------------------------------------------

; ------------- Push registers

PrintChar:	push	cx		; push CX
		push	dx		; push DX
		push	ax		; push AX
		
; ------------- Attempt counter

		mov	cx,2		; CX <- attempt counter

; ------------- Print character to LPT1

PrintChar2:	pop	ax		; AL <- character to print
		push	ax		; push AX
		mov	ah,0		; AH <- 0 function code
		xor	dx,dx		; DX <- 0 port number
		int	17h		; print character to LPT1

; ------------- Check printer status

		mov	dx,OutPaperText	; DX <- error text, out of paper
		test	ah,B5		; out of paper?
		jnz	PrintChar4	; out of paper
		test	ah,B3+B0	; is printer error?
		jz	PrintChar8	; status is OK

; ------------- Next attempt

PrintChar3:	loop	PrintChar2	; next attempt

; ------------- Display error message

		mov	dx,PrnFaultText	; DX <- error text, printer fault
PrintChar4:	call	DispText	; display error text

; ------------- Pop registers

PrintChar8:	pop	ax		; pop AX
		pop	dx		; pop DX
		pop	cx		; pop CX
		retf

; ----------------------------------------------------------------------------
;                                    Data
; ----------------------------------------------------------------------------

OutPaperText:	db	CR,LF,'Out of paper',CR,LF,0
PrnFaultText:	db	CR,LF,'Printer fault',CR,LF,0
