; ============================================================================
;
;                         MicroDOS - Initialization
;
; ============================================================================

; ----------------------------------------------------------------------------
;                                    Data
; ----------------------------------------------------------------------------

BootDisk:	db	0		; boot disk (0=A:,1=B:,...)

; ------------- Old interrupt table

OldInt:		dw	00h*4		; offset of Int 00h
OldInt00:	dw	MyInt00,0	; old Int 00h address

		dw	01h*4		; offset of Int 01h
OldInt01:	dw	MyInt01,0	; old Int 01h address

		dw	03h*4		; offset of Int 03h
OldInt03:	dw	MyInt03,0	; old Int 03h address

		dw	04h*4		; offset of Int 04h
OldInt04:	dw	MyInt04,0	; old Int 04h address

;		dw	10h*4		; offset of Int 10h
;OldInt10:	dw	MyInt10,0	; old Int 10h address

;		dw	13h*4		; offset of Int 13h
;OldInt13:	dw	MyInt13,0	; old Int 13h address

;		dw	15h*4		; offset of Int 15h
;OldInt15:	dw	MyInt15,0	; old Int 15h address

;		dw	19h*4		; offset of Int 19h
;OldInt19:	dw	MyInt19,0	; old Int 19h address

		dw	1bh*4		; offset of Int 1Bh
OldInt1B:	dw	MyInt1B,0	; old Int 1Bh address

;		dw	1eh*4		; offset of Int 1Eh
;OldInt1E:	dw	MyInt1E,0	; old Int 1Eh address

		dw	20h*4		; offset of Int 20h
OldInt20:	dw	MyInt20,0	; old Int 20h address

		dw	21h*4		; offset of Int 21h
OldInt21:	dw	MyInt21,0	; old Int 21h address

		dw	23h*4		; offset of Int 23h
OldInt23:	dw	MyInt23,0	; old Int 23h address

		dw	24h*4		; offset of Int 24h
OldInt24:	dw	MyInt24,0	; old Int 24h address

		dw	25h*4		; offset of Int 25h
OldInt25:	dw	MyInt25,0	; old Int 25h address

		dw	26h*4		; offset of Int 26h
OldInt26:	dw	MyInt26,0	; old Int 26h address

;		dw	28h*4		; offset of Int 28h
;OldInt28:	dw	MyInt28,0	; old Int 28h address

;		dw	29h*4		; offset of Int 29h
;OldInt29:	dw	MyInt29,0	; old Int 29h address

OldIntNum	EQU	($-OldInt)/6	; number of ionterrupts

; ------------- End of code part of system (here begin data buffers)

SystemEnd:

; ----------------------------------------------------------------------------
;                           System initialization
; ----------------------------------------------------------------------------
; INPUT:	DL = boot disk number
; ----------------------------------------------------------------------------

; ------------- Push input parameters from BOOT

Init:		cli			; disable interrupts
%ifndef DOS
		xchg	ax,dx		; AL <- boot disk
		or	al,al		; boting from hard drive?
		jns	Init1		; it is not hard drive
		sub	al,80h-2	; convert to logical disk number
Init1:		mov	[cs:BootDisk],al ; store boot disk number
%endif

; ------------- Shift code behind end of buffers

		mov	ax,cs		; AX <- CS
		mov	ds,ax		; DS <- CS
		mov	es,ax		; ES <- CS
		mov	si,InitEnd-1	; SI <- end of init code
		mov	di,DataBuffersEnd+(InitEnd-InitStart)-1 ; DI <- new end
		mov	cx,InitEnd-InitStart ; length of code
		std			; direction down
		rep	movsb		; shift init code
		jmp	DataBuffersEnd	; jump to new init code

; ------------- Clear data buffers

InitStart:	xor	ax,ax		; AX <- 0
		mov	di,SystemEnd	; DI <- start of buffers
		mov	cx,(DataBuffersEnd-SystemEnd)/2 ; CX <- size in words
		rep	stosw		; clear data buffers

; ------------- Init stack pointer (to end of disk sector buffer)

		mov	ax,cs		; AX <- CS
		mov	ss,ax		; SS <- boot segment
		mov	sp,DiskBuff+SECTORSIZE ; end of disk buffer

; ------------- Install new interrupt handlers (here is ES=CS, CH=0, CLI)

		cld			; direction up
		xor	ax,ax		; AX <- 0
		mov	ds,ax		; DS <- 0 segment of INT table
		mov	cl,OldIntNum	; CX <- number of interrupts
		mov	di,OldInt	; DI <- old interrupt table
Init2:		mov	si,[cs:di]	; SI <- offset of interrupt
		inc	di		; increment DI
		inc	di		; increment DI
		mov	ax,[es:di]	; AX <- new interrupt handler
		movsw			; push old address LOW
		mov	[si-2],ax	; new interrupt address LOW
		movsw			; push old address HIGH
		mov	[si-2],cs	; new interrupt address HIGH
		loop	Init2		; install next interrupt handler

; ------------- Initialize other BIOS variables

		mov	[500h],cx	; reset Print Screen status
		mov	[504h],cx	; disk A: selected as last active

; ------------- End all interrupts

		sti			; enable interrupts
		mov	al,20h		; AL <- interrupt end command
		out	20h,al		; end all interrupts

; ------------- Init data segment register (from now: DS=CS)

		push	cs		; push CS
		pop	ds		; DS <- this segment

; ------------- Display intro text

		mov	dx,IntroText+(DataBuffersEnd-SystemEnd)	; intro text
		call	DispText	; display intro text

; ------------- Init serial COM port

		mov	ax,0a3h		; 2400 Baud, 8 bits, 1 stop, no parity
		xor	dx,dx		; DX <- 0 COM port number
		int	14h		; initialize COM1 port

; ------------- Init paralel LPT port

		mov	ah,1		; AH <- 1 function code
		xor	dx,dx		; DX <- 0 LPT port number
		int	17h		; initialize LPT1 port
		
; ------------- Check if use phantom floppy disk

		int 	11h		; get number of floppy disk
		and	al,B7+B6	; is more than 2 floppy drives?
      		jnz	Init3		; there is 2 or more floppy drives
		or	byte [DiskFlags],B0 ; use phantom disk

; ------------- Test changeline of floppy drives

Init3:		xor	dx,dx		; DL <- floppy drive A:
		mov	si,DiskParFlags	; SI <- disk flags
		mov	cx,2		; CX <- number of drives
Init32:		mov	ah,15h		; AH <- function code
		call	Int13		; check if changeline suported
		jc	Init34		; error
		cmp	ah,2		; changeline supported?
		jne	Init34		; changeline not supported
		or	byte [si],B0	; changeline supported
Init34:		inc	dx		; increase disk number
		inc	si		; increase disk flags pointer
		loop	Init32		; next disk


; ============= Start of DOS initialization



; ----------------------------------------------------------------------------
;                             Initialization data
; ----------------------------------------------------------------------------

; ------------- Intro text (shifted with code!)

IntroText:	db	13,10,'============================'
		db	13,10,' MicroDOS version 1.00.0001 '
		db	13,10,'============================'
		db	13,10,0

InitEnd:				; end of initialization code
