; ============================================================================
;
;                            LT-DOS - LPT port device
;
; ============================================================================

; ----------------------------------------------------------------------------
;                         Device service tables
; ----------------------------------------------------------------------------

; ------------- PRN, LPT service table

FNCLPT:		db	12		; number of functions
		dw	DevIntOK	; 0 init
		dw	DevIntOK	; 1 media check
		dw	DevIntOK	; 2 build BPB
		dw	DevIntInv	; 3 IOCTL input
		dw	LPTRData	; 4 read data
		dw	LPTRTest	; 5 test read
		dw	DevIntOK	; 6 input status
		dw	DevIntOK	; 7 flush input
		dw	LPTWData	; 8 write data
		dw	LPTWData	; 9 write with verify
		dw	LPTWState	; 10 output status
		dw	DevIntOK	; 11 flush output

; ----------------------------------------------------------------------------
;                 Device interrupt service - LPT write data
; ----------------------------------------------------------------------------
; INPUT:	CX = number of characters to write
;		ES:DI = data buffer
;		DS = data segment
; OUTPUT:	AX = status word
; DESTROYS:	BX, DX
; ----------------------------------------------------------------------------

LPTWData:	jcxz	LPTWData8	; there are no data to write
LPTWData2:	mov	bx,2		; BX <- attempt counter

; ------------- Test printer status

LPTWData4:	mov	ah,2		; AH <- function code
		call	LPTFnc		; call LPT function
		jc	LPTWData5	; error

; ------------- Output character

		mov	al,[es:di]	; AL <- character to write
		mov	ah,0		; AH <- function code
		call	LPTFnc		; call LPT function
		jnc	LPTWData7	; all OK

; ------------- Error

LPTWData5:	dec	bx		; attempt counter
		jnz	LPTWData4	; next attempt
LPTWDataERR:	jmp	DevIntError	; error

; ------------- Next character

LPTWData7:	inc	di		; increase pointer
		loop	LPTWData2	; write next character
LPTWData8:	mov	ah,S_DONE	; status OK
		ret			; return from interrupt

; ----------------------------------------------------------------------------
;                 Device interrupt service - LPT output status
; ----------------------------------------------------------------------------
; INPUT:	DS = data segment
; OUTPUT:	AX = status word
; DESTROYS:	DX
; ----------------------------------------------------------------------------

; ------------- Get LPT output status

LPTWState:	mov	ah,2		; AH <- function code
		call	LPTFnc		; call LPT function
		jc	LPTWDataERR	; error

; ------------- Test if output is ready

		and	ah,80h		; is output ready?
		jnz	LPTWData8	; printer is ready
		mov	ah,S_DONE+S_BUSY; status - device not ready
		ret

; ----------------------------------------------------------------------------
;                          LPT function with test state
; ----------------------------------------------------------------------------
; INPUT:	AH = function code
;		DS = data segment
; OUTPUT:	AL = error code
;		CY = error
; ----------------------------------------------------------------------------

LPTFnc:		mov	dx,[DevInx]	; DX <- number of LPT port
		int	17h		; call LPT service
		mov	al,ERR_READY	; error - not ready
		test	ah,10h		; is printer on-line?
		jz	LPTFnc8		; printer is not on-line
		test	ah,1		; is time-out?
		jnz	LPTFnc8		; it is time-out
		test	ah,8		; is I/O error?
		jz	LPTFnc9		; it is OK
		mov	al,ERR_PAPER	; error - out of paper
		test	ah,20h		; out of paper?
		jnz	LPTFnc8		; is out of paper
		inc	ax		; error ERR_WRITE - write error
LPTFnc8:	stc			; error flag
LPTFnc9:	ret
