; ============================================================================
;
;                       LT-DOS - Int 21h filename parses
;
; ============================================================================

; ----------------------------------------------------------------------------
;                          Test space char
; ----------------------------------------------------------------------------
; INPUT:	AL = ASCII character
; OUTPUT:	ZY = it is space (20h) or tabulator (09h)
; ----------------------------------------------------------------------------

TestSpace:	cmp	al,TAB		; is it tabulator (09h)?
		je	TestSpace2	; it is tabulator
		cmp	al,SPACE	; is it space (20h)?
TestSpace2:	ret

; ----------------------------------------------------------------------------
;                               Test slash
; ----------------------------------------------------------------------------
; INPUT:	AL = ASCII character
; OUTPUT:	ZY = it is slash (2Fh) or backslash (5Ch)
; ----------------------------------------------------------------------------

TestSlash:	cmp	al,'/'		; is it slash (2Fh)?
		je	TestSlash2	; it is slash
		cmp	al,'\'		; is it backslash (5Ch)?
TestSlash2:	ret

; ----------------------------------------------------------------------------
;                        Load character from filename
; ----------------------------------------------------------------------------
; INPUT:	DS:SI = data buffer with text
; OUTPUT:	SI = new pointer in data buffer
;		AL = ASCII character
;		ZY = invalid filename character (include dott and slash)
; ----------------------------------------------------------------------------

; ------------- Push registers

GetFileChar:	push	bx		; push BX
		push	cx		; push CX

; ------------- Load character

		cld			; direction up
		lodsb			; load characters from text buffer

; ------------- Convert normal character to uppercase

		cmp	al,'a'		; minimal lowcase character value
		jb	GetFileChar2	; it is not lowcase character
		cmp	al,'z'		; maximal lowcase character value
		ja	GetFileChar2	; it is not lowcase character
		sub	al,32		; convert to uppercase

; ------------- Convert national character to uppercase

GetFileChar2:	mov	bx,[cs:CurrentCIT] ; BX <- current CIT table
		call	far [cs:bx+CIT_map] ; convert character

; ------------- Test character with table

		mov	bx,InvFileName	; table of invalid characters
		mov	cx,InvFileName2-InvFileName ; number of characters
GetFileChar4:	cmp	al,[cs:bx]	; is it invalid character?
		je	GetFileChar8	; it is invalid character
		inc	bx		; increase table pointer (clears ZF)
		loop	GetFileChar4	; next character (here is NZ)

; ------------- Pop registers

GetFileChar8:	pop	cx		; pop CX
		pop	bx		; pop BX
		ret

; ----------------------------------------------------------------------------
;                                    Data
; ----------------------------------------------------------------------------

; ------------- Table of invalid filename characters

InvFileName:	db	TAB		; (9)	tabelator
		db	SPACE		; (20h) space
		db	'"'		; (22h) double quotes
		db	'+'		; (2Bh) plus
		db	','		; (2Ch) comma
		db	'.'		; (2Eh) dot
		db	'/'		; (2Fh) slash
		db	':'		; (3Ah) colon
		db	';'		; (3Bh) semicolon
		db	'<'		; (3Ch) smaller
		db	'='		; (3Dh) equals
		db	'>'		; (3Eh) greater
		db	'['		; (5Bh) left square bracket
		db	'\'		; (5Ch) backslash
		db	']'		; (5Dh) right square bracket
		db	'|'		; (7Ch) vertical line
InvFileName2:				; end of table
