; ============================================================================
;
;                            LT-DOS - National support
;
; ============================================================================

; ------------- Country Information Table (CIT)

struc		CIT

CIT_dateform:	resw	1		; 0: date format (see Date formats)
CIT_curr:	resb	5		; 2: ASCIIZ currency symbol string
CIT_thsnd:	resb	2		; 7: ASCIIZ thousands separator string
CIT_decimal:	resb	2		; 9: ASCIIZ decimal separator string
CIT_date:	resb	2		; 0Bh: ASCIIZ date separator string
CIT_time:	resb	2		; 0Dh: ASCIIZ time separator string
CIT_currflags:	resb	1		; 0Fh: currency flags
					;	B0 = currency symbol follows
					;	     value, else precedes it
					;	B1 = number of spaces between
					;	     value and currency symbol
					;	B2 = currency symbol replaces
					;	     decimal point
CIT_digits:	resb	1		; 10h: number of digits after decimal
					;	in currency
CIT_timeflags:	resb	1		; 11h: time flags
					;	B0 = 24-hour, else 12-hour
CIT_map:	resd	1		; 12h: upper-case mapping routine
					;	(FAR CALL, AL = character)
CIT_data:	resb	2		; 16h: ASCIIZ data-list separator string

endstruc

CIT_SIZE	EQU	CIT_size	; 18h = 24 bytes

; ------------- Date formats

DATE_USA	EQU	0		; date format - USA (MM/DD/YYYY)
DATE_EUROPE	EQU	1		; date format - Europe (DD.MM.YYYY)
DATE_JAPAN	EQU	2		; date format - Japan (YYYY-MM-DD)

; ------------- Country codes

COUNTRY_USA	EQU	1		; country code - USA
COUNTRY_FRANCE	EQU	33		; country code - France
COUNTRY_SPAIN	EQU	34		; country code - Spain
COUNTRY_ITALY	EQU	39		; country code - Italy
COUNTRY_SWITZ	EQU	41		; country code - Switzerland
COUNTRY_CZECH	EQU	42		; country code - Czechoslovakia
COUNTRY_UK	EQU	44		; country code - United Kingdom
COUNTRY_DENMARK	EQU	45		; country code - Denmark
COUNTRY_SWEDEN	EQU	46		; country code - Sweden
COUNTRY_NORWAY	EQU	47		; country code - Norway
COUNTRY_GERMANY	EQU	49		; country code - Germany
COUNTRY_JAPAN	EQU	81		; country code - Japan

; ----------------------------------------------------------------------------
;                 Upper-case mapping (characters >= 128)
; ----------------------------------------------------------------------------
; INPUT:	AL = character
; OUTPUT:	AL = upper-case character (only character >= 128)
; NOTES:	This function is FAR CALL
; ----------------------------------------------------------------------------

; ------------- Check character range

Mapping:	cmp	al,80h		; minimal character
		jb	Mapping4	; invalid character
		cmp	al,0a7h		; maximal character
		ja	Mapping4	; invalid character

; ------------- Translate character

		push	bx		; push BX
		push	ds		; push DS
		push	cs		; push CS
		pop	ds		; DS <- CS
		mov	bx,MapTab	; BX <- mapping table
		sub	al,80h		; AL <- offset in table
		xlat			; translate character
		pop	ds		; pop DS
		pop	bx		; pop BX
Mapping4:	retf

; ----------------------------------------------------------------------------
;                                    Data
; ----------------------------------------------------------------------------

CurrentCIT:	dw	CIT_Table	; current country information table

; ------------- Country information tables

CIT_Table:			; ---- USA
		db	24		; table length
		db	COUNTRY_USA	; country code
		dw	DATE_USA	; date format
		db	'$',0,0,0,0	; currency symbol string
		db	',',0		; thousands separator string
		db	'.',0		; decimal separator string
		db	'-',0		; date separator string
		db	':',0		; time separator string
		db	0		; currency flags
		db	2		; number of digits after decimal
		db	0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	',',0		; data-list separator string
				; ---- France
		db	24		; table length
		db	COUNTRY_FRANCE	; country code
		dw	DATE_EUROPE	; date format
		db	'F',0,0,0,0	; currency symbol string
		db	' ',0		; thousands separator string
		db	',',0		; decimal separator string
		db	'/',0		; date separator string
		db	':',0		; time separator string
		db	B0+B1		; currency flags
		db	2		; number of digits after decimal
		db	B0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	';',0		; data-list separator string
				; ---- Spain
		db	24		; table length
		db	COUNTRY_SPAIN	; country code
		dw	DATE_EUROPE	; date format
		db	9eh,0,0,0,0	; currency symbol string
		db	' ',0		; thousands separator string
		db	',',0		; decimal separator string
		db	'/',0		; date separator string
		db	':',0		; time separator string
		db	B0+B1		; currency flags
		db	2		; number of digits after decimal
		db	B0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	';',0		; data-list separator string
				; ---- Italy
		db	24		; table length
		db	COUNTRY_ITALY	; country code
		dw	DATE_EUROPE	; date format
		db	'Lit.',0	; currency symbol string
		db	'.',0		; thousands separator string
		db	',',0		; decimal separator string
		db	'/',0		; date separator string
		db	':',0		; time separator string
		db	B1		; currency flags
		db	0		; number of digits after decimal
		db	B0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	';',0		; data-list separator string
				; ---- Switzerland
		db	24		; table length
		db	COUNTRY_SWITZ	; country code
		dw	DATE_EUROPE	; date format
		db	'Fr',0,0,0	; currency symbol string
		db	',',0		; thousands separator string
		db	'.',0		; decimal separator string
		db	'.',0		; date separator string
		db	'.',0		; time separator string
		db	B1		; currency flags
		db	2		; number of digits after decimal
		db	B0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	',',0		; data-list separator string
				; ---- Czechoslovakia
		db	24		; table length
		db	COUNTRY_CZECH	; country code
		dw	DATE_EUROPE	; date format
		db	'Kc',0,0,0	; currency symbol string
		db	' ',0		; thousands separator string
		db	',',0		; decimal separator string
		db	'.',0		; date separator string
		db	':',0		; time separator string
		db	B0+B1		; currency flags
		db	2		; number of digits after decimal
		db	B0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	';',0		; data-list separator string
				; ---- United Kingdom
		db	24		; table length
		db	COUNTRY_UK	; country code
		dw	DATE_EUROPE	; date format
		db	9ch,0,0,0,0	; currency symbol string
		db	',',0		; thousands separator string
		db	'.',0		; decimal separator string
		db	'-',0		; date separator string
		db	':',0		; time separator string
		db	0		; currency flags
		db	2		; number of digits after decimal
		db	B0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	',',0		; data-list separator string
				; ---- Denmark
		db	24		; table length
		db	COUNTRY_DENMARK	; country code
		dw	DATE_EUROPE	; date format
		db	'DKR',0,0	; currency symbol string
		db	'.',0		; thousands separator string
		db	',',0		; decimal separator string
		db	'/',0		; date separator string
		db	'.',0		; time separator string
		db	B0+B1		; currency flags
		db	2		; number of digits after decimal
		db	B0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	';',0		; data-list separator string
				; ---- Sweden
		db	24		; table length
		db	COUNTRY_SWEDEN	; country code
		dw	DATE_JAPAN	; date format
		db	'SEK',0,0	; currency symbol string
		db	'.',0		; thousands separator string
		db	',',0		; decimal separator string
		db	'-',0		; date separator string
		db	'.',0		; time separator string
		db	B1		; currency flags
		db	2		; number of digits after decimal
		db	B0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	';',0		; data-list separator string
				; ---- Norway
		db	24		; table length
		db	COUNTRY_NORWAY	; country code
		dw	DATE_JAPAN	; date format
		db	'KR',0,0,0	; currency symbol string
		db	'.',0		; thousands separator string
		db	',',0		; decimal separator string
		db	'/',0		; date separator string
		db	'.',0		; time separator string
		db	B1		; currency flags
		db	2		; number of digits after decimal
		db	B0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	';',0		; data-list separator string
				; ---- Germany
		db	24		; table length
		db	COUNTRY_GERMANY	; country code
		dw	DATE_EUROPE	; date format
		db	'DM',0,0,0	; currency symbol string
		db	'.',0		; thousands separator string
		db	',',0		; decimal separator string
		db	'.',0		; date separator string
		db	'.',0		; time separator string
		db	0		; currency flags
		db	2		; number of digits after decimal
		db	B0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	';',0		; data-list separator string
				; ---- Japan
		db	24		; table length
		db	COUNTRY_JAPAN	; country code
		dw	DATE_JAPAN	; date format
		db	9dh,0,0,0,0	; currency symbol string
		db	',',0		; thousands separator string
		db	'.',0		; decimal separator string
		db	'-',0		; date separator string
		db	':',0		; time separator string
		db	0		; currency flags
		db	0		; number of digits after decimal
		db	B0		; time flags
		dw	Mapping,BOOTSEG	; upper-case mapping routine
		dw	',',0		; data-list separator string
				; ---- End of table
		db	0, 0ffh

; ------------- Upper-case character mapping table (characters >= 128)

MapTab:		db	80h		; 80h
		db	9ah		; 81h
		db	45h		; 82h
		db	41h		; 83h
		db	8eh		; 84h
		db	41h		; 85h
		db	8fh		; 86h
		db	80h		; 87h
		db	45h		; 88h
		db	45h		; 89h
		db	45h		; 8ah
		db	49h		; 8bh
		db	49h		; 8ch
		db	49h		; 8dh
		db	8eh		; 8eh
		db	8fh		; 8fh
		db	90h		; 90h
		db	92h		; 91h
		db	92h		; 92h
		db	4fh		; 93h
		db	99h		; 94h
		db	4fh		; 95h
		db	55h		; 96h
		db	55h		; 97h
		db	59h		; 98h
		db	99h		; 99h
		db	9ah		; 9ah
		db	9bh		; 9bh
		db	9ch		; 9ch
		db	9dh		; 9dh
		db	9eh		; 9eh
		db	9fh		; 9fh
		db	41h		; a0h
		db	49h		; a1h
		db	4fh		; a2h
		db	55h		; a3h
		db	95h		; a4h
		db	95h		; a5h
		db	96h		; a6h
		db	97h		; a7h
