; ============================================================================
;
;                         MicroDOS - Serial COM port
;
; ============================================================================

; ----------------------------------------------------------------------------
;                    Receive character from serial port (COM1)
; ----------------------------------------------------------------------------
; OUTPUT:	AL = received character
; NOTES:	use CALL FAR
; ----------------------------------------------------------------------------

; ------------- Push registers

RecChar:	push	dx		; push DX
		push	ax		; push AX

; ------------- Receive character from COM1

		mov	ah,2		; AH <- 2 function code
		xor	dx,dx		; DX <- 0 port number
		int	14h		; receive character from COM1

; ------------- Check status

		test	ah,B1+B2+B3	; any error?
		jz	RecChar8	; character received OK

; ------------- Display error message

RecChar6:	mov	dx,AuxIOText	; DX <- error message
		call	DispText	; display error text

; ------------- Pop registers

RecChar8:	pop	dx		; DX <- pop AX
		mov	ah,dh		; AH <- pop AH
		pop	dx		; pop DX
		retf

; ----------------------------------------------------------------------------
;                       Send character to serial port (COM1)
; ----------------------------------------------------------------------------
; INPUT:	AL = character to send
; NOTES:	use CALL FAR
; ----------------------------------------------------------------------------

; ------------- Push registers

SendChar:	push	dx		; push DX
		push	ax		; push AX

; ------------- Send character to COM1

		mov	ah,1		; AH <- 1 function code
		xor	dx,dx		; DX <- 0 port number
		int	14h		; send character to COM1

; ------------- Check status

		test	ah,B7		; any error?
		pop	ax		; pop AX
		push	ax		; push AX
		jz	RecChar8	; character received OK
		jmp	short RecChar6	; error

; ----------------------------------------------------------------------------
;                                    Data
; ----------------------------------------------------------------------------

AuxIOText:	db	CR,LF,'Aux IO error',CR,LF,0
