; ============================================================================
;
;                            MicroDOS - DOS console
;
; ============================================================================

; ----------------------------------------------------------------------------
;                      Test character from keyboard
; ----------------------------------------------------------------------------
; OUTPUT:	AL = character (0=scan code follows)
;		ZY = no character (NZ = a character is ready)
; ----------------------------------------------------------------------------

TestKey:	push	cs		; simulate call far
		call	JVTTestChar	; test character from keyboard
		ret

; ----------------------------------------------------------------------------
;                     Input character from keyboard
; ----------------------------------------------------------------------------
; OUTPUT:	AL = character (0=scan code follows)
;		ZY = scan code follows (AL = 0)
; ----------------------------------------------------------------------------

GetKey:		push	cs		; simulate call far
		call	JVTGetChar	; get character from keyboard
		ret

; ----------------------------------------------------------------------------
;                         Display character
; ----------------------------------------------------------------------------
; INPUT:	AL = character to display
; ----------------------------------------------------------------------------

; ------------- Push registers

OutChar:	push	ax		; push AX

; ------------- Check if it is control character

		cmp	al,20h		; is it control character?




; ------------- Pop registers

		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                            Display new line
; ----------------------------------------------------------------------------

; ------------- Push registers

OutNewLine:	push	ax		; push AX

; ------------- Display new line

		mov	al,CR		; AL <- CR character
		call	OutChar		; display CR character
		mov	al,LF		; AL <- LF character
		call	OutChar		; display LF character

; ------------- Pop registers

		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;              Push registers and execute console device transfer
; ----------------------------------------------------------------------------

; ------------- Store return address

;StdPush:	pop	word [cs:ConPushAddr] ; store return address

; ------------- Push registers

;		push	




; ----------------------------------------------------------------------------
;                 Slow write character to console (in file mode)
; ----------------------------------------------------------------------------
; INPUT:	AL = character
; ----------------------------------------------------------------------------



;StdSWrite:



; ----------------------------------------------------------------------------
;   Int 21h, function 01h - read character from keyboard with echo to display
; ----------------------------------------------------------------------------
; INT21 INPUT:	AH = 01h (function code)
; INT21 OUTPUT:	AL = ASCII character (8 bits) or 0 if extended ASCII follows
; ----------------------------------------------------------------------------
; NOTES:	- Does echo on STDOUT
;		- Check for Ctrl+C (executes Int 23h)
;		- 0 means that extended ASCII code follows
;		- Ctrl+P toggles the DOS-internal echo-to-printer flag
; ----------------------------------------------------------------------------

Int2101:

;		call	Int21022	; output character to STDOUT
		ret

; ----------------------------------------------------------------------------
;                 Write character or control character to STDOUT
; ----------------------------------------------------------------------------
; INPUT:	AL = character to write
; DESTROYS:	AL
; ----------------------------------------------------------------------------

; ------------- Write printable character

ConOutCtrl:	cmp	al,SPACE	; is it control character?
;		jae	StdOutCh1	; write printable character

; ------------- Write tabulator

;		cmp	al,TAB		; is it tabulator?
;		je	StdOutCh1	; write tabulator

; ------------- Print control character

;		push	ax		; push AX
;		mov	al,'^'		; ^ character
;		call	StdOutCh1	; print ^ character
;		pop	ax		; pop AX
;		or	al,40h		; convert to printable character
;		jmp	short StdOutCh1	; print character

; ----------------------------------------------------------------------------
;            Int 21h, function 02h - write character to console
; ----------------------------------------------------------------------------
; INT21 INPUT:	AH = 02h (function code)
;		DL = ASCII character to write
; INT21 OUTPUT:	AL = written ASCII character (= DL, 9 is expanded to 20h)
; ----------------------------------------------------------------------------
; NOTES:	- If character is 08h (BS) it moves 1 position left
;		- Check for Ctrl+C (executes Int 23h)
; ----------------------------------------------------------------------------

; ------------- Character to output

Int2102:	xchg	ax,dx		; AL <- character to output

; StdOutChar function must follow!

; ----------------------------------------------------------------------------
;                           Write character to console
; ----------------------------------------------------------------------------
; INPUT:	AL = character to write
; ----------------------------------------------------------------------------

; ------------- Check if it is control character

ConOutChar:	cmp	al,SPACE	; is it control character?
;		jb	StdOutCh4	; it is control character

; ------------- Increase character position (except DELETE character)

		cmp	al,DELETE	; is it DELETE character?
;		je	StdOutCh2	; it is DELETE character, skip
;		inc	byte [cs:CharPos] ; increase character position

; ------------- Break test

;StdOutCh2:	dec	byte [cs:BreakCount] ; Break test counter
;		jnz	StdOutCh3	; do not do break test
;		mov	byte [cs:BreakCount],4 ; init new break test counter
;		call	ConCtrl		; console control service

;StdOutCh3:

;BreakCounter


ConOutCh4:



; ----------------------------------------------------------------------------
;             Int 21h, function 06h - direct STDIN or STDOUT
; ----------------------------------------------------------------------------
; INT21 INPUT:	AH = 06h (function code)
;		DL = ASCII character to write (except 0ffh)
;		or DL = 0ffh to read ASCII character
; INT21 OUTPUT:	AL = writted ASCII character (on write = DL, 9 expands to 20h)
;		if read character:
;			ZF is set (=ZY) if no character available, AL = 0
;			ZF is clear (=NZ) if character available
; ----------------------------------------------------------------------------
; NOTES:	- Does not check for Ctrl+C
; ----------------------------------------------------------------------------

Int2106:




; ----------------------------------------------------------------------------
;       Int 21h, function 07h - read character from STDIN without echo
; ----------------------------------------------------------------------------
; INT21 INPUT:	AH = 07h (function code)
; INT21 OUTPUT:	AL = ASCII character (8 bits) or 0 if extended ASCII follows
; ----------------------------------------------------------------------------
; NOTES:	- Does not check for Ctrl+C
;		- 0 means that extended ASCII code follows
; ----------------------------------------------------------------------------

Int2107:

		ret


; ----------------------------------------------------------------------------
;       Int 21h, function 08h - read character from STDIN without echo
; ----------------------------------------------------------------------------
; INT21 INPUT:	AH = 08h (function code)
; INT21 OUTPUT:	AL = ASCII character (8 bits) or 0 if extended ASCII follows
; ----------------------------------------------------------------------------
; NOTES:	- Check for Ctrl+C (executes Int 23h)
;		- 0 means that extended ASCII code follows
; ----------------------------------------------------------------------------

Int2108:

		ret






; ----------------------------------------------------------------------------
;            Int 21h, function 09h - write string to STDOUT
; ----------------------------------------------------------------------------
; INT21 INPUT:	AH = 09h (function code)
;		DS:DX = ASCII string terminated with '$' dollar character
; INT21 OUTPUT:	AL = '$'
; ----------------------------------------------------------------------------
; NOTES:	- Check for Ctrl+C (executes Int 23h)
; ----------------------------------------------------------------------------


Int2109:



; ----------------------------------------------------------------------------
;           Int 21h, function 0Ah - read string from STDIN
; ----------------------------------------------------------------------------
; INT21 INPUT:	AH = 0Ah (function code)
;		DS:DX = buffer:
;			0: (1) (in) maximum characters
;			1: (1) (in/out) number of chars in buffer, without CR
;			2: (N) characters with the final CR
; INT21 OUTPUT:	buffer filled with user input
; ----------------------------------------------------------------------------
; NOTES:	- Check for Ctrl+C (executes Int 23h)
; ----------------------------------------------------------------------------

Int210A:



; ----------------------------------------------------------------------------
;                  Int 21h, function 0Bh - get STDIN status
; ----------------------------------------------------------------------------
; INT21 INPUT:	AH = 0Bh (function code)
; INT21 OUTPUT:	AL = status
;			0: no character available
;			1: character is available
; ----------------------------------------------------------------------------
; NOTES:	- Check for Ctrl+C (executes Int 23h)
; ----------------------------------------------------------------------------

Int210B:




; ----------------------------------------------------------------------------
;       Int 21h, function 0Ch - flush buffer and read from console
; ----------------------------------------------------------------------------
; INT21 INPUT:	AH = 0Ch (function code)
;		AL = function code (1, 6, 7, 8 or 0Ah as in Int 21h functions)
; ----------------------------------------------------------------------------

; ------------- Flush keyboard buffer

Int210C:	xor	bx,bx		; BX <- 0
		mov	ds,bx		; DS <- 0
		mov	bx,[41ch]	; AX <- write pointer to buffer
		mov	[41ah],bx	; read pointer from bufferu

; ------------- Branch to function

		cmp	al,1		; function 1?
		je	Int2101		; jump to function 1
		cmp	al,6		; function 6?
		je	Int2106		; jump to function 6
		cmp	al,7		; function 7?
		je	Int2107		; jump to function 7
		cmp	al,8		; function 8?
		je	Int2108		; jump to function 8
		cmp	al,0ah		; function 0Ah?
		je	Int210A		; jump to function 0Ah
		mov	al,0		; Al <- 0 error, invalid ode
		ret

; ----------------------------------------------------------------------------
;                     Input from keyboard with interrupt
; ----------------------------------------------------------------------------
; OUTPUT:	AL = character (0=scan code follows)
; NOTES:	- If Ctrl+C (or Ctrl+Break) occurs, it terminates program
; ----------------------------------------------------------------------------

; ------------- Input character from keyboard

KeyCtrl:	call	GetKey		; input character from keyboard

; ------------- Ctrl+P service (print)

		cmp	al,PRINT	; print character (Ctrl+P)?
		jne	KeyCtrl2	; no, it is not print character
		xor	byte [cs:PrintFlag],1 ; flip print flag
KeyCtrl1:	ret

; ------------- Ctrl+C service (BREAK)

KeyCtrl2:	cmp	al,BREAK	; break character (Ctrl+C)?
		jne	KeyCtrl1	; no, it is not break character

; ------------- Check functions 9 and 0ah (text output and input)

		call	GetReg		; get register pointer
		mov	al,[si+REG21AX+1]; AL <- function code
		cmp	al,9		; is it function 9 (output text)?
		je	KeyCtrl3	; it is function 9
		cmp	al,0ah		; is it function 0Ah (input text)?
		jne	KeyCtrl4	; it is not function 0Ah	

; ------------- Print new line

KeyCtrl3:	mov	al,"\"		; AL <- "\" character
		call	OutChar		; display "\" character
		call	OutNewLine	; display new line

; ------------- Return old stack pointer

KeyCtrl4:	cli			; disable interrupts
		mov	sp,[cs:OldStack]; SP <- old SP
		mov	ss,[cs:OldStack+2]; SS <- old SS

; ------------- Pop registers

		call	PopAll		; pop all registers

; ------------- Do Int 23h service (program break)

		int	23h		; do Int 23h service

; ------------- Jump to Int 21h service (repeat function)

		jmp	MyInt21		; repeat function

; ----------------------------------------------------------------------------
;                  Break test during Int 21h function
; ----------------------------------------------------------------------------
; NOTES:	- If Ctrl+C (or Ctrl+Break) occurs, it terminates program
; ----------------------------------------------------------------------------

; ------------- Push registers

BreakTest:	push	ax		; push AX

; ------------- Test character from keyboard

		call	TestKey		; test character from keyboard
		jz	BreakTest8	; no character is ready

; ------------- Ctrl+C service (break)

		cmp	al,BREAK	; break character (Ctrl+C)?
		je	BreakTest4	; it is break character

; ------------- Ctrl+P service (print)

		cmp	al,PRINT	; print character (Ctrl+P)?
		je	BreakTest4	; it is print character

; ------------- Ctrl+S service (pause)

		cmp	al,PAUSE	; pause character (Ctrl+S)?
		jne	BreakTest8	; it is not pause character
		call	GetKey		; flush pause character

; ------------- Input from keyboard with interrupt

BreakTest4:	call	KeyCtrl		; wait for next character

; ------------- Pop registers

BreakTest8:	pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                                    Data
; ----------------------------------------------------------------------------

CharPos:	db	0		; character position on line

PrintFlag:	db	0		; PRINT flag (1=do echo on printer)
