; ============================================================================
;
;                         LT-DOS - DOS AUX device
;
; ============================================================================

; ----------------------------------------------------------------------------
;          Int 21h, function 03h - read character from COM1
; ----------------------------------------------------------------------------
; INT21 INPUT:	AH = 03h (function code)
; INT21 OUTPUT:	AL = ASCII character
; ----------------------------------------------------------------------------
; NOTES:	- Check for Ctrl+C (executes Int 23h)
; ----------------------------------------------------------------------------

Int2103:	call	BreakTest	; break test (Ctrl+C)
		push	cs		; simulate call far
		call	JVTRecChar	; receive character from COM1
		ret

; ----------------------------------------------------------------------------
;            Int 21h, function 04h - write character to STDAUX
; ----------------------------------------------------------------------------
; INT21 INPUT:	AH = 04h (function code)
;		DL = ASCII character to write
; ----------------------------------------------------------------------------
; NOTES:	- Check for Ctrl+C (executes Int 23h)
;		- If STDAUX is busy it will wait until it becomes free
; ----------------------------------------------------------------------------

Int2104:	call	BreakTest	; break test (Ctrl+C)
		xchg	ax,dx		; AL <- character to send
		push	cs		; simulate call far
		call	JVTSendChar	; send character to COM1
		ret
